/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.annotation.TargetApi;
import org.chromium.base.Callback;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="media")
@MainDex
@TargetApi(value=23)
public class MediaDrmStorageBridge {
    public static final long INVALID_NATIVE_MEDIA_DRM_STORAGE_BRIDGE = -1L;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mNativeMediaDrmStorageBridge;

    public MediaDrmStorageBridge(long l2) {
        this.mNativeMediaDrmStorageBridge = l2;
        if (!$assertionsDisabled && !this.isNativeMediaDrmStorageValid()) {
            throw new AssertionError();
        }
    }

    private boolean isNativeMediaDrmStorageValid() {
        return this.mNativeMediaDrmStorageBridge != -1L;
    }

    private native void nativeOnProvisioned(long var1, Callback<Boolean> var3);

    private native void nativeOnLoadInfo(long var1, byte[] var3, Callback<PersistentInfo> var4);

    private native void nativeOnSaveInfo(long var1, PersistentInfo var3, Callback<Boolean> var4);

    private native void nativeOnClearInfo(long var1, byte[] var3, Callback<Boolean> var4);

    static {
        $assertionsDisabled = MediaDrmStorageBridge.class.desiredAssertionStatus() ^ true;
    }

    public void onProvisioned(Callback<Boolean> callback) {
        if (this.isNativeMediaDrmStorageValid()) {
            MediaDrmStorageBridge mediaDrmStorageBridge = this;
            mediaDrmStorageBridge.nativeOnProvisioned(mediaDrmStorageBridge.mNativeMediaDrmStorageBridge, callback);
        } else {
            callback.onResult(true);
        }
    }

    public void loadInfo(byte[] byArray, Callback<PersistentInfo> callback) {
        if (this.isNativeMediaDrmStorageValid()) {
            MediaDrmStorageBridge mediaDrmStorageBridge = this;
            mediaDrmStorageBridge.nativeOnLoadInfo(mediaDrmStorageBridge.mNativeMediaDrmStorageBridge, byArray, callback);
        } else {
            callback.onResult(null);
        }
    }

    public void saveInfo(PersistentInfo persistentInfo, Callback<Boolean> callback) {
        if (this.isNativeMediaDrmStorageValid()) {
            MediaDrmStorageBridge mediaDrmStorageBridge = this;
            mediaDrmStorageBridge.nativeOnSaveInfo(mediaDrmStorageBridge.mNativeMediaDrmStorageBridge, persistentInfo, callback);
        } else {
            callback.onResult(false);
        }
    }

    public void clearInfo(byte[] byArray, Callback<Boolean> callback) {
        if (this.isNativeMediaDrmStorageValid()) {
            MediaDrmStorageBridge mediaDrmStorageBridge = this;
            mediaDrmStorageBridge.nativeOnClearInfo(mediaDrmStorageBridge.mNativeMediaDrmStorageBridge, byArray, callback);
        } else {
            callback.onResult(true);
        }
    }

    @MainDex
    public static class PersistentInfo {
        public final byte[] mEmeId;
        public final byte[] mKeySetId;
        public final String mMimeType;
        public final int mKeyType;

        public static PersistentInfo create(byte[] byArray, byte[] byArray2, String string2, int n2) {
            return new PersistentInfo(byArray, byArray2, string2, n2);
        }

        public PersistentInfo(byte[] byArray, byte[] byArray2, String string2, int n2) {
            this.mEmeId = byArray;
            this.mKeySetId = byArray2;
            this.mMimeType = string2;
            this.mKeyType = n2;
        }

        public byte[] emeId() {
            return this.mEmeId;
        }

        public byte[] keySetId() {
            return this.mKeySetId;
        }

        public String mimeType() {
            return this.mMimeType;
        }

        public int keyType() {
            return this.mKeyType;
        }
    }
}

