/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.b.a.a;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.chromium.base.Callback;
import org.chromium.media.MediaDrmStorageBridge;

public class MediaDrmSessionManager {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public HashMap<ByteBuffer, SessionInfo> mEmeSessionInfoMap = new HashMap();
    public HashMap<ByteBuffer, SessionInfo> mDrmSessionInfoMap = new HashMap();
    public MediaDrmStorageBridge mStorage;

    public MediaDrmSessionManager(MediaDrmStorageBridge mediaDrmStorageBridge) {
        this.mStorage = mediaDrmStorageBridge;
    }

    private SessionId getSessionIdFromMap(HashMap<ByteBuffer, SessionInfo> hashMap, byte[] byArray) {
        SessionInfo sessionInfo = hashMap.get(ByteBuffer.wrap(byArray));
        if (sessionInfo == null) {
            return null;
        }
        return sessionInfo.sessionId();
    }

    static {
        $assertionsDisabled = MediaDrmSessionManager.class.desiredAssertionStatus() ^ true;
    }

    public void setDrmId(SessionId sessionId, byte[] byArray) {
        SessionInfo sessionInfo = this.get(sessionId);
        if (!$assertionsDisabled && sessionInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !sessionInfo.sessionId().isEqual(sessionId)) {
            throw new AssertionError();
        }
        sessionId.setDrmId(byArray);
        this.mDrmSessionInfoMap.put(ByteBuffer.wrap(byArray), sessionInfo);
    }

    public void setKeySetId(SessionId sessionId, byte[] byArray, Callback<Boolean> callback) {
        if (!$assertionsDisabled && this.get(sessionId) == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.get(sessionId).keyType() != 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sessionId.keySetId() != null) {
            throw new AssertionError();
        }
        sessionId.setKeySetId(byArray);
        this.mStorage.saveInfo(this.get(sessionId).toPersistentInfo(), callback);
    }

    public void setKeyType(SessionId object, int n2, Callback<Boolean> callback) {
        object = this.get((SessionId)object);
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        ((SessionInfo)object).setKeyType(n2);
        this.mStorage.saveInfo(((SessionInfo)object).toPersistentInfo(), callback);
    }

    public void load(byte[] byArray, final Callback<SessionId> callback) {
        this.mStorage.loadInfo(byArray, new Callback<MediaDrmStorageBridge.PersistentInfo>(){
            public static final /* synthetic */ boolean $assertionsDisabled;

            static {
                $assertionsDisabled = MediaDrmSessionManager.class.desiredAssertionStatus() ^ true;
            }

            @Override
            public void onResult(MediaDrmStorageBridge.PersistentInfo persistentInfo) {
                if (persistentInfo == null) {
                    sessionInfo.callback.onResult(null);
                    return;
                }
                if (!$assertionsDisabled && sessionInfo.MediaDrmSessionManager.this.getSessionIdByEmeId(persistentInfo.emeId()) != null) {
                    throw new AssertionError();
                }
                1 v0 = sessionInfo;
                SessionInfo sessionInfo = SessionInfo.fromPersistentInfo(persistentInfo);
                v0.MediaDrmSessionManager.this.mEmeSessionInfoMap.put(ByteBuffer.wrap(persistentInfo.emeId()), sessionInfo);
                v0.callback.onResult(sessionInfo.sessionId());
            }
        });
    }

    public void clearPersistentSessionInfo(SessionId sessionId, Callback<Boolean> callback) {
        sessionId.setKeySetId(null);
        this.mStorage.clearInfo(sessionId.emeId(), callback);
    }

    public void remove(SessionId sessionId) {
        SessionInfo sessionInfo = this.get(sessionId);
        if (!$assertionsDisabled && sessionInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !sessionId.isEqual(sessionInfo.sessionId())) {
            throw new AssertionError();
        }
        this.mEmeSessionInfoMap.remove(ByteBuffer.wrap(sessionId.emeId()));
        if (sessionId.drmId() != null) {
            this.mDrmSessionInfoMap.remove(ByteBuffer.wrap(sessionId.drmId()));
        }
    }

    public List<SessionId> getAllSessionIds() {
        ArrayList arrayList;
        MediaDrmSessionManager mediaDrmSessionManager = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Iterator<SessionInfo> iterator = mediaDrmSessionManager.mEmeSessionInfoMap.values().iterator();
        while (iterator.hasNext()) {
            arrayList2.add(iterator.next().sessionId());
        }
        return arrayList2;
    }

    public SessionInfo get(SessionId sessionId) {
        return this.mEmeSessionInfoMap.get(ByteBuffer.wrap(sessionId.emeId()));
    }

    public void put(SessionId sessionId, String string2, int n2) {
        SessionInfo sessionInfo;
        SessionInfo sessionInfo2 = sessionInfo;
        sessionInfo = new SessionInfo(sessionId, string2, n2, null);
        this.mEmeSessionInfoMap.put(ByteBuffer.wrap(sessionId.emeId()), sessionInfo2);
        if (sessionId.drmId() != null) {
            this.mDrmSessionInfoMap.put(ByteBuffer.wrap(sessionId.drmId()), sessionInfo2);
        }
    }

    public SessionId getSessionIdByEmeId(byte[] byArray) {
        MediaDrmSessionManager mediaDrmSessionManager = this;
        return mediaDrmSessionManager.getSessionIdFromMap(mediaDrmSessionManager.mEmeSessionInfoMap, byArray);
    }

    public SessionId getSessionIdByDrmId(byte[] byArray) {
        MediaDrmSessionManager mediaDrmSessionManager = this;
        return mediaDrmSessionManager.getSessionIdFromMap(mediaDrmSessionManager.mDrmSessionInfoMap, byArray);
    }

    public static class SessionInfo {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final SessionId mSessionId;
        public final String mMimeType;
        public int mKeyType;

        public SessionInfo(SessionId sessionId, String string2, int n2) {
            if (!$assertionsDisabled && sessionId == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && (string2 == null || string2.isEmpty())) {
                throw new AssertionError();
            }
            this.mSessionId = sessionId;
            this.mMimeType = string2;
            this.mKeyType = n2;
        }

        private SessionId sessionId() {
            return this.mSessionId;
        }

        private void setKeyType(int n2) {
            this.mKeyType = n2;
        }

        private MediaDrmStorageBridge.PersistentInfo toPersistentInfo() {
            if (!$assertionsDisabled && this.mSessionId.keySetId() == null) {
                throw new AssertionError();
            }
            return new MediaDrmStorageBridge.PersistentInfo(this.mSessionId.emeId(), this.mSessionId.keySetId(), this.mMimeType, this.mKeyType);
        }

        public static SessionInfo fromPersistentInfo(MediaDrmStorageBridge.PersistentInfo persistentInfo) {
            SessionId sessionId;
            if (!$assertionsDisabled && persistentInfo == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && persistentInfo.emeId() == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && persistentInfo.keySetId() == null) {
                throw new AssertionError();
            }
            SessionId sessionId2 = sessionId;
            sessionId = new SessionId(persistentInfo.emeId(), null, persistentInfo.keySetId(), null);
            return new SessionInfo(sessionId2, persistentInfo.mimeType(), SessionInfo.getKeyTypeFromPersistentInfo(persistentInfo));
        }

        public static int getKeyTypeFromPersistentInfo(MediaDrmStorageBridge.PersistentInfo persistentInfo) {
            int n2 = persistentInfo.keyType();
            if (n2 != 2 && n2 != 3) {
                return 2;
            }
            return n2;
        }

        public /* synthetic */ SessionInfo(SessionId sessionId, String string2, int n2, 1 var4_4) {
            this(sessionId, string2, n2);
        }

        static {
            $assertionsDisabled = MediaDrmSessionManager.class.desiredAssertionStatus() ^ true;
        }

        public String mimeType() {
            return this.mMimeType;
        }

        public int keyType() {
            return this.mKeyType;
        }
    }

    public static class SessionId {
        public static final char[] HEX_CHAR_LOOKUP;
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final byte[] mEmeId;
        public byte[] mDrmId;
        public byte[] mKeySetId;

        public static String toHexString(byte[] byArray) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append(HEX_CHAR_LOOKUP[byArray[i2] >>> 4]);
                stringBuilder3.append(HEX_CHAR_LOOKUP[byArray[i2] & 0xF]);
            }
            return stringBuilder2.toString();
        }

        public static SessionId createPersistentSessionId(byte[] byArray) {
            byte[] byArray2 = a.a(UUID.randomUUID().toString().replace('-', '0'));
            return new SessionId(byArray2, byArray, null);
        }

        public static SessionId createTemporarySessionId(byte[] byArray) {
            return new SessionId(byArray, byArray, null);
        }

        public static SessionId createNoExistSessionId() {
            return SessionId.createTemporarySessionId(new byte[0]);
        }

        public SessionId(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            if (!$assertionsDisabled && byArray == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && byArray2 == null && byArray3 == null) {
                throw new AssertionError();
            }
            this.mEmeId = byArray;
            this.mDrmId = byArray2;
            this.mKeySetId = byArray3;
        }

        private void setKeySetId(byte[] byArray) {
            this.mKeySetId = byArray;
        }

        private void setDrmId(byte[] byArray) {
            this.mDrmId = byArray;
        }

        public /* synthetic */ SessionId(byte[] byArray, byte[] byArray2, byte[] byArray3, 1 var4_4) {
            this(byArray, byArray2, byArray3);
        }

        static {
            $assertionsDisabled = MediaDrmSessionManager.class.desiredAssertionStatus() ^ true;
            HEX_CHAR_LOOKUP = "0123456789ABCDEF".toCharArray();
        }

        public byte[] drmId() {
            return this.mDrmId;
        }

        public byte[] emeId() {
            return this.mEmeId;
        }

        public byte[] keySetId() {
            return this.mKeySetId;
        }

        public boolean isEqual(SessionId sessionId) {
            return Arrays.equals(this.mEmeId, sessionId.emeId());
        }

        public String toHexString() {
            return SessionId.toHexString(this.mEmeId);
        }
    }
}

