/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.a.a.a.a;
import a.b.a.g;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Process;
import android.provider.Settings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="media")
public class AudioManagerAndroid {
    public static final String TAG = "cr.media";
    public static final boolean DEBUG = false;
    public static final int DEVICE_DEFAULT = -2;
    public static final int DEVICE_INVALID = -1;
    public static final int DEVICE_SPEAKERPHONE = 0;
    public static final int DEVICE_WIRED_HEADSET = 1;
    public static final int DEVICE_EARPIECE = 2;
    public static final int DEVICE_BLUETOOTH_HEADSET = 3;
    public static final int DEVICE_USB_AUDIO = 4;
    public static final int DEVICE_COUNT = 5;
    public static final String[] DEVICE_NAMES = new String[]{"Speakerphone", "Wired headset", "Headset earpiece", "Bluetooth headset", "USB audio"};
    public static final Integer[] VALID_DEVICES = new Integer[]{0, 1, 2, 3, 4};
    public static final int STATE_BLUETOOTH_SCO_INVALID = -1;
    public static final int STATE_BLUETOOTH_SCO_OFF = 0;
    public static final int STATE_BLUETOOTH_SCO_ON = 1;
    public static final int STATE_BLUETOOTH_SCO_TURNING_ON = 2;
    public static final int STATE_BLUETOOTH_SCO_TURNING_OFF = 3;
    public static final int DEFAULT_SAMPLING_RATE = 44100;
    public static final int DEFAULT_FRAME_PER_BUFFER = 256;
    public final AudioManager mAudioManager;
    public final long mNativeAudioManagerAndroid;
    public boolean mHasModifyAudioSettingsPermission;
    public boolean mHasBluetoothPermission;
    public int mBluetoothScoState;
    public boolean mIsInitialized;
    public boolean mSavedIsSpeakerphoneOn;
    public boolean mSavedIsMicrophoneMute;
    public int mRequestedAudioDevice;
    public final NonThreadSafe mNonThreadSafe;
    public final Object mLock;
    public boolean[] mAudioDevices;
    public final ContentResolver mContentResolver;
    public ContentObserver mSettingsObserver;
    public HandlerThread mSettingsObserverThread;
    public int mCurrentVolume;
    public BroadcastReceiver mWiredHeadsetReceiver;
    public BroadcastReceiver mBluetoothHeadsetReceiver;
    public BroadcastReceiver mBluetoothScoReceiver;
    public final UsbManager mUsbManager;
    public BroadcastReceiver mUsbAudioReceiver;

    public static AudioManagerAndroid createAudioManagerAndroid(long l2) {
        return new AudioManagerAndroid(l2);
    }

    public AudioManagerAndroid(long l2) {
        AudioManagerAndroid audioManagerAndroid = this;
        this.mBluetoothScoState = -1;
        this.mRequestedAudioDevice = -1;
        this.mNonThreadSafe = new NonThreadSafe();
        this.mLock = new Object();
        this.mAudioDevices = new boolean[5];
        audioManagerAndroid.mNativeAudioManagerAndroid = l2;
        audioManagerAndroid.mAudioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        audioManagerAndroid.mContentResolver = ContextUtils.getApplicationContext().getContentResolver();
        audioManagerAndroid.mUsbManager = (UsbManager)ContextUtils.getApplicationContext().getSystemService("usb");
    }

    private void init() {
        AudioManagerAndroid audioManagerAndroid = this;
        audioManagerAndroid.checkIfCalledOnValidThread();
        if (audioManagerAndroid.mIsInitialized) {
            return;
        }
        AudioManagerAndroid audioManagerAndroid2 = this;
        audioManagerAndroid2.mHasModifyAudioSettingsPermission = audioManagerAndroid2.hasPermission("android.permission.MODIFY_AUDIO_SETTINGS");
        audioManagerAndroid2.mAudioDevices[2] = this.hasEarpiece();
        audioManagerAndroid2.mAudioDevices[1] = this.hasWiredHeadset();
        audioManagerAndroid2.mAudioDevices[4] = this.hasUsbAudio();
        audioManagerAndroid2.mAudioDevices[0] = true;
        audioManagerAndroid2.registerBluetoothIntentsIfNeeded();
        audioManagerAndroid2.registerForWiredHeadsetIntentBroadcast();
        audioManagerAndroid2.registerForUsbAudioIntentBroadcast();
        audioManagerAndroid2.mIsInitialized = true;
    }

    private void close() {
        AudioManagerAndroid audioManagerAndroid = this;
        audioManagerAndroid.checkIfCalledOnValidThread();
        if (!audioManagerAndroid.mIsInitialized) {
            return;
        }
        AudioManagerAndroid audioManagerAndroid2 = this;
        audioManagerAndroid2.stopObservingVolumeChanges();
        audioManagerAndroid2.unregisterForWiredHeadsetIntentBroadcast();
        audioManagerAndroid2.unregisterBluetoothIntentsIfNeeded();
        audioManagerAndroid2.unregisterForUsbAudioIntentBroadcast();
        audioManagerAndroid2.mIsInitialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setCommunicationAudioModeOn(boolean bl) {
        Object[] objectArray;
        objectArray.checkIfCalledOnValidThread();
        if (!objectArray.mIsInitialized) {
            return;
        }
        if (!objectArray.mHasModifyAudioSettingsPermission) {
            objectArray = new Object[]{};
            g.d(TAG, "MODIFY_AUDIO_SETTINGS is missing => client will run with reduced functionality", objectArray);
            return;
        }
        if (bl) {
            objectArray.mSavedIsSpeakerphoneOn = objectArray.mAudioManager.isSpeakerphoneOn();
            objectArray.mSavedIsMicrophoneMute = objectArray.mAudioManager.isMicrophoneMute();
            super.startObservingVolumeChanges();
        } else {
            super.stopObservingVolumeChanges();
            super.stopBluetoothSco();
            Object object = objectArray.mLock;
            synchronized (object) {
                objectArray.mRequestedAudioDevice = -1;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl19 : MonitorExitStatement: MONITOREXIT : object
                super.setMicrophoneMute(objectArray.mSavedIsMicrophoneMute);
                super.setSpeakerphoneOn(objectArray.mSavedIsSpeakerphoneOn);
            }
        }
        super.setCommunicationAudioModeOnInternal(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setCommunicationAudioModeOnInternal(boolean bl) {
        if (bl) {
            try {
                this.mAudioManager.setMode(3);
                return;
            }
            catch (SecurityException securityException) {
                this.logDeviceInfo();
                throw securityException;
            }
        }
        try {
            this.mAudioManager.setMode(0);
            return;
        }
        catch (SecurityException securityException) {
            this.logDeviceInfo();
            throw securityException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setDevice(String string2) {
        Object[] objectArray;
        if (!objectArray.mIsInitialized) {
            return false;
        }
        boolean bl = objectArray.hasPermission("android.permission.RECORD_AUDIO");
        if (objectArray.mHasModifyAudioSettingsPermission && bl) {
            int n2 = string2.isEmpty() ? -2 : Integer.parseInt(string2);
            if (n2 == -2) {
                Object object = objectArray.mLock;
                synchronized (object) {
                    objectArray = (boolean[])objectArray.mAudioDevices.clone();
                    objectArray.mRequestedAudioDevice = -2;
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 8, 9] lbl13 : MonitorExitStatement: MONITOREXIT : var2_4
                    super.setAudioDevice(AudioManagerAndroid.selectDefaultDevice((boolean[])objectArray));
                    return true;
                }
            }
            if (Arrays.asList(VALID_DEVICES).contains(n2) && objectArray.mAudioDevices[n2]) {
                Object object = objectArray.mLock;
                synchronized (object) {
                    objectArray.mRequestedAudioDevice = n2;
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 7, 9] lbl24 : MonitorExitStatement: MONITOREXIT : var2_5
                    super.setAudioDevice(n2);
                    return true;
                }
            }
            return false;
        }
        objectArray = new Object[]{};
        g.d(TAG, "Requires MODIFY_AUDIO_SETTINGS and RECORD_AUDIO. Selected device will not be available for recording", objectArray);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioDeviceName[] getAudioInputDeviceNames() {
        if (!this.mIsInitialized) {
            return null;
        }
        AudioManagerAndroid audioManagerAndroid = this;
        boolean bl = audioManagerAndroid.hasPermission("android.permission.RECORD_AUDIO");
        if (audioManagerAndroid.mHasModifyAudioSettingsPermission && bl) {
            ArrayList arrayList;
            boolean[] blArray;
            Object object = this.mLock;
            synchronized (object) {
                blArray = (boolean[])this.mAudioDevices.clone();
            }
            object = arrayList;
            arrayList = new ArrayList();
            AudioDeviceName[] audioDeviceNameArray = new AudioDeviceName[AudioManagerAndroid.getNumOfAudioDevices(blArray)];
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n3 >= 5) {
                    return audioDeviceNameArray;
                }
                if (blArray[n3]) {
                    audioDeviceNameArray[n2] = new AudioDeviceName(n3, DEVICE_NAMES[n3], null);
                    object.add(DEVICE_NAMES[n3]);
                    ++n2;
                }
                ++n3;
            }
        }
        Object[] objectArray = new Object[]{};
        g.d(TAG, "Requires MODIFY_AUDIO_SETTINGS and RECORD_AUDIO. No audio device will be available for recording", objectArray);
        return null;
    }

    @TargetApi(value=17)
    private int getNativeOutputSampleRate() {
        if (Build.VERSION.SDK_INT >= 17) {
            String string2 = ((AudioManagerAndroid)((Object)string2)).mAudioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            return string2 == null ? 44100 : Integer.parseInt(string2);
        }
        return 44100;
    }

    public static int getMinInputFrameSize(int n2, int n3) {
        block4: {
            int n4;
            block3: {
                block2: {
                    if (n3 != 1) break block2;
                    n4 = 16;
                    break block3;
                }
                if (n3 != 2) break block4;
                n4 = 12;
            }
            return AudioRecord.getMinBufferSize((int)n2, (int)n4, (int)2) / 2 / n3;
        }
        return -1;
    }

    public static int getMinOutputFrameSize(int n2, int n3) {
        block4: {
            int n4;
            block3: {
                block2: {
                    if (n3 != 1) break block2;
                    n4 = 4;
                    break block3;
                }
                if (n3 != 2) break block4;
                n4 = 12;
            }
            return AudioTrack.getMinBufferSize((int)n2, (int)n4, (int)2) / 2 / n3;
        }
        return -1;
    }

    private boolean isAudioLowLatencySupported() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    @TargetApi(value=17)
    private int getAudioLowLatencyOutputFrameSize() {
        if (Build.VERSION.SDK_INT < 17) {
            return 256;
        }
        String string2 = ((AudioManagerAndroid)((Object)string2)).mAudioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return string2 == null ? 256 : Integer.parseInt(string2);
    }

    public static boolean acousticEchoCancelerIsAvailable() {
        return AcousticEchoCanceler.isAvailable();
    }

    private void checkIfCalledOnValidThread() {
    }

    private void registerBluetoothIntentsIfNeeded() {
        objectArray.mHasBluetoothPermission = objectArray.hasPermission("android.permission.BLUETOOTH");
        if (!objectArray.mHasBluetoothPermission) {
            Object[] objectArray = new Object[]{};
            g.d(TAG, "Requires BLUETOOTH permission", objectArray);
            return;
        }
        objectArray.mAudioDevices[3] = super.hasBluetoothHeadset();
        super.registerForBluetoothHeadsetIntentBroadcast();
        super.registerForBluetoothScoIntentBroadcast();
    }

    private void unregisterBluetoothIntentsIfNeeded() {
        if (this.mHasBluetoothPermission) {
            AudioManagerAndroid audioManagerAndroid = this;
            audioManagerAndroid.mAudioManager.stopBluetoothSco();
            audioManagerAndroid.unregisterForBluetoothHeadsetIntentBroadcast();
            audioManagerAndroid.unregisterForBluetoothScoIntentBroadcast();
        }
    }

    private void setSpeakerphoneOn(boolean bl) {
        if (this.mAudioManager.isSpeakerphoneOn() == bl) {
            return;
        }
        this.mAudioManager.setSpeakerphoneOn(bl);
    }

    private void setMicrophoneMute(boolean bl) {
        if (this.mAudioManager.isMicrophoneMute() == bl) {
            return;
        }
        this.mAudioManager.setMicrophoneMute(bl);
    }

    private boolean isMicrophoneMute() {
        return this.mAudioManager.isMicrophoneMute();
    }

    private boolean hasEarpiece() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @Deprecated
    private boolean hasWiredHeadset() {
        return this.mAudioManager.isWiredHeadsetOn();
    }

    private boolean hasPermission(String string2) {
        return ContextUtils.getApplicationContext().checkPermission(string2, Process.myPid(), Process.myUid()) == 0;
    }

    @TargetApi(value=18)
    private boolean hasBluetoothHeadset() {
        BluetoothAdapter bluetoothAdapter;
        if (!bluetoothAdapter.mHasBluetoothPermission) {
            bluetoothAdapter = new BluetoothAdapter[]{};
            g.d(TAG, "hasBluetoothHeadset() requires BLUETOOTH permission", (Object[])bluetoothAdapter);
            return false;
        }
        bluetoothAdapter = Build.VERSION.SDK_INT >= 18 ? ((BluetoothManager)ContextUtils.getApplicationContext().getSystemService("bluetooth")).getAdapter() : BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return false;
        }
        BluetoothAdapter bluetoothAdapter2 = bluetoothAdapter;
        int n2 = bluetoothAdapter2.getProfileConnectionState(1);
        return bluetoothAdapter2.isEnabled() && n2 == 2;
    }

    private boolean hasUsbAudio() {
        Iterator iterator;
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        boolean bl = false;
        try {
            iterator = this.mUsbManager.getDeviceList().values().iterator();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        while (iterator.hasNext()) {
            if (!this.hasUsbAudioCommInterface((UsbDevice)iterator.next())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void registerForWiredHeadsetIntentBroadcast() {
        IntentFilter intentFilter;
        IntentFilter intentFilter2 = intentFilter;
        intentFilter = new IntentFilter("android.intent.action.HEADSET_PLUG");
        this.mWiredHeadsetReceiver = new BroadcastReceiver(){
            public static final int STATE_UNPLUGGED = 0;
            public static final int STATE_PLUGGED = 1;
            public static final int HAS_NO_MIC = 0;
            public static final int HAS_MIC = 1;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onReceive(Context context, Intent intent) {
                int n2 = intent.getIntExtra("state", 0);
                if (n2 != 0) {
                    if (n2 != 1) {
                        AudioManagerAndroid.loge("Invalid state");
                    } else {
                        Object object = AudioManagerAndroid.this.mLock;
                        1 v0 = this;
                        synchronized (object) {
                            ((AudioManagerAndroid)v0.AudioManagerAndroid.this).mAudioDevices[1] = true;
                            ((AudioManagerAndroid)v0.AudioManagerAndroid.this).mAudioDevices[2] = false;
                            ((AudioManagerAndroid)v0.AudioManagerAndroid.this).mAudioDevices[4] = false;
                        }
                    }
                } else {
                    1 v2 = this;
                    Object object = v2.AudioManagerAndroid.this.mLock;
                    synchronized (object) {
                        ((AudioManagerAndroid)v2.AudioManagerAndroid.this).mAudioDevices[1] = false;
                        if (v2.AudioManagerAndroid.this.hasUsbAudio()) {
                            1 v3 = this;
                            ((AudioManagerAndroid)v3.AudioManagerAndroid.this).mAudioDevices[4] = true;
                            ((AudioManagerAndroid)v3.AudioManagerAndroid.this).mAudioDevices[2] = false;
                        } else if (AudioManagerAndroid.this.hasEarpiece()) {
                            1 v4 = this;
                            ((AudioManagerAndroid)v4.AudioManagerAndroid.this).mAudioDevices[2] = true;
                            ((AudioManagerAndroid)v4.AudioManagerAndroid.this).mAudioDevices[4] = false;
                        }
                    }
                }
                if (AudioManagerAndroid.this.deviceHasBeenRequested()) {
                    AudioManagerAndroid.this.updateDeviceActivation();
                }
            }
        };
        ContextUtils.getApplicationContext().registerReceiver(this.mWiredHeadsetReceiver, intentFilter2);
    }

    private void unregisterForWiredHeadsetIntentBroadcast() {
        ContextUtils.getApplicationContext().unregisterReceiver(this.mWiredHeadsetReceiver);
        this.mWiredHeadsetReceiver = null;
    }

    private void registerForBluetoothHeadsetIntentBroadcast() {
        IntentFilter intentFilter;
        IntentFilter intentFilter2 = intentFilter;
        intentFilter = new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        this.mBluetoothHeadsetReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context object, Intent intent) {
                switch (intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0)) {
                    default: {
                        AudioManagerAndroid.loge("Invalid state");
                        break;
                    }
                    case 2: {
                        object = AudioManagerAndroid.this.mLock;
                        synchronized (object) {
                            ((AudioManagerAndroid)AudioManagerAndroid.this).mAudioDevices[3] = true;
                            break;
                        }
                    }
                    case 0: {
                        object = AudioManagerAndroid.this.mLock;
                        synchronized (object) {
                            ((AudioManagerAndroid)AudioManagerAndroid.this).mAudioDevices[3] = false;
                            break;
                        }
                    }
                    case 1: 
                    case 3: 
                }
            }
        };
        ContextUtils.getApplicationContext().registerReceiver(this.mBluetoothHeadsetReceiver, intentFilter2);
    }

    private void unregisterForBluetoothHeadsetIntentBroadcast() {
        ContextUtils.getApplicationContext().unregisterReceiver(this.mBluetoothHeadsetReceiver);
        this.mBluetoothHeadsetReceiver = null;
    }

    private void registerForBluetoothScoIntentBroadcast() {
        IntentFilter intentFilter;
        IntentFilter intentFilter2 = intentFilter;
        intentFilter = new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        this.mBluetoothScoReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                int n2 = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0);
                if (n2 != 0) {
                    if (n2 != 1) {
                        if (n2 != 2) {
                            AudioManagerAndroid.loge("Invalid state");
                        }
                    } else {
                        AudioManagerAndroid.access$802(AudioManagerAndroid.this, 1);
                    }
                } else {
                    if (AudioManagerAndroid.this.mBluetoothScoState != 3 && AudioManagerAndroid.this.deviceHasBeenRequested()) {
                        AudioManagerAndroid.this.updateDeviceActivation();
                    }
                    AudioManagerAndroid.access$802(AudioManagerAndroid.this, 0);
                }
            }
        };
        ContextUtils.getApplicationContext().registerReceiver(this.mBluetoothScoReceiver, intentFilter2);
    }

    private void unregisterForBluetoothScoIntentBroadcast() {
        ContextUtils.getApplicationContext().unregisterReceiver(this.mBluetoothScoReceiver);
        this.mBluetoothScoReceiver = null;
    }

    private void startBluetoothSco() {
        if (!this.mHasBluetoothPermission) {
            return;
        }
        int n2 = this.mBluetoothScoState;
        if (n2 != 1 && n2 != 2) {
            if (this.mAudioManager.isBluetoothScoOn()) {
                this.mBluetoothScoState = 1;
                return;
            }
            this.mBluetoothScoState = 2;
            this.mAudioManager.startBluetoothSco();
            return;
        }
    }

    private void stopBluetoothSco() {
        if (!this.mHasBluetoothPermission) {
            return;
        }
        int n2 = this.mBluetoothScoState;
        if (n2 != 1 && n2 != 2) {
            return;
        }
        if (!this.mAudioManager.isBluetoothScoOn()) {
            AudioManagerAndroid.loge("Unable to stop BT SCO since it is already disabled");
            this.mBluetoothScoState = 0;
            return;
        }
        this.mBluetoothScoState = 3;
        this.mAudioManager.stopBluetoothSco();
    }

    private void setAudioDevice(int n2) {
        if (n2 == 3) {
            this.startBluetoothSco();
        } else {
            this.stopBluetoothSco();
        }
        switch (n2) {
            default: {
                AudioManagerAndroid.loge("Invalid audio device selection");
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case 0: {
                this.setSpeakerphoneOn(true);
            }
            case 3: 
        }
        this.reportUpdate();
    }

    public static int selectDefaultDevice(boolean[] blArray) {
        if (blArray[1]) {
            return 1;
        }
        if (blArray[4]) {
            return 4;
        }
        if (blArray[3]) {
            return 3;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deviceHasBeenRequested() {
        AudioManagerAndroid audioManagerAndroid = object;
        Object object = audioManagerAndroid.mLock;
        synchronized (object) {
            boolean bl = audioManagerAndroid.mRequestedAudioDevice != -1;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeviceActivation() {
        AudioManagerAndroid audioManagerAndroid = this;
        Object object = audioManagerAndroid.mLock;
        synchronized (object) {
            boolean[] blArray;
            int n2;
            block7: {
                n2 = audioManagerAndroid.mRequestedAudioDevice;
                Object object2 = object;
                blArray = (boolean[])this.mAudioDevices.clone();
                // ** MonitorExit[v2] (shouldn't be in output)
                if (n2 != -1) break block7;
                AudioManagerAndroid.loge("Unable to activate device since no device is selected");
                return;
            }
            if (n2 != -2 && blArray[n2]) {
                this.setAudioDevice(n2);
            } else {
                this.setAudioDevice(AudioManagerAndroid.selectDefaultDevice(blArray));
            }
            return;
        }
    }

    public static int getNumOfAudioDevices(boolean[] blArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            if (!blArray[i2]) continue;
            ++n2;
        }
        return n2;
    }

    private void reportUpdate() {
    }

    private void logDeviceInfo() {
        AudioManagerAndroid.logd(a.a("Android SDK: ").append(Build.VERSION.SDK_INT).append(", Release: ").append(Build.VERSION.RELEASE).append(", Brand: ").append(Build.BRAND).append(", Device: ").append(Build.DEVICE).append(", Id: ").append(Build.ID).append(", Hardware: ").append(Build.HARDWARE).append(", Manufacturer: ").append(Build.MANUFACTURER).append(", Model: ").append(Build.MODEL).append(", Product: ").append(Build.PRODUCT).toString());
    }

    public static void logd(String string2) {
        g.a(TAG, string2);
    }

    public static void loge(String string2) {
        Object[] objectArray = new Object[]{};
        g.b(TAG, string2, objectArray);
    }

    private void startObservingVolumeChanges() {
        if (this.mSettingsObserverThread != null) {
            return;
        }
        AudioManagerAndroid audioManagerAndroid = this;
        audioManagerAndroid.mSettingsObserverThread = new HandlerThread("SettingsObserver");
        audioManagerAndroid.mSettingsObserverThread.start();
        audioManagerAndroid.mSettingsObserver = new ContentObserver(new Handler(this.mSettingsObserverThread.getLooper())){

            public void onChange(boolean bl) {
                4 v0 = object;
                super.onChange(bl);
                Object object = object.AudioManagerAndroid.this;
                long l2 = ((AudioManagerAndroid)object).mNativeAudioManagerAndroid;
                bl = v0.AudioManagerAndroid.this.mAudioManager.getStreamVolume(0) == 0;
                ((AudioManagerAndroid)object).nativeSetMute(l2, bl);
            }
        };
        audioManagerAndroid.mContentResolver.registerContentObserver(Settings.System.CONTENT_URI, true, this.mSettingsObserver);
    }

    private void stopObservingVolumeChanges() {
        if (this.mSettingsObserverThread == null) {
            return;
        }
        AudioManagerAndroid audioManagerAndroid = this;
        audioManagerAndroid.mContentResolver.unregisterContentObserver(this.mSettingsObserver);
        audioManagerAndroid.mSettingsObserver = null;
        audioManagerAndroid.mSettingsObserverThread.quit();
        try {
            audioManagerAndroid.mSettingsObserverThread.join();
        }
        catch (InterruptedException interruptedException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = interruptedException;
            g.b(TAG, "Thread.join() exception: ", objectArray2);
        }
        this.mSettingsObserverThread = null;
    }

    private boolean hasUsbAudioCommInterface(UsbDevice usbDevice) {
        boolean bl = false;
        for (int i2 = 0; i2 < usbDevice.getInterfaceCount(); ++i2) {
            UsbInterface usbInterface = usbDevice.getInterface(i2);
            if (usbInterface.getInterfaceClass() != 1 || usbInterface.getInterfaceSubclass() != 2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void registerForUsbAudioIntentBroadcast() {
        IntentFilter intentFilter;
        this.mUsbAudioReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context object, Intent intent) {
                block12: {
                    block11: {
                        object = (UsbDevice)intent.getParcelableExtra("device");
                        if (!AudioManagerAndroid.this.hasUsbAudioCommInterface((UsbDevice)object)) {
                            return;
                        }
                        if (!"android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(intent.getAction())) break block11;
                        5 v0 = this;
                        object = v0.AudioManagerAndroid.this.mLock;
                        synchronized (object) {
                            if (v0.AudioManagerAndroid.this.hasWiredHeadset()) break block12;
                            5 v2 = this;
                            ((AudioManagerAndroid)v2.AudioManagerAndroid.this).mAudioDevices[4] = true;
                            ((AudioManagerAndroid)v2.AudioManagerAndroid.this).mAudioDevices[2] = false;
                        }
                    }
                    if (!"android.hardware.usb.action.USB_DEVICE_DETACHED".equals(intent.getAction()) || AudioManagerAndroid.this.hasUsbAudio()) break block12;
                    5 v3 = this;
                    object = v3.AudioManagerAndroid.this.mLock;
                    synchronized (object) {
                        if (v3.AudioManagerAndroid.this.hasWiredHeadset()) break block12;
                        5 v5 = this;
                        ((AudioManagerAndroid)v5.AudioManagerAndroid.this).mAudioDevices[4] = false;
                        if (!v5.AudioManagerAndroid.this.hasEarpiece()) break block12;
                        ((AudioManagerAndroid)AudioManagerAndroid.this).mAudioDevices[2] = true;
                    }
                }
                if (AudioManagerAndroid.this.deviceHasBeenRequested()) {
                    AudioManagerAndroid.this.updateDeviceActivation();
                }
            }
        };
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intentFilter2.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        ContextUtils.getApplicationContext().registerReceiver(this.mUsbAudioReceiver, intentFilter2);
    }

    private void unregisterForUsbAudioIntentBroadcast() {
        ContextUtils.getApplicationContext().unregisterReceiver(this.mUsbAudioReceiver);
        this.mUsbAudioReceiver = null;
    }

    private native void nativeSetMute(long var1, boolean var3);

    public static /* synthetic */ int access$802(AudioManagerAndroid audioManagerAndroid, int n2) {
        audioManagerAndroid.mBluetoothScoState = n2;
        return n2;
    }

    public static class AudioDeviceName {
        public final int mId;
        public final String mName;

        public AudioDeviceName(int n2, String string2) {
            this.mId = n2;
            this.mName = string2;
        }

        private String id() {
            return String.valueOf(this.mId);
        }

        private String name() {
            return this.mName;
        }

        public /* synthetic */ AudioDeviceName(int n2, String string2, 1 var3_3) {
            this(n2, string2);
        }
    }

    public static class NonThreadSafe {
        public final Long mThreadId = 0L;

        public boolean calledOnValidThread() {
            return true;
        }
    }
}

