/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.androidoverlay;

import a.b.c.b.s.a;
import a.b.d.a.y;
import a.b.h.a.b;
import a.b.i.a.c;
import a.b.i.a.d;
import a.b.j.a.q;
import a.b.j.b.k;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.view.Surface;
import android.view.SurfaceHolder;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.PostTask;

@JNINamespace(value="content")
public class DialogOverlayImpl
implements a.b.i.a.a,
a.c {
    public static final String TAG = "DialogOverlayImpl";
    public static final /* synthetic */ boolean $assertionsDisabled;
    public a.b.i.a.b mClient;
    public Handler mOverlayHandler;
    public Runnable mReleasedRunnable;
    public Runnable mReleaseCoreRunnable;
    public final a.b.c.b.s.b mHoppingHost;
    public a mDialogCore;
    public long mNativeHandle;
    public int mSurfaceId;
    public boolean mClosed;
    public final int[] mCompositorOffset;

    public DialogOverlayImpl(a.b.i.a.b object, d d2, Handler handler, Runnable runnable, boolean bl) {
        DialogOverlayImpl dialogOverlayImpl = this;
        DialogOverlayImpl dialogOverlayImpl2 = this;
        this.mCompositorOffset = new int[2];
        ThreadUtils.assertOnUiThread();
        this.mClient = object;
        this.mReleasedRunnable = runnable;
        dialogOverlayImpl2.mOverlayHandler = handler;
        dialogOverlayImpl2.mDialogCore = new a();
        dialogOverlayImpl2.mHoppingHost = new a.b.c.b.s.b(this);
        object = d2.a;
        dialogOverlayImpl.mNativeHandle = dialogOverlayImpl.nativeInit(((a.b.k.a.a)object).a, ((a.b.k.a.a)object).b, d2.d);
        if (dialogOverlayImpl.mNativeHandle == 0L) {
            DialogOverlayImpl dialogOverlayImpl3 = this;
            ((c.e)dialogOverlayImpl3.mClient).c();
            dialogOverlayImpl3.cleanup();
            return;
        }
        DialogOverlayImpl dialogOverlayImpl4 = this;
        object = dialogOverlayImpl4.mDialogCore;
        handler = ContextUtils.getApplicationContext();
        dialogOverlayImpl4.nativeGetCompositorOffset(dialogOverlayImpl4.mNativeHandle, d2.b);
        dialogOverlayImpl4.mOverlayHandler.post(new Runnable((a)object, (Context)handler, d2, bl){
            public final /* synthetic */ a val$dialogCore;
            public final /* synthetic */ Context val$context;
            public final /* synthetic */ d val$config;
            public final /* synthetic */ boolean val$asPanel;
            {
                this.val$dialogCore = a2;
                this.val$context = context;
                this.val$config = d2;
                this.val$asPanel = bl;
            }

            @Override
            public void run() {
                this.val$dialogCore.a(this.val$context, this.val$config, DialogOverlayImpl.this.mHoppingHost, this.val$asPanel);
                PostTask.postTask(y.a, new Runnable(){

                    @Override
                    public void run() {
                        if (DialogOverlayImpl.this.mNativeHandle != 0L) {
                            DialogOverlayImpl dialogOverlayImpl = DialogOverlayImpl.this;
                            dialogOverlayImpl.nativeCompleteInit(dialogOverlayImpl.mNativeHandle);
                        }
                    }
                });
            }
        });
        dialogOverlayImpl4.mReleaseCoreRunnable = new Runnable((a)object){
            public final /* synthetic */ a val$dialogCore;
            {
                this.val$dialogCore = a2;
            }

            @Override
            public void run() {
                a a2 = this.val$dialogCore;
                a2.a();
                a2.b();
                a2.d.token = null;
                a2.a = null;
            }
        };
    }

    public static void receiveCompositorOffset(b b2, int n2, int n3) {
        b b3 = b2;
        b3.a += n2;
        b3.b += n3;
    }

    private void sendWindowTokenToCore(final IBinder iBinder) {
        ThreadUtils.assertOnUiThread();
        final a a2 = this.mDialogCore;
        if (a2 != null) {
            this.mOverlayHandler.post(new Runnable(){

                @Override
                public void run() {
                    a a22 = this_.a2;
                    4 this_ = this_.iBinder;
                    a22.a();
                    if (a22.b != null && a22.a != null) {
                        IBinder iBinder2;
                        if (this_ != null && ((iBinder2 = a22.d.token) == null || this_ == iBinder2)) {
                            iBinder2 = a22.d;
                            if (iBinder2.token != this_) {
                                a a3 = a22;
                                iBinder2.token = this_;
                                a3.b.getWindow().setAttributes(a22.d);
                                a3.c = a22.new a.b(null);
                                a3.b.getWindow().takeSurface((SurfaceHolder.Callback2)a22.c);
                                a3.b.show();
                            }
                        } else {
                            a a4 = a22;
                            a4.a.onOverlayDestroyed();
                            a4.a = null;
                            a4.b();
                        }
                    }
                }
            });
        }
    }

    private void onPowerEfficientState(boolean bl) {
        ThreadUtils.assertOnUiThread();
        if (q2.mDialogCore == null) {
            return;
        }
        q q2 = q2.mClient;
        if (q2 == null) {
            return;
        }
        ((c.e)q2).a(bl);
    }

    private void cleanup() {
        long l2;
        ThreadUtils.assertOnUiThread();
        int n2 = this.mSurfaceId;
        if (n2 != 0) {
            DialogOverlayImpl.nativeUnregisterSurface(n2);
            this.mSurfaceId = 0;
        }
        if ((l2 = this.mNativeHandle) != 0L) {
            this.nativeDestroy(l2);
            this.mNativeHandle = 0L;
        }
        this.mDialogCore = null;
        a.b.i.a.b b2 = this.mClient;
        if (b2 != null) {
            b2.close();
        }
        this.mClient = null;
    }

    private native long nativeInit(long var1, long var3, boolean var5);

    private native void nativeCompleteInit(long var1);

    private native void nativeDestroy(long var1);

    private native void nativeGetCompositorOffset(long var1, b var3);

    public static native int nativeRegisterSurface(Surface var0);

    public static native void nativeUnregisterSurface(int var0);

    public static native Surface nativeLookupSurfaceForTesting(int var0);

    static {
        $assertionsDisabled = DialogOverlayImpl.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public void close() {
        ThreadUtils.assertOnUiThread();
        if (this.mClosed) {
            return;
        }
        DialogOverlayImpl dialogOverlayImpl = this;
        dialogOverlayImpl.mClosed = true;
        dialogOverlayImpl.mHoppingHost.l.release(1);
        Runnable runnable = dialogOverlayImpl.mReleaseCoreRunnable;
        if (runnable != null) {
            DialogOverlayImpl dialogOverlayImpl2 = this;
            dialogOverlayImpl2.mOverlayHandler.post(runnable);
            dialogOverlayImpl2.mReleaseCoreRunnable = null;
            dialogOverlayImpl2.cleanup();
        }
        this.mReleasedRunnable.run();
    }

    @Override
    public void onConnectionError(k k2) {
        ThreadUtils.assertOnUiThread();
        this.close();
    }

    @Override
    public void scheduleLayout(final b b2) {
        ThreadUtils.assertOnUiThread();
        if (this.mDialogCore == null) {
            return;
        }
        DialogOverlayImpl dialogOverlayImpl = this;
        dialogOverlayImpl.nativeGetCompositorOffset(dialogOverlayImpl.mNativeHandle, b2);
        final a a2 = dialogOverlayImpl.mDialogCore;
        dialogOverlayImpl.mOverlayHandler.post(new Runnable(){

            @Override
            public void run() {
                3 v0 = a22;
                a a22 = v0.a2;
                b b22 = v0.b2;
                if (a22.b != null && a22.d.token != null && a22.a(b22)) {
                    a22.b.getWindow().setAttributes(a22.d);
                }
            }
        });
    }

    @Override
    public void onSurfaceReady(Surface surface) {
        ThreadUtils.assertOnUiThread();
        if (this.mDialogCore != null && this.mClient != null) {
            this.mSurfaceId = DialogOverlayImpl.nativeRegisterSurface(surface);
            long l2 = this.mSurfaceId;
            ((c.e)this.mClient).a(l2);
            return;
        }
    }

    @Override
    public void onOverlayDestroyed() {
        ThreadUtils.assertOnUiThread();
        if (this.mDialogCore == null) {
            return;
        }
        a.b.i.a.b b2 = this.mClient;
        if (b2 != null) {
            ((c.e)b2).c();
        }
        this.cleanup();
    }

    @Override
    public void waitForClose() {
        if ($assertionsDisabled) {
            return;
        }
        throw new AssertionError((Object)"Not reached");
    }

    @Override
    public void enforceClose() {
        this.close();
    }

    public void onWindowToken(IBinder iBinder) {
        ThreadUtils.assertOnUiThread();
        if (this.mDialogCore == null) {
            return;
        }
        this.sendWindowTokenToCore(iBinder);
    }

    public void onDismissed() {
        ThreadUtils.assertOnUiThread();
        a.b.i.a.b b2 = this.mClient;
        if (b2 != null) {
            ((c.e)b2).c();
        }
        DialogOverlayImpl dialogOverlayImpl = this;
        dialogOverlayImpl.sendWindowTokenToCore(null);
        dialogOverlayImpl.cleanup();
    }
}

