/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.b.a.q.a;
import a.b.d.a.y;
import android.os.Build;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.chromium.base.ContextUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.PostTask;
import org.chromium.content.browser.LollipopTtsPlatformImpl;

@JNINamespace(value="content")
public class TtsPlatformImpl {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mNativeTtsPlatformImplAndroid;
    public final TextToSpeech mTextToSpeech;
    public boolean mInitialized = false;
    public List<TtsVoice> mVoices;
    public String mCurrentLanguage;
    public PendingUtterance mPendingUtterance;

    public TtsPlatformImpl(long l2) {
        this.mNativeTtsPlatformImplAndroid = l2;
        this.mTextToSpeech = new TextToSpeech(ContextUtils.getApplicationContext(), n2 -> {
            if (n2 == 0) {
                PostTask.runOrPostTask(y.a, () -> this.initialize());
            }
        });
        this.addOnUtteranceProgressListener();
    }

    public static TtsPlatformImpl create(long l2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new LollipopTtsPlatformImpl(l2);
        }
        return new TtsPlatformImpl(l2);
    }

    private void destroy() {
        this.mNativeTtsPlatformImplAndroid = 0L;
    }

    private boolean isInitialized() {
        return this.mInitialized;
    }

    private int getVoiceCount() {
        if (!$assertionsDisabled && !this.mInitialized) {
            throw new AssertionError();
        }
        return this.mVoices.size();
    }

    private String getVoiceName(int n2) {
        if (!$assertionsDisabled && !this.mInitialized) {
            throw new AssertionError();
        }
        return this.mVoices.get(n2).mName;
    }

    private String getVoiceLanguage(int n2) {
        if (!$assertionsDisabled && !this.mInitialized) {
            throw new AssertionError();
        }
        return this.mVoices.get(n2).mLanguage;
    }

    private boolean speak(int n2, String string2, String string3, float f2, float f3, float f4) {
        if (!this.mInitialized) {
            this.mPendingUtterance = new PendingUtterance(this, n2, string2, string3, f2, f3, f4, null);
            return true;
        }
        if (this.mPendingUtterance != null) {
            this.mPendingUtterance = null;
        }
        if (!string3.equals(this.mCurrentLanguage)) {
            this.mTextToSpeech.setLanguage(new Locale(string3));
            this.mCurrentLanguage = string3;
        }
        TtsPlatformImpl ttsPlatformImpl = this;
        ttsPlatformImpl.mTextToSpeech.setSpeechRate(f2);
        ttsPlatformImpl.mTextToSpeech.setPitch(f3);
        return this.callSpeak(string2, f4, n2) == 0;
    }

    private void stop() {
        if (this.mInitialized) {
            this.mTextToSpeech.stop();
        }
        if (this.mPendingUtterance != null) {
            this.mPendingUtterance = null;
        }
    }

    private void initialize() {
        TraceEvent.begin("TtsPlatformImpl:initialize");
        new a<List<TtsVoice>>(){
            public static final /* synthetic */ boolean $assertionsDisabled;

            static {
                $assertionsDisabled = TtsPlatformImpl.class.desiredAssertionStatus() ^ true;
            }

            @Override
            public List<TtsVoice> doInBackground() {
                int n2;
                ArrayList<TtsVoice> arrayList;
                if (!$assertionsDisabled && TtsPlatformImpl.this.mNativeTtsPlatformImplAndroid == 0L) {
                    throw new AssertionError();
                }
                TraceEvent traceEvent = TraceEvent.scoped("TtsPlatformImpl:initialize.async_task");
                Locale[] localeArray = Locale.getAvailableLocales();
                ArrayList<TtsVoice> arrayList2 = arrayList;
                try {
                    arrayList = new ArrayList<TtsVoice>();
                    n2 = localeArray.length;
                }
                catch (Throwable throwable) {
                    if (traceEvent != null) {
                        try {
                            traceEvent.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string2;
                    Locale locale;
                    block19: {
                        locale = localeArray[i2];
                        if (!locale.getVariant().isEmpty()) continue;
                        if (TtsPlatformImpl.this.mTextToSpeech.isLanguageAvailable(locale) <= 0) continue;
                        Locale locale2 = locale;
                        Locale locale3 = locale2;
                        string2 = locale2.getDisplayLanguage();
                        if (locale3.getCountry().isEmpty()) break block19;
                        string2 = string2 + " " + locale.getDisplayCountry();
                    }
                    try {
                        arrayList2.add(new TtsVoice(string2, locale.toString(), null));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (traceEvent != null) {
                    traceEvent.close();
                }
                return arrayList2;
            }

            @Override
            public void onPostExecute(List<TtsVoice> list) {
                2 v0 = this;
                TtsPlatformImpl.access$602(v0.TtsPlatformImpl.this, list);
                TtsPlatformImpl.access$702(v0.TtsPlatformImpl.this, true);
                TtsPlatformImpl ttsPlatformImpl = v0.TtsPlatformImpl.this;
                ttsPlatformImpl.nativeVoicesChanged(ttsPlatformImpl.mNativeTtsPlatformImplAndroid);
                if (v0.TtsPlatformImpl.this.mPendingUtterance != null) {
                    TtsPlatformImpl.this.mPendingUtterance.speak();
                }
                TraceEvent.end("TtsPlatformImpl:initialize");
            }
        }.executeOnExecutor(a.THREAD_POOL_EXECUTOR);
    }

    private native void nativeVoicesChanged(long var1);

    private native void nativeOnEndEvent(long var1, int var3);

    private native void nativeOnStartEvent(long var1, int var3);

    private native void nativeOnErrorEvent(long var1, int var3);

    public static /* synthetic */ List access$602(TtsPlatformImpl ttsPlatformImpl, List list) {
        ttsPlatformImpl.mVoices = list;
        return list;
    }

    public static /* synthetic */ boolean access$702(TtsPlatformImpl ttsPlatformImpl, boolean bl) {
        ttsPlatformImpl.mInitialized = bl;
        return bl;
    }

    static {
        $assertionsDisabled = TtsPlatformImpl.class.desiredAssertionStatus() ^ true;
    }

    public void sendEndEventOnUiThread(String string2) {
        PostTask.runOrPostTask(y.a, () -> {
            long l2 = this.mNativeTtsPlatformImplAndroid;
            if (l2 != 0L) {
                this.nativeOnEndEvent(l2, Integer.parseInt(string2));
            }
        });
    }

    public void sendErrorEventOnUiThread(String string2) {
        PostTask.runOrPostTask(y.a, () -> {
            long l2 = this.mNativeTtsPlatformImplAndroid;
            if (l2 != 0L) {
                this.nativeOnErrorEvent(l2, Integer.parseInt(string2));
            }
        });
    }

    public void sendStartEventOnUiThread(String string2) {
        PostTask.runOrPostTask(y.a, () -> {
            long l2 = this.mNativeTtsPlatformImplAndroid;
            if (l2 != 0L) {
                this.nativeOnStartEvent(l2, Integer.parseInt(string2));
            }
        });
    }

    public void addOnUtteranceProgressListener() {
        this.mTextToSpeech.setOnUtteranceProgressListener(new UtteranceProgressListener(){

            public void onDone(String string2) {
                TtsPlatformImpl.this.sendEndEventOnUiThread(string2);
            }

            public void onError(String string2) {
                TtsPlatformImpl.this.sendErrorEventOnUiThread(string2);
            }

            public void onStart(String string2) {
                TtsPlatformImpl.this.sendStartEventOnUiThread(string2);
            }
        });
    }

    public int callSpeak(String string2, float f2, int n2) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        double d2 = f2;
        if (d2 != 1.0) {
            hashMap2.put("volume", Double.toString(d2));
        }
        hashMap2.put("utteranceId", Integer.toString(n2));
        return this.mTextToSpeech.speak(string2, 0, hashMap2);
    }

    public static class PendingUtterance {
        public TtsPlatformImpl mImpl;
        public int mUtteranceId;
        public String mText;
        public String mLang;
        public float mRate;
        public float mPitch;
        public float mVolume;

        public PendingUtterance(TtsPlatformImpl ttsPlatformImpl, int n2, String string2, String string3, float f2, float f3, float f4) {
            this.mImpl = ttsPlatformImpl;
            this.mUtteranceId = n2;
            this.mText = string2;
            this.mLang = string3;
            this.mRate = f2;
            this.mPitch = f3;
            this.mVolume = f4;
        }

        private void speak() {
            this.mImpl.speak(this.mUtteranceId, this.mText, this.mLang, this.mRate, this.mPitch, this.mVolume);
        }

        public /* synthetic */ PendingUtterance(TtsPlatformImpl ttsPlatformImpl, int n2, String string2, String string3, float f2, float f3, float f4, 1 var8_8) {
            this(ttsPlatformImpl, n2, string2, string3, f2, f3, f4);
        }
    }

    public static class TtsVoice {
        public final String mName;
        public final String mLanguage;

        public TtsVoice(String string2, String string3) {
            this.mName = string2;
            this.mLanguage = string3;
        }

        public /* synthetic */ TtsVoice(String string2, String string3, 1 var3_3) {
            this(string2, string3);
        }
    }
}

