/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.a.a.a.a;
import a.b.a.g;
import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import java.util.ArrayList;
import java.util.Iterator;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="content")
public class SpeechRecognitionImpl {
    public static final String TAG = "SpeechRecog";
    public static final String PROVIDER_PACKAGE_NAME = "com.google.android.googlequicksearchbox";
    public static final int PROVIDER_MIN_VERSION = 300207030;
    public static final int STATE_IDLE = 0;
    public static final int STATE_AWAITING_SPEECH = 1;
    public static final int STATE_CAPTURING_SPEECH = 2;
    public static ComponentName sRecognitionProvider;
    public int mState;
    public final Intent mIntent;
    public final RecognitionListener mListener;
    public SpeechRecognizer mRecognizer;
    public long mNativeSpeechRecognizerImplAndroid;
    public boolean mContinuous;

    @SuppressLint(value={"WrongConstant"})
    public static boolean initialize() {
        Context context = ContextUtils.getApplicationContext();
        if (!SpeechRecognizer.isRecognitionAvailable((Context)context)) {
            return false;
        }
        Iterator iterator = context.getPackageManager().queryIntentServices(new Intent("android.speech.RecognitionService"), 4).iterator();
        while (iterator.hasNext()) {
            int n2;
            ServiceInfo serviceInfo;
            block5: {
                serviceInfo = ((ResolveInfo)iterator.next()).serviceInfo;
                if (!serviceInfo.packageName.equals(PROVIDER_PACKAGE_NAME)) continue;
                String string2 = serviceInfo.packageName;
                n2 = -1;
                try {
                    string2 = context.getPackageManager().getPackageInfo(string2, 0);
                    if (string2 == null) break block5;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {}
                n2 = ((PackageInfo)string2).versionCode;
            }
            if (n2 < 300207030) continue;
            sRecognitionProvider = new ComponentName(serviceInfo.packageName, serviceInfo.name);
            return true;
        }
        return false;
    }

    public SpeechRecognitionImpl(long l2) {
        SpeechRecognitionImpl speechRecognitionImpl = this;
        this.mContinuous = false;
        speechRecognitionImpl.mNativeSpeechRecognizerImplAndroid = l2;
        speechRecognitionImpl.mListener = new Listener();
        speechRecognitionImpl.mIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mRecognizer = sRecognitionProvider != null ? SpeechRecognizer.createSpeechRecognizer((Context)ContextUtils.getApplicationContext(), (ComponentName)sRecognitionProvider) : SpeechRecognizer.createSpeechRecognizer((Context)ContextUtils.getApplicationContext());
        this.mRecognizer.setRecognitionListener(this.mListener);
    }

    private void terminate(int n2) {
        long l2 = this.mNativeSpeechRecognizerImplAndroid;
        if (l2 == 0L) {
            return;
        }
        int n3 = this.mState;
        if (n3 != 0) {
            if (n3 == 2) {
                this.nativeOnSoundEnd(l2);
            }
            SpeechRecognitionImpl speechRecognitionImpl = this;
            speechRecognitionImpl.nativeOnAudioEnd(speechRecognitionImpl.mNativeSpeechRecognizerImplAndroid);
            speechRecognitionImpl.mState = 0;
        }
        if (n2 != 0) {
            SpeechRecognitionImpl speechRecognitionImpl = this;
            speechRecognitionImpl.nativeOnRecognitionError(speechRecognitionImpl.mNativeSpeechRecognizerImplAndroid, n2);
        }
        try {
            this.mRecognizer.destroy();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalArgumentException;
            g.d(TAG, a.a("Destroy threw exception ").append(this.mRecognizer).toString(), objectArray2);
        }
        SpeechRecognitionImpl speechRecognitionImpl = this;
        speechRecognitionImpl.mRecognizer = null;
        speechRecognitionImpl.nativeOnRecognitionEnd(speechRecognitionImpl.mNativeSpeechRecognizerImplAndroid);
        speechRecognitionImpl.mNativeSpeechRecognizerImplAndroid = 0L;
    }

    public static SpeechRecognitionImpl createSpeechRecognition(long l2) {
        return new SpeechRecognitionImpl(l2);
    }

    private void startRecognition(String string2, boolean bl, boolean bl2) {
        if (this.mRecognizer == null) {
            return;
        }
        SpeechRecognitionImpl speechRecognitionImpl = this;
        speechRecognitionImpl.mContinuous = bl;
        speechRecognitionImpl.mIntent.putExtra("android.speech.extra.DICTATION_MODE", bl);
        speechRecognitionImpl.mIntent.putExtra("android.speech.extra.LANGUAGE", string2);
        speechRecognitionImpl.mIntent.putExtra("android.speech.extra.PARTIAL_RESULTS", bl2);
        speechRecognitionImpl.mRecognizer.startListening(this.mIntent);
    }

    private void abortRecognition() {
        SpeechRecognizer speechRecognizer = this.mRecognizer;
        if (speechRecognizer == null) {
            return;
        }
        speechRecognizer.cancel();
        this.terminate(2);
    }

    private void stopRecognition() {
        SpeechRecognizer speechRecognizer = this.mRecognizer;
        if (speechRecognizer == null) {
            return;
        }
        this.mContinuous = false;
        speechRecognizer.stopListening();
    }

    private native void nativeOnAudioStart(long var1);

    private native void nativeOnSoundStart(long var1);

    private native void nativeOnSoundEnd(long var1);

    private native void nativeOnAudioEnd(long var1);

    private native void nativeOnRecognitionResults(long var1, String[] var3, float[] var4, boolean var5);

    private native void nativeOnRecognitionError(long var1, int var3);

    private native void nativeOnRecognitionEnd(long var1);

    public static /* synthetic */ int access$002(SpeechRecognitionImpl speechRecognitionImpl, int n2) {
        speechRecognitionImpl.mState = n2;
        return n2;
    }

    public class Listener
    implements RecognitionListener {
        public static final /* synthetic */ boolean $assertionsDisabled;

        private void handleResults(Bundle object, boolean bl) {
            if (stringArray2.SpeechRecognitionImpl.this.mContinuous && bl) {
                bl = false;
            }
            String[] stringArray = stringArray2;
            Bundle bundle = object;
            ArrayList arrayList = bundle.getStringArrayList("results_recognition");
            String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            object = bundle.getFloatArray("confidence_scores");
            SpeechRecognitionImpl speechRecognitionImpl = stringArray.SpeechRecognitionImpl.this;
            speechRecognitionImpl.nativeOnRecognitionResults(speechRecognitionImpl.mNativeSpeechRecognizerImplAndroid, stringArray2, (float[])object, bl);
        }

        static {
            $assertionsDisabled = SpeechRecognitionImpl.class.desiredAssertionStatus() ^ true;
        }

        public void onBeginningOfSpeech() {
            Listener listener = this;
            SpeechRecognitionImpl.access$002(listener.SpeechRecognitionImpl.this, 2);
            SpeechRecognitionImpl speechRecognitionImpl = listener.SpeechRecognitionImpl.this;
            speechRecognitionImpl.nativeOnSoundStart(speechRecognitionImpl.mNativeSpeechRecognizerImplAndroid);
        }

        public void onBufferReceived(byte[] byArray) {
        }

        public void onEndOfSpeech() {
            if (!SpeechRecognitionImpl.this.mContinuous) {
                Listener listener = this;
                SpeechRecognitionImpl speechRecognitionImpl = listener.SpeechRecognitionImpl.this;
                speechRecognitionImpl.nativeOnSoundEnd(speechRecognitionImpl.mNativeSpeechRecognizerImplAndroid);
                SpeechRecognitionImpl speechRecognitionImpl2 = listener.SpeechRecognitionImpl.this;
                speechRecognitionImpl2.nativeOnAudioEnd(speechRecognitionImpl2.mNativeSpeechRecognizerImplAndroid);
                SpeechRecognitionImpl.access$002(listener.SpeechRecognitionImpl.this, 0);
            }
        }

        public void onError(int n2) {
            block9: {
                switch (n2) {
                    default: {
                        if ($assertionsDisabled) {
                            return;
                        }
                        break block9;
                    }
                    case 8: 
                    case 9: {
                        n2 = 5;
                        break;
                    }
                    case 7: {
                        n2 = 9;
                        break;
                    }
                    case 6: {
                        n2 = 1;
                        break;
                    }
                    case 5: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        n2 = 4;
                    }
                }
                SpeechRecognitionImpl.this.terminate(n2);
                return;
            }
            throw new AssertionError();
        }

        public void onEvent(int n2, Bundle bundle) {
        }

        public void onPartialResults(Bundle bundle) {
            this.handleResults(bundle, true);
        }

        public void onReadyForSpeech(Bundle bundle) {
            Listener listener = this;
            SpeechRecognitionImpl.access$002(listener.SpeechRecognitionImpl.this, 1);
            SpeechRecognitionImpl speechRecognitionImpl = listener.SpeechRecognitionImpl.this;
            speechRecognitionImpl.nativeOnAudioStart(speechRecognitionImpl.mNativeSpeechRecognizerImplAndroid);
        }

        public void onResults(Bundle bundle) {
            Listener listener = this;
            listener.handleResults(bundle, false);
            listener.SpeechRecognitionImpl.this.terminate(0);
        }

        public void onRmsChanged(float f2) {
        }
    }
}

