/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.process_launcher;

import a.b.a.n.b;
import a.b.a.p.e;
import a.b.a.p.f;
import a.b.a.p.g;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.support.annotation.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.base.process_launcher.FileDescriptorInfo;

@JNINamespace(value="base::android")
@MainDex
public abstract class ChildProcessService
extends Service {
    public static final String MAIN_THREAD_NAME = "ChildProcessMain";
    public static final String TAG = "ChildProcessService";
    public static boolean sCreateCalled;
    public static int sSplitApkWorkaroundResult;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final e mDelegate;
    public final Object mBinderLock = new Object();
    public final Object mLibraryInitializedLock = new Object();
    public boolean mBindToCallerCheck;
    @GuardedBy(value="mBinderLock")
    public int mBoundCallingPid;
    public Thread mMainThread;
    public String[] mCommandLineParams;
    public FileDescriptorInfo[] mFdInfos;
    @GuardedBy(value="mLibraryInitializedLock")
    public boolean mLibraryInitialized;
    public boolean mServiceBound;
    public g mParentProcess;
    public final f.a mBinder = new f.a(){
        public static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = ChildProcessService.class.desiredAssertionStatus() ^ true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean bindToCaller() {
            int n2;
            block7: {
                if (!$assertionsDisabled) {
                    if (!ChildProcessService.this.mBindToCallerCheck) throw new AssertionError();
                }
                if (!$assertionsDisabled) {
                    if (!ChildProcessService.this.mServiceBound) throw new AssertionError();
                }
                1 v0 = this;
                Object object = v0.ChildProcessService.this.mBinderLock;
                // MONITORENTER : object
                n2 = Binder.getCallingPid();
                if (v0.ChildProcessService.this.mBoundCallingPid != 0) break block7;
                ChildProcessService.access$302(ChildProcessService.this, n2);
                return true;
            }
            if (ChildProcessService.this.mBoundCallingPid == n2) return true;
            String string2 = ChildProcessService.TAG;
            String string3 = "Service is already bound by pid %d, cannot bind for pid %d";
            Object[] objectArray = new Object[2];
            objectArray[0] = ChildProcessService.this.mBoundCallingPid;
            objectArray[1] = n2;
            a.b.a.g.b(string2, string3, objectArray);
            // MONITOREXIT : object
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setupConnection(Bundle bundle, g g2, List<IBinder> list) {
            1 v2;
            if (!$assertionsDisabled && !ChildProcessService.this.mServiceBound) {
                throw new AssertionError();
            }
            1 v0 = this;
            Object object = v0.ChildProcessService.this.mBinderLock;
            synchronized (object) {
                if (v0.ChildProcessService.this.mBindToCallerCheck && ChildProcessService.this.mBoundCallingPid == 0) {
                    a.b.a.g.b(ChildProcessService.TAG, "Service has not been bound with bindToCaller()", new Object[0]);
                    g2.a(-1);
                    return;
                }
                1 v1 = this;
                v2 = v1;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl14 : MonitorExitStatement: MONITOREXIT : var4_4
                g2.a(Process.myPid());
                ChildProcessService.access$402(v1.ChildProcessService.this, g2);
            }
            v2.ChildProcessService.this.processConnectionBundle(bundle, list);
        }

        @Override
        public void forceKill() {
            if (!$assertionsDisabled && !ChildProcessService.this.mServiceBound) {
                throw new AssertionError();
            }
            Process.killProcess((int)Process.myPid());
        }

        @Override
        public void onMemoryPressure(int n2) {
            ThreadUtils.postOnUiThread(() -> {
                if (n2 >= b.k.a()) {
                    b.k.a(n2);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void dumpProcessStack() {
            Object object;
            if (!$assertionsDisabled && !object.ChildProcessService.this.mServiceBound) {
                throw new AssertionError();
            }
            1 v0 = object;
            object = v0.ChildProcessService.this.mLibraryInitializedLock;
            synchronized (object) {
                if (!v0.ChildProcessService.this.mLibraryInitialized) {
                    a.b.a.g.b(ChildProcessService.TAG, "Cannot dump process stack before native is loaded", new Object[0]);
                    return;
                }
            }
            ChildProcessService.nativeDumpProcessStack();
        }
    };

    public static void setSplitApkWorkaroundResult(int n2) {
        sSplitApkWorkaroundResult = n2;
    }

    public ChildProcessService(e e2) {
        this.mDelegate = e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processConnectionBundle(Bundle bundle, List<IBinder> list) {
        ChildProcessService childProcessService = this;
        bundle.setClassLoader(this.getApplicationContext().getClassLoader());
        Thread thread = childProcessService.mMainThread;
        synchronized (thread) {
            if (childProcessService.mCommandLineParams == null) {
                this.mCommandLineParams = bundle.getStringArray("com.vccorp.base.process_launcher.extra.command_line");
                this.mMainThread.notifyAll();
            }
            if (!$assertionsDisabled && this.mCommandLineParams == null) {
                throw new AssertionError();
            }
            Parcelable[] parcelableArray = bundle.getParcelableArray("com.vccorp.base.process_launcher.extra.extraFiles");
            if (parcelableArray != null) {
                this.mFdInfos = new FileDescriptorInfo[parcelableArray.length];
                System.arraycopy(parcelableArray, 0, this.mFdInfos, 0, parcelableArray.length);
            }
            ChildProcessService childProcessService2 = this;
            childProcessService2.mDelegate.onConnectionSetup(bundle, list);
            childProcessService2.mMainThread.notifyAll();
            return;
        }
    }

    public static native void nativeRegisterFileDescriptors(String[] var0, int[] var1, int[] var2, long[] var3, long[] var4);

    public static native void nativeExitChildProcess();

    public static native void nativeDumpProcessStack();

    public static /* synthetic */ int access$302(ChildProcessService childProcessService, int n2) {
        childProcessService.mBoundCallingPid = n2;
        return n2;
    }

    public static /* synthetic */ g access$402(ChildProcessService childProcessService, g g2) {
        childProcessService.mParentProcess = g2;
        return g2;
    }

    public static /* synthetic */ Thread access$900(ChildProcessService childProcessService) {
        return childProcessService.mMainThread;
    }

    public static /* synthetic */ String[] access$1000(ChildProcessService childProcessService) {
        return childProcessService.mCommandLineParams;
    }

    public static /* synthetic */ e access$1100(ChildProcessService childProcessService) {
        return childProcessService.mDelegate;
    }

    public static /* synthetic */ boolean access$702(ChildProcessService childProcessService, boolean bl) {
        childProcessService.mLibraryInitialized = bl;
        return bl;
    }

    public static /* synthetic */ FileDescriptorInfo[] access$1200(ChildProcessService childProcessService) {
        return childProcessService.mFdInfos;
    }

    public static /* synthetic */ void access$1300(String[] stringArray, int[] nArray, int[] nArray2, long[] lArray, long[] lArray2) {
        ChildProcessService.nativeRegisterFileDescriptors(stringArray, nArray, nArray2, lArray, lArray2);
    }

    public static /* synthetic */ int access$1400() {
        return sSplitApkWorkaroundResult;
    }

    public static /* synthetic */ g access$400(ChildProcessService childProcessService) {
        return childProcessService.mParentProcess;
    }

    public static /* synthetic */ void access$1500() {
        ChildProcessService.nativeExitChildProcess();
    }

    static {
        $assertionsDisabled = ChildProcessService.class.desiredAssertionStatus() ^ true;
        sSplitApkWorkaroundResult = 0;
    }

    public void onCreate() {
        super.onCreate();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = Process.myPid();
        a.b.a.g.c(TAG, "Creating new ChildProcessService pid=%d", objectArray2);
        if (!sCreateCalled) {
            ChildProcessService childProcessService = this;
            sCreateCalled = true;
            ContextUtils.initApplicationContext(childProcessService.getApplicationContext());
            childProcessService.mDelegate.onServiceCreated();
            childProcessService.mMainThread = new Thread(new Runnable(){
                public static final /* synthetic */ boolean $assertionsDisabled;

                static {
                    $assertionsDisabled = ChildProcessService.class.desiredAssertionStatus() ^ true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    block33: {
                        var1_3 = ChildProcessService.access$900(ChildProcessService.this);
                        ** synchronized (var1_3)
lbl-1000:
                        // 1 sources

                        {
                            while (ChildProcessService.access$1000(ChildProcessService.this) == null) {
                                ChildProcessService.access$900(ChildProcessService.this).wait();
                            }
                        }
                        if (!2.$assertionsDisabled && !ChildProcessService.access$100(ChildProcessService.this)) {
                            throw new AssertionError();
                        }
                        CommandLine.init(ChildProcessService.access$1000(ChildProcessService.this));
                        if (CommandLine.getInstance().hasSwitch("renderer-wait-for-java-debugger")) {
                            Debug.waitForDebugger();
                        }
                        var1_4 = false;
                        try {
                            var1_4 = ChildProcessService.access$1100(ChildProcessService.this).loadNativeLibrary(ChildProcessService.this.getApplicationContext());
                            ** GOTO lbl22
                        }
                        catch (Exception var2_6) {
                            a.b.a.g.b("ChildProcessService", "Failed to load native library.", new Object[]{var2_6});
lbl22:
                            // 2 sources

                            if (!var1_4) {
                                System.exit(-1);
                            }
                            v0 = this;
                            v1 = v0;
                            v2 = v0;
                            var1_5 = ChildProcessService.access$600(v0.ChildProcessService.this);
                        }
                        v3 = this;
                        v4 = v3;
                        v5 = v3;
                        ** synchronized (var1_5)
lbl-1000:
                        // 1 sources

                        {
                            ChildProcessService.access$702(v4.ChildProcessService.this, true);
                            ChildProcessService.access$600(v5.ChildProcessService.this).notifyAll();
                        }
                        var1_5 = ChildProcessService.access$900(v2.ChildProcessService.this);
                        ** synchronized (var1_5)
lbl-1000:
                        // 1 sources

                        {
                            ChildProcessService.access$900(v1.ChildProcessService.this).notifyAll();
                            while (ChildProcessService.access$1200(ChildProcessService.this) == null) {
                                ChildProcessService.access$900(ChildProcessService.this).wait();
                            }
                            v6 = this;
                            v7 = v6;
                            v8 = v6;
                            v9 = v6;
                            v10 = v6;
                            v11 = v6;
                            v12 = v6;
                        }
                        var1_5 = ChildProcessService.access$1100(v9.ChildProcessService.this).getFileDescriptorsIdsToKeys();
                        var2_7 = new int[ChildProcessService.access$1200(v10.ChildProcessService.this).length];
                        var3_8 = new String[ChildProcessService.access$1200(v11.ChildProcessService.this).length];
                        var4_9 = new int[ChildProcessService.access$1200(v12.ChildProcessService.this).length];
                        var5_10 = new long[ChildProcessService.access$1200(v7.ChildProcessService.this).length];
                        var6_11 = new long[ChildProcessService.access$1200(v8.ChildProcessService.this).length];
                        for (var7_12 = 0; var7_12 < ChildProcessService.access$1200(ChildProcessService.this).length; ++var7_12) {
                            var8_13 = ChildProcessService.access$1200(ChildProcessService.this)[var7_12];
                            var9_14 = var1_5 != null ? (String)var1_5.get(var8_13.id) : null;
                            if (var9_14 != null) {
                                var3_8[var7_12] = var9_14;
                            } else {
                                var2_7[var7_12] = var8_13.id;
                            }
                            var4_9[var7_12] = var8_13.fd.detachFd();
                            var5_10[var7_12] = var8_13.offset;
                            var6_11[var7_12] = var8_13.size;
                        }
                        ChildProcessService.access$1300(var3_8, var2_7, var4_9, var5_10, var6_11);
                        ChildProcessService.access$1100(ChildProcessService.this).onBeforeMain();
                        if (ContextUtils.isIsolatedProcess()) {
                            RecordHistogram.recordEnumeratedHistogram("Android.WebView.SplitApkWorkaroundResult", ChildProcessService.access$1400(), 6);
                        }
                        v13 = this;
                        ChildProcessService.access$1100(v13.ChildProcessService.this).runMain();
                        try {
                            ChildProcessService.access$400(v13.ChildProcessService.this).a();
                        }
                        catch (RemoteException var0_1) {
                            a.b.a.g.b("ChildProcessService", "Failed to call clean exit callback.", new Object[]{var0_1});
                        }
                        ChildProcessService.access$1500();
                        break block33;
                        {
                            catch (Throwable v14) {
                                throw v14;
                            }
                        }
                        {
                            catch (Throwable v15) {
                                throw v15;
                            }
                        }
                        {
                            catch (Throwable v16) {
                                throw v16;
                            }
                        }
                        {
                            catch (InterruptedException var0_2) {
                                v17 = new Object[2];
                                var1_3 = v17;
                                v17[0] = "ChildProcessMain";
                                v17[1] = var0_2;
                                a.b.a.g.d("ChildProcessService", "%s startup failed: %s", var1_3);
                            }
                        }
                    }
                }
            }, MAIN_THREAD_NAME);
            childProcessService.mMainThread.start();
            return;
        }
        throw new RuntimeException("Illegal child process reuse.");
    }

    public void onDestroy() {
        super.onDestroy();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = Process.myPid();
        a.b.a.g.c(TAG, "Destroying ChildProcessService pid=%d", objectArray2);
        System.exit(0);
    }

    public IBinder onBind(Intent intent) {
        if (!$assertionsDisabled && this.mServiceBound) {
            throw new AssertionError();
        }
        ChildProcessService childProcessService = this;
        this.stopSelf();
        childProcessService.mBindToCallerCheck = intent.getBooleanExtra("com.vccorp.base.process_launcher.extra.bind_to_caller", false);
        childProcessService.mServiceBound = true;
        childProcessService.mDelegate.onServiceBound(intent);
        new Handler(Looper.getMainLooper()).post(() -> this.mDelegate.preloadNativeLibrary(this.getApplicationContext()));
        return childProcessService.mBinder;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SplitApkWorkaroundResult {
        public static final int NOT_RUN = 0;
        public static final int NO_ENTRIES = 1;
        public static final int ONE_ENTRY = 2;
        public static final int MULTIPLE_ENTRIES = 3;
        public static final int TOPLEVEL_EXCEPTION = 4;
        public static final int LOOP_EXCEPTION = 5;
        public static final int NUM_ENTRIES = 6;
    }
}

