/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class ThreadUtils {
    public static final Object sLock;
    public static boolean sWillOverride;
    public static Handler sUiThreadHandler;
    public static boolean sThreadAssertsDisabled;
    public static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWillOverrideUiThread(boolean bl) {
        Object object = sLock;
        synchronized (object) {
            sWillOverride = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void setUiThread(Looper var0) {
        var1_1 = ThreadUtils.sLock;
        synchronized (var1_1) {
            if (var0 != null) ** GOTO lbl7
            ThreadUtils.sUiThreadHandler = null;
            return;
lbl7:
            // 1 sources

            if (ThreadUtils.sUiThreadHandler == null) ** GOTO lbl14
            if (ThreadUtils.sUiThreadHandler.getLooper() == var0) ** GOTO lbl14
            throw new RuntimeException("UI thread looper is already set to " + ThreadUtils.sUiThreadHandler.getLooper() + " (Main thread looper is " + Looper.getMainLooper() + "), cannot set to new looper " + var0);
lbl14:
            // 2 sources

            ThreadUtils.sUiThreadHandler = new Handler(var0);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Handler getUiThreadHandler() {
        Object object = sLock;
        synchronized (object) {
            if (sUiThreadHandler == null) {
                if (sWillOverride) {
                    throw new RuntimeException("Did not yet override the UI thread");
                }
                sUiThreadHandler = new Handler(Looper.getMainLooper());
            }
            return sUiThreadHandler;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static void runOnUiThreadBlocking(Runnable runnable) {
        if (ThreadUtils.runningOnUiThread()) {
            runnable.run();
            return;
        }
        FutureTask<Object> futureTask = new FutureTask<Object>(runnable, null);
        ThreadUtils.postOnUiThread(futureTask);
        try {
            futureTask.get();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception occurred while waiting for runnable", exception);
        }
    }

    @Deprecated
    public static <T> T runOnUiThreadBlockingNoException(Callable<T> callable) {
        try {
            return ThreadUtils.runOnUiThreadBlocking(callable);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException("Error occurred waiting for callable", executionException);
        }
    }

    @Deprecated
    public static <T> T runOnUiThreadBlocking(Callable<T> callable) {
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        ThreadUtils.runOnUiThread(futureTask);
        try {
            return futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for callable", interruptedException);
        }
    }

    @Deprecated
    public static <T> FutureTask<T> runOnUiThread(FutureTask<T> futureTask) {
        if (ThreadUtils.runningOnUiThread()) {
            futureTask.run();
        } else {
            ThreadUtils.postOnUiThread(futureTask);
        }
        return futureTask;
    }

    @Deprecated
    public static <T> FutureTask<T> runOnUiThread(Callable<T> callable) {
        return ThreadUtils.runOnUiThread(new FutureTask<T>(callable));
    }

    @Deprecated
    public static void runOnUiThread(Runnable runnable) {
        if (ThreadUtils.runningOnUiThread()) {
            runnable.run();
        } else {
            ThreadUtils.getUiThreadHandler().post(runnable);
        }
    }

    @Deprecated
    public static <T> FutureTask<T> postOnUiThread(FutureTask<T> futureTask) {
        ThreadUtils.getUiThreadHandler().post(futureTask);
        return futureTask;
    }

    @Deprecated
    public static void postOnUiThread(Runnable runnable) {
        ThreadUtils.getUiThreadHandler().post(runnable);
    }

    @Deprecated
    public static void postOnUiThreadDelayed(Runnable runnable, long l2) {
        ThreadUtils.getUiThreadHandler().postDelayed(runnable, l2);
    }

    public static void assertOnUiThread() {
        if (sThreadAssertsDisabled) {
            return;
        }
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError((Object)"Must be called on the UI thread.");
        }
    }

    public static void checkUiThread() {
        if (!sThreadAssertsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new IllegalStateException("Must be called on the UI thread.");
        }
    }

    public static void assertOnBackgroundThread() {
        if (sThreadAssertsDisabled) {
            return;
        }
        if (!$assertionsDisabled && ThreadUtils.runningOnUiThread()) {
            throw new AssertionError((Object)"Must be called on a thread other than UI.");
        }
    }

    public static void setThreadAssertsDisabledForTesting(boolean bl) {
        sThreadAssertsDisabled = bl;
    }

    public static boolean runningOnUiThread() {
        return ThreadUtils.getUiThreadHandler().getLooper() == Looper.myLooper();
    }

    public static Looper getUiThreadLooper() {
        return ThreadUtils.getUiThreadHandler().getLooper();
    }

    public static void setThreadPriorityAudio(int n2) {
        Process.setThreadPriority((int)n2, (int)-16);
    }

    public static boolean isThreadPriorityAudio(int n2) {
        return Process.getThreadPriority((int)n2) == -16;
    }

    static {
        $assertionsDisabled = ThreadUtils.class.desiredAssertionStatus() ^ true;
        sLock = new Object();
    }
}

