
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/filter_operation.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class FilterOperation extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 64;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(64, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int type;
    public float amount;
    public float outerThreshold;
    public com.vccorp.gfx.mojom.Point dropShadowOffset;
    public int dropShadowColor;
    public PaintFilter imageFilter;
    public float[] matrix;
    public int zoomInset;
    public int blurTileMode;
    public com.vccorp.gfx.mojom.Rect[] shape;

    private FilterOperation(int version) {
        super(STRUCT_SIZE, version);
    }

    public FilterOperation() {
        this(0);
    }

    public static FilterOperation deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static FilterOperation deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static FilterOperation decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        FilterOperation result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new FilterOperation(elementsOrVersion);
                {
                    
                result.type = decoder0.readInt(8);
                    FilterType.validate(result.type);
                }
                {
                    
                result.amount = decoder0.readFloat(12);
                }
                {
                    
                result.outerThreshold = decoder0.readFloat(16);
                }
                {
                    
                result.dropShadowColor = decoder0.readInt(20);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.dropShadowOffset = com.vccorp.gfx.mojom.Point.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.imageFilter = PaintFilter.decode(decoder1);
                }
                {
                    
                result.matrix = decoder0.readFloats(40, com.vccorp.mojo.bindings.BindingsHelper.ARRAY_NULLABLE, 20);
                }
                {
                    
                result.zoomInset = decoder0.readInt(48);
                }
                {
                    
                result.blurTileMode = decoder0.readInt(52);
                    com.vccorp.skia.mojom.BlurTileMode.validate(result.blurTileMode);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, true);
                if (decoder1 == null) {
                    result.shape = null;
                } else {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.shape = new com.vccorp.gfx.mojom.Rect[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.shape[i1] = com.vccorp.gfx.mojom.Rect.decode(decoder2);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.type, 8);
        
        encoder0.encode(this.amount, 12);
        
        encoder0.encode(this.outerThreshold, 16);
        
        encoder0.encode(this.dropShadowColor, 20);
        
        encoder0.encode(this.dropShadowOffset, 24, false);
        
        encoder0.encode(this.imageFilter, 32, false);
        
        encoder0.encode(this.matrix, 40, com.vccorp.mojo.bindings.BindingsHelper.ARRAY_NULLABLE, 20);
        
        encoder0.encode(this.zoomInset, 48);
        
        encoder0.encode(this.blurTileMode, 52);
        
        if (this.shape == null) {
            encoder0.encodeNullPointer(56, true);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.shape.length, 56, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.shape.length; ++i0) {
                
                encoder1.encode(this.shape[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
    }
}