
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/quads.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class DrawQuad extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.gfx.mojom.Rect rect;
    public com.vccorp.gfx.mojom.Rect visibleRect;
    public boolean needsBlending;
    public SharedQuadState sqs;
    public DrawQuadState drawQuadState;

    private DrawQuad(int version) {
        super(STRUCT_SIZE, version);
    }

    public DrawQuad() {
        this(0);
    }

    public static DrawQuad deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static DrawQuad deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static DrawQuad decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        DrawQuad result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new DrawQuad(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.rect = com.vccorp.gfx.mojom.Rect.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.visibleRect = com.vccorp.gfx.mojom.Rect.decode(decoder1);
                }
                {
                    
                result.needsBlending = decoder0.readBoolean(24, 0);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, true);
                result.sqs = SharedQuadState.decode(decoder1);
                }
                {
                    
                result.drawQuadState = DrawQuadState.decode(decoder0, 40);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.rect, 8, false);
        
        encoder0.encode(this.visibleRect, 16, false);
        
        encoder0.encode(this.needsBlending, 24, 0);
        
        encoder0.encode(this.sqs, 32, true);
        
        encoder0.encode(this.drawQuadState, 40, false);
    }
}