
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/proxy_resolver/public/mojom/proxy_resolver.mojom
//

package com.vccorp.proxy_resolver.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class ProxyScheme {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int INVALID = 0;
    public static final int DIRECT = 1; // INVALID + 1
    public static final int HTTP = 2; // DIRECT + 1
    public static final int SOCKS4 = 3; // HTTP + 1
    public static final int SOCKS5 = 4; // SOCKS4 + 1
    public static final int HTTPS = 5; // SOCKS5 + 1
    public static final int QUIC = 6; // HTTPS + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 6;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private ProxyScheme() {}
}