
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/payments/payment_request.mojom
//

package com.vccorp.payments.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class BasicCardNetwork {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int AMEX = 0;
    public static final int DINERS = 1; // AMEX + 1
    public static final int DISCOVER = 2; // DINERS + 1
    public static final int JCB = 3; // DISCOVER + 1
    public static final int MASTERCARD = 4; // JCB + 1
    public static final int MIR = 5; // MASTERCARD + 1
    public static final int UNIONPAY = 6; // MIR + 1
    public static final int VISA = 7; // UNIONPAY + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 7;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private BasicCardNetwork() {}
}