
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/url_loader.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class UrlRequest extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 192;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(192, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String method;
    public com.vccorp.url.mojom.Url url;
    public com.vccorp.url.mojom.Url siteForCookies;
    public com.vccorp.url.mojom.Origin topFrameOrigin;
    public boolean attachSameSiteCookies;
    public boolean updateFirstPartyUrlOnRedirect;
    public com.vccorp.url.mojom.Origin requestInitiator;
    public com.vccorp.url.mojom.Url referrer;
    public int referrerPolicy;
    public boolean isPrerendering;
    public HttpRequestHeaders headers;
    public HttpRequestHeaders corsExemptHeaders;
    public int loadFlags;
    public boolean allowCredentials;
    public int pluginChildId;
    public int resourceType;
    public int priority;
    public int appcacheHostId;
    public boolean shouldResetAppcache;
    public boolean isExternalRequest;
    public int corsPreflightPolicy;
    public boolean originatedFromServiceWorker;
    public boolean skipServiceWorker;
    public int fetchRequestMode;
    public int fetchCredentialsMode;
    public int fetchRedirectMode;
    public String fetchIntegrity;
    public int fetchRequestContextType;
    public int fetchFrameType;
    public UrlRequestBody requestBody;
    public boolean keepalive;
    public boolean hasUserGesture;
    public boolean enableLoadTiming;
    public boolean enableUploadProgress;
    public boolean doNotPromptForLogin;
    public int renderFrameId;
    public boolean isMainFrame;
    public int transitionType;
    public boolean allowDownload;
    public boolean reportRawHeaders;
    public int previewsState;
    public boolean initiatedInSecureContext;
    public boolean upgradeIfInsecure;
    public boolean isRevalidating;
    public com.vccorp.mojo_base.mojom.UnguessableToken throttlingProfileId;
    public HttpRequestHeaders customProxyPreCacheHeaders;
    public HttpRequestHeaders customProxyPostCacheHeaders;
    public com.vccorp.mojo_base.mojom.UnguessableToken fetchWindowId;
    public String devtoolsRequestId;

    private UrlRequest(int version) {
        super(STRUCT_SIZE, version);
    }

    public UrlRequest() {
        this(0);
    }

    public static UrlRequest deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static UrlRequest deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static UrlRequest decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        UrlRequest result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new UrlRequest(elementsOrVersion);
                {
                    
                result.method = decoder0.readString(8, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.siteForCookies = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, true);
                result.topFrameOrigin = com.vccorp.url.mojom.Origin.decode(decoder1);
                }
                {
                    
                result.attachSameSiteCookies = decoder0.readBoolean(40, 0);
                }
                {
                    
                result.updateFirstPartyUrlOnRedirect = decoder0.readBoolean(40, 1);
                }
                {
                    
                result.isPrerendering = decoder0.readBoolean(40, 2);
                }
                {
                    
                result.allowCredentials = decoder0.readBoolean(40, 3);
                }
                {
                    
                result.shouldResetAppcache = decoder0.readBoolean(40, 4);
                }
                {
                    
                result.isExternalRequest = decoder0.readBoolean(40, 5);
                }
                {
                    
                result.originatedFromServiceWorker = decoder0.readBoolean(40, 6);
                }
                {
                    
                result.skipServiceWorker = decoder0.readBoolean(40, 7);
                }
                {
                    
                result.keepalive = decoder0.readBoolean(41, 0);
                }
                {
                    
                result.hasUserGesture = decoder0.readBoolean(41, 1);
                }
                {
                    
                result.enableLoadTiming = decoder0.readBoolean(41, 2);
                }
                {
                    
                result.enableUploadProgress = decoder0.readBoolean(41, 3);
                }
                {
                    
                result.doNotPromptForLogin = decoder0.readBoolean(41, 4);
                }
                {
                    
                result.isMainFrame = decoder0.readBoolean(41, 5);
                }
                {
                    
                result.allowDownload = decoder0.readBoolean(41, 6);
                }
                {
                    
                result.reportRawHeaders = decoder0.readBoolean(41, 7);
                }
                {
                    
                result.initiatedInSecureContext = decoder0.readBoolean(42, 0);
                }
                {
                    
                result.upgradeIfInsecure = decoder0.readBoolean(42, 1);
                }
                {
                    
                result.isRevalidating = decoder0.readBoolean(42, 2);
                }
                {
                    
                result.referrerPolicy = decoder0.readInt(44);
                    UrlRequestReferrerPolicy.validate(result.referrerPolicy);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, true);
                result.requestInitiator = com.vccorp.url.mojom.Origin.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, false);
                result.referrer = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, false);
                result.headers = HttpRequestHeaders.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(72, false);
                result.corsExemptHeaders = HttpRequestHeaders.decode(decoder1);
                }
                {
                    
                result.loadFlags = decoder0.readInt(80);
                }
                {
                    
                result.pluginChildId = decoder0.readInt(84);
                }
                {
                    
                result.resourceType = decoder0.readInt(88);
                }
                {
                    
                result.priority = decoder0.readInt(92);
                    RequestPriority.validate(result.priority);
                }
                {
                    
                result.appcacheHostId = decoder0.readInt(96);
                }
                {
                    
                result.corsPreflightPolicy = decoder0.readInt(100);
                    CorsPreflightPolicy.validate(result.corsPreflightPolicy);
                }
                {
                    
                result.fetchRequestMode = decoder0.readInt(104);
                    FetchRequestMode.validate(result.fetchRequestMode);
                }
                {
                    
                result.fetchCredentialsMode = decoder0.readInt(108);
                    FetchCredentialsMode.validate(result.fetchCredentialsMode);
                }
                {
                    
                result.fetchRedirectMode = decoder0.readInt(112);
                    FetchRedirectMode.validate(result.fetchRedirectMode);
                }
                {
                    
                result.fetchRequestContextType = decoder0.readInt(116);
                }
                {
                    
                result.fetchIntegrity = decoder0.readString(120, false);
                }
                {
                    
                result.fetchFrameType = decoder0.readInt(128);
                    RequestContextFrameType.validate(result.fetchFrameType);
                }
                {
                    
                result.renderFrameId = decoder0.readInt(132);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(136, true);
                result.requestBody = UrlRequestBody.decode(decoder1);
                }
                {
                    
                result.transitionType = decoder0.readInt(144);
                }
                {
                    
                result.previewsState = decoder0.readInt(148);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(152, true);
                result.throttlingProfileId = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(160, false);
                result.customProxyPreCacheHeaders = HttpRequestHeaders.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(168, false);
                result.customProxyPostCacheHeaders = HttpRequestHeaders.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(176, true);
                result.fetchWindowId = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                }
                {
                    
                result.devtoolsRequestId = decoder0.readString(184, true);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.method, 8, false);
        
        encoder0.encode(this.url, 16, false);
        
        encoder0.encode(this.siteForCookies, 24, false);
        
        encoder0.encode(this.topFrameOrigin, 32, true);
        
        encoder0.encode(this.attachSameSiteCookies, 40, 0);
        
        encoder0.encode(this.updateFirstPartyUrlOnRedirect, 40, 1);
        
        encoder0.encode(this.isPrerendering, 40, 2);
        
        encoder0.encode(this.allowCredentials, 40, 3);
        
        encoder0.encode(this.shouldResetAppcache, 40, 4);
        
        encoder0.encode(this.isExternalRequest, 40, 5);
        
        encoder0.encode(this.originatedFromServiceWorker, 40, 6);
        
        encoder0.encode(this.skipServiceWorker, 40, 7);
        
        encoder0.encode(this.keepalive, 41, 0);
        
        encoder0.encode(this.hasUserGesture, 41, 1);
        
        encoder0.encode(this.enableLoadTiming, 41, 2);
        
        encoder0.encode(this.enableUploadProgress, 41, 3);
        
        encoder0.encode(this.doNotPromptForLogin, 41, 4);
        
        encoder0.encode(this.isMainFrame, 41, 5);
        
        encoder0.encode(this.allowDownload, 41, 6);
        
        encoder0.encode(this.reportRawHeaders, 41, 7);
        
        encoder0.encode(this.initiatedInSecureContext, 42, 0);
        
        encoder0.encode(this.upgradeIfInsecure, 42, 1);
        
        encoder0.encode(this.isRevalidating, 42, 2);
        
        encoder0.encode(this.referrerPolicy, 44);
        
        encoder0.encode(this.requestInitiator, 48, true);
        
        encoder0.encode(this.referrer, 56, false);
        
        encoder0.encode(this.headers, 64, false);
        
        encoder0.encode(this.corsExemptHeaders, 72, false);
        
        encoder0.encode(this.loadFlags, 80);
        
        encoder0.encode(this.pluginChildId, 84);
        
        encoder0.encode(this.resourceType, 88);
        
        encoder0.encode(this.priority, 92);
        
        encoder0.encode(this.appcacheHostId, 96);
        
        encoder0.encode(this.corsPreflightPolicy, 100);
        
        encoder0.encode(this.fetchRequestMode, 104);
        
        encoder0.encode(this.fetchCredentialsMode, 108);
        
        encoder0.encode(this.fetchRedirectMode, 112);
        
        encoder0.encode(this.fetchRequestContextType, 116);
        
        encoder0.encode(this.fetchIntegrity, 120, false);
        
        encoder0.encode(this.fetchFrameType, 128);
        
        encoder0.encode(this.renderFrameId, 132);
        
        encoder0.encode(this.requestBody, 136, true);
        
        encoder0.encode(this.transitionType, 144);
        
        encoder0.encode(this.previewsState, 148);
        
        encoder0.encode(this.throttlingProfileId, 152, true);
        
        encoder0.encode(this.customProxyPreCacheHeaders, 160, false);
        
        encoder0.encode(this.customProxyPostCacheHeaders, 168, false);
        
        encoder0.encode(this.fetchWindowId, 176, true);
        
        encoder0.encode(this.devtoolsRequestId, 184, true);
    }
}