
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/url_loader.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class UrlLoaderClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<UrlLoaderClient, UrlLoaderClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<UrlLoaderClient, UrlLoaderClient.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.URLLoaderClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, UrlLoaderClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public UrlLoaderClient[] buildArray(int size) {
          return new UrlLoaderClient[size];
        }
    };


    private static final int ON_RECEIVE_RESPONSE_ORDINAL = 0;

    private static final int ON_RECEIVE_REDIRECT_ORDINAL = 1;

    private static final int ON_UPLOAD_PROGRESS_ORDINAL = 2;

    private static final int ON_RECEIVE_CACHED_METADATA_ORDINAL = 3;

    private static final int ON_TRANSFER_SIZE_UPDATED_ORDINAL = 4;

    private static final int ON_START_LOADING_RESPONSE_BODY_ORDINAL = 5;

    private static final int ON_COMPLETE_ORDINAL = 6;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements UrlLoaderClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onReceiveResponse(
UrlResponseHead head) {

            UrlLoaderClientOnReceiveResponseParams _message = new UrlLoaderClientOnReceiveResponseParams();

            _message.head = head;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_RECEIVE_RESPONSE_ORDINAL)));

        }


        @Override
        public void onReceiveRedirect(
UrlRequestRedirectInfo redirectInfo, UrlResponseHead head) {

            UrlLoaderClientOnReceiveRedirectParams _message = new UrlLoaderClientOnReceiveRedirectParams();

            _message.redirectInfo = redirectInfo;

            _message.head = head;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_RECEIVE_REDIRECT_ORDINAL)));

        }


        @Override
        public void onUploadProgress(
long currentPosition, long totalSize, 
OnUploadProgressResponse callback) {

            UrlLoaderClientOnUploadProgressParams _message = new UrlLoaderClientOnUploadProgressParams();

            _message.currentPosition = currentPosition;

            _message.totalSize = totalSize;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_UPLOAD_PROGRESS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new UrlLoaderClientOnUploadProgressResponseParamsForwardToCallback(callback));

        }


        @Override
        public void onReceiveCachedMetadata(
byte[] data) {

            UrlLoaderClientOnReceiveCachedMetadataParams _message = new UrlLoaderClientOnReceiveCachedMetadataParams();

            _message.data = data;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_RECEIVE_CACHED_METADATA_ORDINAL)));

        }


        @Override
        public void onTransferSizeUpdated(
int transferSizeDiff) {

            UrlLoaderClientOnTransferSizeUpdatedParams _message = new UrlLoaderClientOnTransferSizeUpdatedParams();

            _message.transferSizeDiff = transferSizeDiff;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_TRANSFER_SIZE_UPDATED_ORDINAL)));

        }


        @Override
        public void onStartLoadingResponseBody(
com.vccorp.mojo.system.DataPipe.ConsumerHandle body) {

            UrlLoaderClientOnStartLoadingResponseBodyParams _message = new UrlLoaderClientOnStartLoadingResponseBodyParams();

            _message.body = body;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_START_LOADING_RESPONSE_BODY_ORDINAL)));

        }


        @Override
        public void onComplete(
UrlLoaderCompletionStatus status) {

            UrlLoaderClientOnCompleteParams _message = new UrlLoaderClientOnCompleteParams();

            _message.status = status;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_COMPLETE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<UrlLoaderClient> {

        Stub(com.vccorp.mojo.system.Core core, UrlLoaderClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                UrlLoaderClient_Internal.MANAGER, messageWithHeader);





                    case ON_RECEIVE_RESPONSE_ORDINAL: {

                        UrlLoaderClientOnReceiveResponseParams data =
                                UrlLoaderClientOnReceiveResponseParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onReceiveResponse(data.head);
                        return true;
                    }





                    case ON_RECEIVE_REDIRECT_ORDINAL: {

                        UrlLoaderClientOnReceiveRedirectParams data =
                                UrlLoaderClientOnReceiveRedirectParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onReceiveRedirect(data.redirectInfo, data.head);
                        return true;
                    }







                    case ON_RECEIVE_CACHED_METADATA_ORDINAL: {

                        UrlLoaderClientOnReceiveCachedMetadataParams data =
                                UrlLoaderClientOnReceiveCachedMetadataParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onReceiveCachedMetadata(data.data);
                        return true;
                    }





                    case ON_TRANSFER_SIZE_UPDATED_ORDINAL: {

                        UrlLoaderClientOnTransferSizeUpdatedParams data =
                                UrlLoaderClientOnTransferSizeUpdatedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onTransferSizeUpdated(data.transferSizeDiff);
                        return true;
                    }





                    case ON_START_LOADING_RESPONSE_BODY_ORDINAL: {

                        UrlLoaderClientOnStartLoadingResponseBodyParams data =
                                UrlLoaderClientOnStartLoadingResponseBodyParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onStartLoadingResponseBody(data.body);
                        return true;
                    }





                    case ON_COMPLETE_ORDINAL: {

                        UrlLoaderClientOnCompleteParams data =
                                UrlLoaderClientOnCompleteParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onComplete(data.status);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), UrlLoaderClient_Internal.MANAGER, messageWithHeader, receiver);











                    case ON_UPLOAD_PROGRESS_ORDINAL: {

                        UrlLoaderClientOnUploadProgressParams data =
                                UrlLoaderClientOnUploadProgressParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onUploadProgress(data.currentPosition, data.totalSize, new UrlLoaderClientOnUploadProgressResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }










                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class UrlLoaderClientOnReceiveResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public UrlResponseHead head;

        private UrlLoaderClientOnReceiveResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public UrlLoaderClientOnReceiveResponseParams() {
            this(0);
        }

        public static UrlLoaderClientOnReceiveResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static UrlLoaderClientOnReceiveResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static UrlLoaderClientOnReceiveResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            UrlLoaderClientOnReceiveResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new UrlLoaderClientOnReceiveResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.head = UrlResponseHead.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.head, 8, false);
        }
    }



    
    static final class UrlLoaderClientOnReceiveRedirectParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public UrlRequestRedirectInfo redirectInfo;
        public UrlResponseHead head;

        private UrlLoaderClientOnReceiveRedirectParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public UrlLoaderClientOnReceiveRedirectParams() {
            this(0);
        }

        public static UrlLoaderClientOnReceiveRedirectParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static UrlLoaderClientOnReceiveRedirectParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static UrlLoaderClientOnReceiveRedirectParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            UrlLoaderClientOnReceiveRedirectParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new UrlLoaderClientOnReceiveRedirectParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.redirectInfo = UrlRequestRedirectInfo.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.head = UrlResponseHead.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.redirectInfo, 8, false);
            
            encoder0.encode(this.head, 16, false);
        }
    }



    
    static final class UrlLoaderClientOnUploadProgressParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long currentPosition;
        public long totalSize;

        private UrlLoaderClientOnUploadProgressParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public UrlLoaderClientOnUploadProgressParams() {
            this(0);
        }

        public static UrlLoaderClientOnUploadProgressParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static UrlLoaderClientOnUploadProgressParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static UrlLoaderClientOnUploadProgressParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            UrlLoaderClientOnUploadProgressParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new UrlLoaderClientOnUploadProgressParams(elementsOrVersion);
                    {
                        
                    result.currentPosition = decoder0.readLong(8);
                    }
                    {
                        
                    result.totalSize = decoder0.readLong(16);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.currentPosition, 8);
            
            encoder0.encode(this.totalSize, 16);
        }
    }



    
    static final class UrlLoaderClientOnUploadProgressResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private UrlLoaderClientOnUploadProgressResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public UrlLoaderClientOnUploadProgressResponseParams() {
            this(0);
        }

        public static UrlLoaderClientOnUploadProgressResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static UrlLoaderClientOnUploadProgressResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static UrlLoaderClientOnUploadProgressResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            UrlLoaderClientOnUploadProgressResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new UrlLoaderClientOnUploadProgressResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class UrlLoaderClientOnUploadProgressResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final UrlLoaderClient.OnUploadProgressResponse mCallback;

        UrlLoaderClientOnUploadProgressResponseParamsForwardToCallback(UrlLoaderClient.OnUploadProgressResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_UPLOAD_PROGRESS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class UrlLoaderClientOnUploadProgressResponseParamsProxyToResponder implements UrlLoaderClient.OnUploadProgressResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UrlLoaderClientOnUploadProgressResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            UrlLoaderClientOnUploadProgressResponseParams _response = new UrlLoaderClientOnUploadProgressResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_UPLOAD_PROGRESS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class UrlLoaderClientOnReceiveCachedMetadataParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public byte[] data;

        private UrlLoaderClientOnReceiveCachedMetadataParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public UrlLoaderClientOnReceiveCachedMetadataParams() {
            this(0);
        }

        public static UrlLoaderClientOnReceiveCachedMetadataParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static UrlLoaderClientOnReceiveCachedMetadataParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static UrlLoaderClientOnReceiveCachedMetadataParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            UrlLoaderClientOnReceiveCachedMetadataParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new UrlLoaderClientOnReceiveCachedMetadataParams(elementsOrVersion);
                    {
                        
                    result.data = decoder0.readBytes(8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.data, 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    }



    
    static final class UrlLoaderClientOnTransferSizeUpdatedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int transferSizeDiff;

        private UrlLoaderClientOnTransferSizeUpdatedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public UrlLoaderClientOnTransferSizeUpdatedParams() {
            this(0);
        }

        public static UrlLoaderClientOnTransferSizeUpdatedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static UrlLoaderClientOnTransferSizeUpdatedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static UrlLoaderClientOnTransferSizeUpdatedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            UrlLoaderClientOnTransferSizeUpdatedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new UrlLoaderClientOnTransferSizeUpdatedParams(elementsOrVersion);
                    {
                        
                    result.transferSizeDiff = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.transferSizeDiff, 8);
        }
    }



    
    static final class UrlLoaderClientOnStartLoadingResponseBodyParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.system.DataPipe.ConsumerHandle body;

        private UrlLoaderClientOnStartLoadingResponseBodyParams(int version) {
            super(STRUCT_SIZE, version);
            this.body = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public UrlLoaderClientOnStartLoadingResponseBodyParams() {
            this(0);
        }

        public static UrlLoaderClientOnStartLoadingResponseBodyParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static UrlLoaderClientOnStartLoadingResponseBodyParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static UrlLoaderClientOnStartLoadingResponseBodyParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            UrlLoaderClientOnStartLoadingResponseBodyParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new UrlLoaderClientOnStartLoadingResponseBodyParams(elementsOrVersion);
                    {
                        
                    result.body = decoder0.readConsumerHandle(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.body, 8, false);
        }
    }



    
    static final class UrlLoaderClientOnCompleteParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public UrlLoaderCompletionStatus status;

        private UrlLoaderClientOnCompleteParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public UrlLoaderClientOnCompleteParams() {
            this(0);
        }

        public static UrlLoaderClientOnCompleteParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static UrlLoaderClientOnCompleteParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static UrlLoaderClientOnCompleteParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            UrlLoaderClientOnCompleteParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new UrlLoaderClientOnCompleteParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.status = UrlLoaderCompletionStatus.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8, false);
        }
    }



}
