
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/proxy_resolving_socket.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ProxyResolvingSocketFactory_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ProxyResolvingSocketFactory, ProxyResolvingSocketFactory.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ProxyResolvingSocketFactory, ProxyResolvingSocketFactory.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.ProxyResolvingSocketFactory";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ProxyResolvingSocketFactory impl) {
            return new Stub(core, impl);
        }

        @Override
        public ProxyResolvingSocketFactory[] buildArray(int size) {
          return new ProxyResolvingSocketFactory[size];
        }
    };


    private static final int CREATE_PROXY_RESOLVING_SOCKET_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ProxyResolvingSocketFactory.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void createProxyResolvingSocket(
com.vccorp.url.mojom.Url url, ProxyResolvingSocketOptions options, MutableNetworkTrafficAnnotationTag trafficAnnotation, com.vccorp.mojo.bindings.InterfaceRequest<ProxyResolvingSocket> socket, SocketObserver observer,
CreateProxyResolvingSocketResponse callback) {

            ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams _message = new ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams();

            _message.url = url;

            _message.options = options;

            _message.trafficAnnotation = trafficAnnotation;

            _message.socket = socket;

            _message.observer = observer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CREATE_PROXY_RESOLVING_SOCKET_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ProxyResolvingSocketFactory> {

        Stub(com.vccorp.mojo.system.Core core, ProxyResolvingSocketFactory impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ProxyResolvingSocketFactory_Internal.MANAGER, messageWithHeader);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ProxyResolvingSocketFactory_Internal.MANAGER, messageWithHeader, receiver);







                    case CREATE_PROXY_RESOLVING_SOCKET_ORDINAL: {

                        ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams data =
                                ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createProxyResolvingSocket(data.url, data.options, data.trafficAnnotation, data.socket, data.observer, new ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;
        public ProxyResolvingSocketOptions options;
        public MutableNetworkTrafficAnnotationTag trafficAnnotation;
        public com.vccorp.mojo.bindings.InterfaceRequest<ProxyResolvingSocket> socket;
        public SocketObserver observer;

        private ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams() {
            this(0);
        }

        public static ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ProxyResolvingSocketFactoryCreateProxyResolvingSocketParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.options = ProxyResolvingSocketOptions.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.trafficAnnotation = MutableNetworkTrafficAnnotationTag.decode(decoder1);
                    }
                    {
                        
                    result.socket = decoder0.readInterfaceRequest(32, false);
                    }
                    {
                        
                    result.observer = decoder0.readServiceInterface(36, true, SocketObserver.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
            
            encoder0.encode(this.options, 16, true);
            
            encoder0.encode(this.trafficAnnotation, 24, false);
            
            encoder0.encode(this.socket, 32, false);
            
            encoder0.encode(this.observer, 36, true, SocketObserver.MANAGER);
        }
    }



    
    static final class ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;
        public IpEndPoint localAddr;
        public IpEndPoint peerAddr;
        public com.vccorp.mojo.system.DataPipe.ConsumerHandle receiveStream;
        public com.vccorp.mojo.system.DataPipe.ProducerHandle sendStream;

        private ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams(int version) {
            super(STRUCT_SIZE, version);
            this.receiveStream = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
            this.sendStream = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams() {
            this(0);
        }

        public static ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                    }
                    {
                        
                    result.receiveStream = decoder0.readConsumerHandle(12, true);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.localAddr = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.peerAddr = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    result.sendStream = decoder0.readProducerHandle(32, true);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
            
            encoder0.encode(this.receiveStream, 12, true);
            
            encoder0.encode(this.localAddr, 16, true);
            
            encoder0.encode(this.peerAddr, 24, true);
            
            encoder0.encode(this.sendStream, 32, true);
        }
    }

    static class ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ProxyResolvingSocketFactory.CreateProxyResolvingSocketResponse mCallback;

        ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParamsForwardToCallback(ProxyResolvingSocketFactory.CreateProxyResolvingSocketResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CREATE_PROXY_RESOLVING_SOCKET_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams response = ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result, response.localAddr, response.peerAddr, response.receiveStream, response.sendStream);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParamsProxyToResponder implements ProxyResolvingSocketFactory.CreateProxyResolvingSocketResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result, IpEndPoint localAddr, IpEndPoint peerAddr, com.vccorp.mojo.system.DataPipe.ConsumerHandle receiveStream, com.vccorp.mojo.system.DataPipe.ProducerHandle sendStream) {
            ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams _response = new ProxyResolvingSocketFactoryCreateProxyResolvingSocketResponseParams();

            _response.result = result;

            _response.localAddr = localAddr;

            _response.peerAddr = peerAddr;

            _response.receiveStream = receiveStream;

            _response.sendStream = sendStream;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CREATE_PROXY_RESOLVING_SOCKET_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
