
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_service.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class NetworkServiceClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<NetworkServiceClient, NetworkServiceClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<NetworkServiceClient, NetworkServiceClient.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.NetworkServiceClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, NetworkServiceClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public NetworkServiceClient[] buildArray(int size) {
          return new NetworkServiceClient[size];
        }
    };


    private static final int ON_AUTH_REQUIRED_ORDINAL = 0;

    private static final int ON_CERTIFICATE_REQUESTED_ORDINAL = 1;

    private static final int ON_SSL_CERTIFICATE_ERROR_ORDINAL = 2;

    private static final int ON_FILE_UPLOAD_REQUESTED_ORDINAL = 3;

    private static final int ON_COOKIE_CHANGE_ORDINAL = 4;

    private static final int ON_COOKIES_READ_ORDINAL = 5;

    private static final int ON_LOADING_STATE_UPDATE_ORDINAL = 6;

    private static final int ON_CLEAR_SITE_DATA_ORDINAL = 7;

    private static final int ON_DATA_USE_UPDATE_ORDINAL = 8;

    private static final int ON_GENERATE_HTTP_NEGOTIATE_AUTH_TOKEN_ORDINAL = 9;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements NetworkServiceClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onAuthRequired(
int processId, int routingId, int requestId, com.vccorp.url.mojom.Url url, com.vccorp.url.mojom.Url siteForCookies, boolean firstAuthAttempt, AuthChallengeInfo authInfo, int resourceType, UrlResponseHead head, AuthChallengeResponder authChallengeResponder) {

            NetworkServiceClientOnAuthRequiredParams _message = new NetworkServiceClientOnAuthRequiredParams();

            _message.processId = processId;

            _message.routingId = routingId;

            _message.requestId = requestId;

            _message.url = url;

            _message.siteForCookies = siteForCookies;

            _message.firstAuthAttempt = firstAuthAttempt;

            _message.authInfo = authInfo;

            _message.resourceType = resourceType;

            _message.head = head;

            _message.authChallengeResponder = authChallengeResponder;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_AUTH_REQUIRED_ORDINAL)));

        }


        @Override
        public void onCertificateRequested(
com.vccorp.mojo_base.mojom.UnguessableToken windowId, int processId, int routingId, int requestId, SslCertRequestInfo certInfo,
OnCertificateRequestedResponse callback) {

            NetworkServiceClientOnCertificateRequestedParams _message = new NetworkServiceClientOnCertificateRequestedParams();

            _message.windowId = windowId;

            _message.processId = processId;

            _message.routingId = routingId;

            _message.requestId = requestId;

            _message.certInfo = certInfo;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_CERTIFICATE_REQUESTED_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceClientOnCertificateRequestedResponseParamsForwardToCallback(callback));

        }


        @Override
        public void onSslCertificateError(
int processId, int routingId, int requestId, int resourceType, com.vccorp.url.mojom.Url url, SslInfo sslInfo, boolean fatal,
OnSslCertificateErrorResponse callback) {

            NetworkServiceClientOnSslCertificateErrorParams _message = new NetworkServiceClientOnSslCertificateErrorParams();

            _message.processId = processId;

            _message.routingId = routingId;

            _message.requestId = requestId;

            _message.resourceType = resourceType;

            _message.url = url;

            _message.sslInfo = sslInfo;

            _message.fatal = fatal;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_SSL_CERTIFICATE_ERROR_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceClientOnSslCertificateErrorResponseParamsForwardToCallback(callback));

        }


        @Override
        public void onFileUploadRequested(
int processId, boolean async, com.vccorp.mojo_base.mojom.FilePath[] filePaths,
OnFileUploadRequestedResponse callback) {

            NetworkServiceClientOnFileUploadRequestedParams _message = new NetworkServiceClientOnFileUploadRequestedParams();

            _message.processId = processId;

            _message.async = async;

            _message.filePaths = filePaths;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_FILE_UPLOAD_REQUESTED_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceClientOnFileUploadRequestedResponseParamsForwardToCallback(callback));

        }


        @Override
        public void onCookieChange(
int processId, int routingId, com.vccorp.url.mojom.Url url, com.vccorp.url.mojom.Url frameUrl, CanonicalCookie cookie, boolean blockedByPolicy) {

            NetworkServiceClientOnCookieChangeParams _message = new NetworkServiceClientOnCookieChangeParams();

            _message.processId = processId;

            _message.routingId = routingId;

            _message.url = url;

            _message.frameUrl = frameUrl;

            _message.cookie = cookie;

            _message.blockedByPolicy = blockedByPolicy;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_COOKIE_CHANGE_ORDINAL)));

        }


        @Override
        public void onCookiesRead(
int processId, int routingId, com.vccorp.url.mojom.Url url, com.vccorp.url.mojom.Url frameUrl, CanonicalCookie[] cookieList, boolean blockedByPolicy) {

            NetworkServiceClientOnCookiesReadParams _message = new NetworkServiceClientOnCookiesReadParams();

            _message.processId = processId;

            _message.routingId = routingId;

            _message.url = url;

            _message.frameUrl = frameUrl;

            _message.cookieList = cookieList;

            _message.blockedByPolicy = blockedByPolicy;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_COOKIES_READ_ORDINAL)));

        }


        @Override
        public void onLoadingStateUpdate(
LoadInfo[] infos, 
OnLoadingStateUpdateResponse callback) {

            NetworkServiceClientOnLoadingStateUpdateParams _message = new NetworkServiceClientOnLoadingStateUpdateParams();

            _message.infos = infos;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_LOADING_STATE_UPDATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceClientOnLoadingStateUpdateResponseParamsForwardToCallback(callback));

        }


        @Override
        public void onClearSiteData(
int processId, int routingId, com.vccorp.url.mojom.Url url, String headerValue, int loadFlags,
OnClearSiteDataResponse callback) {

            NetworkServiceClientOnClearSiteDataParams _message = new NetworkServiceClientOnClearSiteDataParams();

            _message.processId = processId;

            _message.routingId = routingId;

            _message.url = url;

            _message.headerValue = headerValue;

            _message.loadFlags = loadFlags;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_CLEAR_SITE_DATA_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceClientOnClearSiteDataResponseParamsForwardToCallback(callback));

        }


        @Override
        public void onDataUseUpdate(
int networkTrafficAnnotationIdHash, long recvBytes, long sentBytes) {

            NetworkServiceClientOnDataUseUpdateParams _message = new NetworkServiceClientOnDataUseUpdateParams();

            _message.networkTrafficAnnotationIdHash = networkTrafficAnnotationIdHash;

            _message.recvBytes = recvBytes;

            _message.sentBytes = sentBytes;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_DATA_USE_UPDATE_ORDINAL)));

        }


        @Override
        public void onGenerateHttpNegotiateAuthToken(
String serverAuthToken, boolean canDelegate, String authNegotiateAndroidAccountType, String spn, 
OnGenerateHttpNegotiateAuthTokenResponse callback) {

            NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams _message = new NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams();

            _message.serverAuthToken = serverAuthToken;

            _message.canDelegate = canDelegate;

            _message.authNegotiateAndroidAccountType = authNegotiateAndroidAccountType;

            _message.spn = spn;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_GENERATE_HTTP_NEGOTIATE_AUTH_TOKEN_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<NetworkServiceClient> {

        Stub(com.vccorp.mojo.system.Core core, NetworkServiceClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                NetworkServiceClient_Internal.MANAGER, messageWithHeader);





                    case ON_AUTH_REQUIRED_ORDINAL: {

                        NetworkServiceClientOnAuthRequiredParams data =
                                NetworkServiceClientOnAuthRequiredParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onAuthRequired(data.processId, data.routingId, data.requestId, data.url, data.siteForCookies, data.firstAuthAttempt, data.authInfo, data.resourceType, data.head, data.authChallengeResponder);
                        return true;
                    }











                    case ON_COOKIE_CHANGE_ORDINAL: {

                        NetworkServiceClientOnCookieChangeParams data =
                                NetworkServiceClientOnCookieChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onCookieChange(data.processId, data.routingId, data.url, data.frameUrl, data.cookie, data.blockedByPolicy);
                        return true;
                    }





                    case ON_COOKIES_READ_ORDINAL: {

                        NetworkServiceClientOnCookiesReadParams data =
                                NetworkServiceClientOnCookiesReadParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onCookiesRead(data.processId, data.routingId, data.url, data.frameUrl, data.cookieList, data.blockedByPolicy);
                        return true;
                    }









                    case ON_DATA_USE_UPDATE_ORDINAL: {

                        NetworkServiceClientOnDataUseUpdateParams data =
                                NetworkServiceClientOnDataUseUpdateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onDataUseUpdate(data.networkTrafficAnnotationIdHash, data.recvBytes, data.sentBytes);
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), NetworkServiceClient_Internal.MANAGER, messageWithHeader, receiver);









                    case ON_CERTIFICATE_REQUESTED_ORDINAL: {

                        NetworkServiceClientOnCertificateRequestedParams data =
                                NetworkServiceClientOnCertificateRequestedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onCertificateRequested(data.windowId, data.processId, data.routingId, data.requestId, data.certInfo, new NetworkServiceClientOnCertificateRequestedResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case ON_SSL_CERTIFICATE_ERROR_ORDINAL: {

                        NetworkServiceClientOnSslCertificateErrorParams data =
                                NetworkServiceClientOnSslCertificateErrorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onSslCertificateError(data.processId, data.routingId, data.requestId, data.resourceType, data.url, data.sslInfo, data.fatal, new NetworkServiceClientOnSslCertificateErrorResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case ON_FILE_UPLOAD_REQUESTED_ORDINAL: {

                        NetworkServiceClientOnFileUploadRequestedParams data =
                                NetworkServiceClientOnFileUploadRequestedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onFileUploadRequested(data.processId, data.async, data.filePaths, new NetworkServiceClientOnFileUploadRequestedResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }











                    case ON_LOADING_STATE_UPDATE_ORDINAL: {

                        NetworkServiceClientOnLoadingStateUpdateParams data =
                                NetworkServiceClientOnLoadingStateUpdateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onLoadingStateUpdate(data.infos, new NetworkServiceClientOnLoadingStateUpdateResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case ON_CLEAR_SITE_DATA_ORDINAL: {

                        NetworkServiceClientOnClearSiteDataParams data =
                                NetworkServiceClientOnClearSiteDataParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onClearSiteData(data.processId, data.routingId, data.url, data.headerValue, data.loadFlags, new NetworkServiceClientOnClearSiteDataResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }









                    case ON_GENERATE_HTTP_NEGOTIATE_AUTH_TOKEN_ORDINAL: {

                        NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams data =
                                NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onGenerateHttpNegotiateAuthToken(data.serverAuthToken, data.canDelegate, data.authNegotiateAndroidAccountType, data.spn, new NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class NetworkServiceClientOnAuthRequiredParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 72;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(72, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int processId;
        public int routingId;
        public int requestId;
        public com.vccorp.url.mojom.Url url;
        public com.vccorp.url.mojom.Url siteForCookies;
        public boolean firstAuthAttempt;
        public AuthChallengeInfo authInfo;
        public int resourceType;
        public UrlResponseHead head;
        public AuthChallengeResponder authChallengeResponder;

        private NetworkServiceClientOnAuthRequiredParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnAuthRequiredParams() {
            this(0);
        }

        public static NetworkServiceClientOnAuthRequiredParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnAuthRequiredParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnAuthRequiredParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnAuthRequiredParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnAuthRequiredParams(elementsOrVersion);
                    {
                        
                    result.processId = decoder0.readInt(8);
                    }
                    {
                        
                    result.routingId = decoder0.readInt(12);
                    }
                    {
                        
                    result.requestId = decoder0.readInt(16);
                    }
                    {
                        
                    result.firstAuthAttempt = decoder0.readBoolean(20, 0);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.siteForCookies = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                    result.authInfo = AuthChallengeInfo.decode(decoder1);
                    }
                    {
                        
                    result.resourceType = decoder0.readInt(48);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, true);
                    result.head = UrlResponseHead.decode(decoder1);
                    }
                    {
                        
                    result.authChallengeResponder = decoder0.readServiceInterface(64, false, AuthChallengeResponder.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.processId, 8);
            
            encoder0.encode(this.routingId, 12);
            
            encoder0.encode(this.requestId, 16);
            
            encoder0.encode(this.firstAuthAttempt, 20, 0);
            
            encoder0.encode(this.url, 24, false);
            
            encoder0.encode(this.siteForCookies, 32, false);
            
            encoder0.encode(this.authInfo, 40, false);
            
            encoder0.encode(this.resourceType, 48);
            
            encoder0.encode(this.head, 56, true);
            
            encoder0.encode(this.authChallengeResponder, 64, false, AuthChallengeResponder.MANAGER);
        }
    }



    
    static final class NetworkServiceClientOnCertificateRequestedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.UnguessableToken windowId;
        public int processId;
        public int routingId;
        public int requestId;
        public SslCertRequestInfo certInfo;

        private NetworkServiceClientOnCertificateRequestedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnCertificateRequestedParams() {
            this(0);
        }

        public static NetworkServiceClientOnCertificateRequestedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnCertificateRequestedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnCertificateRequestedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnCertificateRequestedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnCertificateRequestedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.windowId = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                    }
                    {
                        
                    result.processId = decoder0.readInt(16);
                    }
                    {
                        
                    result.routingId = decoder0.readInt(20);
                    }
                    {
                        
                    result.requestId = decoder0.readInt(24);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.certInfo = SslCertRequestInfo.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.windowId, 8, true);
            
            encoder0.encode(this.processId, 16);
            
            encoder0.encode(this.routingId, 20);
            
            encoder0.encode(this.requestId, 24);
            
            encoder0.encode(this.certInfo, 32, false);
        }
    }



    
    static final class NetworkServiceClientOnCertificateRequestedResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public X509Certificate x509Certificate;
        public String providerName;
        public short[] algorithmPreferences;
        public SslPrivateKey sslPrivateKey;
        public boolean cancelCertificateSelection;

        private NetworkServiceClientOnCertificateRequestedResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnCertificateRequestedResponseParams() {
            this(0);
        }

        public static NetworkServiceClientOnCertificateRequestedResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnCertificateRequestedResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnCertificateRequestedResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnCertificateRequestedResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnCertificateRequestedResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.x509Certificate = X509Certificate.decode(decoder1);
                    }
                    {
                        
                    result.providerName = decoder0.readString(16, false);
                    }
                    {
                        
                    result.algorithmPreferences = decoder0.readShorts(24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }
                    {
                        
                    result.sslPrivateKey = decoder0.readServiceInterface(32, false, SslPrivateKey.MANAGER);
                    }
                    {
                        
                    result.cancelCertificateSelection = decoder0.readBoolean(40, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.x509Certificate, 8, false);
            
            encoder0.encode(this.providerName, 16, false);
            
            encoder0.encode(this.algorithmPreferences, 24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            encoder0.encode(this.sslPrivateKey, 32, false, SslPrivateKey.MANAGER);
            
            encoder0.encode(this.cancelCertificateSelection, 40, 0);
        }
    }

    static class NetworkServiceClientOnCertificateRequestedResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceClient.OnCertificateRequestedResponse mCallback;

        NetworkServiceClientOnCertificateRequestedResponseParamsForwardToCallback(NetworkServiceClient.OnCertificateRequestedResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_CERTIFICATE_REQUESTED_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkServiceClientOnCertificateRequestedResponseParams response = NetworkServiceClientOnCertificateRequestedResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.x509Certificate, response.providerName, response.algorithmPreferences, response.sslPrivateKey, response.cancelCertificateSelection);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceClientOnCertificateRequestedResponseParamsProxyToResponder implements NetworkServiceClient.OnCertificateRequestedResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceClientOnCertificateRequestedResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(X509Certificate x509Certificate, String providerName, short[] algorithmPreferences, SslPrivateKey sslPrivateKey, Boolean cancelCertificateSelection) {
            NetworkServiceClientOnCertificateRequestedResponseParams _response = new NetworkServiceClientOnCertificateRequestedResponseParams();

            _response.x509Certificate = x509Certificate;

            _response.providerName = providerName;

            _response.algorithmPreferences = algorithmPreferences;

            _response.sslPrivateKey = sslPrivateKey;

            _response.cancelCertificateSelection = cancelCertificateSelection;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_CERTIFICATE_REQUESTED_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceClientOnSslCertificateErrorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int processId;
        public int routingId;
        public int requestId;
        public int resourceType;
        public com.vccorp.url.mojom.Url url;
        public SslInfo sslInfo;
        public boolean fatal;

        private NetworkServiceClientOnSslCertificateErrorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnSslCertificateErrorParams() {
            this(0);
        }

        public static NetworkServiceClientOnSslCertificateErrorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnSslCertificateErrorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnSslCertificateErrorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnSslCertificateErrorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnSslCertificateErrorParams(elementsOrVersion);
                    {
                        
                    result.processId = decoder0.readInt(8);
                    }
                    {
                        
                    result.routingId = decoder0.readInt(12);
                    }
                    {
                        
                    result.requestId = decoder0.readInt(16);
                    }
                    {
                        
                    result.resourceType = decoder0.readInt(20);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.sslInfo = SslInfo.decode(decoder1);
                    }
                    {
                        
                    result.fatal = decoder0.readBoolean(40, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.processId, 8);
            
            encoder0.encode(this.routingId, 12);
            
            encoder0.encode(this.requestId, 16);
            
            encoder0.encode(this.resourceType, 20);
            
            encoder0.encode(this.url, 24, false);
            
            encoder0.encode(this.sslInfo, 32, false);
            
            encoder0.encode(this.fatal, 40, 0);
        }
    }



    
    static final class NetworkServiceClientOnSslCertificateErrorResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int netError;

        private NetworkServiceClientOnSslCertificateErrorResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnSslCertificateErrorResponseParams() {
            this(0);
        }

        public static NetworkServiceClientOnSslCertificateErrorResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnSslCertificateErrorResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnSslCertificateErrorResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnSslCertificateErrorResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnSslCertificateErrorResponseParams(elementsOrVersion);
                    {
                        
                    result.netError = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.netError, 8);
        }
    }

    static class NetworkServiceClientOnSslCertificateErrorResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceClient.OnSslCertificateErrorResponse mCallback;

        NetworkServiceClientOnSslCertificateErrorResponseParamsForwardToCallback(NetworkServiceClient.OnSslCertificateErrorResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_SSL_CERTIFICATE_ERROR_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkServiceClientOnSslCertificateErrorResponseParams response = NetworkServiceClientOnSslCertificateErrorResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.netError);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceClientOnSslCertificateErrorResponseParamsProxyToResponder implements NetworkServiceClient.OnSslCertificateErrorResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceClientOnSslCertificateErrorResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer netError) {
            NetworkServiceClientOnSslCertificateErrorResponseParams _response = new NetworkServiceClientOnSslCertificateErrorResponseParams();

            _response.netError = netError;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_SSL_CERTIFICATE_ERROR_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceClientOnFileUploadRequestedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int processId;
        public boolean async;
        public com.vccorp.mojo_base.mojom.FilePath[] filePaths;

        private NetworkServiceClientOnFileUploadRequestedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnFileUploadRequestedParams() {
            this(0);
        }

        public static NetworkServiceClientOnFileUploadRequestedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnFileUploadRequestedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnFileUploadRequestedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnFileUploadRequestedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnFileUploadRequestedParams(elementsOrVersion);
                    {
                        
                    result.processId = decoder0.readInt(8);
                    }
                    {
                        
                    result.async = decoder0.readBoolean(12, 0);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.filePaths = new com.vccorp.mojo_base.mojom.FilePath[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.filePaths[i1] = com.vccorp.mojo_base.mojom.FilePath.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.processId, 8);
            
            encoder0.encode(this.async, 12, 0);
            
            if (this.filePaths == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.filePaths.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.filePaths.length; ++i0) {
                    
                    encoder1.encode(this.filePaths[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class NetworkServiceClientOnFileUploadRequestedResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int netError;
        public com.vccorp.mojo_base.mojom.File[] files;

        private NetworkServiceClientOnFileUploadRequestedResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnFileUploadRequestedResponseParams() {
            this(0);
        }

        public static NetworkServiceClientOnFileUploadRequestedResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnFileUploadRequestedResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnFileUploadRequestedResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnFileUploadRequestedResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnFileUploadRequestedResponseParams(elementsOrVersion);
                    {
                        
                    result.netError = decoder0.readInt(8);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.files = new com.vccorp.mojo_base.mojom.File[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.files[i1] = com.vccorp.mojo_base.mojom.File.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.netError, 8);
            
            if (this.files == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.files.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.files.length; ++i0) {
                    
                    encoder1.encode(this.files[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class NetworkServiceClientOnFileUploadRequestedResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceClient.OnFileUploadRequestedResponse mCallback;

        NetworkServiceClientOnFileUploadRequestedResponseParamsForwardToCallback(NetworkServiceClient.OnFileUploadRequestedResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_FILE_UPLOAD_REQUESTED_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkServiceClientOnFileUploadRequestedResponseParams response = NetworkServiceClientOnFileUploadRequestedResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.netError, response.files);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceClientOnFileUploadRequestedResponseParamsProxyToResponder implements NetworkServiceClient.OnFileUploadRequestedResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceClientOnFileUploadRequestedResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer netError, com.vccorp.mojo_base.mojom.File[] files) {
            NetworkServiceClientOnFileUploadRequestedResponseParams _response = new NetworkServiceClientOnFileUploadRequestedResponseParams();

            _response.netError = netError;

            _response.files = files;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_FILE_UPLOAD_REQUESTED_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceClientOnCookieChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int processId;
        public int routingId;
        public com.vccorp.url.mojom.Url url;
        public com.vccorp.url.mojom.Url frameUrl;
        public CanonicalCookie cookie;
        public boolean blockedByPolicy;

        private NetworkServiceClientOnCookieChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnCookieChangeParams() {
            this(0);
        }

        public static NetworkServiceClientOnCookieChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnCookieChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnCookieChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnCookieChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnCookieChangeParams(elementsOrVersion);
                    {
                        
                    result.processId = decoder0.readInt(8);
                    }
                    {
                        
                    result.routingId = decoder0.readInt(12);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.frameUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.cookie = CanonicalCookie.decode(decoder1);
                    }
                    {
                        
                    result.blockedByPolicy = decoder0.readBoolean(40, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.processId, 8);
            
            encoder0.encode(this.routingId, 12);
            
            encoder0.encode(this.url, 16, false);
            
            encoder0.encode(this.frameUrl, 24, false);
            
            encoder0.encode(this.cookie, 32, false);
            
            encoder0.encode(this.blockedByPolicy, 40, 0);
        }
    }



    
    static final class NetworkServiceClientOnCookiesReadParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int processId;
        public int routingId;
        public com.vccorp.url.mojom.Url url;
        public com.vccorp.url.mojom.Url frameUrl;
        public CanonicalCookie[] cookieList;
        public boolean blockedByPolicy;

        private NetworkServiceClientOnCookiesReadParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnCookiesReadParams() {
            this(0);
        }

        public static NetworkServiceClientOnCookiesReadParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnCookiesReadParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnCookiesReadParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnCookiesReadParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnCookiesReadParams(elementsOrVersion);
                    {
                        
                    result.processId = decoder0.readInt(8);
                    }
                    {
                        
                    result.routingId = decoder0.readInt(12);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.frameUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.cookieList = new CanonicalCookie[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.cookieList[i1] = CanonicalCookie.decode(decoder2);
                        }
                    }
                    }
                    {
                        
                    result.blockedByPolicy = decoder0.readBoolean(40, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.processId, 8);
            
            encoder0.encode(this.routingId, 12);
            
            encoder0.encode(this.url, 16, false);
            
            encoder0.encode(this.frameUrl, 24, false);
            
            if (this.cookieList == null) {
                encoder0.encodeNullPointer(32, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.cookieList.length, 32, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.cookieList.length; ++i0) {
                    
                    encoder1.encode(this.cookieList[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            encoder0.encode(this.blockedByPolicy, 40, 0);
        }
    }



    
    static final class NetworkServiceClientOnLoadingStateUpdateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public LoadInfo[] infos;

        private NetworkServiceClientOnLoadingStateUpdateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnLoadingStateUpdateParams() {
            this(0);
        }

        public static NetworkServiceClientOnLoadingStateUpdateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnLoadingStateUpdateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnLoadingStateUpdateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnLoadingStateUpdateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnLoadingStateUpdateParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.infos = new LoadInfo[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.infos[i1] = LoadInfo.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.infos == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.infos.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.infos.length; ++i0) {
                    
                    encoder1.encode(this.infos[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class NetworkServiceClientOnLoadingStateUpdateResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceClientOnLoadingStateUpdateResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnLoadingStateUpdateResponseParams() {
            this(0);
        }

        public static NetworkServiceClientOnLoadingStateUpdateResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnLoadingStateUpdateResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnLoadingStateUpdateResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnLoadingStateUpdateResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnLoadingStateUpdateResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkServiceClientOnLoadingStateUpdateResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceClient.OnLoadingStateUpdateResponse mCallback;

        NetworkServiceClientOnLoadingStateUpdateResponseParamsForwardToCallback(NetworkServiceClient.OnLoadingStateUpdateResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_LOADING_STATE_UPDATE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceClientOnLoadingStateUpdateResponseParamsProxyToResponder implements NetworkServiceClient.OnLoadingStateUpdateResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceClientOnLoadingStateUpdateResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkServiceClientOnLoadingStateUpdateResponseParams _response = new NetworkServiceClientOnLoadingStateUpdateResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_LOADING_STATE_UPDATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceClientOnClearSiteDataParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int processId;
        public int routingId;
        public com.vccorp.url.mojom.Url url;
        public String headerValue;
        public int loadFlags;

        private NetworkServiceClientOnClearSiteDataParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnClearSiteDataParams() {
            this(0);
        }

        public static NetworkServiceClientOnClearSiteDataParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnClearSiteDataParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnClearSiteDataParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnClearSiteDataParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnClearSiteDataParams(elementsOrVersion);
                    {
                        
                    result.processId = decoder0.readInt(8);
                    }
                    {
                        
                    result.routingId = decoder0.readInt(12);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.headerValue = decoder0.readString(24, false);
                    }
                    {
                        
                    result.loadFlags = decoder0.readInt(32);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.processId, 8);
            
            encoder0.encode(this.routingId, 12);
            
            encoder0.encode(this.url, 16, false);
            
            encoder0.encode(this.headerValue, 24, false);
            
            encoder0.encode(this.loadFlags, 32);
        }
    }



    
    static final class NetworkServiceClientOnClearSiteDataResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceClientOnClearSiteDataResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnClearSiteDataResponseParams() {
            this(0);
        }

        public static NetworkServiceClientOnClearSiteDataResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnClearSiteDataResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnClearSiteDataResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnClearSiteDataResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnClearSiteDataResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkServiceClientOnClearSiteDataResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceClient.OnClearSiteDataResponse mCallback;

        NetworkServiceClientOnClearSiteDataResponseParamsForwardToCallback(NetworkServiceClient.OnClearSiteDataResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_CLEAR_SITE_DATA_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceClientOnClearSiteDataResponseParamsProxyToResponder implements NetworkServiceClient.OnClearSiteDataResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceClientOnClearSiteDataResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkServiceClientOnClearSiteDataResponseParams _response = new NetworkServiceClientOnClearSiteDataResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_CLEAR_SITE_DATA_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceClientOnDataUseUpdateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int networkTrafficAnnotationIdHash;
        public long recvBytes;
        public long sentBytes;

        private NetworkServiceClientOnDataUseUpdateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnDataUseUpdateParams() {
            this(0);
        }

        public static NetworkServiceClientOnDataUseUpdateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnDataUseUpdateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnDataUseUpdateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnDataUseUpdateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnDataUseUpdateParams(elementsOrVersion);
                    {
                        
                    result.networkTrafficAnnotationIdHash = decoder0.readInt(8);
                    }
                    {
                        
                    result.recvBytes = decoder0.readLong(16);
                    }
                    {
                        
                    result.sentBytes = decoder0.readLong(24);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.networkTrafficAnnotationIdHash, 8);
            
            encoder0.encode(this.recvBytes, 16);
            
            encoder0.encode(this.sentBytes, 24);
        }
    }



    
    static final class NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String serverAuthToken;
        public boolean canDelegate;
        public String authNegotiateAndroidAccountType;
        public String spn;

        private NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams() {
            this(0);
        }

        public static NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnGenerateHttpNegotiateAuthTokenParams(elementsOrVersion);
                    {
                        
                    result.serverAuthToken = decoder0.readString(8, false);
                    }
                    {
                        
                    result.canDelegate = decoder0.readBoolean(16, 0);
                    }
                    {
                        
                    result.authNegotiateAndroidAccountType = decoder0.readString(24, false);
                    }
                    {
                        
                    result.spn = decoder0.readString(32, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.serverAuthToken, 8, false);
            
            encoder0.encode(this.canDelegate, 16, 0);
            
            encoder0.encode(this.authNegotiateAndroidAccountType, 24, false);
            
            encoder0.encode(this.spn, 32, false);
        }
    }



    
    static final class NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;
        public String authToken;

        private NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams() {
            this(0);
        }

        public static NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                    }
                    {
                        
                    result.authToken = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
            
            encoder0.encode(this.authToken, 16, false);
        }
    }

    static class NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceClient.OnGenerateHttpNegotiateAuthTokenResponse mCallback;

        NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParamsForwardToCallback(NetworkServiceClient.OnGenerateHttpNegotiateAuthTokenResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_GENERATE_HTTP_NEGOTIATE_AUTH_TOKEN_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams response = NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result, response.authToken);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParamsProxyToResponder implements NetworkServiceClient.OnGenerateHttpNegotiateAuthTokenResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result, String authToken) {
            NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams _response = new NetworkServiceClientOnGenerateHttpNegotiateAuthTokenResponseParams();

            _response.result = result;

            _response.authToken = authToken;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_GENERATE_HTTP_NEGOTIATE_AUTH_TOKEN_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
