
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_service.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface NetworkServiceClient extends com.vccorp.mojo.bindings.Interface {



    public interface Proxy extends NetworkServiceClient, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<NetworkServiceClient, NetworkServiceClient.Proxy> MANAGER = NetworkServiceClient_Internal.MANAGER;


    void onAuthRequired(
int processId, int routingId, int requestId, com.vccorp.url.mojom.Url url, com.vccorp.url.mojom.Url siteForCookies, boolean firstAuthAttempt, AuthChallengeInfo authInfo, int resourceType, UrlResponseHead head, AuthChallengeResponder authChallengeResponder);



    void onCertificateRequested(
com.vccorp.mojo_base.mojom.UnguessableToken windowId, int processId, int routingId, int requestId, SslCertRequestInfo certInfo,
OnCertificateRequestedResponse callback);

    interface OnCertificateRequestedResponse extends com.vccorp.mojo.bindings.Callbacks.Callback5<X509Certificate, String, short[], SslPrivateKey, Boolean> { }



    void onSslCertificateError(
int processId, int routingId, int requestId, int resourceType, com.vccorp.url.mojom.Url url, SslInfo sslInfo, boolean fatal,
OnSslCertificateErrorResponse callback);

    interface OnSslCertificateErrorResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void onFileUploadRequested(
int processId, boolean async, com.vccorp.mojo_base.mojom.FilePath[] filePaths,
OnFileUploadRequestedResponse callback);

    interface OnFileUploadRequestedResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<Integer, com.vccorp.mojo_base.mojom.File[]> { }



    void onCookieChange(
int processId, int routingId, com.vccorp.url.mojom.Url url, com.vccorp.url.mojom.Url frameUrl, CanonicalCookie cookie, boolean blockedByPolicy);



    void onCookiesRead(
int processId, int routingId, com.vccorp.url.mojom.Url url, com.vccorp.url.mojom.Url frameUrl, CanonicalCookie[] cookieList, boolean blockedByPolicy);



    void onLoadingStateUpdate(
LoadInfo[] infos, 
OnLoadingStateUpdateResponse callback);

    interface OnLoadingStateUpdateResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void onClearSiteData(
int processId, int routingId, com.vccorp.url.mojom.Url url, String headerValue, int loadFlags,
OnClearSiteDataResponse callback);

    interface OnClearSiteDataResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void onDataUseUpdate(
int networkTrafficAnnotationIdHash, long recvBytes, long sentBytes);



    void onGenerateHttpNegotiateAuthToken(
String serverAuthToken, boolean canDelegate, String authNegotiateAndroidAccountType, String spn, 
OnGenerateHttpNegotiateAuthTokenResponse callback);

    interface OnGenerateHttpNegotiateAuthTokenResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<Integer, String> { }


}
