
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_service.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface NetworkService extends com.vccorp.mojo.bindings.Interface {



    public interface Proxy extends NetworkService, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<NetworkService, NetworkService.Proxy> MANAGER = NetworkService_Internal.MANAGER;


    void setClient(
NetworkServiceClient client, NetworkServiceParams params);



    void startNetLog(
com.vccorp.mojo_base.mojom.File file, int captureMode, com.vccorp.mojo_base.mojom.DictionaryValue constants);



    void setSslKeyLogFile(
com.vccorp.mojo_base.mojom.FilePath file);



    void createNetworkContext(
com.vccorp.mojo.bindings.InterfaceRequest<NetworkContext> context, NetworkContextParams params);



    void configureStubHostResolver(
boolean stubResolverEnabled, DnsOverHttpsServer[] dnsOverHttpsServers);



    void disableQuic(
);



    void setUpHttpAuth(
HttpAuthStaticParams httpAuthStaticParams);



    void configureHttpAuthPrefs(
HttpAuthDynamicParams httpAuthDynamicParams);



    void setRawHeadersAccess(
int processId, com.vccorp.url.mojom.Origin[] origins);



    void getNetworkChangeManager(
com.vccorp.mojo.bindings.InterfaceRequest<NetworkChangeManager> networkChangeManager);



    void getNetworkQualityEstimatorManager(
com.vccorp.mojo.bindings.InterfaceRequest<NetworkQualityEstimatorManager> networkQualityEstimatorManager);



    void getDnsConfigChangeManager(
com.vccorp.mojo.bindings.InterfaceRequest<DnsConfigChangeManager> dnsConfigChangeManager);



    void getTotalNetworkUsages(

GetTotalNetworkUsagesResponse callback);

    interface GetTotalNetworkUsagesResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<NetworkUsage[]> { }



    void getNetworkList(
int policy, 
GetNetworkListResponse callback);

    interface GetNetworkListResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<NetworkInterface[]> { }



    void updateSignedTreeHead(
SignedTreeHead signedTreeHead);



    void updateCrlSet(
com.vccorp.mojo_base.mojom.ReadOnlyBuffer crlSet);



    void onCertDbChanged(
);



    void addCorbExceptionForPlugin(
int processId);



    void removeCorbExceptionForPlugin(
int processId);



    void onMemoryPressure(
int memoryPressureLevel);



    void onApplicationStateChange(
int state);



    void setEnvironment(
EnvironmentVariable[] environment);


}
