
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_context.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class CustomProxyConfig extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public ProxyRules rules;
    public boolean shouldOverrideExistingConfig;
    public boolean allowNonIdempotentMethods;
    public boolean assumeHttpsProxiesSupportQuic;
    public boolean canUseProxyOnHttpUrlRedirectCycles;
    public HttpRequestHeaders preCacheHeaders;
    public HttpRequestHeaders postCacheHeaders;
    public HttpRequestHeaders connectTunnelHeaders;

    private CustomProxyConfig(int version) {
        super(STRUCT_SIZE, version);
        this.shouldOverrideExistingConfig = (boolean) false;
        this.allowNonIdempotentMethods = (boolean) false;
        this.assumeHttpsProxiesSupportQuic = (boolean) false;
        this.canUseProxyOnHttpUrlRedirectCycles = (boolean) true;
    }

    public CustomProxyConfig() {
        this(0);
    }

    public static CustomProxyConfig deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static CustomProxyConfig deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static CustomProxyConfig decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        CustomProxyConfig result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new CustomProxyConfig(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.rules = ProxyRules.decode(decoder1);
                }
                {
                    
                result.shouldOverrideExistingConfig = decoder0.readBoolean(16, 0);
                }
                {
                    
                result.allowNonIdempotentMethods = decoder0.readBoolean(16, 1);
                }
                {
                    
                result.assumeHttpsProxiesSupportQuic = decoder0.readBoolean(16, 2);
                }
                {
                    
                result.canUseProxyOnHttpUrlRedirectCycles = decoder0.readBoolean(16, 3);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.preCacheHeaders = HttpRequestHeaders.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.postCacheHeaders = HttpRequestHeaders.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.connectTunnelHeaders = HttpRequestHeaders.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.rules, 8, false);
        
        encoder0.encode(this.shouldOverrideExistingConfig, 16, 0);
        
        encoder0.encode(this.allowNonIdempotentMethods, 16, 1);
        
        encoder0.encode(this.assumeHttpsProxiesSupportQuic, 16, 2);
        
        encoder0.encode(this.canUseProxyOnHttpUrlRedirectCycles, 16, 3);
        
        encoder0.encode(this.preCacheHeaders, 24, false);
        
        encoder0.encode(this.postCacheHeaders, 32, false);
        
        encoder0.encode(this.connectTunnelHeaders, 40, false);
    }
}