
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/video_encode_accelerator.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class VideoEncodeAcceleratorClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<VideoEncodeAcceleratorClient, VideoEncodeAcceleratorClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<VideoEncodeAcceleratorClient, VideoEncodeAcceleratorClient.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.VideoEncodeAcceleratorClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, VideoEncodeAcceleratorClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public VideoEncodeAcceleratorClient[] buildArray(int size) {
          return new VideoEncodeAcceleratorClient[size];
        }
    };


    private static final int REQUIRE_BITSTREAM_BUFFERS_ORDINAL = 0;

    private static final int BITSTREAM_BUFFER_READY_ORDINAL = 1;

    private static final int NOTIFY_ERROR_ORDINAL = 2;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements VideoEncodeAcceleratorClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void requireBitstreamBuffers(
int inputCount, com.vccorp.gfx.mojom.Size inputCodedSize, int outputBufferSize) {

            VideoEncodeAcceleratorClientRequireBitstreamBuffersParams _message = new VideoEncodeAcceleratorClientRequireBitstreamBuffersParams();

            _message.inputCount = inputCount;

            _message.inputCodedSize = inputCodedSize;

            _message.outputBufferSize = outputBufferSize;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REQUIRE_BITSTREAM_BUFFERS_ORDINAL)));

        }


        @Override
        public void bitstreamBufferReady(
int bitstreamBufferId, BitstreamBufferMetadata metadata) {

            VideoEncodeAcceleratorClientBitstreamBufferReadyParams _message = new VideoEncodeAcceleratorClientBitstreamBufferReadyParams();

            _message.bitstreamBufferId = bitstreamBufferId;

            _message.metadata = metadata;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(BITSTREAM_BUFFER_READY_ORDINAL)));

        }


        @Override
        public void notifyError(
int error) {

            VideoEncodeAcceleratorClientNotifyErrorParams _message = new VideoEncodeAcceleratorClientNotifyErrorParams();

            _message.error = error;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(NOTIFY_ERROR_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<VideoEncodeAcceleratorClient> {

        Stub(com.vccorp.mojo.system.Core core, VideoEncodeAcceleratorClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                VideoEncodeAcceleratorClient_Internal.MANAGER, messageWithHeader);





                    case REQUIRE_BITSTREAM_BUFFERS_ORDINAL: {

                        VideoEncodeAcceleratorClientRequireBitstreamBuffersParams data =
                                VideoEncodeAcceleratorClientRequireBitstreamBuffersParams.deserialize(messageWithHeader.getPayload());

                        getImpl().requireBitstreamBuffers(data.inputCount, data.inputCodedSize, data.outputBufferSize);
                        return true;
                    }





                    case BITSTREAM_BUFFER_READY_ORDINAL: {

                        VideoEncodeAcceleratorClientBitstreamBufferReadyParams data =
                                VideoEncodeAcceleratorClientBitstreamBufferReadyParams.deserialize(messageWithHeader.getPayload());

                        getImpl().bitstreamBufferReady(data.bitstreamBufferId, data.metadata);
                        return true;
                    }





                    case NOTIFY_ERROR_ORDINAL: {

                        VideoEncodeAcceleratorClientNotifyErrorParams data =
                                VideoEncodeAcceleratorClientNotifyErrorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().notifyError(data.error);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), VideoEncodeAcceleratorClient_Internal.MANAGER, messageWithHeader, receiver);








                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class VideoEncodeAcceleratorClientRequireBitstreamBuffersParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int inputCount;
        public com.vccorp.gfx.mojom.Size inputCodedSize;
        public int outputBufferSize;

        private VideoEncodeAcceleratorClientRequireBitstreamBuffersParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoEncodeAcceleratorClientRequireBitstreamBuffersParams() {
            this(0);
        }

        public static VideoEncodeAcceleratorClientRequireBitstreamBuffersParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoEncodeAcceleratorClientRequireBitstreamBuffersParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoEncodeAcceleratorClientRequireBitstreamBuffersParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoEncodeAcceleratorClientRequireBitstreamBuffersParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoEncodeAcceleratorClientRequireBitstreamBuffersParams(elementsOrVersion);
                    {
                        
                    result.inputCount = decoder0.readInt(8);
                    }
                    {
                        
                    result.outputBufferSize = decoder0.readInt(12);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.inputCodedSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.inputCount, 8);
            
            encoder0.encode(this.outputBufferSize, 12);
            
            encoder0.encode(this.inputCodedSize, 16, false);
        }
    }



    
    static final class VideoEncodeAcceleratorClientBitstreamBufferReadyParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int bitstreamBufferId;
        public BitstreamBufferMetadata metadata;

        private VideoEncodeAcceleratorClientBitstreamBufferReadyParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoEncodeAcceleratorClientBitstreamBufferReadyParams() {
            this(0);
        }

        public static VideoEncodeAcceleratorClientBitstreamBufferReadyParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoEncodeAcceleratorClientBitstreamBufferReadyParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoEncodeAcceleratorClientBitstreamBufferReadyParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoEncodeAcceleratorClientBitstreamBufferReadyParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoEncodeAcceleratorClientBitstreamBufferReadyParams(elementsOrVersion);
                    {
                        
                    result.bitstreamBufferId = decoder0.readInt(8);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.metadata = BitstreamBufferMetadata.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.bitstreamBufferId, 8);
            
            encoder0.encode(this.metadata, 16, false);
        }
    }



    
    static final class VideoEncodeAcceleratorClientNotifyErrorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;

        private VideoEncodeAcceleratorClientNotifyErrorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoEncodeAcceleratorClientNotifyErrorParams() {
            this(0);
        }

        public static VideoEncodeAcceleratorClientNotifyErrorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoEncodeAcceleratorClientNotifyErrorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoEncodeAcceleratorClientNotifyErrorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoEncodeAcceleratorClientNotifyErrorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoEncodeAcceleratorClientNotifyErrorParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        VideoEncodeAccelerator.Error.validate(result.error);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
        }
    }



}
