
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/capture/mojom/video_capture_types.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class VideoCaptureParams extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 32;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public VideoCaptureFormat requestedFormat;
    public int bufferType;
    public int resolutionChangePolicy;
    public int powerLineFrequency;
    public boolean enableFaceDetection;

    private VideoCaptureParams(int version) {
        super(STRUCT_SIZE, version);
    }

    public VideoCaptureParams() {
        this(0);
    }

    public static VideoCaptureParams deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static VideoCaptureParams deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static VideoCaptureParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        VideoCaptureParams result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new VideoCaptureParams(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.requestedFormat = VideoCaptureFormat.decode(decoder1);
                }
                {
                    
                result.bufferType = decoder0.readInt(16);
                    VideoCaptureBufferType.validate(result.bufferType);
                }
                {
                    
                result.resolutionChangePolicy = decoder0.readInt(20);
                    ResolutionChangePolicy.validate(result.resolutionChangePolicy);
                }
                {
                    
                result.powerLineFrequency = decoder0.readInt(24);
                    PowerLineFrequency.validate(result.powerLineFrequency);
                }
                {
                    
                result.enableFaceDetection = decoder0.readBoolean(28, 0);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.requestedFormat, 8, false);
        
        encoder0.encode(this.bufferType, 16);
        
        encoder0.encode(this.resolutionChangePolicy, 20);
        
        encoder0.encode(this.powerLineFrequency, 24);
        
        encoder0.encode(this.enableFaceDetection, 28, 0);
    }
}