
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/video_decoder.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class SupportedVideoDecoderConfig extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int profileMin;
    public int profileMax;
    public com.vccorp.gfx.mojom.Size codedSizeMin;
    public com.vccorp.gfx.mojom.Size codedSizeMax;
    public boolean allowEncrypted;
    public boolean requireEncrypted;

    private SupportedVideoDecoderConfig(int version) {
        super(STRUCT_SIZE, version);
    }

    public SupportedVideoDecoderConfig() {
        this(0);
    }

    public static SupportedVideoDecoderConfig deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static SupportedVideoDecoderConfig deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static SupportedVideoDecoderConfig decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        SupportedVideoDecoderConfig result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new SupportedVideoDecoderConfig(elementsOrVersion);
                {
                    
                result.profileMin = decoder0.readInt(8);
                    VideoCodecProfile.validate(result.profileMin);
                }
                {
                    
                result.profileMax = decoder0.readInt(12);
                    VideoCodecProfile.validate(result.profileMax);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.codedSizeMin = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.codedSizeMax = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                result.allowEncrypted = decoder0.readBoolean(32, 0);
                }
                {
                    
                result.requireEncrypted = decoder0.readBoolean(32, 1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.profileMin, 8);
        
        encoder0.encode(this.profileMax, 12);
        
        encoder0.encode(this.codedSizeMin, 16, false);
        
        encoder0.encode(this.codedSizeMax, 24, false);
        
        encoder0.encode(this.allowEncrypted, 32, 0);
        
        encoder0.encode(this.requireEncrypted, 32, 1);
    }
}