
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/watch_time_recorder.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class SecondaryPlaybackProperties extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int audioCodec;
    public int videoCodec;
    public String audioDecoderName;
    public String videoDecoderName;
    public int audioEncryptionScheme;
    public int videoEncryptionScheme;
    public com.vccorp.gfx.mojom.Size naturalSize;

    private SecondaryPlaybackProperties(int version) {
        super(STRUCT_SIZE, version);
    }

    public SecondaryPlaybackProperties() {
        this(0);
    }

    public static SecondaryPlaybackProperties deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static SecondaryPlaybackProperties deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static SecondaryPlaybackProperties decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        SecondaryPlaybackProperties result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new SecondaryPlaybackProperties(elementsOrVersion);
                {
                    
                result.audioCodec = decoder0.readInt(8);
                    AudioCodec.validate(result.audioCodec);
                }
                {
                    
                result.videoCodec = decoder0.readInt(12);
                    VideoCodec.validate(result.videoCodec);
                }
                {
                    
                result.audioDecoderName = decoder0.readString(16, false);
                }
                {
                    
                result.videoDecoderName = decoder0.readString(24, false);
                }
                {
                    
                result.audioEncryptionScheme = decoder0.readInt(32);
                    EncryptionMode.validate(result.audioEncryptionScheme);
                }
                {
                    
                result.videoEncryptionScheme = decoder0.readInt(36);
                    EncryptionMode.validate(result.videoEncryptionScheme);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.naturalSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.audioCodec, 8);
        
        encoder0.encode(this.videoCodec, 12);
        
        encoder0.encode(this.audioDecoderName, 16, false);
        
        encoder0.encode(this.videoDecoderName, 24, false);
        
        encoder0.encode(this.audioEncryptionScheme, 32);
        
        encoder0.encode(this.videoEncryptionScheme, 36);
        
        encoder0.encode(this.naturalSize, 40, false);
    }
}