
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/media_types.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class MasteringMetadata extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.gfx.mojom.PointF primaryR;
    public com.vccorp.gfx.mojom.PointF primaryG;
    public com.vccorp.gfx.mojom.PointF primaryB;
    public com.vccorp.gfx.mojom.PointF whitePoint;
    public float luminanceMax;
    public float luminanceMin;

    private MasteringMetadata(int version) {
        super(STRUCT_SIZE, version);
    }

    public MasteringMetadata() {
        this(0);
    }

    public static MasteringMetadata deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static MasteringMetadata deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static MasteringMetadata decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        MasteringMetadata result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new MasteringMetadata(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.primaryR = com.vccorp.gfx.mojom.PointF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.primaryG = com.vccorp.gfx.mojom.PointF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.primaryB = com.vccorp.gfx.mojom.PointF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.whitePoint = com.vccorp.gfx.mojom.PointF.decode(decoder1);
                }
                {
                    
                result.luminanceMax = decoder0.readFloat(40);
                }
                {
                    
                result.luminanceMin = decoder0.readFloat(44);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.primaryR, 8, false);
        
        encoder0.encode(this.primaryG, 16, false);
        
        encoder0.encode(this.primaryB, 24, false);
        
        encoder0.encode(this.whitePoint, 32, false);
        
        encoder0.encode(this.luminanceMax, 40);
        
        encoder0.encode(this.luminanceMin, 44);
    }
}