
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/decryptor.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class Decryptor_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<Decryptor, Decryptor.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<Decryptor, Decryptor.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.Decryptor";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, Decryptor impl) {
            return new Stub(core, impl);
        }

        @Override
        public Decryptor[] buildArray(int size) {
          return new Decryptor[size];
        }
    };


    private static final int INITIALIZE_ORDINAL = 0;

    private static final int DECRYPT_ORDINAL = 1;

    private static final int CANCEL_DECRYPT_ORDINAL = 2;

    private static final int INITIALIZE_AUDIO_DECODER_ORDINAL = 3;

    private static final int INITIALIZE_VIDEO_DECODER_ORDINAL = 4;

    private static final int DECRYPT_AND_DECODE_AUDIO_ORDINAL = 5;

    private static final int DECRYPT_AND_DECODE_VIDEO_ORDINAL = 6;

    private static final int RESET_DECODER_ORDINAL = 7;

    private static final int DEINITIALIZE_DECODER_ORDINAL = 8;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements Decryptor.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void initialize(
com.vccorp.mojo.system.DataPipe.ConsumerHandle audioPipe, com.vccorp.mojo.system.DataPipe.ConsumerHandle videoPipe, com.vccorp.mojo.system.DataPipe.ConsumerHandle decryptPipe, com.vccorp.mojo.system.DataPipe.ProducerHandle decryptedPipe) {

            DecryptorInitializeParams _message = new DecryptorInitializeParams();

            _message.audioPipe = audioPipe;

            _message.videoPipe = videoPipe;

            _message.decryptPipe = decryptPipe;

            _message.decryptedPipe = decryptedPipe;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(INITIALIZE_ORDINAL)));

        }


        @Override
        public void decrypt(
int streamType, DecoderBuffer encrypted, 
DecryptResponse callback) {

            DecryptorDecryptParams _message = new DecryptorDecryptParams();

            _message.streamType = streamType;

            _message.encrypted = encrypted;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DECRYPT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new DecryptorDecryptResponseParamsForwardToCallback(callback));

        }


        @Override
        public void cancelDecrypt(
int streamType) {

            DecryptorCancelDecryptParams _message = new DecryptorCancelDecryptParams();

            _message.streamType = streamType;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CANCEL_DECRYPT_ORDINAL)));

        }


        @Override
        public void initializeAudioDecoder(
AudioDecoderConfig config, 
InitializeAudioDecoderResponse callback) {

            DecryptorInitializeAudioDecoderParams _message = new DecryptorInitializeAudioDecoderParams();

            _message.config = config;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    INITIALIZE_AUDIO_DECODER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new DecryptorInitializeAudioDecoderResponseParamsForwardToCallback(callback));

        }


        @Override
        public void initializeVideoDecoder(
VideoDecoderConfig config, 
InitializeVideoDecoderResponse callback) {

            DecryptorInitializeVideoDecoderParams _message = new DecryptorInitializeVideoDecoderParams();

            _message.config = config;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    INITIALIZE_VIDEO_DECODER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new DecryptorInitializeVideoDecoderResponseParamsForwardToCallback(callback));

        }


        @Override
        public void decryptAndDecodeAudio(
DecoderBuffer encrypted, 
DecryptAndDecodeAudioResponse callback) {

            DecryptorDecryptAndDecodeAudioParams _message = new DecryptorDecryptAndDecodeAudioParams();

            _message.encrypted = encrypted;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DECRYPT_AND_DECODE_AUDIO_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new DecryptorDecryptAndDecodeAudioResponseParamsForwardToCallback(callback));

        }


        @Override
        public void decryptAndDecodeVideo(
DecoderBuffer encrypted, 
DecryptAndDecodeVideoResponse callback) {

            DecryptorDecryptAndDecodeVideoParams _message = new DecryptorDecryptAndDecodeVideoParams();

            _message.encrypted = encrypted;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DECRYPT_AND_DECODE_VIDEO_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new DecryptorDecryptAndDecodeVideoResponseParamsForwardToCallback(callback));

        }


        @Override
        public void resetDecoder(
int streamType) {

            DecryptorResetDecoderParams _message = new DecryptorResetDecoderParams();

            _message.streamType = streamType;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(RESET_DECODER_ORDINAL)));

        }


        @Override
        public void deinitializeDecoder(
int streamType) {

            DecryptorDeinitializeDecoderParams _message = new DecryptorDeinitializeDecoderParams();

            _message.streamType = streamType;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DEINITIALIZE_DECODER_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<Decryptor> {

        Stub(com.vccorp.mojo.system.Core core, Decryptor impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                Decryptor_Internal.MANAGER, messageWithHeader);





                    case INITIALIZE_ORDINAL: {

                        DecryptorInitializeParams data =
                                DecryptorInitializeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().initialize(data.audioPipe, data.videoPipe, data.decryptPipe, data.decryptedPipe);
                        return true;
                    }







                    case CANCEL_DECRYPT_ORDINAL: {

                        DecryptorCancelDecryptParams data =
                                DecryptorCancelDecryptParams.deserialize(messageWithHeader.getPayload());

                        getImpl().cancelDecrypt(data.streamType);
                        return true;
                    }













                    case RESET_DECODER_ORDINAL: {

                        DecryptorResetDecoderParams data =
                                DecryptorResetDecoderParams.deserialize(messageWithHeader.getPayload());

                        getImpl().resetDecoder(data.streamType);
                        return true;
                    }





                    case DEINITIALIZE_DECODER_ORDINAL: {

                        DecryptorDeinitializeDecoderParams data =
                                DecryptorDeinitializeDecoderParams.deserialize(messageWithHeader.getPayload());

                        getImpl().deinitializeDecoder(data.streamType);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), Decryptor_Internal.MANAGER, messageWithHeader, receiver);









                    case DECRYPT_ORDINAL: {

                        DecryptorDecryptParams data =
                                DecryptorDecryptParams.deserialize(messageWithHeader.getPayload());

                        getImpl().decrypt(data.streamType, data.encrypted, new DecryptorDecryptResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }









                    case INITIALIZE_AUDIO_DECODER_ORDINAL: {

                        DecryptorInitializeAudioDecoderParams data =
                                DecryptorInitializeAudioDecoderParams.deserialize(messageWithHeader.getPayload());

                        getImpl().initializeAudioDecoder(data.config, new DecryptorInitializeAudioDecoderResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case INITIALIZE_VIDEO_DECODER_ORDINAL: {

                        DecryptorInitializeVideoDecoderParams data =
                                DecryptorInitializeVideoDecoderParams.deserialize(messageWithHeader.getPayload());

                        getImpl().initializeVideoDecoder(data.config, new DecryptorInitializeVideoDecoderResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DECRYPT_AND_DECODE_AUDIO_ORDINAL: {

                        DecryptorDecryptAndDecodeAudioParams data =
                                DecryptorDecryptAndDecodeAudioParams.deserialize(messageWithHeader.getPayload());

                        getImpl().decryptAndDecodeAudio(data.encrypted, new DecryptorDecryptAndDecodeAudioResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DECRYPT_AND_DECODE_VIDEO_ORDINAL: {

                        DecryptorDecryptAndDecodeVideoParams data =
                                DecryptorDecryptAndDecodeVideoParams.deserialize(messageWithHeader.getPayload());

                        getImpl().decryptAndDecodeVideo(data.encrypted, new DecryptorDecryptAndDecodeVideoResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class DecryptorInitializeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.system.DataPipe.ConsumerHandle audioPipe;
        public com.vccorp.mojo.system.DataPipe.ConsumerHandle videoPipe;
        public com.vccorp.mojo.system.DataPipe.ConsumerHandle decryptPipe;
        public com.vccorp.mojo.system.DataPipe.ProducerHandle decryptedPipe;

        private DecryptorInitializeParams(int version) {
            super(STRUCT_SIZE, version);
            this.audioPipe = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
            this.videoPipe = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
            this.decryptPipe = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
            this.decryptedPipe = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public DecryptorInitializeParams() {
            this(0);
        }

        public static DecryptorInitializeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorInitializeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorInitializeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorInitializeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorInitializeParams(elementsOrVersion);
                    {
                        
                    result.audioPipe = decoder0.readConsumerHandle(8, false);
                    }
                    {
                        
                    result.videoPipe = decoder0.readConsumerHandle(12, false);
                    }
                    {
                        
                    result.decryptPipe = decoder0.readConsumerHandle(16, false);
                    }
                    {
                        
                    result.decryptedPipe = decoder0.readProducerHandle(20, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.audioPipe, 8, false);
            
            encoder0.encode(this.videoPipe, 12, false);
            
            encoder0.encode(this.decryptPipe, 16, false);
            
            encoder0.encode(this.decryptedPipe, 20, false);
        }
    }



    
    static final class DecryptorDecryptParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int streamType;
        public DecoderBuffer encrypted;

        private DecryptorDecryptParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorDecryptParams() {
            this(0);
        }

        public static DecryptorDecryptParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorDecryptParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorDecryptParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorDecryptParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorDecryptParams(elementsOrVersion);
                    {
                        
                    result.streamType = decoder0.readInt(8);
                        Decryptor.StreamType.validate(result.streamType);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.encrypted = DecoderBuffer.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.streamType, 8);
            
            encoder0.encode(this.encrypted, 16, false);
        }
    }



    
    static final class DecryptorDecryptResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;
        public DecoderBuffer buffer;

        private DecryptorDecryptResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorDecryptResponseParams() {
            this(0);
        }

        public static DecryptorDecryptResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorDecryptResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorDecryptResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorDecryptResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorDecryptResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        Decryptor.Status.validate(result.status);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.buffer = DecoderBuffer.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
            
            encoder0.encode(this.buffer, 16, true);
        }
    }

    static class DecryptorDecryptResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final Decryptor.DecryptResponse mCallback;

        DecryptorDecryptResponseParamsForwardToCallback(Decryptor.DecryptResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DECRYPT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                DecryptorDecryptResponseParams response = DecryptorDecryptResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status, response.buffer);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class DecryptorDecryptResponseParamsProxyToResponder implements Decryptor.DecryptResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        DecryptorDecryptResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status, DecoderBuffer buffer) {
            DecryptorDecryptResponseParams _response = new DecryptorDecryptResponseParams();

            _response.status = status;

            _response.buffer = buffer;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DECRYPT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class DecryptorCancelDecryptParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int streamType;

        private DecryptorCancelDecryptParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorCancelDecryptParams() {
            this(0);
        }

        public static DecryptorCancelDecryptParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorCancelDecryptParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorCancelDecryptParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorCancelDecryptParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorCancelDecryptParams(elementsOrVersion);
                    {
                        
                    result.streamType = decoder0.readInt(8);
                        Decryptor.StreamType.validate(result.streamType);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.streamType, 8);
        }
    }



    
    static final class DecryptorInitializeAudioDecoderParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public AudioDecoderConfig config;

        private DecryptorInitializeAudioDecoderParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorInitializeAudioDecoderParams() {
            this(0);
        }

        public static DecryptorInitializeAudioDecoderParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorInitializeAudioDecoderParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorInitializeAudioDecoderParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorInitializeAudioDecoderParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorInitializeAudioDecoderParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.config = AudioDecoderConfig.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.config, 8, false);
        }
    }



    
    static final class DecryptorInitializeAudioDecoderResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean success;

        private DecryptorInitializeAudioDecoderResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorInitializeAudioDecoderResponseParams() {
            this(0);
        }

        public static DecryptorInitializeAudioDecoderResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorInitializeAudioDecoderResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorInitializeAudioDecoderResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorInitializeAudioDecoderResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorInitializeAudioDecoderResponseParams(elementsOrVersion);
                    {
                        
                    result.success = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.success, 8, 0);
        }
    }

    static class DecryptorInitializeAudioDecoderResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final Decryptor.InitializeAudioDecoderResponse mCallback;

        DecryptorInitializeAudioDecoderResponseParamsForwardToCallback(Decryptor.InitializeAudioDecoderResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(INITIALIZE_AUDIO_DECODER_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                DecryptorInitializeAudioDecoderResponseParams response = DecryptorInitializeAudioDecoderResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.success);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class DecryptorInitializeAudioDecoderResponseParamsProxyToResponder implements Decryptor.InitializeAudioDecoderResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        DecryptorInitializeAudioDecoderResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean success) {
            DecryptorInitializeAudioDecoderResponseParams _response = new DecryptorInitializeAudioDecoderResponseParams();

            _response.success = success;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    INITIALIZE_AUDIO_DECODER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class DecryptorInitializeVideoDecoderParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VideoDecoderConfig config;

        private DecryptorInitializeVideoDecoderParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorInitializeVideoDecoderParams() {
            this(0);
        }

        public static DecryptorInitializeVideoDecoderParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorInitializeVideoDecoderParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorInitializeVideoDecoderParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorInitializeVideoDecoderParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorInitializeVideoDecoderParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.config = VideoDecoderConfig.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.config, 8, false);
        }
    }



    
    static final class DecryptorInitializeVideoDecoderResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean success;

        private DecryptorInitializeVideoDecoderResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorInitializeVideoDecoderResponseParams() {
            this(0);
        }

        public static DecryptorInitializeVideoDecoderResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorInitializeVideoDecoderResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorInitializeVideoDecoderResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorInitializeVideoDecoderResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorInitializeVideoDecoderResponseParams(elementsOrVersion);
                    {
                        
                    result.success = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.success, 8, 0);
        }
    }

    static class DecryptorInitializeVideoDecoderResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final Decryptor.InitializeVideoDecoderResponse mCallback;

        DecryptorInitializeVideoDecoderResponseParamsForwardToCallback(Decryptor.InitializeVideoDecoderResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(INITIALIZE_VIDEO_DECODER_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                DecryptorInitializeVideoDecoderResponseParams response = DecryptorInitializeVideoDecoderResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.success);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class DecryptorInitializeVideoDecoderResponseParamsProxyToResponder implements Decryptor.InitializeVideoDecoderResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        DecryptorInitializeVideoDecoderResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean success) {
            DecryptorInitializeVideoDecoderResponseParams _response = new DecryptorInitializeVideoDecoderResponseParams();

            _response.success = success;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    INITIALIZE_VIDEO_DECODER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class DecryptorDecryptAndDecodeAudioParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public DecoderBuffer encrypted;

        private DecryptorDecryptAndDecodeAudioParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorDecryptAndDecodeAudioParams() {
            this(0);
        }

        public static DecryptorDecryptAndDecodeAudioParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorDecryptAndDecodeAudioParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorDecryptAndDecodeAudioParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorDecryptAndDecodeAudioParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorDecryptAndDecodeAudioParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.encrypted = DecoderBuffer.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.encrypted, 8, false);
        }
    }



    
    static final class DecryptorDecryptAndDecodeAudioResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;
        public AudioBuffer[] audioBuffers;

        private DecryptorDecryptAndDecodeAudioResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorDecryptAndDecodeAudioResponseParams() {
            this(0);
        }

        public static DecryptorDecryptAndDecodeAudioResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorDecryptAndDecodeAudioResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorDecryptAndDecodeAudioResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorDecryptAndDecodeAudioResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorDecryptAndDecodeAudioResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        Decryptor.Status.validate(result.status);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.audioBuffers = new AudioBuffer[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.audioBuffers[i1] = AudioBuffer.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
            
            if (this.audioBuffers == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.audioBuffers.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.audioBuffers.length; ++i0) {
                    
                    encoder1.encode(this.audioBuffers[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class DecryptorDecryptAndDecodeAudioResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final Decryptor.DecryptAndDecodeAudioResponse mCallback;

        DecryptorDecryptAndDecodeAudioResponseParamsForwardToCallback(Decryptor.DecryptAndDecodeAudioResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DECRYPT_AND_DECODE_AUDIO_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                DecryptorDecryptAndDecodeAudioResponseParams response = DecryptorDecryptAndDecodeAudioResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status, response.audioBuffers);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class DecryptorDecryptAndDecodeAudioResponseParamsProxyToResponder implements Decryptor.DecryptAndDecodeAudioResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        DecryptorDecryptAndDecodeAudioResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status, AudioBuffer[] audioBuffers) {
            DecryptorDecryptAndDecodeAudioResponseParams _response = new DecryptorDecryptAndDecodeAudioResponseParams();

            _response.status = status;

            _response.audioBuffers = audioBuffers;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DECRYPT_AND_DECODE_AUDIO_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class DecryptorDecryptAndDecodeVideoParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public DecoderBuffer encrypted;

        private DecryptorDecryptAndDecodeVideoParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorDecryptAndDecodeVideoParams() {
            this(0);
        }

        public static DecryptorDecryptAndDecodeVideoParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorDecryptAndDecodeVideoParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorDecryptAndDecodeVideoParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorDecryptAndDecodeVideoParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorDecryptAndDecodeVideoParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.encrypted = DecoderBuffer.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.encrypted, 8, false);
        }
    }



    
    static final class DecryptorDecryptAndDecodeVideoResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;
        public VideoFrame videoFrame;
        public FrameResourceReleaser releaser;

        private DecryptorDecryptAndDecodeVideoResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorDecryptAndDecodeVideoResponseParams() {
            this(0);
        }

        public static DecryptorDecryptAndDecodeVideoResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorDecryptAndDecodeVideoResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorDecryptAndDecodeVideoResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorDecryptAndDecodeVideoResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorDecryptAndDecodeVideoResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        Decryptor.Status.validate(result.status);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.videoFrame = VideoFrame.decode(decoder1);
                    }
                    {
                        
                    result.releaser = decoder0.readServiceInterface(24, true, FrameResourceReleaser.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
            
            encoder0.encode(this.videoFrame, 16, true);
            
            encoder0.encode(this.releaser, 24, true, FrameResourceReleaser.MANAGER);
        }
    }

    static class DecryptorDecryptAndDecodeVideoResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final Decryptor.DecryptAndDecodeVideoResponse mCallback;

        DecryptorDecryptAndDecodeVideoResponseParamsForwardToCallback(Decryptor.DecryptAndDecodeVideoResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DECRYPT_AND_DECODE_VIDEO_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                DecryptorDecryptAndDecodeVideoResponseParams response = DecryptorDecryptAndDecodeVideoResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status, response.videoFrame, response.releaser);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class DecryptorDecryptAndDecodeVideoResponseParamsProxyToResponder implements Decryptor.DecryptAndDecodeVideoResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        DecryptorDecryptAndDecodeVideoResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status, VideoFrame videoFrame, FrameResourceReleaser releaser) {
            DecryptorDecryptAndDecodeVideoResponseParams _response = new DecryptorDecryptAndDecodeVideoResponseParams();

            _response.status = status;

            _response.videoFrame = videoFrame;

            _response.releaser = releaser;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DECRYPT_AND_DECODE_VIDEO_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class DecryptorResetDecoderParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int streamType;

        private DecryptorResetDecoderParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorResetDecoderParams() {
            this(0);
        }

        public static DecryptorResetDecoderParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorResetDecoderParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorResetDecoderParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorResetDecoderParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorResetDecoderParams(elementsOrVersion);
                    {
                        
                    result.streamType = decoder0.readInt(8);
                        Decryptor.StreamType.validate(result.streamType);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.streamType, 8);
        }
    }



    
    static final class DecryptorDeinitializeDecoderParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int streamType;

        private DecryptorDeinitializeDecoderParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DecryptorDeinitializeDecoderParams() {
            this(0);
        }

        public static DecryptorDeinitializeDecoderParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DecryptorDeinitializeDecoderParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DecryptorDeinitializeDecoderParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DecryptorDeinitializeDecoderParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DecryptorDeinitializeDecoderParams(elementsOrVersion);
                    {
                        
                    result.streamType = decoder0.readInt(8);
                        Decryptor.StreamType.validate(result.streamType);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.streamType, 8);
        }
    }



}
