
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/decryptor.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface Decryptor extends com.vccorp.mojo.bindings.Interface {



    public static final class Status {
        private static final boolean IS_EXTENSIBLE = false;


        public static boolean isKnownValue(int value) {
            return false;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private Status() {}
    }


    public static final class StreamType {
        private static final boolean IS_EXTENSIBLE = false;


        public static boolean isKnownValue(int value) {
            return false;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private StreamType() {}
    }


    public interface Proxy extends Decryptor, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<Decryptor, Decryptor.Proxy> MANAGER = Decryptor_Internal.MANAGER;


    void initialize(
com.vccorp.mojo.system.DataPipe.ConsumerHandle audioPipe, com.vccorp.mojo.system.DataPipe.ConsumerHandle videoPipe, com.vccorp.mojo.system.DataPipe.ConsumerHandle decryptPipe, com.vccorp.mojo.system.DataPipe.ProducerHandle decryptedPipe);



    void decrypt(
int streamType, DecoderBuffer encrypted, 
DecryptResponse callback);

    interface DecryptResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<Integer, DecoderBuffer> { }



    void cancelDecrypt(
int streamType);



    void initializeAudioDecoder(
AudioDecoderConfig config, 
InitializeAudioDecoderResponse callback);

    interface InitializeAudioDecoderResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Boolean> { }



    void initializeVideoDecoder(
VideoDecoderConfig config, 
InitializeVideoDecoderResponse callback);

    interface InitializeVideoDecoderResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Boolean> { }



    void decryptAndDecodeAudio(
DecoderBuffer encrypted, 
DecryptAndDecodeAudioResponse callback);

    interface DecryptAndDecodeAudioResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<Integer, AudioBuffer[]> { }



    void decryptAndDecodeVideo(
DecoderBuffer encrypted, 
DecryptAndDecodeVideoResponse callback);

    interface DecryptAndDecodeVideoResponse extends com.vccorp.mojo.bindings.Callbacks.Callback3<Integer, VideoFrame, FrameResourceReleaser> { }



    void resetDecoder(
int streamType);



    void deinitializeDecoder(
int streamType);


}
