
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/audio_output_stream.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class AudioOutputStreamObserver_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<AudioOutputStreamObserver, AudioOutputStreamObserver.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<AudioOutputStreamObserver, AudioOutputStreamObserver.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.AudioOutputStreamObserver";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, AudioOutputStreamObserver impl) {
            return new Stub(core, impl);
        }

        @Override
        public AudioOutputStreamObserver[] buildArray(int size) {
          return new AudioOutputStreamObserver[size];
        }
    };


    private static final int DID_START_PLAYING_ORDINAL = 0;

    private static final int DID_STOP_PLAYING_ORDINAL = 1;

    private static final int DID_CHANGE_AUDIBLE_STATE_ORDINAL = 2;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements AudioOutputStreamObserver.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void didStartPlaying(
) {

            AudioOutputStreamObserverDidStartPlayingParams _message = new AudioOutputStreamObserverDidStartPlayingParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DID_START_PLAYING_ORDINAL)));

        }


        @Override
        public void didStopPlaying(
) {

            AudioOutputStreamObserverDidStopPlayingParams _message = new AudioOutputStreamObserverDidStopPlayingParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DID_STOP_PLAYING_ORDINAL)));

        }


        @Override
        public void didChangeAudibleState(
boolean isAudible) {

            AudioOutputStreamObserverDidChangeAudibleStateParams _message = new AudioOutputStreamObserverDidChangeAudibleStateParams();

            _message.isAudible = isAudible;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DID_CHANGE_AUDIBLE_STATE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<AudioOutputStreamObserver> {

        Stub(com.vccorp.mojo.system.Core core, AudioOutputStreamObserver impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                AudioOutputStreamObserver_Internal.MANAGER, messageWithHeader);





                    case DID_START_PLAYING_ORDINAL: {

                        AudioOutputStreamObserverDidStartPlayingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().didStartPlaying();
                        return true;
                    }





                    case DID_STOP_PLAYING_ORDINAL: {

                        AudioOutputStreamObserverDidStopPlayingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().didStopPlaying();
                        return true;
                    }





                    case DID_CHANGE_AUDIBLE_STATE_ORDINAL: {

                        AudioOutputStreamObserverDidChangeAudibleStateParams data =
                                AudioOutputStreamObserverDidChangeAudibleStateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().didChangeAudibleState(data.isAudible);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), AudioOutputStreamObserver_Internal.MANAGER, messageWithHeader, receiver);








                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class AudioOutputStreamObserverDidStartPlayingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private AudioOutputStreamObserverDidStartPlayingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioOutputStreamObserverDidStartPlayingParams() {
            this(0);
        }

        public static AudioOutputStreamObserverDidStartPlayingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioOutputStreamObserverDidStartPlayingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioOutputStreamObserverDidStartPlayingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioOutputStreamObserverDidStartPlayingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioOutputStreamObserverDidStartPlayingParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class AudioOutputStreamObserverDidStopPlayingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private AudioOutputStreamObserverDidStopPlayingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioOutputStreamObserverDidStopPlayingParams() {
            this(0);
        }

        public static AudioOutputStreamObserverDidStopPlayingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioOutputStreamObserverDidStopPlayingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioOutputStreamObserverDidStopPlayingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioOutputStreamObserverDidStopPlayingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioOutputStreamObserverDidStopPlayingParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class AudioOutputStreamObserverDidChangeAudibleStateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean isAudible;

        private AudioOutputStreamObserverDidChangeAudibleStateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioOutputStreamObserverDidChangeAudibleStateParams() {
            this(0);
        }

        public static AudioOutputStreamObserverDidChangeAudibleStateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioOutputStreamObserverDidChangeAudibleStateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioOutputStreamObserverDidChangeAudibleStateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioOutputStreamObserverDidChangeAudibleStateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioOutputStreamObserverDidChangeAudibleStateParams(elementsOrVersion);
                    {
                        
                    result.isAudible = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.isAudible, 8, 0);
        }
    }



}
