
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     gpu/ipc/common/sync_token.mojom
//

package com.vccorp.gpu.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class CommandBufferNamespace {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int INVALID = -1;
    public static final int GPU_IO = 0; // INVALID + 1
    public static final int IN_PROCESS = 1; // GPU_IO + 1
    public static final int MOJO = 2; // IN_PROCESS + 1
    public static final int MOJO_LOCAL = 3; // MOJO + 1
    public static final int NUM_COMMAND_BUFFER_NAMESPACES = 4; // MOJO_LOCAL + 1

    public static boolean isKnownValue(int value) {
        return value >= -1 && value <= 4;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private CommandBufferNamespace() {}
}