
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     ui/gfx/mojo/buffer_types.mojom
//

package com.vccorp.gfx.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class GpuMemoryBufferPlatformHandle extends com.vccorp.mojo.bindings.Union {

    public static final class Tag {
        public static final int SharedMemoryHandle = 0;
        public static final int AndroidHardwareBufferHandle = 1;
    };
    private com.vccorp.mojo_base.mojom.UnsafeSharedMemoryRegion mSharedMemoryHandle;
    private AHardwareBufferHandle mAndroidHardwareBufferHandle;

    public void setSharedMemoryHandle(com.vccorp.mojo_base.mojom.UnsafeSharedMemoryRegion sharedMemoryHandle) {
        this.mTag = Tag.SharedMemoryHandle;
        this.mSharedMemoryHandle = sharedMemoryHandle;
    }

    public com.vccorp.mojo_base.mojom.UnsafeSharedMemoryRegion getSharedMemoryHandle() {
        assert this.mTag == Tag.SharedMemoryHandle;
        return this.mSharedMemoryHandle;
    }

    public void setAndroidHardwareBufferHandle(AHardwareBufferHandle androidHardwareBufferHandle) {
        this.mTag = Tag.AndroidHardwareBufferHandle;
        this.mAndroidHardwareBufferHandle = androidHardwareBufferHandle;
    }

    public AHardwareBufferHandle getAndroidHardwareBufferHandle() {
        assert this.mTag == Tag.AndroidHardwareBufferHandle;
        return this.mAndroidHardwareBufferHandle;
    }


    @Override
    public final void encode(org.chromium.mojo.bindings.Encoder encoder0, int offset) {
        encoder0.encode(com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE, offset);
        encoder0.encode(this.mTag, offset + 4);
        switch (mTag) {
            case Tag.SharedMemoryHandle: {
                
                encoder0.encode(this.mSharedMemoryHandle, offset + 8, false);
                break;
            }
            case Tag.AndroidHardwareBufferHandle: {
                
                encoder0.encode(this.mAndroidHardwareBufferHandle, offset + 8, false);
                break;
            }
            default: {
                break;
            }
        }
    }

    public static GpuMemoryBufferPlatformHandle deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message).decoderForSerializedUnion(), 0);
    }

    public static final GpuMemoryBufferPlatformHandle decode(com.vccorp.mojo.bindings.Decoder decoder0, int offset) {
        com.vccorp.mojo.bindings.DataHeader dataHeader = decoder0.readDataHeaderForUnion(offset);
        if (dataHeader.size == 0) {
            return null;
        }
        GpuMemoryBufferPlatformHandle result = new GpuMemoryBufferPlatformHandle();
        switch (dataHeader.elementsOrVersion) {
            case Tag.SharedMemoryHandle: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mSharedMemoryHandle = com.vccorp.mojo_base.mojom.UnsafeSharedMemoryRegion.decode(decoder1);
                result.mTag = Tag.SharedMemoryHandle;
                break;
            }
            case Tag.AndroidHardwareBufferHandle: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mAndroidHardwareBufferHandle = AHardwareBufferHandle.decode(decoder1);
                result.mTag = Tag.AndroidHardwareBufferHandle;
                break;
            }
            default: {
                break;
            }
        }
        return result;
    }
}