
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     components/services/filesystem/public/interfaces/file_system.mojom
//

package com.vccorp.filesystem.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class FileSystem_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<FileSystem, FileSystem.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<FileSystem, FileSystem.Proxy>() {

        @Override
        public String getName() {
            return "filesystem.mojom.FileSystem";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, FileSystem impl) {
            return new Stub(core, impl);
        }

        @Override
        public FileSystem[] buildArray(int size) {
          return new FileSystem[size];
        }
    };


    private static final int OPEN_TEMP_DIRECTORY_ORDINAL = 0;

    private static final int OPEN_PERSISTENT_FILE_SYSTEM_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements FileSystem.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void openTempDirectory(
com.vccorp.mojo.bindings.InterfaceRequest<Directory> directory,
OpenTempDirectoryResponse callback) {

            FileSystemOpenTempDirectoryParams _message = new FileSystemOpenTempDirectoryParams();

            _message.directory = directory;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    OPEN_TEMP_DIRECTORY_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new FileSystemOpenTempDirectoryResponseParamsForwardToCallback(callback));

        }


        @Override
        public void openPersistentFileSystem(
com.vccorp.mojo.bindings.InterfaceRequest<Directory> directory,
OpenPersistentFileSystemResponse callback) {

            FileSystemOpenPersistentFileSystemParams _message = new FileSystemOpenPersistentFileSystemParams();

            _message.directory = directory;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    OPEN_PERSISTENT_FILE_SYSTEM_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new FileSystemOpenPersistentFileSystemResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<FileSystem> {

        Stub(com.vccorp.mojo.system.Core core, FileSystem impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                FileSystem_Internal.MANAGER, messageWithHeader);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), FileSystem_Internal.MANAGER, messageWithHeader, receiver);







                    case OPEN_TEMP_DIRECTORY_ORDINAL: {

                        FileSystemOpenTempDirectoryParams data =
                                FileSystemOpenTempDirectoryParams.deserialize(messageWithHeader.getPayload());

                        getImpl().openTempDirectory(data.directory, new FileSystemOpenTempDirectoryResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case OPEN_PERSISTENT_FILE_SYSTEM_ORDINAL: {

                        FileSystemOpenPersistentFileSystemParams data =
                                FileSystemOpenPersistentFileSystemParams.deserialize(messageWithHeader.getPayload());

                        getImpl().openPersistentFileSystem(data.directory, new FileSystemOpenPersistentFileSystemResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class FileSystemOpenTempDirectoryParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<Directory> directory;

        private FileSystemOpenTempDirectoryParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public FileSystemOpenTempDirectoryParams() {
            this(0);
        }

        public static FileSystemOpenTempDirectoryParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static FileSystemOpenTempDirectoryParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static FileSystemOpenTempDirectoryParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            FileSystemOpenTempDirectoryParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new FileSystemOpenTempDirectoryParams(elementsOrVersion);
                    {
                        
                    result.directory = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.directory, 8, false);
        }
    }



    
    static final class FileSystemOpenTempDirectoryResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;

        private FileSystemOpenTempDirectoryResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public FileSystemOpenTempDirectoryResponseParams() {
            this(0);
        }

        public static FileSystemOpenTempDirectoryResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static FileSystemOpenTempDirectoryResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static FileSystemOpenTempDirectoryResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            FileSystemOpenTempDirectoryResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new FileSystemOpenTempDirectoryResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        com.vccorp.mojo_base.mojom.FileError.validate(result.error);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
        }
    }

    static class FileSystemOpenTempDirectoryResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final FileSystem.OpenTempDirectoryResponse mCallback;

        FileSystemOpenTempDirectoryResponseParamsForwardToCallback(FileSystem.OpenTempDirectoryResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(OPEN_TEMP_DIRECTORY_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                FileSystemOpenTempDirectoryResponseParams response = FileSystemOpenTempDirectoryResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class FileSystemOpenTempDirectoryResponseParamsProxyToResponder implements FileSystem.OpenTempDirectoryResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        FileSystemOpenTempDirectoryResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error) {
            FileSystemOpenTempDirectoryResponseParams _response = new FileSystemOpenTempDirectoryResponseParams();

            _response.error = error;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    OPEN_TEMP_DIRECTORY_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class FileSystemOpenPersistentFileSystemParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<Directory> directory;

        private FileSystemOpenPersistentFileSystemParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public FileSystemOpenPersistentFileSystemParams() {
            this(0);
        }

        public static FileSystemOpenPersistentFileSystemParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static FileSystemOpenPersistentFileSystemParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static FileSystemOpenPersistentFileSystemParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            FileSystemOpenPersistentFileSystemParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new FileSystemOpenPersistentFileSystemParams(elementsOrVersion);
                    {
                        
                    result.directory = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.directory, 8, false);
        }
    }



    
    static final class FileSystemOpenPersistentFileSystemResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;

        private FileSystemOpenPersistentFileSystemResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public FileSystemOpenPersistentFileSystemResponseParams() {
            this(0);
        }

        public static FileSystemOpenPersistentFileSystemResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static FileSystemOpenPersistentFileSystemResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static FileSystemOpenPersistentFileSystemResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            FileSystemOpenPersistentFileSystemResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new FileSystemOpenPersistentFileSystemResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        com.vccorp.mojo_base.mojom.FileError.validate(result.error);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
        }
    }

    static class FileSystemOpenPersistentFileSystemResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final FileSystem.OpenPersistentFileSystemResponse mCallback;

        FileSystemOpenPersistentFileSystemResponseParamsForwardToCallback(FileSystem.OpenPersistentFileSystemResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(OPEN_PERSISTENT_FILE_SYSTEM_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                FileSystemOpenPersistentFileSystemResponseParams response = FileSystemOpenPersistentFileSystemResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class FileSystemOpenPersistentFileSystemResponseParamsProxyToResponder implements FileSystem.OpenPersistentFileSystemResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        FileSystemOpenPersistentFileSystemResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error) {
            FileSystemOpenPersistentFileSystemResponseParams _response = new FileSystemOpenPersistentFileSystemResponseParams();

            _response.error = error;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    OPEN_PERSISTENT_FILE_SYSTEM_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
