
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/device/public/mojom/bluetooth_system.mojom
//

package com.vccorp.device.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface BluetoothSystem extends com.vccorp.mojo.bindings.Interface {



    public static final class State {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int UNSUPPORTED = 0;
        public static final int UNAVAILABLE = 1; // UNSUPPORTED + 1
        public static final int POWERED_OFF = 2; // UNAVAILABLE + 1
        public static final int TRANSITIONING = 3; // POWERED_OFF + 1
        public static final int POWERED_ON = 4; // TRANSITIONING + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 4;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private State() {}
    }


    public static final class SetPoweredResult {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int SUCCESS = 0;
        public static final int FAILED_UNKNOWN_REASON = 1; // SUCCESS + 1
        public static final int FAILED_BLUETOOTH_UNAVAILABLE = 2; // FAILED_UNKNOWN_REASON + 1
        public static final int FAILED_IN_PROGRESS = 3; // FAILED_BLUETOOTH_UNAVAILABLE + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 3;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private SetPoweredResult() {}
    }


    public static final class ScanState {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int NOT_SCANNING = 0;
        public static final int TRANSITIONING = 1; // NOT_SCANNING + 1
        public static final int SCANNING = 2; // TRANSITIONING + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 2;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private ScanState() {}
    }


    public static final class StartScanResult {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int SUCCESS = 0;
        public static final int FAILED_UNKNOWN_REASON = 1; // SUCCESS + 1
        public static final int FAILED_BLUETOOTH_UNAVAILABLE = 2; // FAILED_UNKNOWN_REASON + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 2;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private StartScanResult() {}
    }


    public static final class StopScanResult {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int SUCCESS = 0;
        public static final int FAILED_UNKNOWN_REASON = 1; // SUCCESS + 1
        public static final int FAILED_BLUETOOTH_UNAVAILABLE = 2; // FAILED_UNKNOWN_REASON + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 2;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private StopScanResult() {}
    }


    public interface Proxy extends BluetoothSystem, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<BluetoothSystem, BluetoothSystem.Proxy> MANAGER = BluetoothSystem_Internal.MANAGER;


    void getState(

GetStateResponse callback);

    interface GetStateResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void setPowered(
boolean powered, 
SetPoweredResponse callback);

    interface SetPoweredResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void getScanState(

GetScanStateResponse callback);

    interface GetScanStateResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void startScan(

StartScanResponse callback);

    interface StartScanResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void stopScan(

StopScanResponse callback);

    interface StopScanResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void getAvailableDevices(

GetAvailableDevicesResponse callback);

    interface GetAvailableDevicesResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<BluetoothDeviceInfo[]> { }


}
