
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     components/content_settings/core/common/content_settings.mojom
//

package com.vccorp.content_settings.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class ContentSettingPatternSource extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public ContentSettingsPattern primaryPattern;
    public ContentSettingsPattern secondaryPattern;
    public com.vccorp.mojo_base.mojom.Value settingValue;
    public String source;
    public boolean incognito;

    private ContentSettingPatternSource(int version) {
        super(STRUCT_SIZE, version);
    }

    public ContentSettingPatternSource() {
        this(0);
    }

    public static ContentSettingPatternSource deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static ContentSettingPatternSource deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static ContentSettingPatternSource decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        ContentSettingPatternSource result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new ContentSettingPatternSource(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.primaryPattern = ContentSettingsPattern.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.secondaryPattern = ContentSettingsPattern.decode(decoder1);
                }
                {
                    
                result.settingValue = com.vccorp.mojo_base.mojom.Value.decode(decoder0, 24);
                }
                {
                    
                result.source = decoder0.readString(40, false);
                }
                {
                    
                result.incognito = decoder0.readBoolean(48, 0);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.primaryPattern, 8, false);
        
        encoder0.encode(this.secondaryPattern, 16, false);
        
        encoder0.encode(this.settingValue, 24, false);
        
        encoder0.encode(this.source, 40, false);
        
        encoder0.encode(this.incognito, 48, 0);
    }
}