
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/window_features/window_features.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class WindowFeatures extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 32;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public float x;
    public boolean hasX;
    public float y;
    public boolean hasY;
    public float width;
    public boolean hasWidth;
    public float height;
    public boolean hasHeight;
    public boolean menuBarVisible;
    public boolean statusBarVisible;
    public boolean toolBarVisible;
    public boolean scrollbarsVisible;

    private WindowFeatures(int version) {
        super(STRUCT_SIZE, version);
        this.hasX = (boolean) false;
        this.hasY = (boolean) false;
        this.hasWidth = (boolean) false;
        this.hasHeight = (boolean) false;
        this.menuBarVisible = (boolean) true;
        this.statusBarVisible = (boolean) true;
        this.toolBarVisible = (boolean) true;
        this.scrollbarsVisible = (boolean) true;
    }

    public WindowFeatures() {
        this(0);
    }

    public static WindowFeatures deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static WindowFeatures deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static WindowFeatures decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        WindowFeatures result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new WindowFeatures(elementsOrVersion);
                {
                    
                result.x = decoder0.readFloat(8);
                }
                {
                    
                result.hasX = decoder0.readBoolean(12, 0);
                }
                {
                    
                result.hasY = decoder0.readBoolean(12, 1);
                }
                {
                    
                result.hasWidth = decoder0.readBoolean(12, 2);
                }
                {
                    
                result.hasHeight = decoder0.readBoolean(12, 3);
                }
                {
                    
                result.menuBarVisible = decoder0.readBoolean(12, 4);
                }
                {
                    
                result.statusBarVisible = decoder0.readBoolean(12, 5);
                }
                {
                    
                result.toolBarVisible = decoder0.readBoolean(12, 6);
                }
                {
                    
                result.scrollbarsVisible = decoder0.readBoolean(12, 7);
                }
                {
                    
                result.y = decoder0.readFloat(16);
                }
                {
                    
                result.width = decoder0.readFloat(20);
                }
                {
                    
                result.height = decoder0.readFloat(24);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.x, 8);
        
        encoder0.encode(this.hasX, 12, 0);
        
        encoder0.encode(this.hasY, 12, 1);
        
        encoder0.encode(this.hasWidth, 12, 2);
        
        encoder0.encode(this.hasHeight, 12, 3);
        
        encoder0.encode(this.menuBarVisible, 12, 4);
        
        encoder0.encode(this.statusBarVisible, 12, 5);
        
        encoder0.encode(this.toolBarVisible, 12, 6);
        
        encoder0.encode(this.scrollbarsVisible, 12, 7);
        
        encoder0.encode(this.y, 16);
        
        encoder0.encode(this.width, 20);
        
        encoder0.encode(this.height, 24);
    }
}