
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/service_worker.mojom
//

package com.vccorp.blink.mojom;



class ServiceWorker_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ServiceWorker, ServiceWorker.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ServiceWorker, ServiceWorker.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.ServiceWorker";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ServiceWorker impl) {
            return new Stub(core, impl);
        }

        @Override
        public ServiceWorker[] buildArray(int size) {
          return new ServiceWorker[size];
        }
    };


    private static final int INITIALIZE_GLOBAL_SCOPE_ORDINAL = 0;

    private static final int DISPATCH_INSTALL_EVENT_ORDINAL = 1;

    private static final int DISPATCH_ACTIVATE_EVENT_ORDINAL = 2;

    private static final int DISPATCH_BACKGROUND_FETCH_ABORT_EVENT_ORDINAL = 3;

    private static final int DISPATCH_BACKGROUND_FETCH_CLICK_EVENT_ORDINAL = 4;

    private static final int DISPATCH_BACKGROUND_FETCH_FAIL_EVENT_ORDINAL = 5;

    private static final int DISPATCH_BACKGROUND_FETCH_SUCCESS_EVENT_ORDINAL = 6;

    private static final int DISPATCH_COOKIE_CHANGE_EVENT_ORDINAL = 7;

    private static final int DISPATCH_FETCH_EVENT_ORDINAL = 8;

    private static final int DISPATCH_NOTIFICATION_CLICK_EVENT_ORDINAL = 9;

    private static final int DISPATCH_NOTIFICATION_CLOSE_EVENT_ORDINAL = 10;

    private static final int DISPATCH_PUSH_EVENT_ORDINAL = 11;

    private static final int DISPATCH_SYNC_EVENT_ORDINAL = 12;

    private static final int DISPATCH_ABORT_PAYMENT_EVENT_ORDINAL = 13;

    private static final int DISPATCH_CAN_MAKE_PAYMENT_EVENT_ORDINAL = 14;

    private static final int DISPATCH_PAYMENT_REQUEST_EVENT_ORDINAL = 15;

    private static final int DISPATCH_EXTENDABLE_MESSAGE_EVENT_ORDINAL = 16;

    private static final int DISPATCH_EXTENDABLE_MESSAGE_EVENT_WITH_CUSTOM_TIMEOUT_ORDINAL = 17;

    private static final int PING_ORDINAL = 18;

    private static final int SET_IDLE_TIMER_DELAY_TO_ZERO_ORDINAL = 19;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ServiceWorker.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void initializeGlobalScope(
com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported serviceWorkerHost, ServiceWorkerRegistrationObjectInfo registrationInfo) {

            ServiceWorkerInitializeGlobalScopeParams _message = new ServiceWorkerInitializeGlobalScopeParams();

            _message.serviceWorkerHost = serviceWorkerHost;

            _message.registrationInfo = registrationInfo;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(INITIALIZE_GLOBAL_SCOPE_ORDINAL)));

        }


        @Override
        public void dispatchInstallEvent(

DispatchInstallEventResponse callback) {

            ServiceWorkerDispatchInstallEventParams _message = new ServiceWorkerDispatchInstallEventParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_INSTALL_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchInstallEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchActivateEvent(

DispatchActivateEventResponse callback) {

            ServiceWorkerDispatchActivateEventParams _message = new ServiceWorkerDispatchActivateEventParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_ACTIVATE_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchActivateEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchBackgroundFetchAbortEvent(
BackgroundFetchRegistration registration, 
DispatchBackgroundFetchAbortEventResponse callback) {

            ServiceWorkerDispatchBackgroundFetchAbortEventParams _message = new ServiceWorkerDispatchBackgroundFetchAbortEventParams();

            _message.registration = registration;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_BACKGROUND_FETCH_ABORT_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchBackgroundFetchAbortEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchBackgroundFetchClickEvent(
BackgroundFetchRegistration registration, 
DispatchBackgroundFetchClickEventResponse callback) {

            ServiceWorkerDispatchBackgroundFetchClickEventParams _message = new ServiceWorkerDispatchBackgroundFetchClickEventParams();

            _message.registration = registration;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_BACKGROUND_FETCH_CLICK_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchBackgroundFetchClickEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchBackgroundFetchFailEvent(
BackgroundFetchRegistration registration, 
DispatchBackgroundFetchFailEventResponse callback) {

            ServiceWorkerDispatchBackgroundFetchFailEventParams _message = new ServiceWorkerDispatchBackgroundFetchFailEventParams();

            _message.registration = registration;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_BACKGROUND_FETCH_FAIL_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchBackgroundFetchFailEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchBackgroundFetchSuccessEvent(
BackgroundFetchRegistration registration, 
DispatchBackgroundFetchSuccessEventResponse callback) {

            ServiceWorkerDispatchBackgroundFetchSuccessEventParams _message = new ServiceWorkerDispatchBackgroundFetchSuccessEventParams();

            _message.registration = registration;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_BACKGROUND_FETCH_SUCCESS_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchCookieChangeEvent(
com.vccorp.network.mojom.CanonicalCookie cookie, int cause,
DispatchCookieChangeEventResponse callback) {

            ServiceWorkerDispatchCookieChangeEventParams _message = new ServiceWorkerDispatchCookieChangeEventParams();

            _message.cookie = cookie;

            _message.cause = cause;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_COOKIE_CHANGE_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchCookieChangeEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchFetchEvent(
DispatchFetchEventParams params, ServiceWorkerFetchResponseCallback responseCallback, 
DispatchFetchEventResponse callback) {

            ServiceWorkerDispatchFetchEventParams _message = new ServiceWorkerDispatchFetchEventParams();

            _message.params = params;

            _message.responseCallback = responseCallback;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_FETCH_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchFetchEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchNotificationClickEvent(
String notificationId, NotificationData notificationData, int actionIndex, com.vccorp.mojo_base.mojom.String16 reply,
DispatchNotificationClickEventResponse callback) {

            ServiceWorkerDispatchNotificationClickEventParams _message = new ServiceWorkerDispatchNotificationClickEventParams();

            _message.notificationId = notificationId;

            _message.notificationData = notificationData;

            _message.actionIndex = actionIndex;

            _message.reply = reply;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_NOTIFICATION_CLICK_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchNotificationClickEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchNotificationCloseEvent(
String notificationId, NotificationData notificationData, 
DispatchNotificationCloseEventResponse callback) {

            ServiceWorkerDispatchNotificationCloseEventParams _message = new ServiceWorkerDispatchNotificationCloseEventParams();

            _message.notificationId = notificationId;

            _message.notificationData = notificationData;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_NOTIFICATION_CLOSE_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchNotificationCloseEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchPushEvent(
String payload, 
DispatchPushEventResponse callback) {

            ServiceWorkerDispatchPushEventParams _message = new ServiceWorkerDispatchPushEventParams();

            _message.payload = payload;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_PUSH_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchPushEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchSyncEvent(
String id, boolean lastChance, com.vccorp.mojo_base.mojom.TimeDelta timeout,
DispatchSyncEventResponse callback) {

            ServiceWorkerDispatchSyncEventParams _message = new ServiceWorkerDispatchSyncEventParams();

            _message.id = id;

            _message.lastChance = lastChance;

            _message.timeout = timeout;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_SYNC_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchSyncEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchAbortPaymentEvent(
com.vccorp.payments.mojom.PaymentHandlerResponseCallback resultOfAbortPayment,
DispatchAbortPaymentEventResponse callback) {

            ServiceWorkerDispatchAbortPaymentEventParams _message = new ServiceWorkerDispatchAbortPaymentEventParams();

            _message.resultOfAbortPayment = resultOfAbortPayment;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_ABORT_PAYMENT_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchAbortPaymentEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchCanMakePaymentEvent(
com.vccorp.payments.mojom.CanMakePaymentEventData eventData, com.vccorp.payments.mojom.PaymentHandlerResponseCallback resultOfCanMakePayment,
DispatchCanMakePaymentEventResponse callback) {

            ServiceWorkerDispatchCanMakePaymentEventParams _message = new ServiceWorkerDispatchCanMakePaymentEventParams();

            _message.eventData = eventData;

            _message.resultOfCanMakePayment = resultOfCanMakePayment;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_CAN_MAKE_PAYMENT_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchCanMakePaymentEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchPaymentRequestEvent(
com.vccorp.payments.mojom.PaymentRequestEventData requestData, com.vccorp.payments.mojom.PaymentHandlerResponseCallback responseCallback,
DispatchPaymentRequestEventResponse callback) {

            ServiceWorkerDispatchPaymentRequestEventParams _message = new ServiceWorkerDispatchPaymentRequestEventParams();

            _message.requestData = requestData;

            _message.responseCallback = responseCallback;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_PAYMENT_REQUEST_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchPaymentRequestEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchExtendableMessageEvent(
ExtendableMessageEvent event, 
DispatchExtendableMessageEventResponse callback) {

            ServiceWorkerDispatchExtendableMessageEventParams _message = new ServiceWorkerDispatchExtendableMessageEventParams();

            _message.event = event;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_EXTENDABLE_MESSAGE_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchExtendableMessageEventResponseParamsForwardToCallback(callback));

        }


        @Override
        public void dispatchExtendableMessageEventWithCustomTimeout(
ExtendableMessageEvent event, com.vccorp.mojo_base.mojom.TimeDelta timeout,
DispatchExtendableMessageEventWithCustomTimeoutResponse callback) {

            ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams _message = new ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams();

            _message.event = event;

            _message.timeout = timeout;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_EXTENDABLE_MESSAGE_EVENT_WITH_CUSTOM_TIMEOUT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParamsForwardToCallback(callback));

        }


        @Override
        public void ping(

PingResponse callback) {

            ServiceWorkerPingParams _message = new ServiceWorkerPingParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    PING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerPingResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setIdleTimerDelayToZero(
) {

            ServiceWorkerSetIdleTimerDelayToZeroParams _message = new ServiceWorkerSetIdleTimerDelayToZeroParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_IDLE_TIMER_DELAY_TO_ZERO_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ServiceWorker> {

        Stub(com.vccorp.mojo.system.Core core, ServiceWorker impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ServiceWorker_Internal.MANAGER, messageWithHeader);





                    case INITIALIZE_GLOBAL_SCOPE_ORDINAL: {

                        ServiceWorkerInitializeGlobalScopeParams data =
                                ServiceWorkerInitializeGlobalScopeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().initializeGlobalScope(data.serviceWorkerHost, data.registrationInfo);
                        return true;
                    }









































                    case SET_IDLE_TIMER_DELAY_TO_ZERO_ORDINAL: {

                        ServiceWorkerSetIdleTimerDelayToZeroParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setIdleTimerDelayToZero();
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ServiceWorker_Internal.MANAGER, messageWithHeader, receiver);









                    case DISPATCH_INSTALL_EVENT_ORDINAL: {

                        ServiceWorkerDispatchInstallEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchInstallEvent(new ServiceWorkerDispatchInstallEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_ACTIVATE_EVENT_ORDINAL: {

                        ServiceWorkerDispatchActivateEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchActivateEvent(new ServiceWorkerDispatchActivateEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_BACKGROUND_FETCH_ABORT_EVENT_ORDINAL: {

                        ServiceWorkerDispatchBackgroundFetchAbortEventParams data =
                                ServiceWorkerDispatchBackgroundFetchAbortEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchBackgroundFetchAbortEvent(data.registration, new ServiceWorkerDispatchBackgroundFetchAbortEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_BACKGROUND_FETCH_CLICK_EVENT_ORDINAL: {

                        ServiceWorkerDispatchBackgroundFetchClickEventParams data =
                                ServiceWorkerDispatchBackgroundFetchClickEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchBackgroundFetchClickEvent(data.registration, new ServiceWorkerDispatchBackgroundFetchClickEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_BACKGROUND_FETCH_FAIL_EVENT_ORDINAL: {

                        ServiceWorkerDispatchBackgroundFetchFailEventParams data =
                                ServiceWorkerDispatchBackgroundFetchFailEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchBackgroundFetchFailEvent(data.registration, new ServiceWorkerDispatchBackgroundFetchFailEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_BACKGROUND_FETCH_SUCCESS_EVENT_ORDINAL: {

                        ServiceWorkerDispatchBackgroundFetchSuccessEventParams data =
                                ServiceWorkerDispatchBackgroundFetchSuccessEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchBackgroundFetchSuccessEvent(data.registration, new ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_COOKIE_CHANGE_EVENT_ORDINAL: {

                        ServiceWorkerDispatchCookieChangeEventParams data =
                                ServiceWorkerDispatchCookieChangeEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchCookieChangeEvent(data.cookie, data.cause, new ServiceWorkerDispatchCookieChangeEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_FETCH_EVENT_ORDINAL: {

                        ServiceWorkerDispatchFetchEventParams data =
                                ServiceWorkerDispatchFetchEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchFetchEvent(data.params, data.responseCallback, new ServiceWorkerDispatchFetchEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_NOTIFICATION_CLICK_EVENT_ORDINAL: {

                        ServiceWorkerDispatchNotificationClickEventParams data =
                                ServiceWorkerDispatchNotificationClickEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchNotificationClickEvent(data.notificationId, data.notificationData, data.actionIndex, data.reply, new ServiceWorkerDispatchNotificationClickEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_NOTIFICATION_CLOSE_EVENT_ORDINAL: {

                        ServiceWorkerDispatchNotificationCloseEventParams data =
                                ServiceWorkerDispatchNotificationCloseEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchNotificationCloseEvent(data.notificationId, data.notificationData, new ServiceWorkerDispatchNotificationCloseEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_PUSH_EVENT_ORDINAL: {

                        ServiceWorkerDispatchPushEventParams data =
                                ServiceWorkerDispatchPushEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchPushEvent(data.payload, new ServiceWorkerDispatchPushEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_SYNC_EVENT_ORDINAL: {

                        ServiceWorkerDispatchSyncEventParams data =
                                ServiceWorkerDispatchSyncEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchSyncEvent(data.id, data.lastChance, data.timeout, new ServiceWorkerDispatchSyncEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_ABORT_PAYMENT_EVENT_ORDINAL: {

                        ServiceWorkerDispatchAbortPaymentEventParams data =
                                ServiceWorkerDispatchAbortPaymentEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchAbortPaymentEvent(data.resultOfAbortPayment, new ServiceWorkerDispatchAbortPaymentEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_CAN_MAKE_PAYMENT_EVENT_ORDINAL: {

                        ServiceWorkerDispatchCanMakePaymentEventParams data =
                                ServiceWorkerDispatchCanMakePaymentEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchCanMakePaymentEvent(data.eventData, data.resultOfCanMakePayment, new ServiceWorkerDispatchCanMakePaymentEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_PAYMENT_REQUEST_EVENT_ORDINAL: {

                        ServiceWorkerDispatchPaymentRequestEventParams data =
                                ServiceWorkerDispatchPaymentRequestEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchPaymentRequestEvent(data.requestData, data.responseCallback, new ServiceWorkerDispatchPaymentRequestEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_EXTENDABLE_MESSAGE_EVENT_ORDINAL: {

                        ServiceWorkerDispatchExtendableMessageEventParams data =
                                ServiceWorkerDispatchExtendableMessageEventParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchExtendableMessageEvent(data.event, new ServiceWorkerDispatchExtendableMessageEventResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DISPATCH_EXTENDABLE_MESSAGE_EVENT_WITH_CUSTOM_TIMEOUT_ORDINAL: {

                        ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams data =
                                ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchExtendableMessageEventWithCustomTimeout(data.event, data.timeout, new ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case PING_ORDINAL: {

                        ServiceWorkerPingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().ping(new ServiceWorkerPingResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ServiceWorkerInitializeGlobalScopeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported serviceWorkerHost;
        public ServiceWorkerRegistrationObjectInfo registrationInfo;

        private ServiceWorkerInitializeGlobalScopeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerInitializeGlobalScopeParams() {
            this(0);
        }

        public static ServiceWorkerInitializeGlobalScopeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerInitializeGlobalScopeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerInitializeGlobalScopeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerInitializeGlobalScopeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerInitializeGlobalScopeParams(elementsOrVersion);
                    {
                        
                    result.serviceWorkerHost = decoder0.readAssociatedServiceInterfaceNotSupported(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.registrationInfo = ServiceWorkerRegistrationObjectInfo.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.serviceWorkerHost, 8, false);
            
            encoder0.encode(this.registrationInfo, 16, false);
        }
    }



    
    static final class ServiceWorkerDispatchInstallEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ServiceWorkerDispatchInstallEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchInstallEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchInstallEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchInstallEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchInstallEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchInstallEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchInstallEventParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class ServiceWorkerDispatchInstallEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;
        public boolean hasFetchHandler;

        private ServiceWorkerDispatchInstallEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchInstallEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchInstallEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchInstallEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchInstallEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchInstallEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchInstallEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }
                    {
                        
                    result.hasFetchHandler = decoder0.readBoolean(12, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
            
            encoder0.encode(this.hasFetchHandler, 12, 0);
        }
    }

    static class ServiceWorkerDispatchInstallEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchInstallEventResponse mCallback;

        ServiceWorkerDispatchInstallEventResponseParamsForwardToCallback(ServiceWorker.DispatchInstallEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_INSTALL_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchInstallEventResponseParams response = ServiceWorkerDispatchInstallEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status, response.hasFetchHandler);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchInstallEventResponseParamsProxyToResponder implements ServiceWorker.DispatchInstallEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchInstallEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status, Boolean hasFetchHandler) {
            ServiceWorkerDispatchInstallEventResponseParams _response = new ServiceWorkerDispatchInstallEventResponseParams();

            _response.status = status;

            _response.hasFetchHandler = hasFetchHandler;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_INSTALL_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchActivateEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ServiceWorkerDispatchActivateEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchActivateEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchActivateEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchActivateEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchActivateEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchActivateEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchActivateEventParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class ServiceWorkerDispatchActivateEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchActivateEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchActivateEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchActivateEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchActivateEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchActivateEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchActivateEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchActivateEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchActivateEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchActivateEventResponse mCallback;

        ServiceWorkerDispatchActivateEventResponseParamsForwardToCallback(ServiceWorker.DispatchActivateEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_ACTIVATE_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchActivateEventResponseParams response = ServiceWorkerDispatchActivateEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchActivateEventResponseParamsProxyToResponder implements ServiceWorker.DispatchActivateEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchActivateEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchActivateEventResponseParams _response = new ServiceWorkerDispatchActivateEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_ACTIVATE_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchBackgroundFetchAbortEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public BackgroundFetchRegistration registration;

        private ServiceWorkerDispatchBackgroundFetchAbortEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchBackgroundFetchAbortEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchBackgroundFetchAbortEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchBackgroundFetchAbortEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchBackgroundFetchAbortEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchBackgroundFetchAbortEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchBackgroundFetchAbortEventParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.registration = BackgroundFetchRegistration.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.registration, 8, false);
        }
    }



    
    static final class ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchBackgroundFetchAbortEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchBackgroundFetchAbortEventResponse mCallback;

        ServiceWorkerDispatchBackgroundFetchAbortEventResponseParamsForwardToCallback(ServiceWorker.DispatchBackgroundFetchAbortEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_BACKGROUND_FETCH_ABORT_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams response = ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchBackgroundFetchAbortEventResponseParamsProxyToResponder implements ServiceWorker.DispatchBackgroundFetchAbortEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchBackgroundFetchAbortEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams _response = new ServiceWorkerDispatchBackgroundFetchAbortEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_BACKGROUND_FETCH_ABORT_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchBackgroundFetchClickEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public BackgroundFetchRegistration registration;

        private ServiceWorkerDispatchBackgroundFetchClickEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchBackgroundFetchClickEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchBackgroundFetchClickEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchBackgroundFetchClickEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchBackgroundFetchClickEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchBackgroundFetchClickEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchBackgroundFetchClickEventParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.registration = BackgroundFetchRegistration.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.registration, 8, false);
        }
    }



    
    static final class ServiceWorkerDispatchBackgroundFetchClickEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchBackgroundFetchClickEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchBackgroundFetchClickEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchBackgroundFetchClickEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchBackgroundFetchClickEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchBackgroundFetchClickEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchBackgroundFetchClickEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchBackgroundFetchClickEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchBackgroundFetchClickEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchBackgroundFetchClickEventResponse mCallback;

        ServiceWorkerDispatchBackgroundFetchClickEventResponseParamsForwardToCallback(ServiceWorker.DispatchBackgroundFetchClickEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_BACKGROUND_FETCH_CLICK_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchBackgroundFetchClickEventResponseParams response = ServiceWorkerDispatchBackgroundFetchClickEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchBackgroundFetchClickEventResponseParamsProxyToResponder implements ServiceWorker.DispatchBackgroundFetchClickEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchBackgroundFetchClickEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchBackgroundFetchClickEventResponseParams _response = new ServiceWorkerDispatchBackgroundFetchClickEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_BACKGROUND_FETCH_CLICK_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchBackgroundFetchFailEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public BackgroundFetchRegistration registration;

        private ServiceWorkerDispatchBackgroundFetchFailEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchBackgroundFetchFailEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchBackgroundFetchFailEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchBackgroundFetchFailEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchBackgroundFetchFailEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchBackgroundFetchFailEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchBackgroundFetchFailEventParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.registration = BackgroundFetchRegistration.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.registration, 8, false);
        }
    }



    
    static final class ServiceWorkerDispatchBackgroundFetchFailEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchBackgroundFetchFailEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchBackgroundFetchFailEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchBackgroundFetchFailEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchBackgroundFetchFailEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchBackgroundFetchFailEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchBackgroundFetchFailEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchBackgroundFetchFailEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchBackgroundFetchFailEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchBackgroundFetchFailEventResponse mCallback;

        ServiceWorkerDispatchBackgroundFetchFailEventResponseParamsForwardToCallback(ServiceWorker.DispatchBackgroundFetchFailEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_BACKGROUND_FETCH_FAIL_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchBackgroundFetchFailEventResponseParams response = ServiceWorkerDispatchBackgroundFetchFailEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchBackgroundFetchFailEventResponseParamsProxyToResponder implements ServiceWorker.DispatchBackgroundFetchFailEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchBackgroundFetchFailEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchBackgroundFetchFailEventResponseParams _response = new ServiceWorkerDispatchBackgroundFetchFailEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_BACKGROUND_FETCH_FAIL_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchBackgroundFetchSuccessEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public BackgroundFetchRegistration registration;

        private ServiceWorkerDispatchBackgroundFetchSuccessEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchBackgroundFetchSuccessEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchBackgroundFetchSuccessEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchBackgroundFetchSuccessEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchBackgroundFetchSuccessEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchBackgroundFetchSuccessEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchBackgroundFetchSuccessEventParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.registration = BackgroundFetchRegistration.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.registration, 8, false);
        }
    }



    
    static final class ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchBackgroundFetchSuccessEventResponse mCallback;

        ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParamsForwardToCallback(ServiceWorker.DispatchBackgroundFetchSuccessEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_BACKGROUND_FETCH_SUCCESS_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams response = ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParamsProxyToResponder implements ServiceWorker.DispatchBackgroundFetchSuccessEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams _response = new ServiceWorkerDispatchBackgroundFetchSuccessEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_BACKGROUND_FETCH_SUCCESS_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchCookieChangeEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.network.mojom.CanonicalCookie cookie;
        public int cause;

        private ServiceWorkerDispatchCookieChangeEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchCookieChangeEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchCookieChangeEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchCookieChangeEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchCookieChangeEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchCookieChangeEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchCookieChangeEventParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.cookie = com.vccorp.network.mojom.CanonicalCookie.decode(decoder1);
                    }
                    {
                        
                    result.cause = decoder0.readInt(16);
                        com.vccorp.network.mojom.CookieChangeCause.validate(result.cause);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.cookie, 8, false);
            
            encoder0.encode(this.cause, 16);
        }
    }



    
    static final class ServiceWorkerDispatchCookieChangeEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchCookieChangeEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchCookieChangeEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchCookieChangeEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchCookieChangeEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchCookieChangeEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchCookieChangeEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchCookieChangeEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchCookieChangeEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchCookieChangeEventResponse mCallback;

        ServiceWorkerDispatchCookieChangeEventResponseParamsForwardToCallback(ServiceWorker.DispatchCookieChangeEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_COOKIE_CHANGE_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchCookieChangeEventResponseParams response = ServiceWorkerDispatchCookieChangeEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchCookieChangeEventResponseParamsProxyToResponder implements ServiceWorker.DispatchCookieChangeEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchCookieChangeEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchCookieChangeEventResponseParams _response = new ServiceWorkerDispatchCookieChangeEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_COOKIE_CHANGE_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchFetchEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public DispatchFetchEventParams params;
        public ServiceWorkerFetchResponseCallback responseCallback;

        private ServiceWorkerDispatchFetchEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchFetchEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchFetchEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchFetchEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchFetchEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchFetchEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchFetchEventParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.params = DispatchFetchEventParams.decode(decoder1);
                    }
                    {
                        
                    result.responseCallback = decoder0.readServiceInterface(16, false, ServiceWorkerFetchResponseCallback.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.params, 8, false);
            
            encoder0.encode(this.responseCallback, 16, false, ServiceWorkerFetchResponseCallback.MANAGER);
        }
    }



    
    static final class ServiceWorkerDispatchFetchEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchFetchEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchFetchEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchFetchEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchFetchEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchFetchEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchFetchEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchFetchEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchFetchEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchFetchEventResponse mCallback;

        ServiceWorkerDispatchFetchEventResponseParamsForwardToCallback(ServiceWorker.DispatchFetchEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_FETCH_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchFetchEventResponseParams response = ServiceWorkerDispatchFetchEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchFetchEventResponseParamsProxyToResponder implements ServiceWorker.DispatchFetchEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchFetchEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchFetchEventResponseParams _response = new ServiceWorkerDispatchFetchEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_FETCH_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchNotificationClickEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String notificationId;
        public NotificationData notificationData;
        public int actionIndex;
        public com.vccorp.mojo_base.mojom.String16 reply;

        private ServiceWorkerDispatchNotificationClickEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchNotificationClickEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchNotificationClickEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchNotificationClickEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchNotificationClickEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchNotificationClickEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchNotificationClickEventParams(elementsOrVersion);
                    {
                        
                    result.notificationId = decoder0.readString(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.notificationData = NotificationData.decode(decoder1);
                    }
                    {
                        
                    result.actionIndex = decoder0.readInt(24);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, true);
                    result.reply = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.notificationId, 8, false);
            
            encoder0.encode(this.notificationData, 16, false);
            
            encoder0.encode(this.actionIndex, 24);
            
            encoder0.encode(this.reply, 32, true);
        }
    }



    
    static final class ServiceWorkerDispatchNotificationClickEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchNotificationClickEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchNotificationClickEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchNotificationClickEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchNotificationClickEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchNotificationClickEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchNotificationClickEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchNotificationClickEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchNotificationClickEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchNotificationClickEventResponse mCallback;

        ServiceWorkerDispatchNotificationClickEventResponseParamsForwardToCallback(ServiceWorker.DispatchNotificationClickEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_NOTIFICATION_CLICK_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchNotificationClickEventResponseParams response = ServiceWorkerDispatchNotificationClickEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchNotificationClickEventResponseParamsProxyToResponder implements ServiceWorker.DispatchNotificationClickEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchNotificationClickEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchNotificationClickEventResponseParams _response = new ServiceWorkerDispatchNotificationClickEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_NOTIFICATION_CLICK_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchNotificationCloseEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String notificationId;
        public NotificationData notificationData;

        private ServiceWorkerDispatchNotificationCloseEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchNotificationCloseEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchNotificationCloseEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchNotificationCloseEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchNotificationCloseEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchNotificationCloseEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchNotificationCloseEventParams(elementsOrVersion);
                    {
                        
                    result.notificationId = decoder0.readString(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.notificationData = NotificationData.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.notificationId, 8, false);
            
            encoder0.encode(this.notificationData, 16, false);
        }
    }



    
    static final class ServiceWorkerDispatchNotificationCloseEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchNotificationCloseEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchNotificationCloseEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchNotificationCloseEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchNotificationCloseEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchNotificationCloseEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchNotificationCloseEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchNotificationCloseEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchNotificationCloseEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchNotificationCloseEventResponse mCallback;

        ServiceWorkerDispatchNotificationCloseEventResponseParamsForwardToCallback(ServiceWorker.DispatchNotificationCloseEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_NOTIFICATION_CLOSE_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchNotificationCloseEventResponseParams response = ServiceWorkerDispatchNotificationCloseEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchNotificationCloseEventResponseParamsProxyToResponder implements ServiceWorker.DispatchNotificationCloseEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchNotificationCloseEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchNotificationCloseEventResponseParams _response = new ServiceWorkerDispatchNotificationCloseEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_NOTIFICATION_CLOSE_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchPushEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String payload;

        private ServiceWorkerDispatchPushEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchPushEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchPushEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchPushEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchPushEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchPushEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchPushEventParams(elementsOrVersion);
                    {
                        
                    result.payload = decoder0.readString(8, true);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.payload, 8, true);
        }
    }



    
    static final class ServiceWorkerDispatchPushEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchPushEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchPushEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchPushEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchPushEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchPushEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchPushEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchPushEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchPushEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchPushEventResponse mCallback;

        ServiceWorkerDispatchPushEventResponseParamsForwardToCallback(ServiceWorker.DispatchPushEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_PUSH_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchPushEventResponseParams response = ServiceWorkerDispatchPushEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchPushEventResponseParamsProxyToResponder implements ServiceWorker.DispatchPushEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchPushEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchPushEventResponseParams _response = new ServiceWorkerDispatchPushEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_PUSH_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchSyncEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String id;
        public boolean lastChance;
        public com.vccorp.mojo_base.mojom.TimeDelta timeout;

        private ServiceWorkerDispatchSyncEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchSyncEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchSyncEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchSyncEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchSyncEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchSyncEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchSyncEventParams(elementsOrVersion);
                    {
                        
                    result.id = decoder0.readString(8, false);
                    }
                    {
                        
                    result.lastChance = decoder0.readBoolean(16, 0);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.timeout = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.id, 8, false);
            
            encoder0.encode(this.lastChance, 16, 0);
            
            encoder0.encode(this.timeout, 24, false);
        }
    }



    
    static final class ServiceWorkerDispatchSyncEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchSyncEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchSyncEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchSyncEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchSyncEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchSyncEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchSyncEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchSyncEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchSyncEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchSyncEventResponse mCallback;

        ServiceWorkerDispatchSyncEventResponseParamsForwardToCallback(ServiceWorker.DispatchSyncEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_SYNC_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchSyncEventResponseParams response = ServiceWorkerDispatchSyncEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchSyncEventResponseParamsProxyToResponder implements ServiceWorker.DispatchSyncEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchSyncEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchSyncEventResponseParams _response = new ServiceWorkerDispatchSyncEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_SYNC_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchAbortPaymentEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.payments.mojom.PaymentHandlerResponseCallback resultOfAbortPayment;

        private ServiceWorkerDispatchAbortPaymentEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchAbortPaymentEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchAbortPaymentEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchAbortPaymentEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchAbortPaymentEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchAbortPaymentEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchAbortPaymentEventParams(elementsOrVersion);
                    {
                        
                    result.resultOfAbortPayment = decoder0.readServiceInterface(8, false, com.vccorp.payments.mojom.PaymentHandlerResponseCallback.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.resultOfAbortPayment, 8, false, com.vccorp.payments.mojom.PaymentHandlerResponseCallback.MANAGER);
        }
    }



    
    static final class ServiceWorkerDispatchAbortPaymentEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchAbortPaymentEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchAbortPaymentEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchAbortPaymentEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchAbortPaymentEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchAbortPaymentEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchAbortPaymentEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchAbortPaymentEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchAbortPaymentEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchAbortPaymentEventResponse mCallback;

        ServiceWorkerDispatchAbortPaymentEventResponseParamsForwardToCallback(ServiceWorker.DispatchAbortPaymentEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_ABORT_PAYMENT_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchAbortPaymentEventResponseParams response = ServiceWorkerDispatchAbortPaymentEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchAbortPaymentEventResponseParamsProxyToResponder implements ServiceWorker.DispatchAbortPaymentEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchAbortPaymentEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchAbortPaymentEventResponseParams _response = new ServiceWorkerDispatchAbortPaymentEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_ABORT_PAYMENT_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchCanMakePaymentEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.payments.mojom.CanMakePaymentEventData eventData;
        public com.vccorp.payments.mojom.PaymentHandlerResponseCallback resultOfCanMakePayment;

        private ServiceWorkerDispatchCanMakePaymentEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchCanMakePaymentEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchCanMakePaymentEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchCanMakePaymentEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchCanMakePaymentEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchCanMakePaymentEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchCanMakePaymentEventParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.eventData = com.vccorp.payments.mojom.CanMakePaymentEventData.decode(decoder1);
                    }
                    {
                        
                    result.resultOfCanMakePayment = decoder0.readServiceInterface(16, false, com.vccorp.payments.mojom.PaymentHandlerResponseCallback.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.eventData, 8, false);
            
            encoder0.encode(this.resultOfCanMakePayment, 16, false, com.vccorp.payments.mojom.PaymentHandlerResponseCallback.MANAGER);
        }
    }



    
    static final class ServiceWorkerDispatchCanMakePaymentEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchCanMakePaymentEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchCanMakePaymentEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchCanMakePaymentEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchCanMakePaymentEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchCanMakePaymentEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchCanMakePaymentEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchCanMakePaymentEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchCanMakePaymentEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchCanMakePaymentEventResponse mCallback;

        ServiceWorkerDispatchCanMakePaymentEventResponseParamsForwardToCallback(ServiceWorker.DispatchCanMakePaymentEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_CAN_MAKE_PAYMENT_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchCanMakePaymentEventResponseParams response = ServiceWorkerDispatchCanMakePaymentEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchCanMakePaymentEventResponseParamsProxyToResponder implements ServiceWorker.DispatchCanMakePaymentEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchCanMakePaymentEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchCanMakePaymentEventResponseParams _response = new ServiceWorkerDispatchCanMakePaymentEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_CAN_MAKE_PAYMENT_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchPaymentRequestEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.payments.mojom.PaymentRequestEventData requestData;
        public com.vccorp.payments.mojom.PaymentHandlerResponseCallback responseCallback;

        private ServiceWorkerDispatchPaymentRequestEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchPaymentRequestEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchPaymentRequestEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchPaymentRequestEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchPaymentRequestEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchPaymentRequestEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchPaymentRequestEventParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.requestData = com.vccorp.payments.mojom.PaymentRequestEventData.decode(decoder1);
                    }
                    {
                        
                    result.responseCallback = decoder0.readServiceInterface(16, false, com.vccorp.payments.mojom.PaymentHandlerResponseCallback.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.requestData, 8, false);
            
            encoder0.encode(this.responseCallback, 16, false, com.vccorp.payments.mojom.PaymentHandlerResponseCallback.MANAGER);
        }
    }



    
    static final class ServiceWorkerDispatchPaymentRequestEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchPaymentRequestEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchPaymentRequestEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchPaymentRequestEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchPaymentRequestEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchPaymentRequestEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchPaymentRequestEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchPaymentRequestEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchPaymentRequestEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchPaymentRequestEventResponse mCallback;

        ServiceWorkerDispatchPaymentRequestEventResponseParamsForwardToCallback(ServiceWorker.DispatchPaymentRequestEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_PAYMENT_REQUEST_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchPaymentRequestEventResponseParams response = ServiceWorkerDispatchPaymentRequestEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchPaymentRequestEventResponseParamsProxyToResponder implements ServiceWorker.DispatchPaymentRequestEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchPaymentRequestEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchPaymentRequestEventResponseParams _response = new ServiceWorkerDispatchPaymentRequestEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_PAYMENT_REQUEST_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchExtendableMessageEventParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ExtendableMessageEvent event;

        private ServiceWorkerDispatchExtendableMessageEventParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchExtendableMessageEventParams() {
            this(0);
        }

        public static ServiceWorkerDispatchExtendableMessageEventParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchExtendableMessageEventParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchExtendableMessageEventParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchExtendableMessageEventParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchExtendableMessageEventParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.event = ExtendableMessageEvent.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.event, 8, false);
        }
    }



    
    static final class ServiceWorkerDispatchExtendableMessageEventResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchExtendableMessageEventResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchExtendableMessageEventResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchExtendableMessageEventResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchExtendableMessageEventResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchExtendableMessageEventResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchExtendableMessageEventResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchExtendableMessageEventResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchExtendableMessageEventResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchExtendableMessageEventResponse mCallback;

        ServiceWorkerDispatchExtendableMessageEventResponseParamsForwardToCallback(ServiceWorker.DispatchExtendableMessageEventResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_EXTENDABLE_MESSAGE_EVENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchExtendableMessageEventResponseParams response = ServiceWorkerDispatchExtendableMessageEventResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchExtendableMessageEventResponseParamsProxyToResponder implements ServiceWorker.DispatchExtendableMessageEventResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchExtendableMessageEventResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchExtendableMessageEventResponseParams _response = new ServiceWorkerDispatchExtendableMessageEventResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_EXTENDABLE_MESSAGE_EVENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ExtendableMessageEvent event;
        public com.vccorp.mojo_base.mojom.TimeDelta timeout;

        private ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams() {
            this(0);
        }

        public static ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.event = ExtendableMessageEvent.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.timeout = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.event, 8, false);
            
            encoder0.encode(this.timeout, 16, false);
        }
    }



    
    static final class ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams() {
            this(0);
        }

        public static ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerEventStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.DispatchExtendableMessageEventWithCustomTimeoutResponse mCallback;

        ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParamsForwardToCallback(ServiceWorker.DispatchExtendableMessageEventWithCustomTimeoutResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPATCH_EXTENDABLE_MESSAGE_EVENT_WITH_CUSTOM_TIMEOUT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams response = ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParamsProxyToResponder implements ServiceWorker.DispatchExtendableMessageEventWithCustomTimeoutResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams _response = new ServiceWorkerDispatchExtendableMessageEventWithCustomTimeoutResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPATCH_EXTENDABLE_MESSAGE_EVENT_WITH_CUSTOM_TIMEOUT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerPingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ServiceWorkerPingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerPingParams() {
            this(0);
        }

        public static ServiceWorkerPingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerPingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerPingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerPingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerPingParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class ServiceWorkerPingResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ServiceWorkerPingResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerPingResponseParams() {
            this(0);
        }

        public static ServiceWorkerPingResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerPingResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerPingResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerPingResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerPingResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class ServiceWorkerPingResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorker.PingResponse mCallback;

        ServiceWorkerPingResponseParamsForwardToCallback(ServiceWorker.PingResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(PING_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerPingResponseParamsProxyToResponder implements ServiceWorker.PingResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerPingResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            ServiceWorkerPingResponseParams _response = new ServiceWorkerPingResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    PING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerSetIdleTimerDelayToZeroParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ServiceWorkerSetIdleTimerDelayToZeroParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerSetIdleTimerDelayToZeroParams() {
            this(0);
        }

        public static ServiceWorkerSetIdleTimerDelayToZeroParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerSetIdleTimerDelayToZeroParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerSetIdleTimerDelayToZeroParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerSetIdleTimerDelayToZeroParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerSetIdleTimerDelayToZeroParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



}
