
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/service_worker_provider.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class ServiceWorkerProviderInfoForStartWorker extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported hostPtrInfo;
    public com.vccorp.mojo.bindings.AssociatedInterfaceRequestNotSupported clientRequest;
    public com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported scriptLoaderFactoryPtrInfo;
    public CacheStorage cacheStorage;
    public com.vccorp.service_manager.mojom.InterfaceProvider interfaceProvider;

    private ServiceWorkerProviderInfoForStartWorker(int version) {
        super(STRUCT_SIZE, version);
    }

    public ServiceWorkerProviderInfoForStartWorker() {
        this(0);
    }

    public static ServiceWorkerProviderInfoForStartWorker deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static ServiceWorkerProviderInfoForStartWorker deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static ServiceWorkerProviderInfoForStartWorker decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        ServiceWorkerProviderInfoForStartWorker result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new ServiceWorkerProviderInfoForStartWorker(elementsOrVersion);
                {
                    
                result.hostPtrInfo = decoder0.readAssociatedServiceInterfaceNotSupported(8, false);
                }
                {
                    
                result.clientRequest = decoder0.readAssociatedInterfaceRequestNotSupported(16, false);
                }
                {
                    
                result.scriptLoaderFactoryPtrInfo = decoder0.readAssociatedServiceInterfaceNotSupported(20, true);
                }
                {
                    
                result.cacheStorage = decoder0.readServiceInterface(28, true, CacheStorage.MANAGER);
                }
                {
                    
                result.interfaceProvider = decoder0.readServiceInterface(36, false, com.vccorp.service_manager.mojom.InterfaceProvider.MANAGER);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.hostPtrInfo, 8, false);
        
        encoder0.encode(this.clientRequest, 16, false);
        
        encoder0.encode(this.scriptLoaderFactoryPtrInfo, 20, true);
        
        encoder0.encode(this.cacheStorage, 28, true, CacheStorage.MANAGER);
        
        encoder0.encode(this.interfaceProvider, 36, false, com.vccorp.service_manager.mojom.InterfaceProvider.MANAGER);
    }
}