
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/frame/navigation_initiator.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class CspViolationParams extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 72;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(72, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String directive;
    public String effectiveDirective;
    public String consoleMessage;
    public String blockedUrl;
    public String[] reportEndpoints;
    public boolean useReportingApi;
    public String header;
    public int disposition;
    public boolean afterRedirect;
    public SourceLocation sourceLocation;

    private CspViolationParams(int version) {
        super(STRUCT_SIZE, version);
    }

    public CspViolationParams() {
        this(0);
    }

    public static CspViolationParams deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static CspViolationParams deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static CspViolationParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        CspViolationParams result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new CspViolationParams(elementsOrVersion);
                {
                    
                result.directive = decoder0.readString(8, false);
                }
                {
                    
                result.effectiveDirective = decoder0.readString(16, false);
                }
                {
                    
                result.consoleMessage = decoder0.readString(24, false);
                }
                {
                    
                result.blockedUrl = decoder0.readString(32, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.reportEndpoints = new String[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        result.reportEndpoints[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
                }
                {
                    
                result.useReportingApi = decoder0.readBoolean(48, 0);
                }
                {
                    
                result.afterRedirect = decoder0.readBoolean(48, 1);
                }
                {
                    
                result.disposition = decoder0.readInt(52);
                    WebContentSecurityPolicyType.validate(result.disposition);
                }
                {
                    
                result.header = decoder0.readString(56, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, false);
                result.sourceLocation = SourceLocation.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.directive, 8, false);
        
        encoder0.encode(this.effectiveDirective, 16, false);
        
        encoder0.encode(this.consoleMessage, 24, false);
        
        encoder0.encode(this.blockedUrl, 32, false);
        
        if (this.reportEndpoints == null) {
            encoder0.encodeNullPointer(40, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.reportEndpoints.length, 40, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.reportEndpoints.length; ++i0) {
                
                encoder1.encode(this.reportEndpoints[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.useReportingApi, 48, 0);
        
        encoder0.encode(this.afterRedirect, 48, 1);
        
        encoder0.encode(this.disposition, 52);
        
        encoder0.encode(this.header, 56, false);
        
        encoder0.encode(this.sourceLocation, 64, false);
    }
}