
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/appcache/appcache_info.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class AppCacheInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 80;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(80, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.url.mojom.Url manifestUrl;
    public com.vccorp.mojo_base.mojom.Time creationTime;
    public com.vccorp.mojo_base.mojom.Time lastUpdateTime;
    public com.vccorp.mojo_base.mojom.Time lastAccessTime;
    public long cacheId;
    public long groupId;
    public int status;
    public long responseSizes;
    public long paddingSizes;
    public boolean isComplete;

    private AppCacheInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public AppCacheInfo() {
        this(0);
    }

    public static AppCacheInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static AppCacheInfo deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static AppCacheInfo decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        AppCacheInfo result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new AppCacheInfo(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.manifestUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.creationTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.lastUpdateTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.lastAccessTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                }
                {
                    
                result.cacheId = decoder0.readLong(40);
                }
                {
                    
                result.groupId = decoder0.readLong(48);
                }
                {
                    
                result.status = decoder0.readInt(56);
                    AppCacheStatus.validate(result.status);
                }
                {
                    
                result.isComplete = decoder0.readBoolean(60, 0);
                }
                {
                    
                result.responseSizes = decoder0.readLong(64);
                }
                {
                    
                result.paddingSizes = decoder0.readLong(72);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.manifestUrl, 8, false);
        
        encoder0.encode(this.creationTime, 16, false);
        
        encoder0.encode(this.lastUpdateTime, 24, false);
        
        encoder0.encode(this.lastAccessTime, 32, false);
        
        encoder0.encode(this.cacheId, 40);
        
        encoder0.encode(this.groupId, 48);
        
        encoder0.encode(this.status, 56);
        
        encoder0.encode(this.isComplete, 60, 0);
        
        encoder0.encode(this.responseSizes, 64);
        
        encoder0.encode(this.paddingSizes, 72);
    }
}