
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/loader/navigation_predictor.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class AnchorElementMetricsHost_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<AnchorElementMetricsHost, AnchorElementMetricsHost.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<AnchorElementMetricsHost, AnchorElementMetricsHost.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.AnchorElementMetricsHost";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, AnchorElementMetricsHost impl) {
            return new Stub(core, impl);
        }

        @Override
        public AnchorElementMetricsHost[] buildArray(int size) {
          return new AnchorElementMetricsHost[size];
        }
    };


    private static final int REPORT_ANCHOR_ELEMENT_METRICS_ON_CLICK_ORDINAL = 0;

    private static final int REPORT_ANCHOR_ELEMENT_METRICS_ON_LOAD_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements AnchorElementMetricsHost.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void reportAnchorElementMetricsOnClick(
AnchorElementMetrics metrics) {

            AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams _message = new AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams();

            _message.metrics = metrics;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REPORT_ANCHOR_ELEMENT_METRICS_ON_CLICK_ORDINAL)));

        }


        @Override
        public void reportAnchorElementMetricsOnLoad(
AnchorElementMetrics[] metrics) {

            AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams _message = new AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams();

            _message.metrics = metrics;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REPORT_ANCHOR_ELEMENT_METRICS_ON_LOAD_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<AnchorElementMetricsHost> {

        Stub(com.vccorp.mojo.system.Core core, AnchorElementMetricsHost impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                AnchorElementMetricsHost_Internal.MANAGER, messageWithHeader);





                    case REPORT_ANCHOR_ELEMENT_METRICS_ON_CLICK_ORDINAL: {

                        AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams data =
                                AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams.deserialize(messageWithHeader.getPayload());

                        getImpl().reportAnchorElementMetricsOnClick(data.metrics);
                        return true;
                    }





                    case REPORT_ANCHOR_ELEMENT_METRICS_ON_LOAD_ORDINAL: {

                        AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams data =
                                AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams.deserialize(messageWithHeader.getPayload());

                        getImpl().reportAnchorElementMetricsOnLoad(data.metrics);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), AnchorElementMetricsHost_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public AnchorElementMetrics metrics;

        private AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams() {
            this(0);
        }

        public static AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AnchorElementMetricsHostReportAnchorElementMetricsOnClickParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.metrics = AnchorElementMetrics.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.metrics, 8, false);
        }
    }



    
    static final class AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public AnchorElementMetrics[] metrics;

        private AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams() {
            this(0);
        }

        public static AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AnchorElementMetricsHostReportAnchorElementMetricsOnLoadParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.metrics = new AnchorElementMetrics[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.metrics[i1] = AnchorElementMetrics.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.metrics == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.metrics.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.metrics.length; ++i0) {
                    
                    encoder1.encode(this.metrics[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



}
