/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources;

import a.b.p.p.a;
import a.b.p.p.b;
import a.b.p.p.d;
import a.b.p.p.g.c;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.util.SparseArray;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.ui.base.WindowAndroid;
import org.chromium.ui.resources.ResourceFactory;

@JNINamespace(value="ui")
@MainDex
public class ResourceManager
implements d.a {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final SparseArray<d> mResourceLoaders;
    public final SparseArray<SparseArray<a>> mLoadedResources;
    public final float mPxToDp;
    public long mNativeResourceManagerPtr;

    public ResourceManager(Resources resources, int n2, long l2) {
        ResourceManager resourceManager = this;
        this.mResourceLoaders = new SparseArray();
        this.mLoadedResources = new SparseArray();
        resourceManager.mPxToDp = 1.0f / resources.getDisplayMetrics().density;
        resourceManager.registerResourceLoader(new c(0, (d.a)this, resources));
        resourceManager.registerResourceLoader(new a.b.p.p.f.b(1, this));
        resourceManager.registerResourceLoader(new a.b.p.p.f.b(2, this));
        resourceManager.registerResourceLoader(new a.b.p.p.h.a(3, (d.a)this, n2));
        this.mNativeResourceManagerPtr = l2;
    }

    public static ResourceManager create(WindowAndroid windowAndroid, long l2) {
        Context context = (Context)windowAndroid.getContext().get();
        if (context != null) {
            windowAndroid = windowAndroid.getDisplay().c;
            int n2 = Math.min(((Point)windowAndroid).x, ((Point)windowAndroid).y);
            context = context.getResources();
            return new ResourceManager((Resources)context, n2, l2);
        }
        throw new IllegalStateException("Context should not be null during initialization.");
    }

    private void saveMetadataForLoadedResource(int n2, int n3, b b2) {
        SparseArray sparseArray = (SparseArray)this.mLoadedResources.get(n2);
        if (sparseArray == null) {
            SparseArray sparseArray2;
            sparseArray = sparseArray2;
            sparseArray2 = new SparseArray();
            this.mLoadedResources.put(n2, (Object)sparseArray);
        }
        sparseArray.put(n3, (Object)new a(this.mPxToDp, b2));
    }

    private void destroy() {
        if (!$assertionsDisabled && this.mNativeResourceManagerPtr == 0L) {
            throw new AssertionError();
        }
        this.mNativeResourceManagerPtr = 0L;
    }

    private void resourceRequested(int n2, int n3) {
        d d2 = (d)((ResourceManager)((Object)d2)).mResourceLoaders.get(n2);
        if (d2 != null) {
            d2.a(n3);
        }
    }

    private void preloadResource(int n2, int n3) {
        d d2 = (d)((ResourceManager)((Object)d2)).mResourceLoaders.get(n2);
        if (d2 != null) {
            d2.b(n3);
        }
    }

    private long getNativePtr() {
        return this.mNativeResourceManagerPtr;
    }

    private void registerResourceLoader(d d2) {
        this.mResourceLoaders.put(d2.a, (Object)d2);
    }

    private native void nativeOnResourceReady(long var1, int var3, int var4, Bitmap var5, long var6);

    private native void nativeRemoveResource(long var1, int var3, int var4);

    private native void nativeClearTintedResourceCache(long var1);

    static {
        $assertionsDisabled = ResourceManager.class.desiredAssertionStatus() ^ true;
    }

    public a.b.p.p.f.b getDynamicResourceLoader() {
        return (a.b.p.p.f.b)this.mResourceLoaders.get(1);
    }

    public a.b.p.p.f.b getBitmapDynamicResourceLoader() {
        return (a.b.p.p.f.b)this.mResourceLoaders.get(2);
    }

    public void preloadResources(int n2, int[] nArray, int[] nArray2) {
        d d2 = (d)((ResourceManager)((Object)d2)).mResourceLoaders.get(n2);
        if (nArray2 != null) {
            n2 = nArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                d2.b(nArray2[i2]);
            }
        }
        if (nArray != null) {
            n2 = nArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                d2.a(nArray[i3]);
            }
        }
    }

    public a getResource(int n2, int n3) {
        ResourceManager resourceManager = (SparseArray)resourceManager.mLoadedResources.get(n2);
        return resourceManager != null ? (a)resourceManager.get(n3) : null;
    }

    @Override
    public void onResourceLoaded(int n2, int n3, b b2) {
        if (b2 != null) {
            a.b.p.p.g.b b3 = (a.b.p.p.g.b)b2;
            if (b3.a != null) {
                ResourceManager resourceManager = this;
                resourceManager.saveMetadataForLoadedResource(n2, n3, b2);
                long l2 = resourceManager.mNativeResourceManagerPtr;
                if (l2 == 0L) {
                    return;
                }
                this.nativeOnResourceReady(l2, n2, n3, b3.a, ResourceFactory.createBitmapResource(b3.b));
                return;
            }
        }
    }

    public void onResourceUnregistered(int n2, int n3) {
        if (n2 != 2) {
            return;
        }
        ResourceManager resourceManager = this;
        resourceManager.nativeRemoveResource(resourceManager.mNativeResourceManagerPtr, n2, n3);
    }

    public void clearTintedResourceCache() {
        long l2 = this.mNativeResourceManagerPtr;
        if (l2 == 0L) {
            return;
        }
        this.nativeClearTintedResourceCache(l2);
    }
}

