/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import java.util.Locale;
import org.chromium.base.ContextUtils;
import org.chromium.base.LocaleUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="l10n_util")
public class LocalizationUtils {
    public static final int UNKNOWN_DIRECTION = 0;
    public static final int RIGHT_TO_LEFT = 1;
    public static final int LEFT_TO_RIGHT = 2;
    public static Boolean sIsLayoutRtl;
    public static final /* synthetic */ boolean $assertionsDisabled;

    public static Locale getJavaLocale(String string2, String string3, String string4) {
        return new Locale(string2, string3, string4);
    }

    public static String getDisplayNameForLocale(Locale locale, Locale locale2) {
        return locale.getDisplayName(locale2);
    }

    public static boolean isLayoutRtl() {
        if (sIsLayoutRtl == null) {
            sIsLayoutRtl = ContextUtils.getApplicationContext().getResources().getConfiguration().getLayoutDirection() == 1;
        }
        return sIsLayoutRtl;
    }

    public static void setRtlForTesting(boolean bl) {
        sIsLayoutRtl = bl;
    }

    public static int getFirstStrongCharacterDirection(String string2) {
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        return LocalizationUtils.nativeGetFirstStrongCharacterDirection(string2);
    }

    public static String substituteLocalePlaceholder(String string2) {
        return string2.replace("$LOCALE", LocaleUtils.getDefaultLocaleString().replace('-', '_'));
    }

    public static String getSplitLanguageForAndroid(String string2) {
        int n2 = -1;
        int n3 = string2.hashCode();
        if (n3 != 3325) {
            if (n3 != 3355) {
                if (n3 != 3856) {
                    if (n3 == 101385 && string2.equals("fil")) {
                        n2 = 3;
                    }
                } else if (string2.equals("yi")) {
                    n2 = 1;
                }
            } else if (string2.equals("id")) {
                n2 = 2;
            }
        } else if (string2.equals("he")) {
            n2 = 0;
        }
        switch (n2) {
            default: {
                return string2;
            }
            case 3: {
                return "tl";
            }
            case 2: {
                return "in";
            }
            case 1: {
                return "ji";
            }
            case 0: 
        }
        return "iw";
    }

    public static String getDefaultCompressedPakLocaleForLanguage(String string2) {
        int n2 = -1;
        int n3 = string2.hashCode();
        if (n3 != 3241) {
            if (n3 != 3588) {
                if (n3 == 3886 && string2.equals("zh")) {
                    n2 = 2;
                }
            } else if (string2.equals("pt")) {
                n2 = 1;
            }
        } else if (string2.equals("en")) {
            n2 = 0;
        }
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return string2;
                }
                return "zh-CN";
            }
            return "pt-PT";
        }
        return "en-US";
    }

    public static boolean chromiumLocaleMatchesLanguage(String string2, String string3) {
        return LocaleUtils.toLanguage(string2).equals(string3);
    }

    public static native int nativeGetFirstStrongCharacterDirection(String var0);

    static {
        $assertionsDisabled = LocalizationUtils.class.desiredAssertionStatus() ^ true;
    }
}

