/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.a.a.a.a;
import a.b.a.g;
import android.annotation.TargetApi;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import android.util.SparseIntArray;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.chromium.base.ContextUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.media.PhotoCapabilities;
import org.chromium.media.VideoCapture;
import org.chromium.media.VideoCaptureFormat;

@JNINamespace(value="media")
@TargetApi(value=23)
public class VideoCaptureCamera2
extends VideoCapture {
    public static final double kNanosecondsPerSecond = 1.0E9;
    public static final long kNanosecondsPer100Microsecond = 100000L;
    public static final String TAG = "VideoCapture";
    public static final String[] AE_TARGET_FPS_RANGE_BUGGY_DEVICE_LIST;
    public static final SparseIntArray COLOR_TEMPERATURES_MAP;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final Object mCameraStateLock;
    public CameraDevice mCameraDevice;
    public CameraCaptureSession mPreviewSession;
    public CaptureRequest mPreviewRequest;
    public CaptureRequest.Builder mPreviewRequestBuilder;
    public ImageReader mImageReader;
    public Handler mCameraThreadHandler;
    public ConditionVariable mWaitForDeviceClosedConditionVariable;
    public Range<Integer> mAeFpsRange;
    public int mCameraState;
    public float mMaxZoom;
    public Rect mCropRect;
    public int mPhotoWidth;
    public int mPhotoHeight;
    public int mFocusMode;
    public float mCurrentFocusDistance;
    public int mExposureMode;
    public long mLastExposureTimeNs;
    public MeteringRectangle mAreaOfInterest;
    public int mExposureCompensation;
    public int mWhiteBalanceMode;
    public int mColorTemperature;
    public int mIso;
    public boolean mRedEyeReduction;
    public int mFillLightMode;
    public boolean mTorch;
    public boolean mEnableFaceDetection;

    /*
     * WARNING - void declaration
     */
    public static CameraCharacteristics getCameraCharacteristics(int n2) {
        void var0_4;
        try {
            return ((CameraManager)ContextUtils.getApplicationContext().getSystemService("camera")).getCameraCharacteristics(Integer.toString(n2));
        }
        catch (AssertionError assertionError) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (CameraAccessException cameraAccessException) {
            // empty catch block
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = var0_4;
        g.b(TAG, "getCameraCharacteristics: ", objectArray2);
        return null;
    }

    private void createPreviewObjectsAndStartPreviewOrFailWith(int n2) {
        if (!$assertionsDisabled && this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
            throw new AssertionError((Object)"called on wrong thread");
        }
        if (this.createPreviewObjectsAndStartPreview()) {
            return;
        }
        VideoCaptureCamera2 videoCaptureCamera2 = this;
        videoCaptureCamera2.changeCameraStateAndNotify(3);
        videoCaptureCamera2.nativeOnError(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid, n2, "Error starting or restarting preview");
    }

    /*
     * Unable to fully structure code
     */
    private boolean createPreviewObjectsAndStartPreview() {
        block32: {
            if (!VideoCaptureCamera2.$assertionsDisabled && this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            if (this.mCameraDevice == null) {
                return false;
            }
            v0 = this;
            var1_12 = TraceEvent.scoped("VideoCaptureCamera2.createPreviewObjectsAndStartPreview");
            v0.mImageReader = ImageReader.newInstance((int)v0.mCaptureFormat.getWidth(), (int)this.mCaptureFormat.getHeight(), (int)this.mCaptureFormat.getPixelFormat(), (int)2);
            var2_13 = v1;
            v1 = new CrPreviewReaderListener(null);
            v0.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)var2_13, this.mCameraThreadHandler);
            v0.mPreviewRequestBuilder = v0.mCameraDevice.createCaptureRequest(1);
            if (v0.mPreviewRequestBuilder != null) break block32;
            g.b("VideoCapture", "mPreviewRequestBuilder error", new Object[0]);
            var0_1 = false;
            if (var1_12 != null) {
                var1_12.close();
            }
            return var0_1;
        }
        v2 = this;
        v2.mPreviewRequestBuilder.addTarget(this.mImageReader.getSurface());
        v2.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        v2.mPreviewRequestBuilder.set(CaptureRequest.NOISE_REDUCTION_MODE, (Object)1);
        v2.mPreviewRequestBuilder.set(CaptureRequest.EDGE_MODE, (Object)1);
        v3 = (int[])VideoCaptureCamera2.getCameraCharacteristics(v2.mId).get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
        var2_13 = (ArrayList<E>)v3;
        var3_14 = v3.length;
        for (var4_15 = 0; var4_15 < var3_14; ++var4_15) {
            if (var2_13[var4_15] != true) continue;
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
            break;
        }
        try {
            v4 = this;
            v4.configureCommonCaptureSettings(v4.mPreviewRequestBuilder);
            if (!v4.mEnableFaceDetection) ** GOTO lbl55
        }
        catch (Throwable var0_11) {
            if (var1_12 != null) {
                try {
                    var1_12.close();
                }
                catch (Throwable v5) {
                    var0_11.addSuppressed(v5);
                }
            }
            throw var0_11;
        }
        v6 = this;
        v6.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)2);
        v6.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_SCENE_MODE, (Object)1);
lbl55:
        // 2 sources

        v7 = var1_12;
        v8 = this;
        v9 = v8;
        v10 = v8;
        v11 = v8;
        var2_13 = v12;
        var2_13(1);
        v12.add(this.mImageReader.getSurface());
        v11.mPreviewRequest = v10.mPreviewRequestBuilder.build();
        v13 = this;
        v9.mCameraDevice.createCaptureSession(var2_13, (CameraCaptureSession.StateCallback)v13.new CrPreviewSessionListener(v13.mPreviewRequest), null);
        var0_2 = true;
        if (v7 != null) {
            var1_12.close();
        }
        return var0_2;
        {
            catch (SecurityException var0_3) {
            }
            catch (IllegalArgumentException var0_4) {
            }
            catch (CameraAccessException var0_5) {
                // empty catch block
            }
        }
        g.b("VideoCapture", "createCaptureSession: ", new Object[]{this});
        var0_6 = false;
        if (var1_12 != null) {
            var1_12.close();
        }
        return var0_6;
        {
            catch (SecurityException var0_7) {
            }
            catch (IllegalArgumentException var0_8) {
            }
            catch (CameraAccessException var0_9) {
                // empty catch block
            }
        }
        g.b("VideoCapture", "createCaptureRequest: ", new Object[]{this});
        var0_10 = false;
        if (var1_12 != null) {
            var1_12.close();
        }
        return var0_10;
    }

    /*
     * Unable to fully structure code
     */
    private void configureCommonCaptureSettings(CaptureRequest.Builder var1_2) {
        block41: {
            if (!VideoCaptureCamera2.$assertionsDisabled && this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            v0 = this;
            var2_3 = TraceEvent.scoped("VideoCaptureCamera2.configureCommonCaptureSettings");
            var3_4 = VideoCaptureCamera2.getCameraCharacteristics(v0.mId);
            if (v0.mFocusMode != 4) ** GOTO lbl14
            v1 = var1_2;
            v1.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            v1.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            ** GOTO lbl25
lbl14:
            // 1 sources

            if (this.mFocusMode != 2) ** GOTO lbl25
            v2 = var1_2;
            v3 = v2;
            v2.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            v2.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            v4 = CaptureRequest.LENS_FOCUS_DISTANCE;
            v5 = 1.0f / this.mCurrentFocusDistance;
            v3.set(v4, (Object)Float.valueOf(v5));
lbl25:
            // 3 sources

            if (this.mExposureMode == 1) ** GOTO lbl36
            if (this.mExposureMode == 2) ** GOTO lbl36
            v6 = var1_2;
            v6.set(CaptureRequest.CONTROL_MODE, (Object)1);
            v6.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            if (VideoCaptureCamera2.shouldSkipSettingAeTargetFpsRange()) ** GOTO lbl56
            var1_2.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, this.mAeFpsRange);
            ** GOTO lbl56
lbl36:
            // 2 sources

            var1_2.set(CaptureRequest.CONTROL_AE_MODE, (Object)0);
            if (this.mLastExposureTimeNs == 0L) ** GOTO lbl45
            v7 = var1_2;
            v8 = CaptureRequest.SENSOR_EXPOSURE_TIME;
            v9 = this.mLastExposureTimeNs / 100000L;
lbl42:
            // 2 sources

            while (true) {
                v7.set(v8, (Object)v9);
                ** GOTO lbl56
                break;
            }
lbl45:
            // 1 sources

            v7 = var1_2;
            var4_7 = (Range)var3_4.get(CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE);
            v8 = CaptureRequest.SENSOR_EXPOSURE_TIME;
            v10 = (Long)var4_7.getLower();
            v11 = (Long)var4_7.getUpper() + (Long)var4_7.getLower();
            v12 = v10 + v11 / 2L;
            v9 = v12 / 100000L;
            ** continue;
lbl56:
            // 3 sources

            if (!this.mTorch) ** GOTO lbl71
            v13 = this;
            var4_7 = CaptureRequest.CONTROL_AE_MODE;
            var5_10 = v13.mExposureMode == 4 ? 1 : 0;
            v14 = var1_2;
            v15 = v14;
            v14.set((CaptureRequest.Key)var4_7, (Object)var5_10);
            v16 = CaptureRequest.FLASH_MODE;
            v17 = 2;
lbl68:
            // 2 sources

            while (true) {
                v15.set(v16, (Object)v17);
                ** GOTO lbl100
                break;
            }
lbl71:
            // 1 sources

            var4_8 = this.mFillLightMode;
            if (var4_8 == 1) ** GOTO lbl91
            if (var4_8 == 2) ** GOTO lbl84
            if (var4_8 != 3) ** GOTO lbl95
            v18 = var1_2;
            v19 = v18;
            v18.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
            v20 = CaptureRequest.FLASH_MODE;
            v21 = 1;
lbl81:
            // 2 sources

            while (true) {
                v19.set(v20, (Object)v21);
                ** GOTO lbl95
                break;
            }
lbl84:
            // 1 sources

            v22 = this;
            var4_9 = CaptureRequest.CONTROL_AE_MODE;
            var5_11 = v22.mRedEyeReduction != false ? 4 : 2;
            var1_2.set(var4_9, (Object)var5_11);
            break block41;
lbl91:
            // 1 sources

            v19 = var1_2;
            v20 = CaptureRequest.FLASH_MODE;
            v21 = 0;
            ** continue;
        }
        v15 = var1_2;
        v16 = CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER;
        v17 = 0;
        ** continue;
lbl100:
        // 1 sources

        var1_2.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)this.mExposureCompensation);
        if (this.mWhiteBalanceMode != 4) ** GOTO lbl111
        v23 = var1_2;
        v24 = v23;
        v23.set(CaptureRequest.CONTROL_AWB_LOCK, (Object)false);
        v25 = CaptureRequest.CONTROL_AWB_MODE;
        v26 = 1;
lbl108:
        // 2 sources

        while (true) {
            v24.set(v25, (Object)v26);
            ** GOTO lbl122
            break;
        }
lbl111:
        // 1 sources

        if (this.mWhiteBalanceMode != 1) ** GOTO lbl119
        v27 = var1_2;
        v24 = v27;
        v27.set(CaptureRequest.CONTROL_AWB_LOCK, (Object)false);
        v25 = CaptureRequest.CONTROL_AWB_MODE;
        v26 = 0;
        ** continue;
lbl119:
        // 1 sources

        if (this.mWhiteBalanceMode != 2) ** GOTO lbl122
        var1_2.set(CaptureRequest.CONTROL_AWB_LOCK, (Object)true);
lbl122:
        // 3 sources

        if (this.mColorTemperature <= 0) ** GOTO lbl132
        var3_5 = VideoCaptureCamera2.getClosestWhiteBalance(this.mColorTemperature, (int[])var3_4.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES));
        g.a("VideoCapture", " Color temperature (%d ==> %d)", (Object)this.mColorTemperature, (Object)var3_5);
        if (var3_5 == -1) ** GOTO lbl132
        var1_2.set(CaptureRequest.CONTROL_AWB_MODE, (Object)var3_5);
lbl132:
        // 3 sources

        if (this.mAreaOfInterest == null) ** GOTO lbl146
        v28 = var1_2;
        v29 = v28;
        v30 = v28;
        v31 = v28;
        v32 = new MeteringRectangle[1];
        var3_6 = v32;
        try {
            v32[0] = this.mAreaOfInterest;
            g.a("VideoCapture", "Area of interest %s", (Object)this.mAreaOfInterest.toString());
            v30.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)var3_6);
            v31.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)var3_6);
            v29.set(CaptureRequest.CONTROL_AWB_REGIONS, (Object)var3_6);
lbl146:
            // 2 sources

            if (!this.mCropRect.isEmpty()) {
                var1_2.set(CaptureRequest.SCALER_CROP_REGION, (Object)this.mCropRect);
            }
        }
        finally {
            if (var2_3 != null) {
                try {
                    var2_3.close();
                }
                catch (Throwable v33) {
                    var0_1.addSuppressed(v33);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCameraStateAndNotify(int n2) {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            this.mCameraState = n2;
            this.mCameraStateLock.notifyAll();
            return;
        }
    }

    public static boolean shouldSkipSettingAeTargetFpsRange() {
        String[] stringArray = AE_TARGET_FPS_RANGE_BUGGY_DEVICE_LIST;
        int n2 = AE_TARGET_FPS_RANGE_BUGGY_DEVICE_LIST.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!stringArray[i2].contentEquals(Build.MODEL)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static Size findClosestSizeInArray(Size[] objectArray, int n2, int n3) {
        if (objectArray == null) {
            return null;
        }
        Size size = null;
        int n4 = Integer.MAX_VALUE;
        for (Object object : objectArray) {
            void size2;
            int n5 = n2 > 0 ? Math.abs(object.getWidth() - n2) : 0;
            int n6 = n3 > 0 ? Math.abs(object.getHeight() - n3) : 0;
            if ((n5 += n6) >= n4) {
                n5 = n4;
                Size size3 = size;
            }
            size = size2;
            n4 = n5;
        }
        if (n4 == Integer.MAX_VALUE) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = n2;
            objectArray2[1] = n3;
            g.b(TAG, "Couldn't find resolution close to (%dx%d)", objectArray);
            return null;
        }
        return size;
    }

    public static int findInIntArray(int[] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (n2 != nArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int getClosestWhiteBalance(int n2, int[] nArray) {
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        for (int i2 = 0; i2 < COLOR_TEMPERATURES_MAP.size(); ++i2) {
            int n5;
            if (VideoCaptureCamera2.findInIntArray(nArray, COLOR_TEMPERATURES_MAP.valueAt(i2)) == -1 || (n5 = Math.abs(n2 - COLOR_TEMPERATURES_MAP.keyAt(i2))) >= n3) {
                n5 = n3;
            } else {
                n4 = COLOR_TEMPERATURES_MAP.valueAt(i2);
            }
            n3 = n5;
        }
        return n4;
    }

    public static boolean isLegacyDevice(int n2) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(n2);
        return cameraCharacteristics != null && (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) == 2;
    }

    /*
     * WARNING - void declaration
     */
    public static int getNumberOfCameras() {
        void var0_4;
        CameraManager cameraManager;
        block6: {
            try {
                cameraManager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
                if (cameraManager != null) break block6;
                return 0;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = illegalArgumentException;
                g.b(TAG, "getSystemService(Context.CAMERA_SERVICE): ", objectArray2);
                return 0;
            }
        }
        try {
            return cameraManager.getCameraIdList().length;
        }
        catch (AssertionError assertionError) {
        }
        catch (SecurityException securityException) {
        }
        catch (CameraAccessException cameraAccessException) {
            // empty catch block
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray3 = objectArray;
        objectArray[0] = var0_4;
        g.b(TAG, "getNumberOfCameras: getCameraIdList(): ", objectArray3);
        return 0;
    }

    public static int getCaptureApiType(int n2) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(n2);
        if (cameraCharacteristics == null) {
            return 11;
        }
        int n3 = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        if (n3 != 0) {
            if (n3 != 1) {
                if (n3 != 2) {
                    return 7;
                }
                return 7;
            }
            return 8;
        }
        return 9;
    }

    public static int getFacingMode(int n2) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(n2);
        if (cameraCharacteristics == null) {
            return 0;
        }
        int n3 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        if (n3 != 0) {
            if (n3 != 1) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public static String getName(int n2) {
        Object object = VideoCaptureCamera2.getCameraCharacteristics(n2);
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder().append("camera2 ").append(n2).append(", facing ");
        object = (Integer)object.get(CameraCharacteristics.LENS_FACING) == 0 ? "front" : "back";
        return stringBuilder.append((String)object).toString();
    }

    public static VideoCaptureFormat[] getDeviceSupportedFormats(int n2) {
        ArrayList arrayList;
        Object object = VideoCaptureCamera2.getCameraCharacteristics(n2);
        if (object == null) {
            return null;
        }
        Object object2 = (int[])object.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        boolean bl = false;
        int n3 = ((int[])object2).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (object2[i2] != 1) continue;
            bl = true;
            break;
        }
        CameraCharacteristics cameraCharacteristics = object;
        object = arrayList;
        arrayList = new ArrayList();
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        object2 = streamConfigurationMap;
        for (int n4 : streamConfigurationMap.getOutputFormats()) {
            Size[] sizeArray = object2.getOutputSizes(n4);
            if (sizeArray == null) continue;
            for (Size size : sizeArray) {
                double d2;
                long l2;
                if (bl && (l2 = object2.getOutputMinFrameDuration(n4, size)) != 0L) {
                    d2 = l2;
                    d2 = 1.0E9 / d2;
                } else {
                    d2 = 0.0;
                }
                ((ArrayList)object).add(new VideoCaptureFormat(size.getWidth(), size.getHeight(), (int)d2, n4));
            }
        }
        Object object3 = object;
        return ((ArrayList)object3).toArray(new VideoCaptureFormat[((ArrayList)object3).size()]);
    }

    public VideoCaptureCamera2(int n2, long l2) {
        HandlerThread handlerThread;
        VideoCaptureCamera2 videoCaptureCamera2 = this;
        super(n2, l2);
        videoCaptureCamera2.mCameraStateLock = new Object();
        videoCaptureCamera2.mWaitForDeviceClosedConditionVariable = new ConditionVariable();
        videoCaptureCamera2.mCameraState = 3;
        videoCaptureCamera2.mMaxZoom = 1.0f;
        videoCaptureCamera2.mCropRect = new Rect();
        videoCaptureCamera2.mFocusMode = 4;
        videoCaptureCamera2.mCurrentFocusDistance = 1.0f;
        videoCaptureCamera2.mExposureMode = 4;
        videoCaptureCamera2.mWhiteBalanceMode = 4;
        videoCaptureCamera2.mColorTemperature = -1;
        videoCaptureCamera2.mFillLightMode = 1;
        videoCaptureCamera2.nativeDCheckCurrentlyOnIncomingTaskRunner(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid);
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread("VideoCaptureCamera2_CameraThread").start();
        videoCaptureCamera2.mCameraThreadHandler = new Handler(handlerThread2.getLooper());
        handlerThread2 = VideoCaptureCamera2.getCameraCharacteristics(n2);
        if (handlerThread2 != null) {
            this.mMaxZoom = ((Float)handlerThread2.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        }
    }

    public static /* synthetic */ CameraDevice access$102(VideoCaptureCamera2 videoCaptureCamera2, CameraDevice cameraDevice) {
        videoCaptureCamera2.mCameraDevice = cameraDevice;
        return cameraDevice;
    }

    public static /* synthetic */ CameraCaptureSession access$502(VideoCaptureCamera2 videoCaptureCamera2, CameraCaptureSession cameraCaptureSession) {
        videoCaptureCamera2.mPreviewSession = cameraCaptureSession;
        return cameraCaptureSession;
    }

    public static /* synthetic */ long access$602(VideoCaptureCamera2 videoCaptureCamera2, long l2) {
        videoCaptureCamera2.mLastExposureTimeNs = l2;
        return l2;
    }

    public static /* synthetic */ Rect access$702(VideoCaptureCamera2 videoCaptureCamera2, Rect rect) {
        videoCaptureCamera2.mCropRect = rect;
        return rect;
    }

    public static /* synthetic */ float access$1302(VideoCaptureCamera2 videoCaptureCamera2, float f2) {
        videoCaptureCamera2.mCurrentFocusDistance = f2;
        return f2;
    }

    public static /* synthetic */ int access$1502(VideoCaptureCamera2 videoCaptureCamera2, int n2) {
        videoCaptureCamera2.mFocusMode = n2;
        return n2;
    }

    public static /* synthetic */ int access$1602(VideoCaptureCamera2 videoCaptureCamera2, int n2) {
        videoCaptureCamera2.mExposureMode = n2;
        return n2;
    }

    public static /* synthetic */ int access$1702(VideoCaptureCamera2 videoCaptureCamera2, int n2) {
        videoCaptureCamera2.mWhiteBalanceMode = n2;
        return n2;
    }

    public static /* synthetic */ int access$1002(VideoCaptureCamera2 videoCaptureCamera2, int n2) {
        videoCaptureCamera2.mPhotoWidth = n2;
        return n2;
    }

    public static /* synthetic */ int access$1102(VideoCaptureCamera2 videoCaptureCamera2, int n2) {
        videoCaptureCamera2.mPhotoHeight = n2;
        return n2;
    }

    public static /* synthetic */ MeteringRectangle access$1802(VideoCaptureCamera2 videoCaptureCamera2, MeteringRectangle meteringRectangle) {
        videoCaptureCamera2.mAreaOfInterest = meteringRectangle;
        return meteringRectangle;
    }

    public static /* synthetic */ int access$1902(VideoCaptureCamera2 videoCaptureCamera2, int n2) {
        videoCaptureCamera2.mExposureCompensation = n2;
        return n2;
    }

    public static /* synthetic */ int access$2002(VideoCaptureCamera2 videoCaptureCamera2, int n2) {
        videoCaptureCamera2.mIso = n2;
        return n2;
    }

    public static /* synthetic */ int access$2102(VideoCaptureCamera2 videoCaptureCamera2, int n2) {
        videoCaptureCamera2.mColorTemperature = n2;
        return n2;
    }

    public static /* synthetic */ boolean access$2202(VideoCaptureCamera2 videoCaptureCamera2, boolean bl) {
        videoCaptureCamera2.mRedEyeReduction = bl;
        return bl;
    }

    public static /* synthetic */ int access$2302(VideoCaptureCamera2 videoCaptureCamera2, int n2) {
        videoCaptureCamera2.mFillLightMode = n2;
        return n2;
    }

    public static /* synthetic */ boolean access$2402(VideoCaptureCamera2 videoCaptureCamera2, boolean bl) {
        videoCaptureCamera2.mTorch = bl;
        return bl;
    }

    static {
        $assertionsDisabled = VideoCaptureCamera2.class.desiredAssertionStatus() ^ true;
        AE_TARGET_FPS_RANGE_BUGGY_DEVICE_LIST = new String[]{"Pixel 3", "Pixel 3 XL"};
        COLOR_TEMPERATURES_MAP = new SparseIntArray();
        COLOR_TEMPERATURES_MAP.append(2850, 2);
        COLOR_TEMPERATURES_MAP.append(2950, 4);
        COLOR_TEMPERATURES_MAP.append(4250, 3);
        COLOR_TEMPERATURES_MAP.append(4600, 7);
        COLOR_TEMPERATURES_MAP.append(5000, 5);
        COLOR_TEMPERATURES_MAP.append(6000, 6);
        COLOR_TEMPERATURES_MAP.append(7000, 8);
    }

    public void finalize() {
        this.mCameraThreadHandler.getLooper().quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean allocate(int n2, int n3, int n4, boolean bl) {
        block7: {
            ArrayList arrayList;
            Object[] objectArray;
            Object[] objectArray2 = objectArray;
            Object object = n2;
            Object object2 = n3;
            Integer n5 = n4;
            g.a(TAG, "allocate: requested (%d x %d) @%dfps", object, object2, (Object)n5);
            objectArray2.nativeDCheckCurrentlyOnIncomingTaskRunner(objectArray.mNativeVideoCaptureDeviceAndroid);
            object = objectArray.mCameraStateLock;
            // MONITORENTER : object
            if (objectArray2.mCameraState == 0 || objectArray.mCameraState == 1) break block7;
            // MONITOREXIT : object
            object = VideoCaptureCamera2.getCameraCharacteristics(objectArray.mId);
            Size size = VideoCaptureCamera2.findClosestSizeInArray(((StreamConfigurationMap)object.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputSizes(35), n2, n3);
            if (size == null) {
                objectArray = new Object[]{};
                g.b(TAG, "No supported resolutions.", objectArray);
                return false;
            }
            List<Range> list = Arrays.asList((Range[])object.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES));
            if (list.isEmpty()) {
                objectArray = new Object[]{};
                g.b(TAG, "No supported framerate ranges.", objectArray);
                return false;
            }
            object2 = arrayList;
            arrayList = new ArrayList(list.size());
            int n6 = (Integer)list.get(0).getUpper() > 1000 ? 1 : 1000;
            for (Range range : list) {
                object2.add(new VideoCapture.FramerateRange((Integer)range.getLower() * n6, (Integer)range.getUpper() * n6));
            }
            Object object3 = object;
            Object object4 = object;
            Size size2 = size;
            list = VideoCapture.getClosestFramerateRange((List<VideoCapture.FramerateRange>)object2, n4 * 1000);
            objectArray.mAeFpsRange = new Range((Comparable)Integer.valueOf(((VideoCapture.FramerateRange)((Object)list)).min / n6), (Comparable)Integer.valueOf(((VideoCapture.FramerateRange)((Object)list)).max / n6));
            list = size2.getWidth();
            object = size2.getHeight();
            object2 = objectArray.mAeFpsRange.getLower();
            Comparable comparable = objectArray.mAeFpsRange.getUpper();
            g.a(TAG, "allocate: matched (%d x %d) @[%d - %d]", (Object)list, object, object2, (Object)comparable);
            objectArray.mCaptureFormat = new VideoCaptureFormat(size.getWidth(), size.getHeight(), n4, 35);
            objectArray.mCameraNativeOrientation = (Integer)object4.get(CameraCharacteristics.SENSOR_ORIENTATION);
            boolean bl2 = (Integer)object3.get(CameraCharacteristics.LENS_FACING) == 1;
            objectArray.mInvertDeviceOrientationReadings = bl2;
            objectArray.mEnableFaceDetection = bl;
            return true;
        }
        g.b(TAG, "allocate() invoked while Camera is busy opening/configuring.", new Object[0]);
        // MONITOREXIT : object
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean startCaptureMaybeAsync() {
        void var0_4;
        Object[] objectArray;
        VideoCaptureCamera2 videoCaptureCamera2 = this;
        videoCaptureCamera2.nativeDCheckCurrentlyOnIncomingTaskRunner(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid);
        videoCaptureCamera2.changeCameraStateAndNotify(0);
        CameraManager cameraManager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        Object[] objectArray2 = objectArray;
        objectArray = new CrStateListener(null);
        try {
            TraceEvent.instant("VideoCaptureCamera2.java", "VideoCaptureCamera2.startCaptureMaybeAsync calling manager.openCamera");
            cameraManager.openCamera(Integer.toString(this.mId), (CameraDevice.StateCallback)objectArray2, this.mCameraThreadHandler);
            return true;
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (CameraAccessException cameraAccessException) {
            // empty catch block
        }
        Object[] objectArray3 = new Object[1];
        objectArray2 = objectArray3;
        objectArray3[0] = var0_4;
        g.b(TAG, "allocate: manager.openCamera: ", objectArray2);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean stopCaptureAndBlockUntilStopped() {
        VideoCaptureCamera2 videoCaptureCamera2 = this;
        videoCaptureCamera2.nativeDCheckCurrentlyOnIncomingTaskRunner(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid);
        TraceEvent traceEvent = TraceEvent.scoped("VideoCaptureCamera2.stopCaptureAndBlockUntilStopped");
        Object object = videoCaptureCamera2.mCameraStateLock;
        while (this.mCameraState != 2 && this.mCameraState != 3) {
            try {
                this.mCameraStateLock.wait();
            }
            catch (InterruptedException interruptedException) {
                g.b(TAG, "CaptureStartedEvent: ", interruptedException);
            }
        }
        if (this.mCameraState == 3) {
            boolean bl = true;
            // MONITOREXIT : object
            if (traceEvent == null) return bl;
            traceEvent.close();
            return bl;
        }
        TraceEvent traceEvent2 = traceEvent;
        VideoCaptureCamera2 videoCaptureCamera22 = this;
        VideoCaptureCamera2 videoCaptureCamera23 = videoCaptureCamera22;
        VideoCaptureCamera2 videoCaptureCamera24 = videoCaptureCamera22;
        // MONITOREXIT : object
        videoCaptureCamera23.mCameraThreadHandler.post((Runnable)new StopCaptureTask(null));
        {
            catch (Throwable throwable) {
                if (traceEvent == null) throw throwable;
                try {
                    traceEvent.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        videoCaptureCamera24.mWaitForDeviceClosedConditionVariable.block();
        boolean bl = true;
        if (traceEvent2 == null) return bl;
        traceEvent.close();
        return bl;
        catch (Throwable throwable) {
            // MONITOREXIT : object
            throw throwable;
        }
    }

    @Override
    public void getPhotoCapabilitiesAsync(long l2) {
        VideoCaptureCamera2 videoCaptureCamera2 = this;
        videoCaptureCamera2.nativeDCheckCurrentlyOnIncomingTaskRunner(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid);
        videoCaptureCamera2.mCameraThreadHandler.post((Runnable)new GetPhotoCapabilitiesTask(l2));
    }

    @Override
    public void setPhotoOptions(double d2, int n2, double d3, int n3, double d4, double d5, double[] dArray, boolean bl, double d6, double d7, int n4, double d8, boolean bl2, boolean bl3, int n5, boolean bl4, boolean bl5, double d9) {
        VideoCaptureCamera2 videoCaptureCamera2 = this;
        videoCaptureCamera2.nativeDCheckCurrentlyOnIncomingTaskRunner(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid);
        videoCaptureCamera2.mCameraThreadHandler.post((Runnable)new SetPhotoOptionsTask(new PhotoOptions(d2, n2, d3, n3, d4, d5, dArray, bl, d6, d7, n4, d8, bl2, bl3, n5, bl4, bl5, d9)));
    }

    @Override
    public void takePhotoAsync(long l2) {
        VideoCaptureCamera2 videoCaptureCamera2 = this;
        videoCaptureCamera2.nativeDCheckCurrentlyOnIncomingTaskRunner(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid);
        TraceEvent.instant("VideoCaptureCamera2.java", "takePhotoAsync");
        videoCaptureCamera2.mCameraThreadHandler.post((Runnable)new TakePhotoTask(l2));
    }

    @Override
    public void deallocate() {
        g.a(TAG, "deallocate");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CameraState {
        public static final int OPENING = 0;
        public static final int CONFIGURING = 1;
        public static final int STARTED = 2;
        public static final int STOPPED = 3;
    }

    public class TakePhotoTask
    implements Runnable {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final long mCallbackId;

        public TakePhotoTask(long l2) {
            this.mCallbackId = l2;
        }

        static {
            $assertionsDisabled = VideoCaptureCamera2.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public void run() {
            if (!$assertionsDisabled && VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            TraceEvent.instant("VideoCaptureCamera2.java", "TakePhotoTask.run");
            if (VideoCaptureCamera2.this.mCameraDevice != null && VideoCaptureCamera2.this.mCameraState == 2) {
                block10: {
                    Object[] objectArray;
                    CrPhotoSessionListener crPhotoSessionListener;
                    Object[] objectArray2;
                    Object[] objectArray3;
                    Integer n2;
                    block9: {
                        Object[] objectArray4;
                        Size size = VideoCaptureCamera2.findClosestSizeInArray(((StreamConfigurationMap)VideoCaptureCamera2.getCameraCharacteristics(VideoCaptureCamera2.this.mId).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputSizes(256), VideoCaptureCamera2.this.mPhotoWidth, VideoCaptureCamera2.this.mPhotoHeight);
                        TakePhotoTask takePhotoTask = this;
                        Integer n3 = takePhotoTask.VideoCaptureCamera2.this.mPhotoWidth;
                        n2 = takePhotoTask.VideoCaptureCamera2.this.mPhotoHeight;
                        g.a(VideoCaptureCamera2.TAG, "requested resolution: (%dx%d)", (Object)n3, (Object)n2);
                        if (size != null) {
                            Size size2 = size;
                            n3 = size2.getWidth();
                            n2 = size2.getHeight();
                            g.a(VideoCaptureCamera2.TAG, " matched (%dx%d)", (Object)n3, (Object)n2);
                        }
                        TraceEvent.instant("VideoCaptureCamera2.java", "TakePhotoTask.run creating ImageReader");
                        int n4 = size != null ? size.getWidth() : VideoCaptureCamera2.this.mCaptureFormat.getWidth();
                        int n5 = size != null ? size.getHeight() : VideoCaptureCamera2.this.mCaptureFormat.getHeight();
                        objectArray3 = ImageReader.newInstance((int)n4, (int)n5, (int)256, (int)1);
                        objectArray3.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new CrPhotoReaderListener(this.mCallbackId), VideoCaptureCamera2.this.mCameraThreadHandler);
                        objectArray2 = objectArray4;
                        objectArray2(1);
                        objectArray4.add(objectArray3.getSurface());
                        try {
                            n2 = VideoCaptureCamera2.this.mCameraDevice.createCaptureRequest(2);
                            if (n2 != null) break block9;
                        }
                        catch (CameraAccessException cameraAccessException) {
                            Object[] objectArray5 = new Object[1];
                            objectArray2 = objectArray5;
                            objectArray5[0] = cameraAccessException;
                            g.b(VideoCaptureCamera2.TAG, "createCaptureRequest() error ", objectArray2);
                            VideoCaptureCamera2.this.notifyTakePhotoError(this.mCallbackId);
                            return;
                        }
                        objectArray3 = new Object[]{};
                        g.b(VideoCaptureCamera2.TAG, "photoRequestBuilder error", objectArray3);
                        VideoCaptureCamera2.this.notifyTakePhotoError(this.mCallbackId);
                        return;
                    }
                    Integer n6 = n2;
                    n6.addTarget(objectArray3.getSurface());
                    n6.set(CaptureRequest.JPEG_ORIENTATION, VideoCaptureCamera2.this.getCameraRotation());
                    TraceEvent.instant("VideoCaptureCamera2.java", "TakePhotoTask.run calling configureCommonCaptureSettings");
                    VideoCaptureCamera2.this.configureCommonCaptureSettings((CaptureRequest.Builder)n2);
                    TraceEvent.instant("VideoCaptureCamera2.java", "TakePhotoTask.run calling photoRequestBuilder.build()");
                    n2 = n2.build();
                    CrPhotoSessionListener crPhotoSessionListener2 = crPhotoSessionListener;
                    crPhotoSessionListener = new CrPhotoSessionListener((ImageReader)objectArray3, (CaptureRequest)n2, this.mCallbackId);
                    try {
                        TraceEvent.instant("VideoCaptureCamera2.java", "TakePhotoTask.run calling mCameraDevice.createCaptureSession()");
                        VideoCaptureCamera2.this.mCameraDevice.createCaptureSession((List)objectArray2, (CameraCaptureSession.StateCallback)crPhotoSessionListener2, VideoCaptureCamera2.this.mCameraThreadHandler);
                        break block10;
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (CameraAccessException cameraAccessException) {
                        // empty catch block
                    }
                    String string2 = "createCaptureSession: " + objectArray;
                    objectArray = new Object[]{};
                    g.b(VideoCaptureCamera2.TAG, string2, objectArray);
                    VideoCaptureCamera2.this.notifyTakePhotoError(this.mCallbackId);
                }
                return;
            }
            Object[] objectArray = new Object[]{};
            g.b(VideoCaptureCamera2.TAG, "TakePhoto failed because mCameraDevice == null || mCameraState != CameraState.STARTED", objectArray);
            VideoCaptureCamera2.this.notifyTakePhotoError(this.mCallbackId);
        }
    }

    public class SetPhotoOptionsTask
    implements Runnable {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final PhotoOptions mOptions;

        public SetPhotoOptionsTask(PhotoOptions photoOptions) {
            this.mOptions = photoOptions;
        }

        static {
            $assertionsDisabled = VideoCaptureCamera2.class.desiredAssertionStatus() ^ true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            block32: {
                int n2;
                double d2;
                double d3;
                double d4;
                double d5;
                int n3;
                double d6;
                int n4;
                double d7;
                int n5;
                if (!$assertionsDisabled && VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                    throw new AssertionError((Object)"called on wrong thread");
                }
                SetPhotoOptionsTask setPhotoOptionsTask = this;
                CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(setPhotoOptionsTask.VideoCaptureCamera2.this.mId);
                Object object = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                double d8 = setPhotoOptionsTask.mOptions.zoom;
                if (d8 != 0.0) {
                    float f2 = Math.max(1.0f, Math.min((float)d8, VideoCaptureCamera2.this.mMaxZoom));
                    float f3 = f2;
                    f3 = (f3 - 1.0f) / (f3 * 2.0f);
                    int n6 = Math.round((float)object.width() * f3);
                    int n7 = Math.round((float)object.height() * f3);
                    f3 = 1.0f - f3;
                    VideoCaptureCamera2.access$702(VideoCaptureCamera2.this, new Rect(n6, n7, Math.round((float)object.width() * f3), Math.round((float)object.height() * f3)));
                    Float f4 = Float.valueOf(f2);
                    String string2 = VideoCaptureCamera2.this.mCropRect.toString();
                    g.a(VideoCaptureCamera2.TAG, "zoom level %f, rectangle: %s", (Object)f4, (Object)string2);
                }
                if ((n5 = this.mOptions.focusMode) != 0) {
                    VideoCaptureCamera2.access$1502(VideoCaptureCamera2.this, n5);
                }
                if ((d7 = this.mOptions.currentFocusDistance) != 0.0) {
                    VideoCaptureCamera2.access$1302(VideoCaptureCamera2.this, (float)d7);
                }
                if ((n4 = this.mOptions.exposureMode) != 0) {
                    VideoCaptureCamera2.access$1602(VideoCaptureCamera2.this, n4);
                }
                if ((d6 = this.mOptions.exposureTime) != 0.0) {
                    VideoCaptureCamera2.access$602(VideoCaptureCamera2.this, (long)d6);
                }
                if ((n3 = this.mOptions.whiteBalanceMode) != 0) {
                    VideoCaptureCamera2.access$1702(VideoCaptureCamera2.this, n3);
                }
                double d9 = this.mOptions.width;
                if (d5 > 0.0) {
                    VideoCaptureCamera2.access$1002(VideoCaptureCamera2.this, (int)Math.round(d9));
                }
                d9 = this.mOptions.height;
                if (d4 > 0.0) {
                    VideoCaptureCamera2.access$1102(VideoCaptureCamera2.this, (int)Math.round(d9));
                }
                if (VideoCaptureCamera2.this.mAreaOfInterest != null && !VideoCaptureCamera2.this.mAreaOfInterest.getRect().isEmpty() && this.mOptions.zoom > 0.0) {
                    VideoCaptureCamera2.access$1802(VideoCaptureCamera2.this, null);
                }
                if (VideoCaptureCamera2.this.mFocusMode == 1 || VideoCaptureCamera2.this.mExposureMode == 1) {
                    VideoCaptureCamera2.access$1802(VideoCaptureCamera2.this, null);
                }
                boolean bl = (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF) > 0 || (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE) > 0 || (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB) > 0;
                if (bl) {
                    Object object2 = this.mOptions.pointsOfInterest2D;
                    if (this.mOptions.pointsOfInterest2D.length > 0) {
                        if (!$assertionsDisabled && ((double[])object2).length != 2) {
                            throw new AssertionError((Object)"Only 1 point of interest supported");
                        }
                        if (!$assertionsDisabled) {
                            object2 = this.mOptions.pointsOfInterest2D;
                            if (!(this.mOptions.pointsOfInterest2D[0] <= 1.0) || !(object2[0] >= 0.0)) {
                                throw new AssertionError();
                            }
                        }
                        if (!$assertionsDisabled) {
                            object2 = this.mOptions.pointsOfInterest2D;
                            if (!(this.mOptions.pointsOfInterest2D[1] <= 1.0) || !(object2[1] >= 0.0)) {
                                throw new AssertionError();
                            }
                        }
                        object2 = VideoCaptureCamera2.this.mCropRect.isEmpty() ? (Object)object : (Object)VideoCaptureCamera2.this.mCropRect;
                        SetPhotoOptionsTask setPhotoOptionsTask2 = this;
                        int n8 = (int)Math.round(setPhotoOptionsTask2.mOptions.pointsOfInterest2D[0] * (double)object2.width());
                        int n9 = (int)Math.round(setPhotoOptionsTask2.mOptions.pointsOfInterest2D[1] * (double)object2.height());
                        if (object2.equals((Object)setPhotoOptionsTask2.VideoCaptureCamera2.this.mCropRect)) {
                            Object object3 = object;
                            n8 = (object3.width() - object2.width()) / 2 + n8;
                            n9 = (object3.height() - object2.height()) / 2 + n9;
                        }
                        Object object4 = object;
                        SetPhotoOptionsTask setPhotoOptionsTask3 = this;
                        int n10 = object2.width() / 8;
                        int n11 = object2.height() / 8;
                        VideoCaptureCamera2.access$1802(setPhotoOptionsTask3.VideoCaptureCamera2.this, new MeteringRectangle(Math.max(0, n8 - n10 / 2), Math.max(0, n9 - n11 / 2), n10, n11, 1000));
                        object = setPhotoOptionsTask3.mOptions.pointsOfInterest2D[0];
                        Double d10 = setPhotoOptionsTask3.mOptions.pointsOfInterest2D[1];
                        String string3 = object2.toString();
                        String string4 = object4.toString();
                        g.a(VideoCaptureCamera2.TAG, "Calculating (%.2fx%.2f) wrt to %s (canvas being %s)", object, (Object)d10, (Object)string3, (Object)string4);
                        object = VideoCaptureCamera2.this.mAreaOfInterest.toString();
                        g.a(VideoCaptureCamera2.TAG, "Area of interest %s", object);
                    }
                }
                object = this.mOptions;
                if (object.hasExposureCompensation) {
                    VideoCaptureCamera2.access$1902(VideoCaptureCamera2.this, (int)Math.round(object.exposureCompensation / (double)((Rational)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP)).floatValue()));
                }
                double d11 = this.mOptions.iso;
                if (d3 > 0.0) {
                    VideoCaptureCamera2.access$2002(VideoCaptureCamera2.this, (int)Math.round(d11));
                }
                d11 = this.mOptions.colorTemperature;
                if (d2 > 0.0) {
                    VideoCaptureCamera2.access$2102(VideoCaptureCamera2.this, (int)Math.round(d11));
                }
                PhotoOptions photoOptions = this.mOptions;
                if (photoOptions.hasRedEyeReduction) {
                    VideoCaptureCamera2.access$2202(VideoCaptureCamera2.this, photoOptions.redEyeReduction);
                }
                if ((n2 = this.mOptions.fillLightMode) != 0) {
                    VideoCaptureCamera2.access$2302(VideoCaptureCamera2.this, n2);
                }
                Object[] objectArray = this.mOptions;
                if (this.mOptions.hasTorch) {
                    VideoCaptureCamera2.access$2402(VideoCaptureCamera2.this, objectArray.torch);
                }
                if (VideoCaptureCamera2.this.mPreviewSession != null) {
                    void var0_5;
                    if (!$assertionsDisabled && VideoCaptureCamera2.this.mPreviewRequestBuilder == null) {
                        throw new AssertionError((Object)"preview request builder");
                    }
                    SetPhotoOptionsTask setPhotoOptionsTask4 = this;
                    VideoCaptureCamera2 videoCaptureCamera2 = setPhotoOptionsTask4.VideoCaptureCamera2.this;
                    videoCaptureCamera2.configureCommonCaptureSettings(videoCaptureCamera2.mPreviewRequestBuilder);
                    try {
                        setPhotoOptionsTask4.VideoCaptureCamera2.this.mPreviewSession.setRepeatingRequest(VideoCaptureCamera2.this.mPreviewRequestBuilder.build(), null, null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (CameraAccessException cameraAccessException) {
                        // empty catch block
                    }
                    break block32;
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = var0_5;
                    g.b(VideoCaptureCamera2.TAG, "setRepeatingRequest: ", objectArray);
                }
            }
        }
    }

    public class PhotoOptions {
        public final double zoom;
        public final int focusMode;
        public final double currentFocusDistance;
        public final int exposureMode;
        public final double width;
        public final double height;
        public final double[] pointsOfInterest2D;
        public final boolean hasExposureCompensation;
        public final double exposureCompensation;
        public final double exposureTime;
        public final int whiteBalanceMode;
        public final double iso;
        public final boolean hasRedEyeReduction;
        public final boolean redEyeReduction;
        public final int fillLightMode;
        public final boolean hasTorch;
        public final boolean torch;
        public final double colorTemperature;

        public PhotoOptions(double d2, int n2, double d3, int n3, double d4, double d5, double[] dArray, boolean bl, double d6, double d7, int n4, double d8, boolean bl2, boolean bl3, int n5, boolean bl4, boolean bl5, double d9) {
            this.zoom = d2;
            this.focusMode = n2;
            this.currentFocusDistance = d3;
            this.exposureMode = n3;
            this.width = d4;
            this.height = d5;
            this.pointsOfInterest2D = dArray;
            this.hasExposureCompensation = bl;
            this.exposureCompensation = d6;
            this.exposureTime = d7;
            this.whiteBalanceMode = n4;
            this.iso = d8;
            this.hasRedEyeReduction = bl2;
            this.redEyeReduction = bl3;
            this.fillLightMode = n5;
            this.hasTorch = bl4;
            this.torch = bl5;
            this.colorTemperature = d9;
        }
    }

    public class GetPhotoCapabilitiesTask
    implements Runnable {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final long mCallbackId;

        public GetPhotoCapabilitiesTask(long l2) {
            this.mCallbackId = l2;
        }

        static {
            $assertionsDisabled = VideoCaptureCamera2.class.desiredAssertionStatus() ^ true;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int n2;
            ArrayList<Integer> arrayList;
            PhotoCapabilities.Builder builder;
            CameraCharacteristics cameraCharacteristics;
            block48: {
                void var6_42;
                ArrayList<Integer> arrayList2;
                ArrayList<Integer> arrayList3;
                block47: {
                    void var6_40;
                    ArrayList<Integer> arrayList4;
                    int n3;
                    block55: {
                        block56: {
                            block57: {
                                float f2;
                                float f3;
                                ArrayList<Integer> arrayList5;
                                int[] nArray;
                                block54: {
                                    block53: {
                                        block52: {
                                            block51: {
                                                int n4;
                                                block50: {
                                                    block49: {
                                                        ArrayList<Integer> arrayList6;
                                                        int n5;
                                                        PhotoCapabilities.Builder builder2;
                                                        if (!$assertionsDisabled && VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                                                            throw new AssertionError((Object)"called on wrong thread");
                                                        }
                                                        cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(VideoCaptureCamera2.this.mId);
                                                        builder = builder2;
                                                        builder2 = new PhotoCapabilities.Builder();
                                                        int n6 = 0;
                                                        int n7 = 0;
                                                        Range range = (Range)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_SENSITIVITY_RANGE);
                                                        if (range != null) {
                                                            Range range2 = range;
                                                            n6 = (Integer)range2.getLower();
                                                            n7 = (Integer)range2.getUpper();
                                                        }
                                                        builder.setInt(0, n6).setInt(1, n7).setInt(3, 1);
                                                        if (VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.SENSOR_SENSITIVITY) != null) {
                                                            builder.setInt(2, (Integer)VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.SENSOR_SENSITIVITY));
                                                        }
                                                        Object object = ((StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputSizes(256);
                                                        n7 = Integer.MAX_VALUE;
                                                        int n8 = Integer.MAX_VALUE;
                                                        boolean bl = false;
                                                        n4 = 0;
                                                        for (Size size : object) {
                                                            if (size.getWidth() < n7) {
                                                                n7 = size.getWidth();
                                                            }
                                                            if (size.getHeight() < n8) {
                                                                n8 = size.getHeight();
                                                            }
                                                            if (size.getWidth() > n5) {
                                                                n5 = size.getWidth();
                                                            }
                                                            if (size.getHeight() <= n4) continue;
                                                            n4 = size.getHeight();
                                                        }
                                                        object = builder.setInt(4, n8).setInt(5, n4).setInt(7, 1);
                                                        n8 = 6;
                                                        n4 = VideoCaptureCamera2.this.mPhotoHeight > 0 ? VideoCaptureCamera2.this.mPhotoHeight : VideoCaptureCamera2.this.mCaptureFormat.getHeight();
                                                        object = ((PhotoCapabilities.Builder)object).setInt(n8, n4).setInt(8, n7).setInt(9, n5).setInt(11, 1);
                                                        n7 = 10;
                                                        n8 = VideoCaptureCamera2.this.mPhotoWidth > 0 ? VideoCaptureCamera2.this.mPhotoWidth : VideoCaptureCamera2.this.mCaptureFormat.getWidth();
                                                        ((PhotoCapabilities.Builder)object).setInt(n7, n8);
                                                        float f4 = 1.0f;
                                                        if (cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE) != null && VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.SCALER_CROP_REGION) != null) {
                                                            f4 = (float)((Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE)).width() / (float)((Rect)VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.SCALER_CROP_REGION)).width();
                                                        }
                                                        CameraCharacteristics cameraCharacteristics2 = cameraCharacteristics;
                                                        double d2 = VideoCaptureCamera2.this.mMaxZoom;
                                                        double d3 = f4;
                                                        builder.setDouble(0, 1.0).setDouble(1, d2).setDouble(2, d3).setDouble(3, 0.1);
                                                        nArray = (int[])cameraCharacteristics2.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
                                                        arrayList5 = arrayList6;
                                                        arrayList6 = new ArrayList<Integer>(3);
                                                        f3 = 0.0f;
                                                        f2 = 0.0f;
                                                        if (cameraCharacteristics2.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE) == null) break block49;
                                                        f3 = ((Float)cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE)).floatValue();
                                                        float f5 = f3 - 0.0f;
                                                        float f6 = f5 == 0.0f ? 0 : (f5 > 0.0f ? 1 : -1);
                                                        n4 = (int)f6;
                                                        if (f6 == false) {
                                                            g.a(VideoCaptureCamera2.TAG, "lens is fixed-focus");
                                                            break block50;
                                                        } else if (n4 > 0) {
                                                            f3 = 1.0f / f3;
                                                        }
                                                        break block50;
                                                    }
                                                    g.a(VideoCaptureCamera2.TAG, "LENS_INFO_MINIMUM_FOCUS_DISTANCE is null");
                                                }
                                                if (cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_HYPERFOCAL_DISTANCE) == null) break block51;
                                                f2 = ((Float)cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_HYPERFOCAL_DISTANCE)).floatValue();
                                                float f7 = f2 - 0.0f;
                                                float f8 = f7 == 0.0f ? 0 : (f7 > 0.0f ? 1 : -1);
                                                n4 = (int)f8;
                                                if (f8 == false) {
                                                    f2 = 9.223372E18f;
                                                    break block52;
                                                } else if (n4 > 0) {
                                                    f2 = 1.0f / f2;
                                                }
                                                break block52;
                                            }
                                            g.a(VideoCaptureCamera2.TAG, "LENS_INFO_HYPERFOCAL_DISTANCE is null");
                                        }
                                        if (VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.LENS_FOCUS_DISTANCE) == null) break block53;
                                        GetPhotoCapabilitiesTask getPhotoCapabilitiesTask = this;
                                        VideoCaptureCamera2 videoCaptureCamera2 = getPhotoCapabilitiesTask.VideoCaptureCamera2.this;
                                        VideoCaptureCamera2.access$1302(videoCaptureCamera2, ((Float)videoCaptureCamera2.mPreviewRequest.get(CaptureRequest.LENS_FOCUS_DISTANCE)).floatValue());
                                        if (getPhotoCapabilitiesTask.VideoCaptureCamera2.this.mCurrentFocusDistance == 0.0f) {
                                            g.a(VideoCaptureCamera2.TAG, "infinity focus.");
                                            VideoCaptureCamera2.access$1302(VideoCaptureCamera2.this, 9.223372E18f);
                                            break block54;
                                        } else if (VideoCaptureCamera2.this.mCurrentFocusDistance > 0.0f) {
                                            double d4 = 1.0f / VideoCaptureCamera2.this.mCurrentFocusDistance;
                                            builder.setDouble(6, d4);
                                        }
                                        break block54;
                                    }
                                    g.a(VideoCaptureCamera2.TAG, "LENS_FOCUS_DISTANCE is null");
                                }
                                for (int n9 : nArray) {
                                    if (n9 == 0) {
                                        arrayList5.add(2);
                                        double d5 = f3;
                                        PhotoCapabilities.Builder builder3 = builder.setDouble(4, d5);
                                        d5 = f2;
                                        PhotoCapabilities.Builder builder4 = builder3.setDouble(5, d5);
                                        d5 = 0.01f;
                                        builder4.setDouble(7, d5);
                                        continue;
                                    }
                                    if (n9 != 1 && n9 != 2) {
                                        if (n9 != 3 && n9 != 4 && n9 != 5 || arrayList5.contains(4)) continue;
                                        arrayList5.add(4);
                                        continue;
                                    }
                                    if (arrayList5.contains(3)) continue;
                                    arrayList5.add(3);
                                }
                                builder.setMeteringModeArray(0, VideoCapture.integerArrayListToArray(arrayList5));
                                n3 = 1;
                                if (VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.CONTROL_AF_MODE) == null) break block55;
                                int n10 = (Integer)VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.CONTROL_AF_MODE);
                                if (n10 == 3 || n10 == 4) break block56;
                                if (n10 == 1 || n10 == 2) break block57;
                                if (n10 == 0) {
                                    n3 = 2;
                                    if (VideoCaptureCamera2.this.mCurrentFocusDistance > 0.0f) {
                                        double d6 = 1.0f / VideoCaptureCamera2.this.mCurrentFocusDistance;
                                        builder.setDouble(6, d6);
                                    }
                                    break block55;
                                } else if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                                break block55;
                            }
                            n3 = 3;
                            break block55;
                        }
                        n3 = 4;
                    }
                    builder.setMeteringMode(0, n3);
                    int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
                    arrayList3 = arrayList4;
                    arrayList4 = new ArrayList<Integer>(1);
                    int n11 = nArray.length;
                    boolean bl = false;
                    while (var6_40 < n11) {
                        int n12 = nArray[var6_40];
                        if (n12 != 1 && n12 != 2 && n12 != 3 && n12 != 4) {
                            if (cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE) != null) {
                                Range range = (Range)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE);
                                long l2 = (Long)range.getLower();
                                long l3 = (Long)range.getUpper();
                                if (l2 != 0L && l3 != 0L) {
                                    double d7 = l3 / 100000L;
                                    double d8 = l2 / 100000L;
                                    builder.setDouble(13, d7).setDouble(12, d8);
                                }
                                double d9 = VideoCaptureCamera2.this.mLastExposureTimeNs / 100000L;
                                builder.setDouble(15, 0.0).setDouble(14, d9);
                            }
                            ++var6_40;
                            continue;
                        }
                        arrayList3.add(4);
                        break;
                    }
                    try {
                        if (!((Boolean)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_LOCK_AVAILABLE)).booleanValue()) break block47;
                        arrayList3.add(2);
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                }
                builder.setMeteringModeArray(1, VideoCapture.integerArrayListToArray(arrayList3));
                int n13 = 4;
                if (VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.CONTROL_AE_MODE) != null && (Integer)VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.CONTROL_AE_MODE) == 0) {
                    n13 = 1;
                }
                if (((Boolean)VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.CONTROL_AE_LOCK)).booleanValue()) {
                    n13 = 2;
                }
                builder.setMeteringMode(1, n13);
                float f9 = ((Rational)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP)).floatValue();
                double d10 = f9;
                builder.setDouble(11, d10);
                Range range = (Range)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
                double d11 = (float)((Integer)range.getLower()).intValue() * f9;
                double d12 = (float)((Integer)range.getUpper()).intValue() * f9;
                builder.setDouble(8, d11).setDouble(9, d12);
                if (VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION) != null) {
                    double d13 = (float)((Integer)VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION)).intValue() * f9;
                    builder.setDouble(10, d13);
                }
                int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES);
                arrayList = arrayList2;
                arrayList2 = new ArrayList<Integer>(1);
                n2 = nArray.length;
                boolean bl = false;
                while (var6_42 < n2) {
                    if (nArray[var6_42] == 1) {
                        arrayList.add(4);
                        break;
                    }
                    ++var6_42;
                }
                try {
                    if (!((Boolean)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_LOCK_AVAILABLE)).booleanValue()) break block48;
                    arrayList.add(2);
                }
                catch (NoSuchFieldError noSuchFieldError) {}
            }
            builder.setMeteringModeArray(2, VideoCapture.integerArrayListToArray(arrayList));
            int n14 = 1;
            if (VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.CONTROL_AWB_MODE) != null) {
                n14 = (Integer)VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.CONTROL_AWB_MODE);
                if (n14 == 0) {
                    builder.setMeteringMode(2, 1);
                } else {
                    int n15 = 2;
                    n2 = n14 == 1 ? 4 : 2;
                    builder.setMeteringMode(n15, n2);
                }
            }
            builder.setInt(12, COLOR_TEMPERATURES_MAP.keyAt(0)).setInt(13, COLOR_TEMPERATURES_MAP.keyAt(COLOR_TEMPERATURES_MAP.size() - 1)).setInt(15, 50);
            n14 = COLOR_TEMPERATURES_MAP.indexOfValue(n14);
            if (n14 >= 0) {
                builder.setInt(14, COLOR_TEMPERATURES_MAP.keyAt(n14));
            }
            if (!((Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE)).booleanValue()) {
                builder.setBool(0, false).setBool(2, false);
            } else {
                ArrayList<Integer> arrayList7;
                builder.setBool(0, true).setBool(2, true);
                if (VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.FLASH_MODE) != null) {
                    n14 = 1;
                    boolean bl = (Integer)VideoCaptureCamera2.this.mPreviewRequest.get(CaptureRequest.FLASH_MODE) == 2;
                    builder.setBool(n14, bl);
                }
                int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
                ArrayList<Integer> arrayList8 = arrayList7;
                arrayList7 = new ArrayList<Integer>(0);
                for (int n16 : nArray) {
                    if (n16 == 0) {
                        arrayList8.add(1);
                        continue;
                    }
                    if (n16 == 2) {
                        arrayList8.add(2);
                        continue;
                    }
                    if (n16 != 3) continue;
                    arrayList8.add(3);
                }
                builder.setFillLightModeArray(VideoCapture.integerArrayListToArray(arrayList8));
            }
            VideoCaptureCamera2 videoCaptureCamera2 = VideoCaptureCamera2.this;
            videoCaptureCamera2.nativeOnGetPhotoCapabilitiesReply(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid, this.mCallbackId, builder.build());
        }
    }

    public class StopCaptureTask
    implements Runnable {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public StopCaptureTask() {
        }

        public /* synthetic */ StopCaptureTask(1 var2_2) {
            this();
        }

        static {
            $assertionsDisabled = VideoCaptureCamera2.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public void run() {
            if (!$assertionsDisabled && VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            if (VideoCaptureCamera2.this.mCameraDevice == null) {
                return;
            }
            StopCaptureTask stopCaptureTask = this;
            stopCaptureTask.VideoCaptureCamera2.this.mCameraDevice.close();
            stopCaptureTask.VideoCaptureCamera2.this.changeCameraStateAndNotify(3);
            VideoCaptureCamera2.access$702(stopCaptureTask.VideoCaptureCamera2.this, new Rect());
        }
    }

    public class CrPhotoReaderListener
    implements ImageReader.OnImageAvailableListener {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final long mCallbackId;

        public CrPhotoReaderListener(long l2) {
            this.mCallbackId = l2;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private byte[] readCapturedData(Image object) {
            Object object2 = null;
            return object.getPlanes()[0].getBuffer().array();
            {
                byte[] byArray;
                catch (Throwable throwable) {
                    return object2;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                {
                    object = object.getPlanes()[0].getBuffer();
                }
                {
                    byArray = new byte[((Buffer)object).remaining()];
                }
                object2 = byArray;
                {
                    ((ByteBuffer)object).get((byte[])object2);
                }
                return byArray;
            }
        }

        static {
            $assertionsDisabled = VideoCaptureCamera2.class.desiredAssertionStatus() ^ true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onImageAvailable(ImageReader imageReader) {
            Throwable throwable2;
            block11: {
                ImageReader imageReader2;
                CrPhotoReaderListener crPhotoReaderListener;
                TraceEvent.instant("VideoCaptureCamera2.java", "CrPhotoReaderListener.onImageAvailable");
                if (!$assertionsDisabled) {
                    if (VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) throw new AssertionError((Object)"called on wrong thread");
                }
                imageReader = imageReader.acquireLatestImage();
                if (imageReader == null) throw new IllegalStateException();
                try {
                    if (imageReader.getFormat() != 256) break block11;
                    crPhotoReaderListener = this;
                    imageReader2 = imageReader;
                    CrPhotoReaderListener crPhotoReaderListener2 = this;
                    byte[] byArray = crPhotoReaderListener2.readCapturedData((Image)imageReader);
                    crPhotoReaderListener2.VideoCaptureCamera2.this.nativeOnPhotoTaken(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, this.mCallbackId, byArray);
                }
                catch (Throwable throwable2) {}
                imageReader2.close();
                crPhotoReaderListener.VideoCaptureCamera2.this.createPreviewObjectsAndStartPreviewOrFailWith(73);
                return;
            }
            Object[] objectArray = new Object[1];
            objectArray[0] = imageReader.getFormat();
            g.b(VideoCaptureCamera2.TAG, "Unexpected image format: %d", objectArray);
            throw new IllegalStateException();
            if (imageReader == null) throw throwable2;
            try {
                imageReader.close();
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
                catch (IllegalStateException illegalStateException) {
                    VideoCaptureCamera2.this.notifyTakePhotoError(this.mCallbackId);
                    return;
                }
            }
        }
    }

    public class CrPhotoSessionListener
    extends CameraCaptureSession.StateCallback {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final ImageReader mImageReader;
        public final CaptureRequest mPhotoRequest;
        public final long mCallbackId;

        public CrPhotoSessionListener(ImageReader imageReader, CaptureRequest captureRequest, long l2) {
            this.mImageReader = imageReader;
            this.mPhotoRequest = captureRequest;
            this.mCallbackId = l2;
        }

        static {
            $assertionsDisabled = VideoCaptureCamera2.class.desiredAssertionStatus() ^ true;
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            TraceEvent.instant("VideoCaptureCamera2.java", "CrPhotoSessionListener.onConfigured");
            if (!$assertionsDisabled && VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            g.a(VideoCaptureCamera2.TAG, "CrPhotoSessionListener.onConfigured");
            try {
                TraceEvent.instant("VideoCaptureCamera2.java", "Calling CameraCaptureSession.capture()");
                cameraCaptureSession.capture(this.mPhotoRequest, null, null);
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = illegalStateException;
                g.b(VideoCaptureCamera2.TAG, "capture() IllegalStateException", objectArray2);
                VideoCaptureCamera2.this.notifyTakePhotoError(this.mCallbackId);
                return;
            }
            catch (CameraAccessException cameraAccessException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = cameraAccessException;
                g.b(VideoCaptureCamera2.TAG, "capture() CameraAccessException", objectArray3);
                VideoCaptureCamera2.this.notifyTakePhotoError(this.mCallbackId);
                return;
            }
            return;
        }

        public void onConfigureFailed(CameraCaptureSession objectArray) {
            if (!$assertionsDisabled && VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            objectArray = new Object[]{};
            g.b(VideoCaptureCamera2.TAG, "failed configuring capture session", objectArray);
            VideoCaptureCamera2.this.notifyTakePhotoError(this.mCallbackId);
        }

        public void onClosed(CameraCaptureSession cameraCaptureSession) {
            this.mImageReader.close();
        }
    }

    public class CrPreviewReaderListener
    implements ImageReader.OnImageAvailableListener {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public CrPreviewReaderListener() {
        }

        public /* synthetic */ CrPreviewReaderListener(1 var2_2) {
            this();
        }

        static {
            $assertionsDisabled = VideoCaptureCamera2.class.desiredAssertionStatus() ^ true;
        }

        /*
         * Unable to fully structure code
         */
        public void onImageAvailable(ImageReader var1_3) {
            block19: {
                block18: {
                    if (!CrPreviewReaderListener.$assertionsDisabled && VideoCaptureCamera2.access$000(VideoCaptureCamera2.this).getLooper() != Looper.myLooper()) {
                        throw new AssertionError((Object)"called on wrong thread");
                    }
                    var2_4 = var1_3.acquireLatestImage();
                    if (var2_4 != null) break block18;
                    VideoCaptureCamera2.this.nativeOnFrameDropped(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, 9);
                    if (var2_4 == null) ** GOTO lbl11
                    var2_4.close();
lbl11:
                    // 2 sources

                    return;
                }
                if (var2_4.getFormat() != 35) ** GOTO lbl34
                if (var2_4.getPlanes().length != 3) ** GOTO lbl34
                if (var1_3.getWidth() != var2_4.getWidth()) break block19;
                if (var1_3.getHeight() != var2_4.getHeight()) break block19;
                v0 = var2_4;
                VideoCaptureCamera2.this.nativeOnI420FrameAvailable(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, var2_4.getPlanes()[0].getBuffer(), var2_4.getPlanes()[0].getRowStride(), var2_4.getPlanes()[1].getBuffer(), var2_4.getPlanes()[2].getBuffer(), var2_4.getPlanes()[1].getRowStride(), var2_4.getPlanes()[1].getPixelStride(), var2_4.getWidth(), var2_4.getHeight(), VideoCaptureCamera2.this.getCameraRotation(), var2_4.getTimestamp());
                v0.close();
            }
            v1 = VideoCaptureCamera2.this;
            v2 = VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid;
            v1.nativeOnError(v2, 72, "ImageReader size (" + var1_3.getWidth() + "x" + var1_3.getHeight() + ") did not match Image size (" + var2_4.getWidth() + "x" + var2_4.getHeight() + ")");
            throw new IllegalStateException();
lbl34:
            // 2 sources

            v3 = VideoCaptureCamera2.this;
            v4 = VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid;
            try {
                v3.nativeOnError(v4, 71, "Unexpected image format: " + var2_4.getFormat() + " or #planes: " + var2_4.getPlanes().length);
                throw new IllegalStateException();
            }
            catch (Throwable var0_1) {
                if (var2_4 == null) ** GOTO lbl47
                try {
                    var2_4.close();
                    ** GOTO lbl47
                }
                catch (Throwable v5) {
                    try {
                        var0_1.addSuppressed(v5);
lbl47:
                        // 3 sources

                        throw var0_1;
                    }
                    catch (IllegalStateException var0_2) {
                        v6 = new Object[1];
                        var1_3 = v6;
                        v6[0] = var0_2;
                        g.b("VideoCapture", "acquireLatestImage():", var1_3);
                    }
                }
            }
        }
    }

    public class CrPreviewSessionListener
    extends CameraCaptureSession.StateCallback {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final CaptureRequest mPreviewRequest;

        public CrPreviewSessionListener(CaptureRequest captureRequest) {
            this.mPreviewRequest = captureRequest;
        }

        static {
            $assertionsDisabled = VideoCaptureCamera2.class.desiredAssertionStatus() ^ true;
        }

        /*
         * WARNING - void declaration
         */
        public void onConfigured(CameraCaptureSession objectArray) {
            void var0_5;
            if (!$assertionsDisabled && VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            CrPreviewSessionListener crPreviewSessionListener = this;
            g.a(VideoCaptureCamera2.TAG, "CrPreviewSessionListener.onConfigured");
            VideoCaptureCamera2.access$502(crPreviewSessionListener.VideoCaptureCamera2.this, (CameraCaptureSession)objectArray);
            try {
                crPreviewSessionListener.VideoCaptureCamera2.this.mPreviewSession.setRepeatingRequest(this.mPreviewRequest, new CameraCaptureSession.CaptureCallback(){

                    public void onCaptureCompleted(CameraCaptureSession object, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
                        object = (Long)totalCaptureResult.get(CaptureResult.SENSOR_EXPOSURE_TIME);
                        if (object == null) {
                            return;
                        }
                        VideoCaptureCamera2.access$602(VideoCaptureCamera2.this, (Long)object);
                    }
                }, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException securityException) {
            }
            catch (CameraAccessException cameraAccessException) {
                // empty catch block
            }
            crPreviewSessionListener.VideoCaptureCamera2.this.changeCameraStateAndNotify(2);
            VideoCaptureCamera2 videoCaptureCamera2 = crPreviewSessionListener.VideoCaptureCamera2.this;
            videoCaptureCamera2.nativeOnStarted(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid);
            return;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = var0_5;
            g.b(VideoCaptureCamera2.TAG, "setRepeatingRequest: ", objectArray);
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            if (!$assertionsDisabled && VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            CrPreviewSessionListener crPreviewSessionListener = this;
            g.a(VideoCaptureCamera2.TAG, "CrPreviewSessionListener.onConfigureFailed");
            crPreviewSessionListener.VideoCaptureCamera2.this.changeCameraStateAndNotify(3);
            VideoCaptureCamera2.access$502(crPreviewSessionListener.VideoCaptureCamera2.this, null);
            VideoCaptureCamera2 videoCaptureCamera2 = crPreviewSessionListener.VideoCaptureCamera2.this;
            videoCaptureCamera2.nativeOnError(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid, 70, "Camera session configuration error");
        }

        public void onClosed(CameraCaptureSession cameraCaptureSession) {
            if (!$assertionsDisabled && VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            g.a(VideoCaptureCamera2.TAG, "CrPreviewSessionListener.onClosed");
            VideoCaptureCamera2.access$502(VideoCaptureCamera2.this, null);
        }
    }

    public class CrStateListener
    extends CameraDevice.StateCallback {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public CrStateListener() {
        }

        public /* synthetic */ CrStateListener(1 var2_2) {
            this();
        }

        static {
            $assertionsDisabled = VideoCaptureCamera2.class.desiredAssertionStatus() ^ true;
        }

        public void onOpened(CameraDevice cameraDevice) {
            if (!$assertionsDisabled && objectArray3.VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = objectArray3;
            Object[] objectArray3 = new Object[]{};
            g.b(VideoCaptureCamera2.TAG, "CameraDevice.StateCallback onOpened", objectArray3);
            VideoCaptureCamera2.access$102(objectArray.VideoCaptureCamera2.this, cameraDevice);
            objectArray2.VideoCaptureCamera2.this.mWaitForDeviceClosedConditionVariable.close();
            objectArray.VideoCaptureCamera2.this.changeCameraStateAndNotify(1);
            objectArray2.VideoCaptureCamera2.this.createPreviewObjectsAndStartPreviewOrFailWith(114);
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            if (!$assertionsDisabled && objectArray.VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            Object[] objectArray = new Object[]{};
            g.b(VideoCaptureCamera2.TAG, "cameraDevice was closed unexpectedly", objectArray);
            cameraDevice.close();
            VideoCaptureCamera2.access$102(objectArray.VideoCaptureCamera2.this, null);
            objectArray.VideoCaptureCamera2.this.changeCameraStateAndNotify(3);
        }

        public void onError(CameraDevice cameraDevice, int n2) {
            if (!$assertionsDisabled && objectArray2.VideoCaptureCamera2.this.mCameraThreadHandler.getLooper() != Looper.myLooper()) {
                throw new AssertionError((Object)"called on wrong thread");
            }
            Object[] objectArray = objectArray2;
            Object[] objectArray2 = new Object[]{};
            g.b(VideoCaptureCamera2.TAG, "cameraDevice encountered an error", objectArray2);
            cameraDevice.close();
            VideoCaptureCamera2.access$102(objectArray.VideoCaptureCamera2.this, null);
            objectArray.VideoCaptureCamera2.this.changeCameraStateAndNotify(3);
            VideoCaptureCamera2 videoCaptureCamera2 = objectArray2.VideoCaptureCamera2.this;
            videoCaptureCamera2.nativeOnError(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid, 69, a.a("Camera device error ").append(Integer.toString(n2)).toString());
        }

        public void onClosed(CameraDevice cameraDevice) {
            g.a(VideoCaptureCamera2.TAG, "cameraDevice closed");
            if (VideoCaptureCamera2.this.mPreviewSession != null) {
                VideoCaptureCamera2.access$502(VideoCaptureCamera2.this, null);
            }
            VideoCaptureCamera2.this.mWaitForDeviceClosedConditionVariable.open();
        }
    }
}

