/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.a.a.a.a;
import a.b.a.e;
import a.b.a.g;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Base64InputStream;
import android.view.Surface;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="media")
public class MediaPlayerBridge {
    public static final String TAG = "cr.media";
    public LoadDataUriTask mLoadDataUriTask;
    public MediaPlayer mPlayer;
    public long mNativeMediaPlayerBridge;

    public static MediaPlayerBridge create(long l2) {
        return new MediaPlayerBridge(l2);
    }

    public MediaPlayerBridge(long l2) {
        this.mNativeMediaPlayerBridge = l2;
    }

    public MediaPlayerBridge() {
    }

    private native void nativeOnDidSetDataUriDataSource(long var1, boolean var3);

    private void cancelLoadDataUriTask() {
        LoadDataUriTask loadDataUriTask = this.mLoadDataUriTask;
        if (loadDataUriTask != null) {
            loadDataUriTask.cancel(true);
            this.mLoadDataUriTask = null;
        }
    }

    public void destroy() {
        this.cancelLoadDataUriTask();
        this.mNativeMediaPlayerBridge = 0L;
    }

    public MediaPlayer getLocalPlayer() {
        if (this.mPlayer == null) {
            this.mPlayer = new MediaPlayer();
        }
        return this.mPlayer;
    }

    public void setSurface(Surface surface) {
        this.getLocalPlayer().setSurface(surface);
    }

    public boolean prepareAsync() {
        try {
            this.getLocalPlayer().prepareAsync();
            return true;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = exception;
            g.b(TAG, "Unable to prepare MediaPlayer.", objectArray2);
            return false;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray3 = objectArray;
            objectArray[0] = illegalStateException;
            g.b(TAG, "Unable to prepare MediaPlayer.", objectArray3);
            return false;
        }
    }

    public boolean isPlaying() {
        return this.getLocalPlayer().isPlaying();
    }

    public int getCurrentPosition() {
        return this.getLocalPlayer().getCurrentPosition();
    }

    public int getDuration() {
        return this.getLocalPlayer().getDuration();
    }

    public void release() {
        MediaPlayerBridge mediaPlayerBridge = this;
        mediaPlayerBridge.cancelLoadDataUriTask();
        mediaPlayerBridge.getLocalPlayer().release();
    }

    public void setVolume(double d2) {
        float f2 = (float)d2;
        this.getLocalPlayer().setVolume(f2, f2);
    }

    public void start() {
        this.getLocalPlayer().start();
    }

    public void pause() {
        this.getLocalPlayer().pause();
    }

    public void seekTo(int n2) {
        this.getLocalPlayer().seekTo(n2);
    }

    public boolean setDataSource(String string2, String string3, String string4, boolean bl) {
        HashMap<String, String> hashMap;
        string2 = Uri.parse((String)string2);
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        if (bl) {
            hashMap2.put("x-hide-urls-from-log", "true");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            hashMap2.put("Cookie", string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            hashMap2.put("UserInfo-Agent", string4);
        }
        if (Build.VERSION.SDK_INT > 19) {
            hashMap2.put("allow-cross-domain-redirect", "false");
        }
        try {
            this.getLocalPlayer().setDataSource(ContextUtils.getApplicationContext(), (Uri)string2, hashMap2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setDataSourceFromFd(int n2, long l2, long l3) {
        ParcelFileDescriptor parcelFileDescriptor;
        try {
            parcelFileDescriptor = ParcelFileDescriptor.adoptFd((int)n2);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{};
            g.b(TAG, "Failed to set data source from file descriptor: " + iOException, objectArray);
            return false;
        }
        this.getLocalPlayer().setDataSource(parcelFileDescriptor.getFileDescriptor(), l2, l3);
        parcelFileDescriptor.close();
        return true;
    }

    public boolean setDataUriDataSource(String string2) {
        this.cancelLoadDataUriTask();
        if (!string2.startsWith("data:")) {
            return false;
        }
        int n2 = string2.indexOf(44);
        if (n2 == -1) {
            return false;
        }
        String string3 = string2.substring(0, n2);
        string2 = string2.substring(n2 + 1);
        String[] stringArray = string3.substring(5).split(";");
        if (stringArray.length != 2) {
            return false;
        }
        if (!"base64".equals(stringArray[1])) {
            return false;
        }
        this.mLoadDataUriTask = new LoadDataUriTask(string2);
        this.mLoadDataUriTask.executeOnExecutor(a.b.a.q.a.THREAD_POOL_EXECUTOR);
        return true;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener onCompletionListener) {
        this.getLocalPlayer().setOnCompletionListener(onCompletionListener);
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener onErrorListener) {
        this.getLocalPlayer().setOnErrorListener(onErrorListener);
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener onPreparedListener) {
        this.getLocalPlayer().setOnPreparedListener(onPreparedListener);
    }

    public void setOnVideoSizeChangedListener(MediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener) {
        this.getLocalPlayer().setOnVideoSizeChangedListener(onVideoSizeChangedListener);
    }

    public AllowedOperations getAllowedOperations() {
        boolean bl;
        boolean bl2;
        block30: {
            boolean bl3;
            block26: {
                block29: {
                    int n2;
                    Method method;
                    Method method2;
                    block28: {
                        block27: {
                            Object object = ((MediaPlayerBridge)object).getLocalPlayer();
                            bl2 = true;
                            bl3 = true;
                            Class<?> clazz = object.getClass();
                            Class[] classArray = new Class[2];
                            classArray[0] = Boolean.TYPE;
                            classArray[1] = Boolean.TYPE;
                            Method method3 = clazz.getDeclaredMethod("getMetadata", classArray);
                            MediaPlayerBridge mediaPlayerBridge = object;
                            method3.setAccessible(true);
                            Object[] objectArray = new Object[2];
                            objectArray[0] = false;
                            objectArray[1] = false;
                            object = method3.invoke((Object)mediaPlayerBridge, objectArray);
                            if (object == null) break block26;
                            Class<?> clazz2 = object.getClass();
                            Class[] classArray2 = new Class[1];
                            classArray2[0] = Integer.TYPE;
                            method2 = clazz2.getDeclaredMethod("has", classArray2);
                            Class[] classArray3 = new Class[1];
                            classArray3[0] = Integer.TYPE;
                            method = clazz2.getDeclaredMethod("getBoolean", classArray3);
                            Method method4 = method2;
                            Class<?> clazz3 = clazz2;
                            Class<?> clazz4 = clazz3;
                            int n3 = (Integer)clazz3.getField("SEEK_FORWARD_AVAILABLE").get(null);
                            n2 = (Integer)clazz4.getField("SEEK_BACKWARD_AVAILABLE").get(null);
                            method4.setAccessible(true);
                            method.setAccessible(true);
                            Object[] objectArray2 = new Object[1];
                            objectArray2[0] = n3;
                            if (!((Boolean)method2.invoke(object, objectArray2)).booleanValue()) break block27;
                            Method method5 = method;
                            Object object2 = object;
                            Object[] objectArray3 = new Object[1];
                            objectArray3[0] = n3;
                            if (((Boolean)method5.invoke(object2, objectArray3)).booleanValue()) break block27;
                            bl2 = false;
                            break block28;
                        }
                        bl2 = true;
                    }
                    Method method6 = method2;
                    Object object = object;
                    Object[] objectArray = new Object[1];
                    objectArray[0] = n2;
                    if (!((Boolean)method6.invoke(object, objectArray)).booleanValue()) break block29;
                    Method method7 = method;
                    Object object3 = object;
                    Object[] objectArray4 = new Object[1];
                    try {
                        objectArray4[0] = n2;
                        if (((Boolean)method7.invoke(object3, objectArray4)).booleanValue()) break block29;
                        bl = false;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        Object[] objectArray5 = new Object[]{};
                        g.b(TAG, "Cannot find matching fields in Metadata class: " + noSuchFieldException, objectArray5);
                        bl = bl3;
                        break block30;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Object[] objectArray6 = new Object[]{};
                        g.b(TAG, "Cannot access metadata: " + illegalAccessException, objectArray6);
                        bl = bl3;
                        break block30;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Object[] objectArray7 = new Object[]{};
                        g.b(TAG, "Cannot invoke MediaPlayer.getMetadata() method: " + invocationTargetException, objectArray7);
                        bl = bl3;
                        break block30;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        Object[] objectArray8 = new Object[]{};
                        g.b(TAG, "Cannot find getMetadata() method: " + noSuchMethodException, objectArray8);
                        bl = bl3;
                    }
                }
                bl = true;
                break block30;
            }
            bl = bl3;
        }
        return new AllowedOperations(bl2, bl);
    }

    public static class AllowedOperations {
        public final boolean mCanSeekForward;
        public final boolean mCanSeekBackward;

        public AllowedOperations(boolean bl, boolean bl2) {
            this.mCanSeekForward = bl;
            this.mCanSeekBackward = bl2;
        }

        private boolean canSeekForward() {
            return this.mCanSeekForward;
        }

        private boolean canSeekBackward() {
            return this.mCanSeekBackward;
        }
    }

    public class LoadDataUriTask
    extends a.b.a.q.a<Boolean> {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final String mData;
        public File mTempFile;

        public LoadDataUriTask(String string2) {
            this.mData = string2;
        }

        private void deleteFile() {
            File file = objectArray.mTempFile;
            if (file == null) {
                return;
            }
            if (!file.delete()) {
                Object[] objectArray = new Object[]{};
                g.b(MediaPlayerBridge.TAG, a.a("Failed to delete temporary file: ").append(objectArray.mTempFile).toString(), objectArray);
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
        }

        static {
            $assertionsDisabled = MediaPlayerBridge.class.desiredAssertionStatus() ^ true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Boolean doInBackground() {
            block12: {
                var1_1 = null;
                this.mTempFile = File.createTempFile("decoded", "mediadata");
                var2_2 = v0;
                v0 = new FileOutputStream(this.mTempFile);
                var1_1 = v1;
                ** try [egrp 3[TRYBLOCK] [6, 7 : 30->43)] { 
lbl9:
                // 1 sources

                ** GOTO lbl29
lbl10:
                // 1 sources

                catch (IOException v2) {
                    ** GOTO lbl-1000
                }
lbl12:
                // 1 sources

                catch (Throwable v3) {
                    // empty catch block
                    break block12;
                }
lbl-1000:
                // 1 sources

                {
                    while (true) {
                        if ((var3_3 = this.read((byte[])var1_1)) == -1) ** GOTO lbl19
                        {
                            var2_2.write((byte[])var1_1, 0, var3_3);
                            continue;
lbl19:
                            // 1 sources

                            this.close();
                            v4 = true;
                        }
                        e.a(var2_2);
                        return v4;
                    }
                    catch (Throwable v3) {
                        var2_2 = var1_1;
                        break block12;
                    }
                    catch (IOException v5) {
                        var2_2 = var1_1;
                        ** GOTO lbl-1000
                    }
lbl29:
                    // 1 sources

                    v1 = new ByteArrayInputStream(a.b.a.a.a(this.mData));
                    this = v6;
                    v6 = new Base64InputStream((InputStream)var1_1, 0);
                    var1_1 = new byte[1024];
                    ** continue;
                }
lbl-1000:
                // 2 sources

                {
                    v7 = false;
                }
                e.a(var2_2);
                return v7;
            }
            e.a(var2_2);
            throw v3;
        }

        @Override
        public void onPostExecute(Boolean bl) {
            if (this.isCancelled()) {
                this.deleteFile();
                return;
            }
            if (bl.booleanValue()) {
                try {
                    MediaPlayerBridge.this.getLocalPlayer().setDataSource(ContextUtils.getApplicationContext(), Uri.fromFile((File)this.mTempFile));
                }
                catch (IOException iOException) {
                    bl = false;
                }
            }
            this.deleteFile();
            if (!$assertionsDisabled && MediaPlayerBridge.this.mNativeMediaPlayerBridge == 0L) {
                throw new AssertionError();
            }
            MediaPlayerBridge mediaPlayerBridge = MediaPlayerBridge.this;
            mediaPlayerBridge.nativeOnDidSetDataUriDataSource(mediaPlayerBridge.mNativeMediaPlayerBridge, bl);
        }
    }
}

