/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.a.a.a.a;
import a.b.a.g;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.DeniedByServerException;
import android.media.MediaCrypto;
import android.media.MediaCryptoException;
import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.media.NotProvisionedException;
import android.media.UnsupportedSchemeException;
import android.os.Build;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.chromium.base.Callback;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.media.MediaDrmSessionManager;
import org.chromium.media.MediaDrmStorageBridge;

@JNINamespace(value="media")
@MainDex
@SuppressLint(value={"WrongConstant"})
@TargetApi(value=19)
public class MediaDrmBridge {
    public static final String TAG = "cr_media";
    public static final String SECURITY_LEVEL = "securityLevel";
    public static final String SERVER_CERTIFICATE = "serviceCertificate";
    public static final String ORIGIN = "origin";
    public static final String PRIVACY_MODE = "privacyMode";
    public static final String SESSION_SHARING = "sessionSharing";
    public static final String ENABLE = "enable";
    public static final long INVALID_NATIVE_MEDIA_DRM_BRIDGE = 0L;
    public static final String FIRST_API_LEVEL = "ro.product.first_api_level";
    public static final UUID WIDEVINE_UUID;
    public static final byte[] DUMMY_KEY_ID;
    public static final byte[] UNPROVISION;
    public static final MediaCryptoDeferrer sMediaCryptoDeferrer;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public MediaDrm mMediaDrm;
    public MediaCrypto mMediaCrypto;
    public long mNativeMediaDrmBridge;
    public UUID mSchemeUUID;
    public final boolean mRequiresMediaCrypto;
    public MediaDrmSessionManager.SessionId mMediaCryptoSession;
    public MediaDrmSessionManager mSessionManager;
    public MediaDrmStorageBridge mStorage;
    public boolean mProvisioningPending;
    public boolean mOriginSet;
    public SessionEventDeferrer mSessionEventDeferrer;

    public static List<KeyStatus> getDummyKeysInfo(int n2) {
        ArrayList<KeyStatus> arrayList = new ArrayList<KeyStatus>();
        arrayList.add(new KeyStatus(DUMMY_KEY_ID, n2, null));
        return arrayList;
    }

    public static UUID getUUIDFromBytes(byte[] byArray) {
        int n2;
        if (byArray.length != 16) {
            return null;
        }
        long l2 = 0L;
        long l3 = 0L;
        for (n2 = 0; n2 < 8; ++n2) {
            l2 = l2 << 8 | (long)(byArray[n2] & 0xFF);
        }
        for (n2 = 8; n2 < 16; ++n2) {
            l3 = l3 << 8 | (long)(byArray[n2] & 0xFF);
        }
        return new UUID(l2, l3);
    }

    private boolean isNativeMediaDrmBridgeValid() {
        return this.mNativeMediaDrmBridge != 0L;
    }

    private boolean isWidevine() {
        return this.mSchemeUUID.equals(WIDEVINE_UUID);
    }

    @TargetApi(value=23)
    public MediaDrmBridge(UUID uUID, boolean bl, long l2, long l3) {
        MediaDrmBridge mediaDrmBridge = this;
        mediaDrmBridge.mSchemeUUID = uUID;
        mediaDrmBridge.mMediaDrm = new MediaDrm(uUID);
        this.mRequiresMediaCrypto = bl;
        this.mNativeMediaDrmBridge = l2;
        if (!$assertionsDisabled && !this.isNativeMediaDrmBridgeValid()) {
            throw new AssertionError();
        }
        this.mStorage = new MediaDrmStorageBridge(l3);
        this.mSessionManager = new MediaDrmSessionManager(this.mStorage);
        this.mProvisioningPending = false;
        this.mMediaDrm.setOnEventListener((MediaDrm.OnEventListener)new EventListener(null));
        if (Build.VERSION.SDK_INT >= 23) {
            MediaDrmBridge mediaDrmBridge2 = this;
            mediaDrmBridge2.mMediaDrm.setOnExpirationUpdateListener((MediaDrm.OnExpirationUpdateListener)new ExpirationUpdateListener(null), null);
            mediaDrmBridge2.mMediaDrm.setOnKeyStatusChangeListener((MediaDrm.OnKeyStatusChangeListener)new KeyStatusChangeListener(null), null);
        }
        if (this.isWidevine()) {
            MediaDrmBridge mediaDrmBridge3 = this;
            mediaDrmBridge3.mMediaDrm.setPropertyString(PRIVACY_MODE, ENABLE);
            mediaDrmBridge3.mMediaDrm.setPropertyString(SESSION_SHARING, ENABLE);
        }
    }

    private boolean createMediaCrypto() {
        block11: {
            Object object;
            block10: {
                if (!$assertionsDisabled && objectArray.mMediaDrm == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && objectArray.mProvisioningPending) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && objectArray.mMediaCryptoSession != null) {
                    throw new AssertionError();
                }
                try {
                    object = objectArray.openSession();
                    if (object != null) break block10;
                }
                catch (NotProvisionedException notProvisionedException) {
                    g.a(TAG, "Not provisioned during openSession()");
                    if (!sMediaCryptoDeferrer.isProvisioning()) {
                        super.startProvisioning();
                        return true;
                    }
                    g.a(TAG, "defer CreateMediaCrypto() calls");
                    sMediaCryptoDeferrer.defer(new Runnable(){

                        @Override
                        public void run() {
                            MediaDrmBridge.this.createMediaCrypto();
                        }
                    });
                    return true;
                }
                Object[] objectArray = new Object[]{};
                g.b(TAG, "Cannot create MediaCrypto Session.", objectArray);
                return false;
            }
            objectArray.mMediaCryptoSession = MediaDrmSessionManager.SessionId.createTemporarySessionId(object);
            object = objectArray.mMediaCryptoSession.toHexString();
            g.a(TAG, "MediaCrypto Session created: %s", object);
            if (!MediaCrypto.isCryptoSchemeSupported((UUID)objectArray.mSchemeUUID)) break block11;
            objectArray.mMediaCrypto = new MediaCrypto(objectArray.mSchemeUUID, objectArray.mMediaCryptoSession.drmId());
            g.a(TAG, "MediaCrypto successfully created!");
            super.onMediaCryptoReady(objectArray.mMediaCrypto);
            return true;
        }
        try {
            g.b(TAG, "Cannot create MediaCrypto for unsupported scheme.", new Object[0]);
        }
        catch (MediaCryptoException mediaCryptoException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = mediaCryptoException;
            g.b(TAG, "Cannot create MediaCrypto", objectArray2);
        }
        super.release();
        return false;
    }

    private byte[] openSession() {
        Object[] objectArray;
        if (!$assertionsDisabled && objectArray.mMediaDrm == null) {
            throw new AssertionError();
        }
        try {
            return (byte[])objectArray.mMediaDrm.openSession().clone();
        }
        catch (MediaDrmException mediaDrmException) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = mediaDrmException;
            g.b(TAG, "Cannot open a new session", objectArray);
            super.release();
            return null;
        }
        catch (NotProvisionedException notProvisionedException) {
            throw notProvisionedException;
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray4 = objectArray;
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = runtimeException;
            g.b(TAG, "Cannot open a new session", objectArray);
            super.release();
            return null;
        }
    }

    public static boolean isCryptoSchemeSupported(byte[] object, String string2) {
        object = MediaDrmBridge.getUUIDFromBytes(object);
        if (string2.isEmpty()) {
            return MediaDrm.isCryptoSchemeSupported((UUID)object);
        }
        return MediaDrm.isCryptoSchemeSupported((UUID)object, (String)string2);
    }

    public static int getFirstApiLevel() {
        int n2;
        Class<?> clazz = Class.forName("android.os.SystemProperties");
        Class[] classArray = new Class[2];
        classArray[0] = String.class;
        classArray[1] = Integer.TYPE;
        Method method = clazz.getMethod("getInt", classArray);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        objectArray[0] = FIRST_API_LEVEL;
        try {
            objectArray3[1] = 0;
            n2 = (Integer)method.invoke(null, objectArray2);
        }
        catch (Exception exception) {
            Object[] objectArray4 = new Object[1];
            Object[] objectArray5 = objectArray4;
            objectArray4[0] = exception;
            g.b("Exception while getting system property %s. Using default.", FIRST_API_LEVEL, objectArray5);
            n2 = 0;
        }
        return n2;
    }

    public static MediaDrmBridge create(byte[] object, String objectArray, String string2, boolean bl, long l2, long l3) {
        UUID uUID = MediaDrmBridge.getUUIDFromBytes(object);
        object = uUID;
        if (uUID != null && MediaDrm.isCryptoSchemeSupported((UUID)object)) {
            MediaDrmBridge mediaDrmBridge;
            String string3 = string2;
            MediaDrmBridge mediaDrmBridge2 = mediaDrmBridge;
            try {
                mediaDrmBridge = new MediaDrmBridge((UUID)object, bl, l2, l3);
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = illegalStateException;
                g.b(TAG, "Failed to create MediaDrmBridge", objectArray);
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = illegalArgumentException;
                g.b(TAG, "Failed to create MediaDrmBridge", objectArray);
                return null;
            }
            catch (UnsupportedSchemeException unsupportedSchemeException) {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = unsupportedSchemeException;
                g.b(TAG, "Unsupported DRM scheme", objectArray);
                return null;
            }
            if (!string3.isEmpty() && !mediaDrmBridge2.setSecurityLevel(string2)) {
                return null;
            }
            if (!objectArray.isEmpty() && !mediaDrmBridge2.setOrigin((String)objectArray)) {
                return null;
            }
            if (bl && !mediaDrmBridge2.createMediaCrypto()) {
                return null;
            }
            return mediaDrmBridge2;
        }
        return null;
    }

    private boolean setOrigin(String string2) {
        if (!$assertionsDisabled && Build.VERSION.SDK_INT < 23) {
            throw new AssertionError();
        }
        if (!this.isWidevine()) {
            g.a(TAG, "Property origin isn't supported");
            return true;
        }
        if (!$assertionsDisabled && this.mMediaDrm == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string2.isEmpty()) {
            throw new AssertionError();
        }
        try {
            this.mMediaDrm.setPropertyString(ORIGIN, string2);
            this.mOriginSet = true;
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = illegalStateException;
            g.b(TAG, "Failed to set security origin %s", objectArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = illegalArgumentException;
            g.b(TAG, "Failed to set security origin %s", objectArray3);
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray4 = objectArray;
        objectArray[0] = string2;
        g.b(TAG, "Security origin %s not supported!", objectArray4);
        return false;
    }

    private boolean setSecurityLevel(String string2) {
        if (!this.isWidevine()) {
            g.a(TAG, "Security level is not supported.");
            return true;
        }
        if (!$assertionsDisabled && this.mMediaDrm == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string2.isEmpty()) {
            throw new AssertionError();
        }
        Object[] objectArray = this.mMediaDrm.getPropertyString(SECURITY_LEVEL);
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = objectArray;
        objectArray2[1] = string2;
        g.c(TAG, "Security level: current %s, new %s", objectArray3);
        if (string2.equals(objectArray)) {
            return true;
        }
        try {
            this.mMediaDrm.setPropertyString(SECURITY_LEVEL, string2);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray4 = new Object[2];
            objectArray = objectArray4;
            objectArray4[0] = string2;
            objectArray4[1] = illegalStateException;
            g.b(TAG, "Failed to set security level %s", objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray5 = new Object[2];
            objectArray = objectArray5;
            objectArray5[0] = string2;
            objectArray5[1] = illegalArgumentException;
            g.b(TAG, "Failed to set security level %s", objectArray);
        }
        Object[] objectArray6 = new Object[1];
        Object[] objectArray7 = objectArray6;
        objectArray6[0] = string2;
        g.b(TAG, "Security level %s not supported!", objectArray7);
        return false;
    }

    private boolean setServerCertificate(byte[] objectArray) {
        if (!this.isWidevine()) {
            g.a(TAG, "Setting server certificate is not supported.");
            return true;
        }
        try {
            this.mMediaDrm.setPropertyByteArray(SERVER_CERTIFICATE, objectArray);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = illegalStateException;
            g.b(TAG, "Failed to set server certificate", objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = illegalArgumentException;
            g.b(TAG, "Failed to set server certificate", objectArray);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void provision() {
        if (!$assertionsDisabled) {
            if (objectArray.mMediaDrm == null) throw new AssertionError();
        }
        if (!$assertionsDisabled) {
            if (objectArray.mProvisioningPending) throw new AssertionError();
        }
        if (!$assertionsDisabled) {
            if (objectArray.mRequiresMediaCrypto) throw new AssertionError();
        }
        if (!objectArray.mOriginSet) {
            Object[] objectArray = new Object[]{};
            g.b(TAG, "Calling provision() without an origin.", objectArray);
            super.nativeOnProvisioningComplete(objectArray.mNativeMediaDrmBridge, false);
            return;
        }
        try {
            byte[] byArray = objectArray.openSession();
            if (byArray != null) {
                super.closeSessionNoException(MediaDrmSessionManager.SessionId.createTemporarySessionId(byArray));
            }
            super.nativeOnProvisioningComplete(objectArray.mNativeMediaDrmBridge, true);
            return;
        }
        catch (NotProvisionedException notProvisionedException) {
            super.startProvisioning();
        }
    }

    private void unprovision() {
        if (this.mMediaDrm == null) {
            return;
        }
        if (!this.mOriginSet) {
            return;
        }
        this.provideProvisionResponse(UNPROVISION);
    }

    private void destroy() {
        this.mNativeMediaDrmBridge = 0L;
        if (this.mMediaDrm != null) {
            this.release();
        }
    }

    private void release() {
        if (!$assertionsDisabled && this.mMediaDrm == null) {
            throw new AssertionError();
        }
        for (MediaDrmSessionManager.SessionId sessionId : this.mSessionManager.getAllSessionIds()) {
            try {
                this.mMediaDrm.removeKeys(sessionId.drmId());
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = exception;
                g.b(TAG, "removeKeys failed: ", objectArray2);
            }
            this.closeSessionNoException(sessionId);
            this.onSessionClosed(sessionId);
        }
        this.mSessionManager = new MediaDrmSessionManager(this.mStorage);
        Object object = this.mMediaCryptoSession;
        if (object != null) {
            this.closeSessionNoException((MediaDrmSessionManager.SessionId)object);
            this.mMediaCryptoSession = null;
        }
        if ((object = this.mMediaDrm) != null) {
            object.release();
            this.mMediaDrm = null;
        }
        if ((object = this.mMediaCrypto) != null) {
            object.release();
            this.mMediaCrypto = null;
        } else {
            this.onMediaCryptoReady(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private MediaDrm.KeyRequest getKeyRequest(MediaDrmSessionManager.SessionId var1_2, byte[] var2_3, String var3_4, int var4_5, HashMap<String, String> var5_6) {
        block9: {
            block10: {
                if (!MediaDrmBridge.$assertionsDisabled && this.mMediaDrm == null) {
                    throw new AssertionError();
                }
                if (!MediaDrmBridge.$assertionsDisabled && this.mMediaCryptoSession == null) {
                    throw new AssertionError();
                }
                if (!MediaDrmBridge.$assertionsDisabled && this.mProvisioningPending) {
                    throw new AssertionError();
                }
                if (var5_6 == null) {
                    var5_6 = v0;
                    v0 = new HashMap<K, V>();
                }
                var6_7 = null;
                if (var4_5 != 3) break block10;
                v1 = var1_2.keySetId();
lbl14:
                // 2 sources

                while (true) {
                    var1_2 = v1;
                    ** GOTO lbl21
                    break;
                }
            }
            v1 = var1_2.drmId();
            ** continue;
lbl21:
            // 1 sources

            if (MediaDrmBridge.$assertionsDisabled || var1_2 != null) ** GOTO lbl24
            try {
                throw new AssertionError();
lbl24:
                // 1 sources

                var6_7 = this.mMediaDrm.getKeyRequest((byte[])var1_2, var2_3, var3_4, var4_5, var5_6);
            }
            catch (IllegalStateException var0_1) {
                if (Build.VERSION.SDK_INT < 21 || !(var0_1 instanceof MediaDrm.MediaDrmStateException)) break block9;
                v2 = new Object[1];
                var1_2 = v2;
                v2[0] = var0_1;
                g.b("cr_media", "MediaDrmStateException fired during getKeyRequest().", var1_2);
            }
        }
        this = var6_7 != null ? "successed" : "failed";
        g.a("cr_media", "getKeyRequest %s!", (Object)this);
        return var6_7;
    }

    private void createSessionFromNative(byte[] byArray, String string2, int n2, String[] stringArray, long l2) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        if (stringArray != null) {
            if (stringArray.length % 2 == 0) {
                for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
                    hashMap2.put(stringArray[i2], stringArray[i2 + 1]);
                }
            } else {
                throw new IllegalArgumentException("Additional data array doesn't have equal keys/values");
            }
        }
        this.createSession(byArray, string2, n2, hashMap2, l2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSession(byte[] object, String objectArray, int n2, HashMap<String, String> hashMap, long l2) {
        Object[] objectArray2;
        MediaDrm.KeyRequest keyRequest;
        void var3_6;
        MediaDrmSessionManager.SessionId sessionId;
        boolean bl;
        void var5_8;
        block11: {
            void var4_7;
            g.a(TAG, "createSession()");
            if (objectArray4.mMediaDrm == null) {
                Object[] objectArray3 = objectArray4;
                Object[] objectArray4 = new Object[]{};
                g.b(TAG, "createSession() called when MediaDrm is null.", objectArray4);
                super.onPromiseRejected((long)var5_8, "MediaDrm released previously.");
                return;
            }
            if (!$assertionsDisabled) {
                if (objectArray4.mMediaCryptoSession == null) throw new AssertionError();
            }
            if (!$assertionsDisabled) {
                if (objectArray4.mProvisioningPending) throw new AssertionError();
            }
            bl = false;
            sessionId = null;
            byte[] byArray = super.openSession();
            if (byArray == null) {
                super.onPromiseRejected((long)var5_8, "Open session failed.");
                return;
            }
            bl = true;
            if (!$assertionsDisabled && var3_6 != true) {
                if (var3_6 != 2) throw new AssertionError();
            }
            if ((keyRequest = super.getKeyRequest(sessionId = var3_6 == 2 ? MediaDrmSessionManager.SessionId.createPersistentSessionId(byArray) : MediaDrmSessionManager.SessionId.createTemporarySessionId(byArray), (byte[])object, (String)objectArray2, (int)var3_6, (HashMap<String, String>)var4_7)) != null) break block11;
            super.closeSessionNoException(sessionId);
            super.onPromiseRejected((long)var5_8, "Generate request failed.");
            return;
        }
        try {
            g.a(TAG, "createSession(): Session (%s) created.", (Object)sessionId.toHexString());
            super.onPromiseResolvedWithSession((long)var5_8, sessionId);
            super.onSessionMessage(sessionId, keyRequest);
            objectArray4.mSessionManager.put(sessionId, (String)objectArray2, (int)var3_6);
            return;
        }
        catch (NotProvisionedException notProvisionedException) {
            Object[] objectArray5 = new Object[1];
            objectArray2 = objectArray5;
            objectArray5[0] = notProvisionedException;
            g.b(TAG, "Device not provisioned", objectArray2);
            if (bl) {
                super.closeSessionNoException(sessionId);
            }
            super.onPromiseRejected((long)var5_8, "Device not provisioned during createSession().");
        }
    }

    private MediaDrmSessionManager.SessionId getSessionIdByEmeId(byte[] object) {
        if (objectArray.mMediaCryptoSession == null) {
            Object[] objectArray = new Object[]{};
            g.b(TAG, "Session doesn't exist because media crypto session is not created.", objectArray);
            return null;
        }
        MediaDrmSessionManager.SessionId sessionId = objectArray.mSessionManager.getSessionIdByEmeId((byte[])object);
        object = sessionId;
        if (sessionId == null) {
            return null;
        }
        if (!$assertionsDisabled && objectArray.mMediaCryptoSession.isEqual((MediaDrmSessionManager.SessionId)object)) {
            throw new AssertionError();
        }
        return object;
    }

    private MediaDrmSessionManager.SessionId getSessionIdByDrmId(byte[] object) {
        if (objectArray.mMediaCryptoSession == null) {
            Object[] objectArray = new Object[]{};
            g.b(TAG, "Session doesn't exist because media crypto session is not created.", objectArray);
            return null;
        }
        MediaDrmSessionManager.SessionId sessionId = objectArray.mSessionManager.getSessionIdByDrmId((byte[])object);
        object = sessionId;
        if (sessionId == null) {
            return null;
        }
        if (!$assertionsDisabled && objectArray.mMediaCryptoSession.isEqual((MediaDrmSessionManager.SessionId)object)) {
            throw new AssertionError();
        }
        return object;
    }

    private void closeSession(byte[] byArray, long l2) {
        g.a(TAG, "closeSession()");
        if (((MediaDrmBridge)((Object)string2)).mMediaDrm == null) {
            ((MediaDrmBridge)((Object)string2)).onPromiseRejected(l2, "closeSession() called when MediaDrm is null.");
            return;
        }
        MediaDrmSessionManager.SessionId sessionId = ((MediaDrmBridge)((Object)string2)).getSessionIdByEmeId(byArray);
        if (sessionId == null) {
            ((MediaDrmBridge)((Object)string2)).onPromiseRejected(l2, a.a("Invalid sessionId in closeSession(): ").append(MediaDrmSessionManager.SessionId.toHexString(byArray)).toString());
            return;
        }
        try {
            ((MediaDrmBridge)((Object)string2)).mMediaDrm.removeKeys(sessionId.drmId());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = exception;
            g.b(TAG, "removeKeys failed: ", objectArray2);
        }
        MediaDrmBridge mediaDrmBridge = string2;
        mediaDrmBridge.closeSessionNoException(sessionId);
        mediaDrmBridge.mSessionManager.remove(sessionId);
        ((MediaDrmBridge)((Object)string2)).onPromiseResolved(l2);
        ((MediaDrmBridge)((Object)string2)).onSessionClosed(sessionId);
        String string2 = sessionId.toHexString();
        g.a(TAG, "Session %s closed", (Object)string2);
    }

    private void closeSessionNoException(MediaDrmSessionManager.SessionId objectArray) {
        try {
            this.mMediaDrm.closeSession(objectArray.drmId());
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = exception;
            g.b(TAG, "closeSession failed: ", objectArray);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateSession(byte[] var1_1, byte[] var2_5, long var3_6) {
        block19: {
            block17: {
                g.a("cr_media", "updateSession()");
                if (this.mMediaDrm == null) {
                    this.onPromiseRejected(var3_6, "updateSession() called when MediaDrm is null.");
                    return;
                }
                var5_7 = this.getSessionIdByEmeId((byte[])var1_1);
                if (var5_7 == null) {
                    if (MediaDrmBridge.$assertionsDisabled) {
                        this.onPromiseRejected(var3_6, a.a("Invalid session in updateSession: ").append(MediaDrmSessionManager.SessionId.toHexString((byte[])var1_1)).toString());
                        return;
                    }
                    throw new AssertionError();
                }
                v0 = this.mSessionManager.get(var5_7);
                var1_1 = v0;
                var6_8 = v0.keyType() == 3;
                var7_9 = null;
                if (!var6_8) break block17;
                g.a("cr_media", "updateSession() for key release");
                if (MediaDrmBridge.$assertionsDisabled) ** GOTO lbl25
                if (var5_7.keySetId() != null) ** GOTO lbl25
                throw new AssertionError();
lbl25:
                // 2 sources

                this.mMediaDrm.provideKeyResponse(var5_7.keySetId(), (byte[])var2_5);
                break block19;
            }
            var7_9 = this.mMediaDrm.provideKeyResponse(var5_7.drmId(), (byte[])var2_5);
        }
        v1 = var6_8;
        var2_5 = v2;
        v2 = new KeyUpdatedCallback(var5_7, var3_6, var6_8);
        if (!v1) ** GOTO lbl41
        this.mSessionManager.clearPersistentSessionInfo(var5_7, (Callback<Boolean>)var2_5);
        ** GOTO lbl48
lbl41:
        // 1 sources

        if (var1_1.keyType() != 2 || var7_9 == null) ** GOTO lbl47
        if (var7_9.length <= 0) ** GOTO lbl47
        try {
            block20: {
                this.mSessionManager.setKeySetId(var5_7, var7_9, (Callback<Boolean>)var2_5);
                break block20;
lbl47:
                // 2 sources

                var2_5.onResult(true);
            }
            return;
        }
        catch (IllegalStateException var1_2) {
            v3 = new Object[1];
            var2_5 = v3;
            v3[0] = var1_2;
            g.b("cr_media", "failed to provide key response", (Object[])var2_5);
        }
        catch (DeniedByServerException var1_3) {
            v4 = new Object[1];
            var2_5 = v4;
            v4[0] = var1_3;
            g.b("cr_media", "failed to provide key response", (Object[])var2_5);
        }
        catch (NotProvisionedException var1_4) {
            v5 = new Object[1];
            var2_5 = v5;
            v5[0] = var1_4;
            g.b("cr_media", "failed to provide key response", (Object[])var2_5);
        }
        v6 = this;
        v6.onPromiseRejected(var3_6, "Update session failed.");
        v6.release();
    }

    @TargetApi(value=23)
    private void loadSession(byte[] byArray, final long l2) {
        g.a(TAG, "loadSession()");
        if (!$assertionsDisabled && this.mProvisioningPending) {
            throw new AssertionError();
        }
        this.mSessionManager.load(byArray, new Callback<MediaDrmSessionManager.SessionId>(){

            @Override
            public void onResult(MediaDrmSessionManager.SessionId sessionId) {
                if (sessionId == null) {
                    MediaDrmBridge.this.onPersistentLicenseNoExist(l2);
                    return;
                }
                MediaDrmBridge.this.loadSessionWithLoadedStorage(sessionId, l2);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=23)
    private void loadSessionWithLoadedStorage(MediaDrmSessionManager.SessionId sessionId, long l2) {
        Object object = objectArray2.openSession();
        if (object == null) {
            super.onPromiseRejected(l2, "Failed to open session to load license.");
            return;
        }
        objectArray2.mSessionManager.setDrmId(sessionId, (byte[])object);
        if (!$assertionsDisabled) {
            if (!Arrays.equals(sessionId.drmId(), (byte[])object)) throw new AssertionError();
        }
        MediaDrmSessionManager.SessionInfo sessionInfo = objectArray2.mSessionManager.get(sessionId);
        object = sessionInfo;
        try {
            if (sessionInfo.keyType() == 3) {
                g.d(TAG, "Persistent license is waiting for release ack.", new Object[0]);
                super.onPromiseResolvedWithSession(l2, sessionId);
                super.onSessionKeysChange(sessionId, MediaDrmBridge.getDummyKeysInfo(1).toArray(), false, true);
                return;
            }
            if (!$assertionsDisabled) {
                if (((MediaDrmSessionManager.SessionInfo)object).keyType() != 2) throw new AssertionError();
            }
            if (!$assertionsDisabled) {
                if (objectArray2.mSessionEventDeferrer != null) throw new AssertionError();
            }
            objectArray2.mSessionEventDeferrer = new SessionEventDeferrer(sessionId);
            if (!$assertionsDisabled) {
                if (sessionId.keySetId() == null) throw new AssertionError();
            }
            Object[] objectArray = objectArray2;
            objectArray2.mMediaDrm.restoreKeys(sessionId.drmId(), sessionId.keySetId());
            super.onPromiseResolvedWithSession(l2, sessionId);
            objectArray.mSessionEventDeferrer.fire();
            objectArray2.mSessionEventDeferrer = null;
            return;
        }
        catch (IllegalStateException illegalStateException) {
            if (!$assertionsDisabled) {
                if (sessionId.drmId() == null) throw new AssertionError();
            }
            objectArray2.onPersistentLicenseLoadFail(sessionId, l2);
            return;
        }
        catch (NotProvisionedException notProvisionedException) {
            Object[] objectArray = objectArray2;
            Object[] objectArray2 = new Object[]{};
            g.d(TAG, "Persistent license load fail because origin isn't provisioned.", objectArray2);
            super.onPersistentLicenseLoadFail(sessionId, l2);
        }
    }

    private void onPersistentLicenseNoExist(long l2) {
        this.onPromiseResolvedWithSession(l2, MediaDrmSessionManager.SessionId.createNoExistSessionId());
    }

    private void onPersistentLicenseLoadFail(MediaDrmSessionManager.SessionId sessionId, final long l2) {
        MediaDrmBridge mediaDrmBridge = this;
        mediaDrmBridge.closeSessionNoException(sessionId);
        mediaDrmBridge.mSessionManager.clearPersistentSessionInfo(sessionId, new Callback<Boolean>(){

            @Override
            public void onResult(Boolean objectArray) {
                if (!objectArray.booleanValue()) {
                    objectArray = new Object[]{};
                    g.d(MediaDrmBridge.TAG, "Failed to clear persistent storage for non-exist license", objectArray);
                }
                MediaDrmBridge.this.onPersistentLicenseNoExist(l2);
            }
        });
    }

    private void removeSession(byte[] object, final long l2) {
        Callback<Boolean> callback;
        g.a(TAG, "removeSession()");
        MediaDrmSessionManager.SessionId sessionId = this.getSessionIdByEmeId((byte[])object);
        object = sessionId;
        if (sessionId == null) {
            this.onPromiseRejected(l2, "Session doesn't exist");
            return;
        }
        MediaDrmSessionManager.SessionInfo sessionInfo = this.mSessionManager.get((MediaDrmSessionManager.SessionId)object);
        if (sessionInfo.keyType() == 1) {
            this.onPromiseRejected(l2, "Removing temporary session isn't implemented");
            return;
        }
        if (!$assertionsDisabled && ((MediaDrmSessionManager.SessionId)object).keySetId() == null) {
            throw new AssertionError();
        }
        Callback<Boolean> callback2 = callback;
        callback = new Callback<Boolean>((MediaDrmSessionManager.SessionId)object, sessionInfo){
            public final /* synthetic */ MediaDrmSessionManager.SessionId val$sessionId;
            public final /* synthetic */ MediaDrmSessionManager.SessionInfo val$sessionInfo;
            {
                this.val$sessionId = sessionId;
                this.val$sessionInfo = sessionInfo;
            }

            @Override
            public void onResult(Boolean bl) {
                if (!bl.booleanValue()) {
                    MediaDrmBridge.this.onPromiseRejected(l2, "Fail to update persistent storage");
                    return;
                }
                MediaDrmBridge.this.doRemoveSession(this.val$sessionId, this.val$sessionInfo.mimeType(), l2);
            }
        };
        this.mSessionManager.setKeyType((MediaDrmSessionManager.SessionId)object, 3, callback2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRemoveSession(MediaDrmSessionManager.SessionId sessionId, String string2, long l2) {
        try {
            string2 = objectArray2.getKeyRequest(sessionId, null, string2, 3, null);
            if (string2 == null) {
                super.onPromiseRejected(l2, "Fail to generate key release request");
                return;
            }
            super.onPromiseResolved(l2);
            super.onSessionMessage(sessionId, (MediaDrm.KeyRequest)string2);
            return;
        }
        catch (NotProvisionedException notProvisionedException) {
            Object[] objectArray = objectArray2;
            Object[] objectArray2 = new Object[]{};
            g.b(TAG, "removeSession called on unprovisioned device", objectArray2);
            super.onPromiseRejected(l2, "Unknown failure");
        }
    }

    private String getSecurityLevel() {
        if (objectArray.mMediaDrm != null && objectArray.isWidevine()) {
            return objectArray.mMediaDrm.getPropertyString(SECURITY_LEVEL);
        }
        Object[] objectArray = new Object[]{};
        g.b(TAG, "getSecurityLevel(): MediaDrm is null or security level is not supported.", objectArray);
        return "";
    }

    private void startProvisioning() {
        g.a(TAG, "startProvisioning");
        if (!$assertionsDisabled && mediaDrmBridge2.mProvisioningPending) {
            throw new AssertionError();
        }
        mediaDrmBridge2.mProvisioningPending = true;
        if (!$assertionsDisabled && mediaDrmBridge2.mMediaDrm == null) {
            throw new AssertionError();
        }
        if (!mediaDrmBridge2.isNativeMediaDrmBridgeValid()) {
            return;
        }
        if (mediaDrmBridge2.mRequiresMediaCrypto) {
            sMediaCryptoDeferrer.onProvisionStarted();
        }
        MediaDrmBridge mediaDrmBridge = mediaDrmBridge2;
        MediaDrmBridge mediaDrmBridge2 = mediaDrmBridge.mMediaDrm.getProvisionRequest();
        mediaDrmBridge.nativeOnProvisionRequest(mediaDrmBridge.mNativeMediaDrmBridge, mediaDrmBridge2.getDefaultUrl(), mediaDrmBridge2.getData());
    }

    private void processProvisionResponse(boolean bl, byte[] byArray) {
        g.a(TAG, "processProvisionResponse()");
        if (!$assertionsDisabled && this.mMediaCryptoSession != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.mProvisioningPending) {
            throw new AssertionError();
        }
        this.mProvisioningPending = false;
        boolean bl2 = false;
        bl = this.mMediaDrm != null ? (bl ? this.provideProvisionResponse(byArray) : false) : bl2;
        MediaDrmBridge mediaDrmBridge = this;
        mediaDrmBridge.onProvisioned(bl);
        if (mediaDrmBridge.mRequiresMediaCrypto) {
            sMediaCryptoDeferrer.onProvisionDone();
        }
    }

    private void deferEventHandleIfNeeded(MediaDrmSessionManager.SessionId sessionId, Runnable runnable) {
        SessionEventDeferrer sessionEventDeferrer = this.mSessionEventDeferrer;
        if (sessionEventDeferrer != null && sessionEventDeferrer.shouldDefer(sessionId)) {
            this.mSessionEventDeferrer.defer(runnable);
            return;
        }
        runnable.run();
    }

    private void onMediaCryptoReady(MediaCrypto mediaCrypto) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnMediaCryptoReady(mediaDrmBridge.mNativeMediaDrmBridge, mediaCrypto);
        }
    }

    private void onPromiseResolved(long l2) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnPromiseResolved(mediaDrmBridge.mNativeMediaDrmBridge, l2);
        }
    }

    private void onPromiseResolvedWithSession(long l2, MediaDrmSessionManager.SessionId sessionId) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnPromiseResolvedWithSession(mediaDrmBridge.mNativeMediaDrmBridge, l2, sessionId.emeId());
        }
    }

    private void onPromiseRejected(long l2, String string2) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        g.b(TAG, "onPromiseRejected: %s", objectArray2);
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnPromiseRejected(mediaDrmBridge.mNativeMediaDrmBridge, l2, string2);
        }
    }

    @TargetApi(value=23)
    private void onSessionMessage(MediaDrmSessionManager.SessionId sessionId, MediaDrm.KeyRequest keyRequest) {
        if (!this.isNativeMediaDrmBridgeValid()) {
            return;
        }
        int n2 = Build.VERSION.SDK_INT >= 23 ? keyRequest.getRequestType() : keyRequest.getDefaultUrl().isEmpty() ^ 1;
        MediaDrmBridge mediaDrmBridge = this;
        mediaDrmBridge.nativeOnSessionMessage(mediaDrmBridge.mNativeMediaDrmBridge, sessionId.emeId(), n2, keyRequest.getData());
    }

    private void onSessionClosed(MediaDrmSessionManager.SessionId sessionId) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnSessionClosed(mediaDrmBridge.mNativeMediaDrmBridge, sessionId.emeId());
        }
    }

    private void onSessionKeysChange(MediaDrmSessionManager.SessionId sessionId, Object[] objectArray, boolean bl, boolean bl2) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnSessionKeysChange(mediaDrmBridge.mNativeMediaDrmBridge, sessionId.emeId(), objectArray, bl, bl2);
        }
    }

    private void onSessionExpirationUpdate(MediaDrmSessionManager.SessionId sessionId, long l2) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnSessionExpirationUpdate(mediaDrmBridge.mNativeMediaDrmBridge, sessionId.emeId(), l2);
        }
    }

    private native void nativeOnMediaCryptoReady(long var1, MediaCrypto var3);

    private native void nativeOnProvisionRequest(long var1, String var3, byte[] var4);

    private native void nativeOnProvisioningComplete(long var1, boolean var3);

    private native void nativeOnPromiseResolved(long var1, long var3);

    private native void nativeOnPromiseResolvedWithSession(long var1, long var3, byte[] var5);

    private native void nativeOnPromiseRejected(long var1, long var3, String var5);

    private native void nativeOnSessionMessage(long var1, byte[] var3, int var4, byte[] var5);

    private native void nativeOnSessionClosed(long var1, byte[] var3);

    private native void nativeOnSessionKeysChange(long var1, byte[] var3, Object[] var4, boolean var5, boolean var6);

    private native void nativeOnSessionExpirationUpdate(long var1, byte[] var3, long var4);

    static {
        $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
        WIDEVINE_UUID = UUID.fromString("edef8ba9-79d6-4ace-a3c8-27dcd51d21ed");
        DUMMY_KEY_ID = new byte[]{0};
        UNPROVISION = a.b.a.a.a("unprovision");
        sMediaCryptoDeferrer = new MediaCryptoDeferrer();
    }

    public boolean provideProvisionResponse(byte[] objectArray) {
        if (objectArray != null && objectArray.length != 0) {
            try {
                objectArray4.mMediaDrm.provideProvisionResponse(objectArray);
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = illegalStateException;
                g.b(TAG, "failed to provide provision response", objectArray);
            }
            catch (DeniedByServerException deniedByServerException) {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = deniedByServerException;
                g.b(TAG, "failed to provide provision response", objectArray);
            }
            return false;
        }
        Object[] objectArray4 = new Object[]{};
        g.b(TAG, "Invalid provision response.", objectArray4);
        return false;
    }

    public void onProvisioned(boolean bl) {
        if (!this.mRequiresMediaCrypto) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnProvisioningComplete(mediaDrmBridge.mNativeMediaDrmBridge, bl);
            if (!bl) {
                this.release();
            }
            return;
        }
        if (!bl) {
            this.release();
            return;
        }
        if (!this.mOriginSet) {
            this.createMediaCrypto();
            return;
        }
        this.mStorage.onProvisioned(new Callback<Boolean>(){
            public static final /* synthetic */ boolean $assertionsDisabled;

            static {
                $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
            }

            @Override
            public void onResult(Boolean bl) {
                if (!$assertionsDisabled && objectArray2.MediaDrmBridge.this.mMediaCryptoSession != null) {
                    throw new AssertionError();
                }
                if (!bl.booleanValue()) {
                    Object[] objectArray = objectArray2;
                    Object[] objectArray2 = new Object[]{};
                    g.b(MediaDrmBridge.TAG, "Failed to initialize storage for origin", objectArray2);
                    objectArray.MediaDrmBridge.this.release();
                    return;
                }
                objectArray2.MediaDrmBridge.this.createMediaCrypto();
            }
        });
    }

    @MainDex
    public class KeyUpdatedCallback
    implements Callback<Boolean> {
        public final MediaDrmSessionManager.SessionId mSessionId;
        public final long mPromiseId;
        public final boolean mIsKeyRelease;

        public KeyUpdatedCallback(MediaDrmSessionManager.SessionId sessionId, long l2, boolean bl) {
            this.mSessionId = sessionId;
            this.mPromiseId = l2;
            this.mIsKeyRelease = bl;
        }

        @Override
        public void onResult(Boolean object) {
            if (!((Boolean)object).booleanValue()) {
                MediaDrmBridge.this.onPromiseRejected(this.mPromiseId, "failed to update key after response accepted");
                return;
            }
            object = MediaDrmBridge.TAG;
            String string2 = "Key successfully %s for session %s";
            String string3 = this.mIsKeyRelease ? "released" : "added";
            KeyUpdatedCallback keyUpdatedCallback = this;
            g.a((String)object, string2, (Object)string3, (Object)this.mSessionId.toHexString());
            keyUpdatedCallback.MediaDrmBridge.this.onPromiseResolved(this.mPromiseId);
            if (!keyUpdatedCallback.mIsKeyRelease && Build.VERSION.SDK_INT < 23) {
                MediaDrmBridge.this.onSessionKeysChange(this.mSessionId, MediaDrmBridge.getDummyKeysInfo(0).toArray(), true, this.mIsKeyRelease);
            }
        }
    }

    @TargetApi(value=23)
    @MainDex
    public class ExpirationUpdateListener
    implements MediaDrm.OnExpirationUpdateListener {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public ExpirationUpdateListener() {
        }

        public /* synthetic */ ExpirationUpdateListener(1 var2_2) {
            this();
        }

        static {
            $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
        }

        public void onExpirationUpdate(MediaDrm object, byte[] byArray, long l2) {
            object = MediaDrmBridge.this.getSessionIdByDrmId(byArray);
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
            MediaDrmBridge.this.deferEventHandleIfNeeded((MediaDrmSessionManager.SessionId)object, new Runnable((MediaDrmSessionManager.SessionId)object, l2){
                public final /* synthetic */ MediaDrmSessionManager.SessionId val$sessionId;
                public final /* synthetic */ long val$expirationTime;
                {
                    this.val$sessionId = sessionId;
                    this.val$expirationTime = l2;
                }

                @Override
                public void run() {
                    g.a(MediaDrmBridge.TAG, a.a("ExpirationUpdate: ").append(this.val$sessionId.toHexString()).append(", ").append(this.val$expirationTime).toString());
                    MediaDrmBridge.this.onSessionExpirationUpdate(this.val$sessionId, this.val$expirationTime);
                }
            });
        }
    }

    @TargetApi(value=23)
    @MainDex
    public class KeyStatusChangeListener
    implements MediaDrm.OnKeyStatusChangeListener {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public KeyStatusChangeListener() {
        }

        private List<KeyStatus> getKeysInfo(List<MediaDrm.KeyStatus> object) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            object = object.iterator();
            while (object.hasNext()) {
                MediaDrm.KeyStatus keyStatus = (MediaDrm.KeyStatus)object.next();
                arrayList2.add(new KeyStatus(keyStatus.getKeyId(), keyStatus.getStatusCode(), null));
            }
            return arrayList2;
        }

        public /* synthetic */ KeyStatusChangeListener(1 var2_2) {
            this();
        }

        static {
            $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
        }

        public void onKeyStatusChange(MediaDrm object, byte[] byArray, List<MediaDrm.KeyStatus> list, boolean bl) {
            object = MediaDrmBridge.this.getSessionIdByDrmId(byArray);
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && MediaDrmBridge.this.mSessionManager.get((MediaDrmSessionManager.SessionId)object) == null) {
                throw new AssertionError();
            }
            boolean bl2 = MediaDrmBridge.this.mSessionManager.get((MediaDrmSessionManager.SessionId)object).keyType() == 3;
            MediaDrmBridge.this.deferEventHandleIfNeeded((MediaDrmSessionManager.SessionId)object, new Runnable((MediaDrmSessionManager.SessionId)object, bl, list, bl2){
                public final /* synthetic */ MediaDrmSessionManager.SessionId val$sessionId;
                public final /* synthetic */ boolean val$hasNewUsableKey;
                public final /* synthetic */ List val$keyInformation;
                public final /* synthetic */ boolean val$isKeyRelease;
                {
                    this.val$sessionId = sessionId;
                    this.val$hasNewUsableKey = bl;
                    this.val$keyInformation = list;
                    this.val$isKeyRelease = bl2;
                }

                @Override
                public void run() {
                    g.a(MediaDrmBridge.TAG, a.a("KeysStatusChange: ").append(this.val$sessionId.toHexString()).append(", ").append(this.val$hasNewUsableKey).toString());
                    KeyStatusChangeListener keyStatusChangeListener = KeyStatusChangeListener.this;
                    keyStatusChangeListener.MediaDrmBridge.this.onSessionKeysChange(this.val$sessionId, keyStatusChangeListener.getKeysInfo(this.val$keyInformation).toArray(), this.val$hasNewUsableKey, this.val$isKeyRelease);
                }
            });
        }
    }

    @MainDex
    public class EventListener
    implements MediaDrm.OnEventListener {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public EventListener() {
        }

        public /* synthetic */ EventListener(1 var2_2) {
            this();
        }

        static {
            $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onEvent(MediaDrm object, byte[] object2, int n2, int n3, byte[] byArray) {
            Object[] objectArray;
            block8: {
                if (object2 == null) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = n2;
                    g.b(MediaDrmBridge.TAG, "EventListener: No session for event %d.", objectArray);
                    return;
                }
                object = objectArray.MediaDrmBridge.this.getSessionIdByDrmId((byte[])object2);
                if (object == null) {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = MediaDrmSessionManager.SessionId.toHexString((byte[])object2);
                    g.b(MediaDrmBridge.TAG, "EventListener: Invalid session %s", objectArray);
                    return;
                }
                object2 = objectArray.MediaDrmBridge.this.mSessionManager.get((MediaDrmSessionManager.SessionId)object);
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 4) {
                            objectArray = new Object[]{};
                            g.b(MediaDrmBridge.TAG, "Invalid DRM event " + n2, objectArray);
                            return;
                        }
                        g.a(MediaDrmBridge.TAG, "MediaDrm.EVENT_VENDOR_DEFINED");
                        if ($assertionsDisabled) return;
                        throw new AssertionError();
                    }
                    g.a(MediaDrmBridge.TAG, "MediaDrm.EVENT_KEY_EXPIRED");
                    if (Build.VERSION.SDK_INT >= 23) return;
                    Object object3 = object2;
                    objectArray = objectArray.MediaDrmBridge.this;
                    object2 = MediaDrmBridge.getDummyKeysInfo(1).toArray();
                    n2 = 0;
                    n3 = ((MediaDrmSessionManager.SessionInfo)object3).keyType() == 3 ? 1 : 0;
                    ((MediaDrmBridge)objectArray).onSessionKeysChange((MediaDrmSessionManager.SessionId)object, (Object[])object2, n2 != 0, n3 != 0);
                    return;
                }
                g.a(MediaDrmBridge.TAG, "MediaDrm.EVENT_KEY_REQUIRED");
                try {
                    object2 = objectArray.MediaDrmBridge.this.getKeyRequest((MediaDrmSessionManager.SessionId)object, byArray, ((MediaDrmSessionManager.SessionInfo)object2).mimeType(), ((MediaDrmSessionManager.SessionInfo)object2).keyType(), null);
                    if (object2 == null) break block8;
                }
                catch (NotProvisionedException notProvisionedException) {
                    Object[] objectArray4 = new Object[1];
                    object = objectArray4;
                    objectArray4[0] = notProvisionedException;
                    g.b(MediaDrmBridge.TAG, "Device not provisioned", (Object[])object);
                    return;
                }
                objectArray.MediaDrmBridge.this.onSessionMessage((MediaDrmSessionManager.SessionId)object, (MediaDrm.KeyRequest)object2);
                return;
            }
            if (Build.VERSION.SDK_INT < 23) {
                objectArray.MediaDrmBridge.this.onSessionKeysChange((MediaDrmSessionManager.SessionId)object, MediaDrmBridge.getDummyKeysInfo(4).toArray(), false, false);
            }
            objectArray = new Object[]{};
            g.b(MediaDrmBridge.TAG, "EventListener: getKeyRequest failed.", objectArray);
        }
    }

    @MainDex
    public static class KeyStatus {
        public final byte[] mKeyId;
        public final int mStatusCode;

        public KeyStatus(byte[] byArray, int n2) {
            this.mKeyId = byArray;
            this.mStatusCode = n2;
        }

        private byte[] getKeyId() {
            return this.mKeyId;
        }

        private int getStatusCode() {
            return this.mStatusCode;
        }

        public /* synthetic */ KeyStatus(byte[] byArray, int n2, 1 var3_3) {
            this(byArray, n2);
        }
    }

    public static class SessionEventDeferrer {
        public final MediaDrmSessionManager.SessionId mSessionId;
        public final ArrayList<Runnable> mEventHandlers;

        public SessionEventDeferrer(MediaDrmSessionManager.SessionId sessionId) {
            SessionEventDeferrer sessionEventDeferrer = this;
            sessionEventDeferrer.mSessionId = sessionId;
            sessionEventDeferrer.mEventHandlers = new ArrayList();
        }

        public boolean shouldDefer(MediaDrmSessionManager.SessionId sessionId) {
            return this.mSessionId.isEqual(sessionId);
        }

        public void defer(Runnable runnable) {
            this.mEventHandlers.add(runnable);
        }

        public void fire() {
            Iterator<Runnable> iterator = this.mEventHandlers.iterator();
            while (iterator.hasNext()) {
                iterator.next().run();
            }
            this.mEventHandlers.clear();
        }
    }

    public static class MediaCryptoDeferrer {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public boolean mIsProvisioning = false;
        public final Queue<Runnable> mEventHandlers = new ArrayDeque<Runnable>();

        static {
            $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
        }

        public boolean isProvisioning() {
            return this.mIsProvisioning;
        }

        public void onProvisionStarted() {
            if (!$assertionsDisabled && this.mIsProvisioning) {
                throw new AssertionError();
            }
            this.mIsProvisioning = true;
        }

        public void defer(Runnable runnable) {
            if (!$assertionsDisabled && !this.mIsProvisioning) {
                throw new AssertionError();
            }
            this.mEventHandlers.add(runnable);
        }

        public void onProvisionDone() {
            if (!$assertionsDisabled && !this.mIsProvisioning) {
                throw new AssertionError();
            }
            this.mIsProvisioning = false;
            while (!this.mEventHandlers.isEmpty()) {
                MediaCryptoDeferrer mediaCryptoDeferrer = this;
                g.a(MediaDrmBridge.TAG, "run deferred CreateMediaCrypto() calls");
                this.mEventHandlers.remove();
                mediaCryptoDeferrer.mEventHandlers.element().run();
                if (!mediaCryptoDeferrer.mIsProvisioning) continue;
                g.a(MediaDrmBridge.TAG, "provision triggerred while running deferred CreateMediaCrypto()");
                return;
            }
        }
    }
}

