/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.a.a.a.a;
import a.b.a.g;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.os.Build;
import android.support.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.media.CodecProfileLevelList;

@JNINamespace(value="media")
@MainDex
public class MediaCodecUtil {
    public static final String TAG = "cr_MediaCodecUtil";
    public static final String[] H264_ENCODER_MODEL_BLACKLIST;
    public static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean isSoftwareCodec(String string2) {
        if (string2.startsWith("OMX.google.")) {
            return true;
        }
        return !string2.startsWith("OMX.");
    }

    public static String getDefaultCodecName(String string2, int n2, boolean bl) {
        for (MediaCodecInfo mediaCodecInfo : new MediaCodecListHelper()) {
            if (mediaCodecInfo.isEncoder() != n2 || bl && !MediaCodecUtil.isSoftwareCodec(mediaCodecInfo.getName())) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            int n3 = stringArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!stringArray[i2].equalsIgnoreCase(string2)) continue;
                return mediaCodecInfo.getName();
            }
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        g.b(TAG, "Decoder for type %s is not supported on this device", objectArray2);
        return "";
    }

    public static int[] getEncoderColorFormatsForMime(String string2) {
        for (MediaCodecInfo mediaCodecInfo : new MediaCodecListHelper()) {
            if (!mediaCodecInfo.isEncoder()) continue;
            for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                if (!string3.equalsIgnoreCase(string2)) continue;
                return mediaCodecInfo.getCapabilitiesForType((String)string3).colorFormats;
            }
        }
        return null;
    }

    public static boolean canDecode(String object, boolean bl) {
        if ((object = MediaCodecUtil.createDecoder((String)object, bl ? 1 : 0)) != null && (object = ((CodecCreationInfo)object).mediaCodec) != null) {
            try {
                object.release();
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = illegalStateException;
                g.b(TAG, "Cannot release media codec", objectArray2);
            }
            return true;
        }
        return false;
    }

    @TargetApi(value=21)
    public static void addVp9CodecProfileLevels(CodecProfileLevelList codecProfileLevelList, MediaCodecInfo.CodecCapabilities object) {
        int[][] nArrayArray = new int[11][];
        MediaCodecInfo.CodecCapabilities codecCapabilities = object;
        int[][] nArrayArray2 = nArrayArray;
        int[] nArray = new int[2];
        object = nArray;
        nArray[0] = 200;
        nArray[1] = 10;
        nArrayArray2[0] = (int[])object;
        int[] nArray2 = new int[2];
        object = nArray2;
        nArray2[0] = 800;
        nArray2[1] = 11;
        nArrayArray2[1] = (int[])object;
        int[] nArray3 = new int[2];
        object = nArray3;
        nArray3[0] = 1800;
        nArray3[1] = 20;
        nArrayArray2[2] = (int[])object;
        int[] nArray4 = new int[2];
        object = nArray4;
        nArray4[0] = 3600;
        nArray4[1] = 21;
        nArrayArray2[3] = (int[])object;
        int[] nArray5 = new int[2];
        object = nArray5;
        nArray5[0] = 7200;
        nArray5[1] = 30;
        nArrayArray2[4] = (int[])object;
        int[] nArray6 = new int[2];
        object = nArray6;
        nArray6[0] = 12000;
        nArray6[1] = 31;
        nArrayArray2[5] = (int[])object;
        int[] nArray7 = new int[2];
        object = nArray7;
        nArray7[0] = 18000;
        nArray7[1] = 40;
        nArrayArray2[6] = (int[])object;
        int[] nArray8 = new int[2];
        object = nArray8;
        nArray8[0] = 30000;
        nArray8[1] = 41;
        nArrayArray2[7] = (int[])object;
        int[] nArray9 = new int[2];
        object = nArray9;
        nArray9[0] = 60000;
        nArray9[1] = 50;
        nArrayArray2[8] = (int[])object;
        int[] nArray10 = new int[2];
        object = nArray10;
        nArray10[0] = 120000;
        nArray10[1] = 51;
        nArrayArray2[9] = (int[])object;
        int[] nArray11 = new int[2];
        object = nArray11;
        nArray11[0] = 180000;
        nArray11[1] = 52;
        nArrayArray[10] = (int[])object;
        object = codecCapabilities.getVideoCapabilities();
        for (int[] nArray12 : nArrayArray) {
            int n2 = nArray12[0];
            int n3 = nArray12[1];
            if (!object.getBitrateRange().contains((Comparable)Integer.valueOf(n2))) continue;
            codecProfileLevelList.addCodecProfileLevel(7, 12, n3);
        }
    }

    public static Object[] getSupportedCodecProfileLevels() {
        CodecProfileLevelList codecProfileLevelList;
        CodecProfileLevelList codecProfileLevelList2 = codecProfileLevelList;
        codecProfileLevelList = new CodecProfileLevelList();
        for (MediaCodecInfo mediaCodecInfo : new MediaCodecListHelper()) {
            for (String string2 : mediaCodecInfo.getSupportedTypes()) {
                int n2;
                MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray;
                if (!MediaCodecUtil.isDecoderSupportedForDevice(string2)) {
                    MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray2 = new Object[1];
                    codecProfileLevelArray = codecProfileLevelArray2;
                    codecProfileLevelArray2[0] = string2;
                    g.d(TAG, "Decoder for type %s disabled on this device", codecProfileLevelArray);
                    continue;
                }
                codecProfileLevelArray = mediaCodecInfo.getCapabilitiesForType(string2);
                if (string2.endsWith("vp9") && 21 <= (n2 = Build.VERSION.SDK_INT) && n2 <= 23) {
                    MediaCodecUtil.addVp9CodecProfileLevels(codecProfileLevelList2, (MediaCodecInfo.CodecCapabilities)codecProfileLevelArray);
                    continue;
                }
                codecProfileLevelArray = codecProfileLevelArray.profileLevels;
                n2 = codecProfileLevelArray.profileLevels.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    codecProfileLevelList2.addCodecProfileLevel(string2, codecProfileLevelArray[i2]);
                }
            }
        }
        return codecProfileLevelList2.toArray();
    }

    public static CodecCreationInfo createDecoder(String string2, int n2) {
        return MediaCodecUtil.createDecoder(string2, n2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static CodecCreationInfo createDecoder(String var0, int var1_1, MediaCrypto var2_3) {
        block17: {
            block18: {
                block16: {
                    var3_5 = v0;
                    v0 = new CodecCreationInfo();
                    if (!MediaCodecUtil.$assertionsDisabled && var3_5.mediaCodec != null) {
                        throw new AssertionError();
                    }
                    if (var1_1 == 1 && Build.VERSION.SDK_INT < 18) {
                        return var3_5;
                    }
                    if (!MediaCodecUtil.isDecoderSupportedForDevice(var0)) {
                        v1 = new Object[1];
                        var1_2 = v1;
                        v1[0] = var0;
                        g.b("cr_MediaCodecUtil", "Decoder for type %s is not supported on this device", var1_2);
                        return var3_5;
                    }
                    if (var0.startsWith("video") && var1_1 == 1) break block16;
                    if (!var0.startsWith("audio") || var2_3 /* !! */  == null) break block17;
                    if (!var2_3 /* !! */ .requiresSecureDecoderComponent(var0)) break block17;
                }
                var2_3 /* !! */  = MediaCodecUtil.getDefaultCodecName(var0, 0, false);
                if (!var2_3 /* !! */ .equals("")) break block18;
                return null;
            }
            if (Build.VERSION.SDK_INT < 19) ** GOTO lbl33
            v2 = MediaCodec.createByCodecName((String)var2_3 /* !! */ );
            var3_5.supportsAdaptivePlayback = MediaCodecUtil.codecSupportsAdaptivePlayback(v2, var0);
            v2.release();
lbl33:
            // 2 sources

            v3 = var3_5;
            v3.mediaCodec = MediaCodec.createByCodecName((String)((String)var2_3 /* !! */  + ".secure"));
        }
        if (var1_1 != 2) ** GOTO lbl45
        v4 = var3_5;
        v5 = MediaCodec.createByCodecName((String)MediaCodecUtil.getDefaultCodecName(var0, 0, true));
lbl42:
        // 3 sources

        while (true) {
            v4.mediaCodec = v5;
            ** GOTO lbl53
            break;
        }
lbl45:
        // 1 sources

        if (!var0.equals("audio/raw")) ** GOTO lbl50
        try {
            v4 = var3_5;
            v5 = MediaCodec.createByCodecName((String)"OMX.google.raw.decoder");
            ** GOTO lbl42
lbl50:
            // 1 sources

            v4 = var3_5;
            v5 = MediaCodec.createDecoderByType((String)var0);
            ** continue;
lbl53:
            // 1 sources

            var3_5.supportsAdaptivePlayback = MediaCodecUtil.codecSupportsAdaptivePlayback(var3_5.mediaCodec, var0);
        }
        catch (Exception var2_4) {
            v6 = new Object[3];
            var4_6 = v6;
            var4_6[0] = var0;
            v6[1] = var1_1;
            v6[2] = var2_4;
            g.b("cr_MediaCodecUtil", "Failed to create MediaCodec: %s, codecType: %d", var4_6);
            var3_5.mediaCodec = null;
        }
        return var3_5;
    }

    public static boolean isDecoderSupportedForDevice(String string2) {
        if (string2.equals("video/x-vnd.on2.vp8")) {
            if (Build.VERSION.SDK_INT < 18) {
                return false;
            }
            if (Build.MANUFACTURER.toLowerCase(Locale.getDefault()).equals("samsung")) {
                if (Build.VERSION.SDK_INT < 21 && (Build.MODEL.startsWith("GT-I9505") || Build.MODEL.startsWith("GT-I9500"))) {
                    return false;
                }
                if (!Build.MODEL.startsWith("GT-I9190") && !Build.MODEL.startsWith("GT-I9195")) {
                    if (Build.VERSION.SDK_INT <= 19) {
                        if (Build.MODEL.startsWith("GT-")) {
                            return false;
                        }
                        if (Build.MODEL.startsWith("SCH-")) {
                            return false;
                        }
                        if (Build.MODEL.startsWith("SM-T")) {
                            return false;
                        }
                        if (Build.MODEL.startsWith("SM-G")) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
            }
            if (Build.HARDWARE.startsWith("mt")) {
                return false;
            }
            if (Build.VERSION.SDK_INT <= 19 && Build.MODEL.startsWith("Lenovo A6000")) {
                return false;
            }
        } else if (string2.equals("video/x-vnd.on2.vp9")) {
            int n2 = Build.VERSION.SDK_INT;
            if (n2 < 19) {
                return false;
            }
            if (n2 < 21 && Build.HARDWARE.startsWith("mt")) {
                return false;
            }
            if (Build.MODEL.equals("Nexus Player")) {
                return false;
            }
        } else if (string2.equals("audio/opus") && Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return true;
    }

    public static boolean isAdaptivePlaybackBlacklisted(String string2) {
        if (!string2.equals("video/avc") && !string2.equals("video/avc1")) {
            return false;
        }
        if (!Build.VERSION.RELEASE.equals("4.4.2")) {
            return false;
        }
        if (!Build.MANUFACTURER.toLowerCase(Locale.getDefault()).equals("samsung")) {
            return false;
        }
        return Build.MODEL.startsWith("GT-I9300") || Build.MODEL.startsWith("SCH-I535");
    }

    @TargetApi(value=19)
    public static boolean codecSupportsAdaptivePlayback(MediaCodec mediaCodec, String objectArray) {
        if (Build.VERSION.SDK_INT >= 19 && mediaCodec != null) {
            boolean bl;
            block9: {
                block8: {
                    block7: {
                        try {
                            mediaCodec = mediaCodec.getCodecInfo();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = illegalArgumentException;
                            g.b(TAG, "Cannot retrieve codec information", objectArray);
                            return false;
                        }
                        if (!mediaCodec.isEncoder()) break block7;
                        return false;
                    }
                    if (!MediaCodecUtil.isAdaptivePlaybackBlacklisted((String)objectArray)) break block8;
                    return false;
                }
                mediaCodec = mediaCodec.getCapabilitiesForType((String)objectArray);
                if (mediaCodec == null) break block9;
                if (!mediaCodec.isFeatureSupported("adaptive-playback")) break block9;
                bl = true;
            }
            bl = false;
            return bl;
        }
        return false;
    }

    public static String getMimeForHWEncoder(int n2) {
        switch (n2) {
            default: {
                return "";
            }
            case 1: 
            case 3: 
            case 4: {
                return "video/avc";
            }
            case 0: 
            case 2: 
        }
        return "video/x-vnd.on2.vp8";
    }

    public static String getPrefixForHWEncoder(int n2) {
        switch (n2) {
            default: {
                return "";
            }
            case 4: {
                return "OMX.MTK.";
            }
            case 2: 
            case 3: {
                return "OMX.Exynos.";
            }
            case 0: 
            case 1: 
        }
        return "OMX.qcom.";
    }

    public static int getMinSDKForHWEncoder(int n2) {
        switch (n2) {
            default: {
                return -1;
            }
            case 4: {
                return 27;
            }
            case 3: {
                return 21;
            }
            case 2: {
                return 23;
            }
            case 0: 
            case 1: 
        }
        return 19;
    }

    public static int getBitrateAdjusterTypeForHWEncoder(int n2) {
        switch (n2) {
            default: {
                return -1;
            }
            case 3: 
            case 4: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: 
        }
        return 0;
    }

    public static CodecCreationInfo createEncoder(String string2) {
        CodecCreationInfo codecCreationInfo;
        CodecCreationInfo codecCreationInfo2 = codecCreationInfo;
        codecCreationInfo = new CodecCreationInfo();
        Integer n2 = MediaCodecUtil.findHWEncoder(string2);
        if (n2 == null) {
            return codecCreationInfo2;
        }
        try {
            CodecCreationInfo codecCreationInfo3 = codecCreationInfo2;
            codecCreationInfo3.mediaCodec = MediaCodec.createEncoderByType((String)string2);
            codecCreationInfo3.supportsAdaptivePlayback = false;
            codecCreationInfo2.bitrateAdjuster = MediaCodecUtil.getBitrateAdjusterTypeForHWEncoder(n2);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = exception;
            g.b(TAG, "Failed to create MediaCodec: %s", objectArray2);
        }
        return codecCreationInfo2;
    }

    public static boolean isEncoderSupportedByDevice(String objectArray) {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        if (objectArray.equals("video/avc") && Arrays.asList(H264_ENCODER_MODEL_BLACKLIST).contains(Build.MODEL)) {
            objectArray = new Object[]{};
            g.d(TAG, a.a("Model: ").append(Build.MODEL).append(" has blacklisted H.264 encoder.").toString(), objectArray);
            return false;
        }
        return MediaCodecUtil.findHWEncoder((String)objectArray) != null;
    }

    public static boolean isSetOutputSurfaceSupported() {
        return Build.VERSION.SDK_INT >= 23 && !Build.HARDWARE.equalsIgnoreCase("hi6210sft") && !Build.HARDWARE.equalsIgnoreCase("hi6250");
    }

    @Nullable
    public static Integer findHWEncoder(String objectArray) {
        for (MediaCodecInfo mediaCodecInfo : new MediaCodecListHelper()) {
            if (!mediaCodecInfo.isEncoder() || MediaCodecUtil.isSoftwareCodec(mediaCodecInfo.getName())) continue;
            String string2 = null;
            Object[] objectArray2 = mediaCodecInfo.getSupportedTypes();
            int n2 = objectArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!objectArray2[i2].equalsIgnoreCase((String)objectArray)) continue;
                string2 = mediaCodecInfo.getName();
                break;
            }
            if (string2 == null) continue;
            for (int i3 = 0; i3 < 5; ++i3) {
                if (!objectArray.equalsIgnoreCase(MediaCodecUtil.getMimeForHWEncoder(i3)) || !string2.startsWith(MediaCodecUtil.getPrefixForHWEncoder(i3))) continue;
                if (Build.VERSION.SDK_INT < MediaCodecUtil.getMinSDKForHWEncoder(i3)) {
                    objectArray2 = new Object[]{};
                    g.d(TAG, "Codec " + string2 + " is disabled due to SDK version " + Build.VERSION.SDK_INT, objectArray2);
                    continue;
                }
                g.a(TAG, "Found target encoder for mime " + (String)objectArray + " : " + string2);
                return i3;
            }
        }
        String string3 = "HW encoder for " + (String)objectArray + " is not available on this device.";
        objectArray = new Object[]{};
        g.d(TAG, string3, objectArray);
        return null;
    }

    public static boolean platformSupportsCbcsEncryption(int n2) {
        return n2 >= 25;
    }

    public static void setPatternIfSupported(MediaCodec.CryptoInfo cryptoInfo, int n2, int n3) {
        if (Build.VERSION.SDK_INT >= 24) {
            cryptoInfo.setPattern(new MediaCodec.CryptoInfo.Pattern(n2, n3));
        }
    }

    static {
        $assertionsDisabled = MediaCodecUtil.class.desiredAssertionStatus() ^ true;
        H264_ENCODER_MODEL_BLACKLIST = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4"};
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HWEncoder {
        public static final int QcomVp8 = 0;
        public static final int QcomH264 = 1;
        public static final int ExynosVp8 = 2;
        public static final int ExynosH264 = 3;
        public static final int MediatekH264 = 4;
        public static final int NUM_ENTRIES = 5;
    }

    public static class MediaCodecListHelper
    implements Iterable<MediaCodecInfo> {
        public MediaCodecInfo[] mCodecList;

        @TargetApi(value=21)
        public MediaCodecListHelper() {
            if (MediaCodecListHelper.supportsNewMediaCodecList()) {
                try {
                    this.mCodecList = new MediaCodecList(1).getCodecInfos();
                }
                catch (RuntimeException runtimeException) {}
            }
        }

        private int getCodecCount() {
            if (this.hasNewMediaCodecList()) {
                return this.mCodecList.length;
            }
            try {
                return MediaCodecList.getCodecCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        private MediaCodecInfo getCodecInfoAt(int n2) {
            if (this.hasNewMediaCodecList()) {
                return this.mCodecList[n2];
            }
            return MediaCodecList.getCodecInfoAt((int)n2);
        }

        public static boolean supportsNewMediaCodecList() {
            return Build.VERSION.SDK_INT >= 21;
        }

        private boolean hasNewMediaCodecList() {
            return MediaCodecListHelper.supportsNewMediaCodecList() && this.mCodecList != null;
        }

        @Override
        public Iterator<MediaCodecInfo> iterator() {
            return new CodecInfoIterator(null);
        }

        public class CodecInfoIterator
        implements Iterator<MediaCodecInfo> {
            public int mPosition;

            public CodecInfoIterator() {
            }

            public /* synthetic */ CodecInfoIterator(1 var2_2) {
                this();
            }

            @Override
            public boolean hasNext() {
                return this.mPosition < MediaCodecListHelper.this.getCodecCount();
            }

            @Override
            public MediaCodecInfo next() {
                if (this.mPosition != MediaCodecListHelper.this.getCodecCount()) {
                    return MediaCodecListHelper.this.getCodecInfoAt(this.mPosition++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static final class MimeTypes {
        public static final String VIDEO_MP4 = "video/mp4";
        public static final String VIDEO_WEBM = "video/webm";
        public static final String VIDEO_H264 = "video/avc";
        public static final String VIDEO_H265 = "video/hevc";
        public static final String VIDEO_VP8 = "video/x-vnd.on2.vp8";
        public static final String VIDEO_VP9 = "video/x-vnd.on2.vp9";
    }

    public static class CodecCreationInfo {
        public MediaCodec mediaCodec;
        public boolean supportsAdaptivePlayback;
        public int bitrateAdjuster = 0;
    }
}

