/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.gamepad;

import a.b.g.b.a;
import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.input.InputManager;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import java.util.Arrays;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="device")
public class GamepadList {
    public static final int MAX_GAMEPADS = 4;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final Object mLock = new Object();
    public final a[] mGamepadDevices = new a[4];
    public InputManager mInputManager;
    public int mAttachedToWindowCounter;
    public boolean mIsGamepadAPIActive;
    public InputManager.InputDeviceListener mInputDeviceListener = new InputManager.InputDeviceListener(){

        public void onInputDeviceChanged(int n2) {
            GamepadList.this.onInputDeviceChangedImpl(n2);
        }

        public void onInputDeviceRemoved(int n2) {
            GamepadList.this.onInputDeviceRemovedImpl(n2);
        }

        public void onInputDeviceAdded(int n2) {
            GamepadList.this.onInputDeviceAddedImpl(n2);
        }
    };

    public GamepadList() {
    }

    private void initializeDevices() {
        int[] nArray = this.mInputManager.getInputDeviceIds();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            InputDevice inputDevice = InputDevice.getDevice((int)nArray[i2]);
            if (!GamepadList.isGamepadDevice(inputDevice)) continue;
            this.registerGamepad(inputDevice);
        }
    }

    public static void onAttachedToWindow(Context context) {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        GamepadList.getInstance().attachedToWindow(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void attachedToWindow(Context object) {
        if (this.mAttachedToWindowCounter++ != 0) return;
        GamepadList gamepadList = this;
        gamepadList.mInputManager = (InputManager)object.getSystemService("input");
        object = gamepadList.mLock;
        synchronized (object) {
            this.initializeDevices();
        }
        gamepadList.mInputManager.registerInputDeviceListener(this.mInputDeviceListener, null);
    }

    @SuppressLint(value={"MissingSuperCall"})
    public static void onDetachedFromWindow() {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        GamepadList.getInstance().detachedFromWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachedFromWindow() {
        if (--this.mAttachedToWindowCounter == 0) {
            Object object = this.mLock;
            synchronized (object) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.mGamepadDevices[i2] = null;
                    continue;
                }
                // MONITOREXIT @DISABLED, blocks:[1, 2, 5] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                this.mInputManager.unregisterInputDeviceListener(this.mInputDeviceListener);
                this.mInputManager = null;
            }
        }
    }

    private void onInputDeviceChangedImpl(int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInputDeviceRemovedImpl(int n2) {
        Object object = this.mLock;
        synchronized (object) {
            this.unregisterGamepad(n2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInputDeviceAddedImpl(int n2) {
        InputDevice inputDevice = InputDevice.getDevice((int)n2);
        if (!GamepadList.isGamepadDevice(inputDevice)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.registerGamepad(inputDevice);
            return;
        }
    }

    public static GamepadList getInstance() {
        return LazyHolder.INSTANCE;
    }

    private int getDeviceCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.getDevice(i2) == null) continue;
            ++n2;
        }
        return n2;
    }

    private boolean isDeviceConnected(int n2) {
        return n2 < 4 && this.getDevice(n2) != null;
    }

    private a getDeviceById(int n2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            a a2 = this.mGamepadDevices[i2];
            if (a2 == null || a2.a != n2) continue;
            return a2;
        }
        return null;
    }

    private a getDevice(int n2) {
        if (!($assertionsDisabled || n2 >= 0 && n2 < 4)) {
            throw new AssertionError();
        }
        return this.mGamepadDevices[n2];
    }

    public static boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (!GamepadList.isGamepadEvent(keyEvent)) {
            return false;
        }
        return GamepadList.getInstance().handleKeyEvent(keyEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleKeyEvent(KeyEvent keyEvent) {
        GamepadList gamepadList = this;
        Object object = gamepadList.mLock;
        synchronized (object) {
            block10: {
                if (!gamepadList.mIsGamepadAPIActive) {
                    return false;
                }
                if ((this = ((GamepadList)this).getGamepadForEvent((InputEvent)keyEvent)) != null) break block10;
                return false;
            }
            if (!GamepadList.isGamepadEvent(keyEvent)) {
                return false;
            }
            int n2 = keyEvent.getKeyCode();
            if (!a.k && n2 >= 256) {
                throw new AssertionError();
            }
            if (keyEvent.getAction() == 0) {
                ((a)this).f[n2] = 1.0f;
            } else if (keyEvent.getAction() == 1) {
                ((a)this).f[n2] = 0.0f;
            }
            ((a)this).c = keyEvent.getEventTime();
            return true;
        }
    }

    public static boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (!GamepadList.isGamepadEvent(motionEvent)) {
            return false;
        }
        return GamepadList.getInstance().handleMotionEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleMotionEvent(MotionEvent motionEvent) {
        GamepadList gamepadList = this;
        Object object = gamepadList.mLock;
        synchronized (object) {
            boolean bl;
            if (!gamepadList.mIsGamepadAPIActive) {
                return false;
            }
            if ((this = ((GamepadList)this).getGamepadForEvent((InputEvent)motionEvent)) == null) {
                return false;
            }
            if (!GamepadList.isGamepadEvent(motionEvent)) {
                bl = false;
                return bl;
            } else {
                int n2 = 0;
                while (true) {
                    int[] nArray = ((a)this).i;
                    if (++n2 >= ((a)this).i.length) break;
                    int n3 = nArray[n2];
                    ((a)this).g[n3] = motionEvent.getAxisValue(n3);
                }
                ((a)this).c = motionEvent.getEventTime();
                bl = true;
            }
            return bl;
        }
    }

    private int getNextAvailableIndex() {
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.getDevice(i2) != null) continue;
            return i2;
        }
        return -1;
    }

    private boolean registerGamepad(InputDevice inputDevice) {
        a a2;
        int n2 = ((GamepadList)((Object)a3)).getNextAvailableIndex();
        if (n2 == -1) {
            return false;
        }
        GamepadList gamepadList = a3;
        a a3 = a2;
        a2 = new a(n2, inputDevice);
        gamepadList.mGamepadDevices[n2] = a3;
        return true;
    }

    private void unregisterGamepad(int n2) {
        a a2 = this.getDeviceById(n2);
        if (a2 == null) {
            return;
        }
        int n3 = a2.b;
        this.mGamepadDevices[n3] = null;
    }

    public static boolean isGamepadDevice(InputDevice inputDevice) {
        if (inputDevice == null) {
            return false;
        }
        return (inputDevice.getSources() & 0x1000010) == 0x1000010;
    }

    private a getGamepadForEvent(InputEvent inputEvent) {
        return this.getDeviceById(inputEvent.getDeviceId());
    }

    public static boolean isGamepadAPIActive() {
        return GamepadList.getInstance().mIsGamepadAPIActive;
    }

    public static boolean isGamepadEvent(MotionEvent motionEvent) {
        return (motionEvent.getSource() & 0x1000010) == 0x1000010;
    }

    public static boolean isGamepadEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        switch (n2) {
            default: {
                return KeyEvent.isGamepadButton((int)n2);
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
        }
        return true;
    }

    public static void updateGamepadData(long l2) {
        GamepadList.getInstance().grabGamepadData(l2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void grabGamepadData(long var1_2) {
        var3_3 = this.mLock;
        synchronized (var3_3) {
            for (var4_4 = 0; var4_4 < 4; ++var4_4) {
                var5_5 = this.getDevice(var4_4);
                if (var5_5 != null) {
                }
                ** GOTO lbl15
                {
                    v0 = var5_5;
                    v0.j.mapToStandardGamepad(var5_5.d, var5_5.e, var5_5.g, var5_5.f);
                    this.nativeSetGamepadData(var1_2, var4_4, v0.j.isStandard(), true, var5_5.h, var5_5.c, var5_5.d, var5_5.e);
                    continue;
lbl15:
                    // 1 sources

                    this.nativeSetGamepadData(var1_2, var4_4, false, false, null, 0L, null, null);
                    continue;
                }
            }
            return;
        }
    }

    public static void setGamepadAPIActive(boolean bl) {
        GamepadList.getInstance().setIsGamepadActive(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setIsGamepadActive(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsGamepadAPIActive = bl;
            if (bl) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    a a2 = this.getDevice(i2);
                    if (a2 == null) continue;
                    a a3 = a2;
                    Arrays.fill(a3.d, 0.0f);
                    Arrays.fill(a3.g, 0.0f);
                    Arrays.fill(a3.e, 0.0f);
                    Arrays.fill(a3.f, 0.0f);
                }
            }
            return;
        }
    }

    private native void nativeSetGamepadData(long var1, int var3, boolean var4, boolean var5, String var6, long var7, float[] var9, float[] var10);

    public /* synthetic */ GamepadList(1 var1_1) {
        this();
    }

    static {
        $assertionsDisabled = GamepadList.class.desiredAssertionStatus() ^ true;
    }

    public static class LazyHolder {
        public static final GamepadList INSTANCE = new GamepadList(null);
    }
}

