/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content_shell;

import a.b.d.a.k;
import a.b.d.a.v;
import a.b.d.a.z;
import a.b.m.a;
import a.b.p.n.c;
import android.content.Context;
import android.graphics.drawable.ClipDrawable;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.vccorp.content.R;
import com.vccorp.object.UserInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.chromium.base.Callback;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.components.embedder_support.view.ContentView;
import org.chromium.components.embedder_support.view.ContentViewRenderView;
import org.chromium.content_public.browser.ActionModeCallbackHelper;
import org.chromium.content_public.browser.LoadUrlParams;
import org.chromium.content_public.browser.NavigationController;
import org.chromium.content_public.browser.WebContents;
import org.chromium.content_shell.DatabaseHandler;
import org.chromium.content_shell.OnConfigListener;
import org.chromium.content_shell.OnWebViewListener;
import org.chromium.content_shell.ShellManager;
import org.chromium.ui.base.ViewAndroidDelegate;
import org.json.JSONException;
import org.json.JSONObject;

@JNINamespace(value="content")
public class Shell
extends LinearLayout {
    public static final long COMPLETED_PROGRESS_TIMEOUT_MS = 200L;
    public static final String NAME_ANONYMOUS = "anonymous";
    public static final int ID_ANONYMOUS = 123;
    public static String CLIENT_ID = "2407e7c8032ed1fba1cfe6a305178519";
    public static String CLIENT_SECRET = "qwe9667cd5c50c42d68f36fe4df9poiu";
    public final Runnable mClearProgressRunnable = new Runnable(){

        @Override
        public void run() {
            Shell.this.mProgressDrawable.setLevel(0);
        }
    };
    public WebContents mWebContents;
    public NavigationController mNavigationController;
    public EditText mUrlTextView;
    public ImageButton mPrevButton;
    public ImageButton mNextButton;
    public ImageButton mStopReloadButton;
    public ClipDrawable mProgressDrawable;
    public long mNativeShell;
    public ContentViewRenderView mContentViewRenderView;
    public c mWindow;
    public a.b.e.a mViewAndroidDelegate;
    public boolean mLoading;
    public boolean mIsFullscreen;
    public Callback<Boolean> mOverlayModeChangedCallbackForTesting;
    public boolean isUpdated;
    public OnWebViewListener onWebViewListener;
    public long timeLoadPage;
    public String TAG = Shell.class.getName();
    public UserInfo userInfoVCCInfo;
    public OnConfigListener configListener;
    public DatabaseHandler databaseHandler;

    public Shell(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private void onNativeDestroyed() {
        Shell shell = this;
        shell.mWindow = null;
        shell.mNativeShell = 0L;
        shell.mWebContents = null;
    }

    private void initializeUrlField() {
        Shell shell = this;
        shell.mUrlTextView = (EditText)shell.findViewById(R.id.url);
        shell.mUrlTextView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int n2, KeyEvent keyEvent) {
                if (n2 != 2 && (keyEvent == null || keyEvent.getKeyCode() != 66 || keyEvent.getAction() != 0)) {
                    return false;
                }
                if (Shell.this.mWebContents != null) {
                    Shell shell = Shell.this;
                    shell.loadUrl(shell.mUrlTextView.getText().toString());
                }
                2 v1 = this;
                v1.Shell.this.setKeyboardVisibilityForUrl(false);
                v1.Shell.this.getContentView().requestFocus();
                return true;
            }
        });
        shell.mUrlTextView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                3 v0 = this;
                v0.Shell.this.setKeyboardVisibilityForUrl(bl);
                view = v0.Shell.this.mNextButton;
                int n2 = bl ? 8 : 0;
                view.setVisibility(n2);
                view = Shell.this.mPrevButton;
                n2 = bl ? 8 : 0;
                view.setVisibility(n2);
                view = Shell.this.mStopReloadButton;
                n2 = bl ? 8 : 0;
                view.setVisibility(n2);
                if (!bl) {
                    Shell.this.mUrlTextView.setText((CharSequence)Shell.this.mWebContents.getVisibleUrl());
                }
            }
        });
        shell.mUrlTextView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int n2, KeyEvent keyEvent) {
                if (n2 == 4) {
                    Shell.this.getContentView().requestFocus();
                    return true;
                }
                return false;
            }
        });
    }

    public static String sanitizeUrl(String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.startsWith("www.") || string2.indexOf(":") == -1) {
            string2 = "http://" + string2;
        }
        return string2;
    }

    private void initializeNavigationButtons() {
        Shell shell = this;
        shell.mPrevButton = (ImageButton)shell.findViewById(R.id.prev);
        shell.mPrevButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (Shell.this.mNavigationController.canGoBack()) {
                    Shell.this.mNavigationController.goBack();
                }
            }
        });
        shell.mNextButton = (ImageButton)shell.findViewById(R.id.next);
        shell.mNextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (Shell.this.mNavigationController.canGoForward()) {
                    Shell.this.mNavigationController.goForward();
                }
            }
        });
        shell.mStopReloadButton = (ImageButton)shell.findViewById(R.id.stop_reload_button);
        shell.mStopReloadButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (Shell.this.mLoading) {
                    Shell.this.mWebContents.stop();
                } else {
                    Shell.this.mNavigationController.reload(true);
                }
            }
        });
    }

    private void onUpdateUrl(String string2) {
        Shell shell = this;
        shell.mUrlTextView.setText((CharSequence)string2);
        a a2 = null;
        if (shell.databaseHandler != null) {
            if (((Shell)((Object)this)).userInfoVCCInfo == null) {
                String string3 = String.valueOf(System.currentTimeMillis());
                ((Shell)((Object)this)).userInfoVCCInfo = new UserInfo(123, NAME_ANONYMOUS, NAME_ANONYMOUS, NAME_ANONYMOUS, string3);
                ((Shell)((Object)this)).databaseHandler.addUser(((Shell)((Object)this)).userInfoVCCInfo);
            }
            if (((Shell)((Object)this)).getWebContents().getLastCommittedUrl() != null) {
                a a3;
                a2 = a3;
                a3 = new a(((Shell)((Object)this)).getWebContents().getVisibleUrl(), ((Shell)((Object)this)).getWebContents().getLastCommittedUrl(), ((Shell)((Object)this)).getWebContents().getTitle(), ((Shell)((Object)this)).userInfoVCCInfo.getUid(), ((Shell)((Object)this)).userInfoVCCInfo.getTimeCreate());
            }
            ((Shell)((Object)this)).databaseHandler.addLinkVisited(a2);
        }
        if ((this = ((Shell)((Object)this)).onWebViewListener) != null) {
            this.updateURL(string2);
        }
        ShellManager.mStartupUrl = string2;
    }

    private void onLoadProgressChanged(double d2) {
        Shell shell = onWebViewListener;
        shell.removeCallbacks(shell.mClearProgressRunnable);
        shell.mProgressDrawable.setLevel((int)(d2 * 10000.0));
        if (d2 == 1.0) {
            Shell shell2 = onWebViewListener;
            shell2.postDelayed(shell2.mClearProgressRunnable, 200L);
            OnWebViewListener onWebViewListener = shell2.onWebViewListener;
            if (onWebViewListener != null) {
                onWebViewListener.onLoaded();
            }
        }
    }

    private String convertMinisecondToDate(String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(Long.parseLong(string2));
        return simpleDateFormat.format(calendar.getTime());
    }

    /*
     * WARNING - void declaration
     */
    private void toggleFullscreenModeForTab(boolean bl) {
        void var1_4;
        Shell shell;
        shell.mIsFullscreen = bl;
        shell = (LinearLayout)shell.findViewById(R.id.toolbar);
        if (bl) {
            int n2 = 8;
        } else {
            boolean bl2 = false;
        }
        shell.setVisibility((int)var1_4);
    }

    private boolean isFullscreenForTabOrPending() {
        return this.mIsFullscreen;
    }

    private void setIsLoading(boolean bl) {
        this.mLoading = bl;
        if (this.mLoading) {
            OnWebViewListener onWebViewListener = this.onWebViewListener;
            if (onWebViewListener != null) {
                onWebViewListener.onStartLoading();
            }
            this.timeLoadPage = System.currentTimeMillis();
            this.mStopReloadButton.setImageResource(17301560);
        } else {
            Shell shell = this;
            shell.mStopReloadButton.setImageResource(R.drawable.ic_refresh);
            OnWebViewListener onWebViewListener = shell.onWebViewListener;
            if (onWebViewListener != null) {
                onWebViewListener.timeLoadPage(System.currentTimeMillis() - this.timeLoadPage);
            }
        }
    }

    private void initFromNativeTabContents(WebContents object) {
        Shell shell = this;
        WebContents webContents = object;
        WebContents webContents2 = object;
        Shell shell2 = this;
        Context context = shell2.getContext();
        object = ContentView.createContentView(context, (WebContents)object);
        a.b.e.a a2 = shell2.mViewAndroidDelegate = new a.b.e.a((ViewGroup)object);
        c c2 = shell2.mWindow;
        WebContents.InternalsHolder internalsHolder = WebContents.createDefaultInternalsHolder();
        webContents2.initialize("", a2, (z.a)object, c2, internalsHolder);
        this.mWebContents = webContents2;
        k.fromWebContents(this.mWebContents).addPossiblyUnsafeInterface(new MyJavaScriptInterface(context), "ViVaHandler", null);
        v.fromWebContents(webContents).setActionModeCallback(this.defaultActionCallback());
        shell.mNavigationController = shell.mWebContents.getNavigationController();
        if (shell.getParent() != null) {
            this.mWebContents.onShow();
        }
        if (this.mWebContents.getVisibleUrl() != null) {
            this.mUrlTextView.setText((CharSequence)this.mWebContents.getVisibleUrl());
        }
        ((FrameLayout)this.findViewById(R.id.contentview_holder)).addView((View)object, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        object.requestFocus();
        this.mContentViewRenderView.setCurrentWebContents(this.mWebContents);
    }

    private ActionMode.Callback defaultActionCallback() {
        final ActionModeCallbackHelper actionModeCallbackHelper = v.fromWebContents(this.mWebContents).getActionModeCallbackHelper();
        return new ActionMode.Callback(){

            public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
                actionModeCallbackHelper.onCreateActionMode(actionMode, menu2);
                return true;
            }

            public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
                return actionModeCallbackHelper.onPrepareActionMode(actionMode, menu2);
            }

            public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
                return actionModeCallbackHelper.onActionItemClicked(actionMode, menuItem);
            }

            public void onDestroyActionMode(ActionMode actionMode) {
                actionModeCallbackHelper.onDestroyActionMode();
            }
        };
    }

    private void enableUiControl(int n2, boolean bl) {
        if (n2 == 0) {
            this.mPrevButton.setEnabled(bl);
        } else if (n2 == 1) {
            this.mNextButton.setEnabled(bl);
        }
    }

    private void setKeyboardVisibilityForUrl(boolean bl) {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (bl) {
            inputMethodManager.showSoftInput((View)this.mUrlTextView, 1);
        } else {
            inputMethodManager.hideSoftInputFromWindow(this.mUrlTextView.getWindowToken(), 0);
        }
    }

    private void getUserInforFromSDK() {
        Shell shell = this;
        shell.onListenVivaUserInfo(shell.userInfoVCCInfo);
    }

    public static native void nativeCloseShell(long var0);

    public void setContentViewRenderView(ContentViewRenderView contentViewRenderView) {
        FrameLayout frameLayout = (FrameLayout)this.findViewById(R.id.contentview_holder);
        if (contentViewRenderView == null) {
            ContentViewRenderView contentViewRenderView2 = this.mContentViewRenderView;
            if (contentViewRenderView2 != null) {
                frameLayout.removeView((View)contentViewRenderView2);
            }
        } else {
            frameLayout.addView((View)contentViewRenderView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
        this.mContentViewRenderView = contentViewRenderView;
    }

    public void initialize(long l2, c c2) {
        Shell shell = this;
        this.mNativeShell = l2;
        shell.mWindow = c2;
        shell.databaseHandler = new DatabaseHandler(this.getContext());
    }

    public void close() {
        long l2 = this.mNativeShell;
        if (l2 == 0L) {
            return;
        }
        Shell.nativeCloseShell(l2);
    }

    public boolean isDestroyed() {
        return this.mNativeShell == 0L;
    }

    public boolean isLoading() {
        return this.mLoading;
    }

    public void onFinishInflate() {
        Shell shell = this;
        super.onFinishInflate();
        shell.mProgressDrawable = (ClipDrawable)shell.findViewById(R.id.toolbar).getBackground();
        shell.initializeUrlField();
        shell.initializeNavigationButtons();
    }

    public void loadUrl(String string2) {
        if (string2 == null) {
            return;
        }
        NavigationController navigationController = ((Shell)((Object)onWebViewListener)).mNavigationController;
        if (navigationController != null) {
            navigationController.loadUrl(new LoadUrlParams(Shell.sanitizeUrl(string2)));
        }
        Shell shell = onWebViewListener;
        shell.mUrlTextView.clearFocus();
        shell.getContentView().clearFocus();
        shell.getContentView().requestFocus();
        OnWebViewListener onWebViewListener = shell.onWebViewListener;
        if (onWebViewListener != null) {
            onWebViewListener.onLoading(string2);
        }
    }

    public a.b.e.a getViewAndroidDelegate() {
        return this.mViewAndroidDelegate;
    }

    public void setOverlayMode(boolean bl) {
        Shell shell = callback;
        shell.mContentViewRenderView.setOverlayVideoMode(bl);
        Callback<Boolean> callback = shell.mOverlayModeChangedCallbackForTesting;
        if (callback != null) {
            callback.onResult(bl);
        }
    }

    public void sizeTo(int n2, int n3) {
        this.mWebContents.setSize(n2, n3);
    }

    public void setOverayModeChangedCallbackForTesting(Callback<Boolean> callback) {
        this.mOverlayModeChangedCallbackForTesting = callback;
    }

    public ViewGroup getContentView() {
        if (((Shell)((Object)viewAndroidDelegate)).mWebContents.getViewAndroidDelegate() != null) {
            ViewAndroidDelegate viewAndroidDelegate = ((Shell)((Object)viewAndroidDelegate)).mWebContents.getViewAndroidDelegate();
            return viewAndroidDelegate != null ? viewAndroidDelegate.getContainerView() : null;
        }
        return null;
    }

    public WebContents getWebContents() {
        return this.mWebContents;
    }

    public void onListenVivaUserInfo(UserInfo object) {
        JSONObject jSONObject;
        this.getContext().getResources().getString(R.string.user_infor_test);
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        if (object != null) {
            JSONObject jSONObject3;
            JSONObject jSONObject4 = jSONObject2;
            jSONObject4.put("code", 200);
            jSONObject4.put("message", (Object)"\u0110\u0103ng nh\u1eadp th\u00e0nh c\u00f4ng");
            JSONObject jSONObject5 = jSONObject3;
            jSONObject3 = new JSONObject();
            jSONObject3.put("id", ((UserInfo)object).getUid());
            jSONObject3.put("Name", (Object)((UserInfo)object).getName());
            jSONObject3.put("email", (Object)((UserInfo)object).getEmail());
            try {
                jSONObject4.put("data", (Object)jSONObject5);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        object = "javascript:onListenVivaUserInfo(" + jSONObject2 + ")";
        this.post(new Runnable((String)object){
            public final /* synthetic */ String val$webUrl;
            {
                this.val$webUrl = string2;
            }

            @Override
            public void run() {
                Shell.this.loadUrl(this.val$webUrl);
            }
        });
    }

    public void setConfigListener(OnConfigListener onConfigListener) {
        this.configListener = onConfigListener;
    }

    public String getCurrentUrl() {
        return this.mUrlTextView.getText().toString();
    }

    public void setOnWebViewListener(OnWebViewListener onWebViewListener) {
        this.onWebViewListener = onWebViewListener;
    }

    public boolean removeUserById(int n2) {
        Object object = object.databaseHandler;
        if (object != null) {
            return ((DatabaseHandler)((Object)object)).removeUserByUserId(n2);
        }
        return false;
    }

    public boolean removeUserByName(String string2) {
        Object object = object.databaseHandler;
        if (object != null) {
            return ((DatabaseHandler)((Object)object)).removeUserByName(string2);
        }
        return false;
    }

    public boolean removeUserByEmail(String string2) {
        Object object = object.databaseHandler;
        if (object != null) {
            return ((DatabaseHandler)((Object)object)).removeUserByEmail(string2);
        }
        return false;
    }

    public void setRemoveAllHistoryAfter30Days(boolean bl) {
        if (bl && (this = ((Shell)((Object)this)).databaseHandler) != null) {
            ((DatabaseHandler)((Object)this)).removeHistory30Days();
        }
    }

    public void removeHistoryById(int n2) {
        Object object = object.databaseHandler;
        if (object != null) {
            ((DatabaseHandler)((Object)object)).removeHistoryByUserId(n2);
        }
    }

    public void removeHistoryByRange(Date date, Date date2) {
        Object object = object.databaseHandler;
        if (object != null) {
            ((DatabaseHandler)((Object)object)).removeHistoryByRange(date, date2);
        }
    }

    public List<a> getAllHistoryByUser(int n2) {
        Object object = object.databaseHandler;
        if (object != null) {
            return ((DatabaseHandler)((Object)object)).getAllHistoryOfUser(n2);
        }
        return new ArrayList<a>();
    }

    public List<a> getAllHistory() {
        Object object = object.databaseHandler;
        if (object != null) {
            ((DatabaseHandler)((Object)object)).getAllHistory();
        }
        return new ArrayList<a>();
    }

    public List<a> getAllHistoryByRange(Date date, Date date2) {
        Object object = object.databaseHandler;
        if (object != null) {
            return ((DatabaseHandler)((Object)object)).getHistoryByRange(date, date2);
        }
        return new ArrayList<a>();
    }

    public class MyJavaScriptInterface {
        public Context context;

        public MyJavaScriptInterface(Context context) {
            this.context = context;
        }

        public void getVivaUserInfo() {
            Shell.this.getUserInforFromSDK();
        }
    }
}

