/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.webcontents;

import a.b.a.g;
import a.b.a.k;
import a.b.a.l;
import a.b.c.b.j;
import a.b.c.b.o;
import a.b.c.b.p;
import a.b.c.b.q;
import a.b.d.a.a;
import a.b.d.a.b;
import a.b.d.a.b0;
import a.b.d.a.c0;
import a.b.d.a.f;
import a.b.d.a.n;
import a.b.d.a.r;
import a.b.d.a.z;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.vccorp.content.browser.AppWebMessagePort;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.chromium.base.Callback;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.ContentUiEventHandler;
import org.chromium.content.browser.GestureListenerManagerImpl;
import org.chromium.content.browser.MediaSessionImpl;
import org.chromium.content.browser.accessibility.WebContentsAccessibilityImpl;
import org.chromium.content.browser.framehost.RenderFrameHostImpl;
import org.chromium.content.browser.selection.SelectionPopupControllerImpl;
import org.chromium.content.browser.webcontents.WebContentsObserverProxy;
import org.chromium.content_public.browser.JavaScriptCallback;
import org.chromium.content_public.browser.NavigationController;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.OverscrollRefreshHandler;
import org.chromium.ui.base.EventForwarder;
import org.chromium.ui.base.ViewAndroidDelegate;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="content")
public class WebContentsImpl
implements WebContents,
a.b.c.b.t.a,
p {
    public static final String TAG = "cr_WebContentsImpl";
    public static final String PARCEL_VERSION_KEY = "version";
    public static final String PARCEL_WEBCONTENTS_KEY = "webcontents";
    public static final String PARCEL_PROCESS_GUARD_KEY = "processguard";
    public static final long PARCELABLE_VERSION_ID = 0L;
    public static UUID sParcelableUUID;
    @SuppressLint(value={"ParcelClassLoader"})
    public static final Parcelable.Creator<WebContents> CREATOR;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final List<RenderFrameHostImpl> mFrames = new ArrayList<RenderFrameHostImpl>();
    public long mNativeWebContentsAndroid;
    public NavigationController mNavigationController;
    public WebContentsObserverProxy mObserverProxy;
    public MediaSessionImpl mMediaSession;
    public SmartClipCallback mSmartClipCallback;
    public EventForwarder mEventForwarder;
    public j mRenderCoordinates;
    public WebContents.InternalsHolder mInternalsHolder;
    public String mProductVersion;
    public boolean mInitialized;
    public Throwable mNativeDestroyThrowable;

    public static void invalidateSerializedWebContentsForTesting() {
        sParcelableUUID = UUID.randomUUID();
    }

    public WebContentsImpl(long l2, NavigationController navigationController) {
        if (!$assertionsDisabled && l2 == 0L) {
            throw new AssertionError();
        }
        this.mNativeWebContentsAndroid = l2;
        this.mNavigationController = navigationController;
    }

    public static WebContentsImpl create(long l2, NavigationController navigationController) {
        return new WebContentsImpl(l2, navigationController);
    }

    private void clearNativePtr() {
        this.mNativeDestroyThrowable = new RuntimeException("clearNativePtr");
        this.mNativeWebContentsAndroid = 0L;
        this.mNavigationController = null;
        WebContentsObserverProxy webContentsObserverProxy = this.mObserverProxy;
        if (webContentsObserverProxy != null) {
            webContentsObserverProxy.destroy();
            this.mObserverProxy = null;
        }
    }

    private long getNativePointer() {
        return this.mNativeWebContentsAndroid;
    }

    private SelectionPopupControllerImpl getSelectionPopupController() {
        return SelectionPopupControllerImpl.fromWebContents(this);
    }

    public static void onEvaluateJavaScriptResult(String string2, JavaScriptCallback javaScriptCallback) {
        javaScriptCallback.handleJavaScriptResult(string2);
    }

    public static void onSmartClipDataExtracted(String string2, String string3, int n2, int n3, int n4, int n5, SmartClipCallback smartClipCallback) {
        smartClipCallback.onSmartClipDataExtracted(string2, string3, new Rect(n2, n3, n4, n5));
    }

    public static void onAccessibilitySnapshot(b b2, a a2) {
        a2.onAccessibilitySnapshot(b2);
    }

    public static void addAccessibilityNodeAsChild(b b2, b b3) {
        b2.s.add(b3);
    }

    public static b createAccessibilitySnapshotNode(int n2, int n3, int n4, int n5, boolean bl, String string2, int n6, int n7, float f2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string3) {
        b b2;
        b b3 = b2;
        b2 = new b(string2, string3);
        if ((double)f2 >= 0.0) {
            b b4 = b3;
            b3.j = n6;
            b3.k = n7;
            b3.f = f2;
            b3.l = bl2;
            b3.m = bl3;
            b3.n = bl4;
            b4.o = bl5;
            b4.i = true;
        }
        b3.a = n2;
        b3.b = n3;
        b3.c = n4;
        b3.d = n5;
        b3.e = bl;
        return b3;
    }

    public static void setAccessibilitySnapshotSelection(b b2, int n2, int n3) {
        b2.p = true;
        b2.q = n2;
        b2.r = n3;
    }

    private void onDownloadImageFinished(f f2, int n2, int n3, String string2, List<Bitmap> list, List<Rect> list2) {
        f2.a(n2, n3, string2, list, list2);
    }

    private final void setMediaSession(MediaSessionImpl mediaSessionImpl) {
        this.mMediaSession = mediaSessionImpl;
    }

    public static List<Bitmap> createBitmapList() {
        return new ArrayList<Bitmap>();
    }

    public static void addToBitmapList(List<Bitmap> list, Bitmap bitmap) {
        list.add(bitmap);
    }

    public static List<Rect> createSizeList() {
        return new ArrayList<Rect>();
    }

    public static void createSizeAndAddToList(List<Rect> list, int n2, int n3) {
        list.add(new Rect(0, 0, n2, n3));
    }

    public static Rect createSize(int n2, int n3) {
        return new Rect(0, 0, n2, n3);
    }

    private l getUserDataHost() {
        Object object = ((WebContentsImpl)object).mInternalsHolder;
        if (object == null) {
            return null;
        }
        if ((object = object.get()) == null) {
            return null;
        }
        return ((WebContentsInternalsImpl)object).userDataHost;
    }

    private void checkNotDestroyed() {
        if (this.mNativeWebContentsAndroid != 0L) {
            return;
        }
        throw new IllegalStateException("Native WebContents already destroyed", this.mNativeDestroyThrowable);
    }

    public static native void nativeDestroyWebContents(long var0);

    public static native WebContents nativeFromNativePtr(long var0);

    private native WindowAndroid nativeGetTopLevelNativeWindow(long var1);

    private native void nativeSetTopLevelNativeWindow(long var1, WindowAndroid var3);

    private native r nativeGetMainFrame(long var1);

    private native String nativeGetTitle(long var1);

    private native String nativeGetVisibleURL(long var1);

    private native String nativeGetEncoding(long var1);

    private native boolean nativeIsLoading(long var1);

    private native boolean nativeIsLoadingToDifferentDocument(long var1);

    private native void nativeStop(long var1);

    private native void nativeCut(long var1);

    private native void nativeCopy(long var1);

    private native void nativePaste(long var1);

    private native void nativePasteAsPlainText(long var1);

    private native void nativeReplace(long var1, String var3);

    private native void nativeSelectAll(long var1);

    private native void nativeCollapseSelection(long var1);

    private native void nativeOnHide(long var1);

    private native void nativeOnShow(long var1);

    private native void nativeSetImportance(long var1, int var3);

    private native void nativeSuspendAllMediaPlayers(long var1);

    private native void nativeSetAudioMuted(long var1, boolean var3);

    private native int nativeGetBackgroundColor(long var1);

    private native boolean nativeIsShowingInterstitialPage(long var1);

    private native boolean nativeFocusLocationBarByDefault(long var1);

    private native boolean nativeIsRenderWidgetHostViewReady(long var1);

    private native void nativeExitFullscreen(long var1);

    private native void nativeScrollFocusedEditableNodeIntoView(long var1);

    private native void nativeSelectWordAroundCaret(long var1);

    private native void nativeAdjustSelectionByCharacterOffset(long var1, int var3, int var4, boolean var5);

    private native String nativeGetLastCommittedURL(long var1);

    private native boolean nativeIsIncognito(long var1);

    private native void nativeResumeLoadingCreatedWebContents(long var1);

    private native void nativeEvaluateJavaScript(long var1, String var3, JavaScriptCallback var4);

    private native void nativeEvaluateJavaScriptForTests(long var1, String var3, JavaScriptCallback var4);

    private native void nativeAddMessageToDevToolsConsole(long var1, int var3, String var4);

    private native void nativePostMessageToFrame(long var1, String var3, String var4, String var5, String var6, n[] var7);

    private native boolean nativeHasAccessedInitialDocument(long var1);

    private native int nativeGetThemeColor(long var1);

    private native void nativeRequestSmartClipExtract(long var1, SmartClipCallback var3, int var4, int var5, int var6, int var7);

    private native void nativeRequestAccessibilitySnapshot(long var1, a var3);

    private native void nativeSetOverscrollRefreshHandler(long var1, OverscrollRefreshHandler var3);

    private native void nativeWriteContentBitmapToDisk(long var1, int var3, int var4, String var5, Callback<String> var6);

    private native void nativeReloadLoFiImages(long var1);

    private native int nativeDownloadImage(long var1, String var3, boolean var4, int var5, boolean var6, f var7);

    private native void nativeDismissTextHandles(long var1);

    private native void nativeShowContextMenuAtTouchHandle(long var1, int var3, int var4);

    private native void nativeSetHasPersistentVideo(long var1, boolean var3);

    private native boolean nativeHasActiveEffectivelyFullscreenVideo(long var1);

    private native boolean nativeIsPictureInPictureAllowedForFullscreenVideo(long var1);

    private native Rect nativeGetFullscreenVideoSize(long var1);

    private native void nativeSetSize(long var1, int var3, int var4);

    private native int nativeGetWidth(long var1);

    private native int nativeGetHeight(long var1);

    private native EventForwarder nativeGetOrCreateEventForwarder(long var1);

    private native void nativeSetViewAndroidDelegate(long var1, ViewAndroidDelegate var3);

    private native void nativeSendOrientationChangeEvent(long var1, int var3);

    private native void nativeOnScaleFactorChanged(long var1);

    private native void nativeSetFocus(long var1, boolean var3);

    private native void nativeSetDisplayCutoutSafeArea(long var1, int var3, int var4, int var5, int var6);

    private native boolean nativeIsBeingDestroyed(long var1);

    static {
        $assertionsDisabled = WebContentsImpl.class.desiredAssertionStatus() ^ true;
        sParcelableUUID = UUID.randomUUID();
        CREATOR = new Parcelable.Creator<WebContents>(){

            public WebContents createFromParcel(Parcel parcel) {
                1 this_ = parcel.readBundle();
                if (this_.getLong(WebContentsImpl.PARCEL_VERSION_KEY, -1L) != 0L) {
                    return null;
                }
                if (sParcelableUUID.compareTo(((ParcelUuid)this_.getParcelable(WebContentsImpl.PARCEL_PROCESS_GUARD_KEY)).getUuid()) != 0) {
                    return null;
                }
                return WebContentsImpl.nativeFromNativePtr(this_.getLong(WebContentsImpl.PARCEL_WEBCONTENTS_KEY));
            }

            public WebContents[] newArray(int n2) {
                return new WebContents[n2];
            }
        };
    }

    @Override
    public void initialize(String string2, ViewAndroidDelegate viewAndroidDelegate, z.a a2, WindowAndroid windowAndroid, WebContents.InternalsHolder internalsHolder) {
        WebContentsImpl webContentsImpl;
        WebContentsInternalsImpl webContentsInternalsImpl;
        if (!$assertionsDisabled && ((WebContentsImpl)((Object)webContentsInternalsImpl2)).mInitialized) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && internalsHolder == null) {
            throw new AssertionError();
        }
        WebContentsImpl webContentsImpl2 = webContentsInternalsImpl2;
        WebContentsImpl webContentsImpl3 = webContentsInternalsImpl2;
        ((WebContentsImpl)((Object)webContentsInternalsImpl2)).mProductVersion = string2;
        ((WebContentsImpl)((Object)webContentsInternalsImpl2)).mInternalsHolder = internalsHolder;
        WebContentsInternalsImpl webContentsInternalsImpl2 = webContentsInternalsImpl;
        new WebContentsInternalsImpl(null).userDataHost = new l();
        webContentsImpl.mInternalsHolder.set(webContentsInternalsImpl2);
        j j2 = webContentsImpl.mRenderCoordinates = new j();
        j2.b = 0.0f;
        j2.a = 0.0f;
        j2.g = 1.0f;
        webContentsImpl.mInitialized = true;
        webContentsImpl3.setViewAndroidDelegate(viewAndroidDelegate);
        webContentsImpl2.setTopLevelNativeWindow(windowAndroid);
        o o2 = o.a(webContentsImpl2);
        GestureListenerManagerImpl.fromWebContents(o2.j).setScrollDelegate(a2);
        ContentUiEventHandler.fromWebContents(o2.j).setEventDelegate(a2);
        webContentsImpl2.getRenderCoordinates().j = windowAndroid.getDisplay().d;
    }

    @Nullable
    public Context getContext() {
        if (!$assertionsDisabled && !((WebContentsImpl)this).mInitialized) {
            throw new AssertionError();
        }
        return (this = ((WebContentsImpl)this).getTopLevelNativeWindow()) != null ? (Context)((WindowAndroid)this).getContext().get() : null;
    }

    public String getProductVersion() {
        if (!$assertionsDisabled && !this.mInitialized) {
            throw new AssertionError();
        }
        return this.mProductVersion;
    }

    @Override
    public void renderFrameCreated(RenderFrameHostImpl renderFrameHostImpl) {
        if (!$assertionsDisabled && this.mFrames.contains(renderFrameHostImpl)) {
            throw new AssertionError();
        }
        this.mFrames.add(renderFrameHostImpl);
    }

    @Override
    public void renderFrameDeleted(RenderFrameHostImpl renderFrameHostImpl) {
        if (!$assertionsDisabled && !this.mFrames.contains(renderFrameHostImpl)) {
            throw new AssertionError();
        }
        this.mFrames.remove(renderFrameHostImpl);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        ParcelUuid parcelUuid;
        Bundle bundle = new Bundle();
        bundle.putLong(PARCEL_VERSION_KEY, 0L);
        WebContentsImpl webContentsImpl = parcelUuid;
        parcelUuid = new ParcelUuid(sParcelableUUID);
        bundle.putParcelable(PARCEL_PROCESS_GUARD_KEY, (Parcelable)webContentsImpl);
        long l2 = webContentsImpl.mNativeWebContentsAndroid;
        bundle.putLong(PARCEL_WEBCONTENTS_KEY, l2);
        parcel.writeBundle(bundle);
    }

    @Override
    public WindowAndroid getTopLevelNativeWindow() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeGetTopLevelNativeWindow(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void setTopLevelNativeWindow(WindowAndroid windowAndroid) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeSetTopLevelNativeWindow(webContentsImpl.mNativeWebContentsAndroid, windowAndroid);
        q.a(webContentsImpl).onWindowAndroidChanged(windowAndroid);
    }

    @Override
    public ViewAndroidDelegate getViewAndroidDelegate() {
        b0 b02 = ((WebContentsImpl)((Object)b02)).mInternalsHolder.get();
        if (b02 == null) {
            return null;
        }
        return ((WebContentsInternalsImpl)b02).viewAndroidDelegate;
    }

    public void setViewAndroidDelegate(ViewAndroidDelegate viewAndroidDelegate) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        b0 b02 = webContentsImpl.mInternalsHolder.get();
        if (!$assertionsDisabled && b02 == null) {
            throw new AssertionError();
        }
        b02 = (WebContentsInternalsImpl)b02;
        if (!$assertionsDisabled && ((WebContentsInternalsImpl)b02).viewAndroidDelegate != null) {
            throw new AssertionError();
        }
        WebContentsImpl webContentsImpl2 = this;
        ((WebContentsInternalsImpl)b02).viewAndroidDelegate = viewAndroidDelegate;
        webContentsImpl2.nativeSetViewAndroidDelegate(webContentsImpl2.mNativeWebContentsAndroid, viewAndroidDelegate);
    }

    @Override
    public void destroy() {
        if (ThreadUtils.runningOnUiThread()) {
            long l2 = this.mNativeWebContentsAndroid;
            if (l2 != 0L) {
                WebContentsImpl.nativeDestroyWebContents(l2);
            }
            return;
        }
        throw new IllegalStateException("Attempting to destroy WebContents on non-UI thread");
    }

    @Override
    public boolean isDestroyed() {
        long l2 = this.mNativeWebContentsAndroid;
        return l2 == 0L || this.nativeIsBeingDestroyed(l2);
    }

    @Override
    public NavigationController getNavigationController() {
        return this.mNavigationController;
    }

    @Override
    public r getMainFrame() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeGetMainFrame(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public String getTitle() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeGetTitle(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public String getVisibleUrl() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeGetVisibleURL(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public String getEncoding() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeGetEncoding(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public boolean isLoading() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeIsLoading(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public boolean isLoadingToDifferentDocument() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeIsLoadingToDifferentDocument(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void stop() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeStop(webContentsImpl.mNativeWebContentsAndroid);
    }

    public void cut() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeCut(webContentsImpl.mNativeWebContentsAndroid);
    }

    public void copy() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeCopy(webContentsImpl.mNativeWebContentsAndroid);
    }

    public void paste() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativePaste(webContentsImpl.mNativeWebContentsAndroid);
    }

    public void pasteAsPlainText() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativePasteAsPlainText(webContentsImpl.mNativeWebContentsAndroid);
    }

    public void replace(String string2) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeReplace(webContentsImpl.mNativeWebContentsAndroid, string2);
    }

    public void selectAll() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeSelectAll(webContentsImpl.mNativeWebContentsAndroid);
    }

    public void collapseSelection() {
        if (this.isDestroyed()) {
            return;
        }
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.nativeCollapseSelection(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void onHide() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        SelectionPopupControllerImpl selectionPopupControllerImpl = webContentsImpl.getSelectionPopupController();
        if (selectionPopupControllerImpl != null) {
            selectionPopupControllerImpl.hidePopupsAndPreserveSelection();
        }
        WebContentsImpl webContentsImpl2 = this;
        webContentsImpl2.nativeOnHide(webContentsImpl2.mNativeWebContentsAndroid);
    }

    @Override
    public void onShow() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        p p2 = WebContentsAccessibilityImpl.fromWebContents(webContentsImpl);
        if (p2 != null) {
            ((WebContentsAccessibilityImpl)p2).refreshState();
        }
        if ((p2 = this.getSelectionPopupController()) != null) {
            ((SelectionPopupControllerImpl)p2).restoreSelectionPopupsIfNecessary();
        }
        WebContentsImpl webContentsImpl2 = this;
        webContentsImpl2.nativeOnShow(webContentsImpl2.mNativeWebContentsAndroid);
    }

    @Override
    public void setImportance(int n2) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeSetImportance(webContentsImpl.mNativeWebContentsAndroid, n2);
    }

    @Override
    public void suspendAllMediaPlayers() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeSuspendAllMediaPlayers(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void setAudioMuted(boolean bl) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeSetAudioMuted(webContentsImpl.mNativeWebContentsAndroid, bl);
    }

    @Override
    public int getBackgroundColor() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeGetBackgroundColor(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public boolean isShowingInterstitialPage() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeIsShowingInterstitialPage(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public boolean focusLocationBarByDefault() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeFocusLocationBarByDefault(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public boolean isReady() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeIsRenderWidgetHostViewReady(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void exitFullscreen() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeExitFullscreen(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void scrollFocusedEditableNodeIntoView() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeScrollFocusedEditableNodeIntoView(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void selectWordAroundCaret() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeSelectWordAroundCaret(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void adjustSelectionByCharacterOffset(int n2, int n3, boolean bl) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.nativeAdjustSelectionByCharacterOffset(webContentsImpl.mNativeWebContentsAndroid, n2, n3, bl);
    }

    @Override
    public String getLastCommittedUrl() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeGetLastCommittedURL(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public boolean isIncognito() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeIsIncognito(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void resumeLoadingCreatedWebContents() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeResumeLoadingCreatedWebContents(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void evaluateJavaScript(String string2, JavaScriptCallback javaScriptCallback) {
        ThreadUtils.assertOnUiThread();
        if (!this.isDestroyed() && string2 != null) {
            WebContentsImpl webContentsImpl = this;
            webContentsImpl.nativeEvaluateJavaScript(webContentsImpl.mNativeWebContentsAndroid, string2, javaScriptCallback);
            return;
        }
    }

    @Override
    public void evaluateJavaScriptForTests(String string2, JavaScriptCallback javaScriptCallback) {
        ThreadUtils.assertOnUiThread();
        if (string2 == null) {
            return;
        }
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeEvaluateJavaScriptForTests(webContentsImpl.mNativeWebContentsAndroid, string2, javaScriptCallback);
    }

    @Override
    public void addMessageToDevToolsConsole(int n2, String string2) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeAddMessageToDevToolsConsole(webContentsImpl.mNativeWebContentsAndroid, n2, string2);
    }

    @Override
    public void postMessageToFrame(String string2, String string3, String string4, String string5, n[] nArray) {
        if (nArray != null) {
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                n n3 = nArray[i2];
                if (!((AppWebMessagePort)n3).a) {
                    n3 = (AppWebMessagePort)n3;
                    if (!((AppWebMessagePort)n3).b) {
                        if (!((AppWebMessagePort)n3).c) {
                            continue;
                        }
                        throw new IllegalStateException("Port is already started");
                    }
                }
                throw new IllegalStateException("Port is already closed or transferred");
            }
        }
        if (string5.equals("*")) {
            string5 = "";
        }
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.nativePostMessageToFrame(webContentsImpl.mNativeWebContentsAndroid, string2, string3, string4, string5, nArray);
    }

    public AppWebMessagePort[] createMessageChannel() {
        return AppWebMessagePort.a();
    }

    @Override
    public boolean hasAccessedInitialDocument() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeHasAccessedInitialDocument(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public int getThemeColor() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeGetThemeColor(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void requestSmartClipExtract(int n2, int n3, int n4, int n5) {
        if (this.mSmartClipCallback == null) {
            return;
        }
        WebContentsImpl webContentsImpl = this;
        WebContentsImpl webContentsImpl2 = this;
        webContentsImpl2.checkNotDestroyed();
        j j2 = webContentsImpl2.getRenderCoordinates();
        float f2 = j2.j;
        int n6 = n3 - (int)j2.k;
        webContentsImpl.nativeRequestSmartClipExtract(webContentsImpl.mNativeWebContentsAndroid, this.mSmartClipCallback, (int)((float)n2 / f2), (int)((float)n6 / f2), (int)((float)n4 / f2), (int)((float)n5 / f2));
    }

    @Override
    public void setSmartClipResultHandler(Handler handler) {
        if (handler == null) {
            this.mSmartClipCallback = null;
            return;
        }
        this.mSmartClipCallback = new SmartClipCallback(handler);
    }

    @Override
    public void requestAccessibilitySnapshot(a a2) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeRequestAccessibilitySnapshot(webContentsImpl.mNativeWebContentsAndroid, a2);
    }

    @Override
    public void simulateRendererKilledForTesting(boolean bl) {
        WebContentsObserverProxy webContentsObserverProxy = ((WebContentsImpl)((Object)webContentsObserverProxy)).mObserverProxy;
        if (webContentsObserverProxy != null) {
            webContentsObserverProxy.renderProcessGone(bl);
        }
    }

    @Override
    public boolean isSelectPopupVisibleForTesting() {
        return false;
    }

    @Override
    public EventForwarder getEventForwarder() {
        if (!$assertionsDisabled && this.mNativeWebContentsAndroid == 0L) {
            throw new AssertionError();
        }
        if (this.mEventForwarder == null) {
            WebContentsImpl webContentsImpl = this;
            webContentsImpl.checkNotDestroyed();
            webContentsImpl.mEventForwarder = webContentsImpl.nativeGetOrCreateEventForwarder(webContentsImpl.mNativeWebContentsAndroid);
        }
        return this.mEventForwarder;
    }

    @Override
    public void addObserver(c0 c02) {
        if (!$assertionsDisabled && this.mNativeWebContentsAndroid == 0L) {
            throw new AssertionError();
        }
        if (this.mObserverProxy == null) {
            this.mObserverProxy = new WebContentsObserverProxy(this);
        }
        this.mObserverProxy.addObserver(c02);
    }

    @Override
    public void removeObserver(c0 c02) {
        WebContentsObserverProxy webContentsObserverProxy = ((WebContentsImpl)((Object)webContentsObserverProxy)).mObserverProxy;
        if (webContentsObserverProxy == null) {
            return;
        }
        webContentsObserverProxy.removeObserver(c02);
    }

    @Override
    public void setOverscrollRefreshHandler(OverscrollRefreshHandler overscrollRefreshHandler) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeSetOverscrollRefreshHandler(webContentsImpl.mNativeWebContentsAndroid, overscrollRefreshHandler);
    }

    @Override
    public void writeContentBitmapToDiskAsync(int n2, int n3, String string2, Callback<String> callback) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeWriteContentBitmapToDisk(webContentsImpl.mNativeWebContentsAndroid, n2, n3, string2, callback);
    }

    @Override
    public void reloadLoFiImages() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeReloadLoFiImages(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public int downloadImage(String string2, boolean bl, int n2, boolean bl2, f f2) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeDownloadImage(webContentsImpl.mNativeWebContentsAndroid, string2, bl, n2, bl2, f2);
    }

    public void dismissTextHandles() {
        if (this.isDestroyed()) {
            return;
        }
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.nativeDismissTextHandles(webContentsImpl.mNativeWebContentsAndroid);
    }

    public void showContextMenuAtTouchHandle(int n2, int n3) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeShowContextMenuAtTouchHandle(webContentsImpl.mNativeWebContentsAndroid, n2, n3);
    }

    @Override
    public void setHasPersistentVideo(boolean bl) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeSetHasPersistentVideo(webContentsImpl.mNativeWebContentsAndroid, bl);
    }

    @Override
    public boolean hasActiveEffectivelyFullscreenVideo() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeHasActiveEffectivelyFullscreenVideo(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public boolean isPictureInPictureAllowedForFullscreenVideo() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeIsPictureInPictureAllowedForFullscreenVideo(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    @Nullable
    public Rect getFullscreenVideoSize() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeGetFullscreenVideoSize(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public void setSize(int n2, int n3) {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        webContentsImpl.nativeSetSize(webContentsImpl.mNativeWebContentsAndroid, n2, n3);
    }

    @Override
    public int getWidth() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeGetWidth(webContentsImpl.mNativeWebContentsAndroid);
    }

    @Override
    public int getHeight() {
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.checkNotDestroyed();
        return webContentsImpl.nativeGetHeight(webContentsImpl.mNativeWebContentsAndroid);
    }

    public j getRenderCoordinates() {
        return this.mRenderCoordinates;
    }

    public <T extends k> T getOrSetUserData(Class<T> clazz, UserDataFactory<T> userDataFactory) {
        Object object;
        if (!object.mInitialized) {
            return null;
        }
        l l2 = object.getUserDataHost();
        if (l2 == null) {
            object = new Object[]{};
            g.b(TAG, "UserDataHost can't be found", object);
            return null;
        }
        T t2 = l2.a(clazz);
        if (t2 == null && userDataFactory != null) {
            if (!$assertionsDisabled && l2.a(clazz) != null) {
                throw new AssertionError();
            }
            object = (k)userDataFactory.create((WebContents)object);
            if (!$assertionsDisabled && !clazz.isInstance(object)) {
                throw new AssertionError();
            }
            l2.a();
            if (!l.c && object == null) {
                throw new AssertionError((Object)"Neither key nor object of UserDataHost can be null");
            }
            l2.b.put(clazz, (k)object);
            t2 = l2.a(clazz);
        }
        return (T)((k)clazz.cast(t2));
    }

    @Override
    public void onRotationChanged(int n2) {
        if (this.mNativeWebContentsAndroid == 0L) {
            return;
        }
        switch (n2) {
            default: {
                throw new IllegalStateException("Display.getRotation() shouldn't return that value");
            }
            case 3: {
                n2 = -90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        WebContentsImpl webContentsImpl = this;
        webContentsImpl.nativeSendOrientationChangeEvent(webContentsImpl.mNativeWebContentsAndroid, n2);
    }

    @Override
    public void onDIPScaleChanged(float f2) {
        long l2 = this.mNativeWebContentsAndroid;
        if (l2 == 0L) {
            return;
        }
        this.mRenderCoordinates.j = f2;
        this.nativeOnScaleFactorChanged(l2);
    }

    public void setFocus(boolean bl) {
        long l2 = this.mNativeWebContentsAndroid;
        if (l2 == 0L) {
            return;
        }
        this.nativeSetFocus(l2, bl);
    }

    @Override
    public void setDisplayCutoutSafeArea(Rect rect) {
        long l2 = this.mNativeWebContentsAndroid;
        if (l2 == 0L) {
            return;
        }
        this.nativeSetDisplayCutoutSafeArea(l2, rect.top, rect.left, rect.bottom, rect.right);
    }

    public static class WebContentsInternalsImpl
    implements b0 {
        public l userDataHost;
        public ViewAndroidDelegate viewAndroidDelegate;

        public WebContentsInternalsImpl() {
        }

        public /* synthetic */ WebContentsInternalsImpl(1 var1_1) {
            this();
        }
    }

    public class SmartClipCallback {
        public final Handler mHandler;

        public SmartClipCallback(Handler handler) {
            this.mHandler = handler;
        }

        public void onSmartClipDataExtracted(String string2, String string3, Rect rect) {
            Bundle bundle;
            j j2 = WebContentsImpl.this.getRenderCoordinates();
            rect.offset(0, (int)(j2.k / j2.j));
            j2 = bundle;
            j2();
            j2.putString("url", WebContentsImpl.this.getVisibleUrl());
            bundle.putString("title", WebContentsImpl.this.getTitle());
            bundle.putString("text", string2);
            bundle.putString("html", string3);
            bundle.putParcelable("rect", (Parcelable)rect);
            Message message = Message.obtain((Handler)this.mHandler, (int)0);
            message.setData((Bundle)j2);
            message.sendToTarget();
        }
    }

    public static interface UserDataFactory<T> {
        public T create(WebContents var1);
    }
}

