/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.b.a.h;
import a.b.d.a.l;
import a.b.d.a.m;
import java.util.Arrays;
import java.util.HashSet;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content_public.browser.WebContents;
import org.chromium.services.media_session.MediaImage;
import org.chromium.services.media_session.MediaMetadata;

@JNINamespace(value="content")
public class MediaSessionImpl
extends l {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mNativeMediaSessionAndroid;
    public h<m> mObservers;
    public h.c<m> mObserversIterator;

    public static MediaSessionImpl fromWebContents(WebContents webContents) {
        return MediaSessionImpl.nativeGetMediaSessionFromWebContents(webContents);
    }

    private boolean hasObservers() {
        return this.mObservers.b() ^ true;
    }

    private void mediaSessionDestroyed() {
        ((h.b)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((m)this.mObserversIterator.next()).c();
        }
        ((h.b)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((m)this.mObserversIterator.next()).f();
        }
        this.mObservers.a();
        this.mNativeMediaSessionAndroid = 0L;
    }

    private void mediaSessionStateChanged(boolean bl, boolean bl2) {
        ((h.b)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((m)this.mObserversIterator.next()).e();
        }
    }

    private void mediaSessionMetadataChanged(MediaMetadata mediaMetadata) {
        ((h.b)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((m)this.mObserversIterator.next()).d();
        }
    }

    private void mediaSessionActionsChanged(int[] nArray) {
        HashSet<Integer> hashSet;
        HashSet<Integer> hashSet2 = hashSet;
        hashSet = new HashSet<Integer>();
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            hashSet2.add(nArray[i2]);
        }
        ((h.b)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((m)this.mObserversIterator.next()).a();
        }
    }

    private void mediaSessionArtworkChanged(MediaImage[] mediaImageArray) {
        Arrays.asList(mediaImageArray);
        ((h.b)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((m)this.mObserversIterator.next()).b();
        }
    }

    public static MediaSessionImpl create(long l2) {
        return new MediaSessionImpl(l2);
    }

    public MediaSessionImpl(long l2) {
        this.mNativeMediaSessionAndroid = l2;
        this.mObservers = new h();
        this.mObserversIterator = this.mObservers.c();
    }

    private native void nativeResume(long var1);

    private native void nativeSuspend(long var1);

    private native void nativeStop(long var1);

    private native void nativeSeek(long var1, long var3);

    private native void nativeDidReceiveAction(long var1, int var3);

    private native void nativeRequestSystemAudioFocus(long var1);

    public static native MediaSessionImpl nativeGetMediaSessionFromWebContents(WebContents var0);

    static {
        $assertionsDisabled = MediaSessionImpl.class.desiredAssertionStatus() ^ true;
    }

    public void addObserver(m m2) {
        this.mObservers.a(m2);
    }

    public void removeObserver(m m2) {
        this.mObservers.b(m2);
    }

    @Override
    public h.c<m> getObserversForTesting() {
        return this.mObservers.c();
    }

    @Override
    public void resume() {
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeResume(mediaSessionImpl.mNativeMediaSessionAndroid);
    }

    @Override
    public void suspend() {
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeSuspend(mediaSessionImpl.mNativeMediaSessionAndroid);
    }

    @Override
    public void stop() {
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeStop(mediaSessionImpl.mNativeMediaSessionAndroid);
    }

    @Override
    public void seek(long l2) {
        if (!$assertionsDisabled && l2 != 0L) {
            throw new AssertionError((Object)"Attempted to seek by an unspecified number of milliseconds");
        }
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeSeek(mediaSessionImpl.mNativeMediaSessionAndroid, l2);
    }

    @Override
    public void didReceiveAction(int n2) {
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeDidReceiveAction(mediaSessionImpl.mNativeMediaSessionAndroid, n2);
    }

    @Override
    public void requestSystemAudioFocus() {
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeRequestSystemAudioFocus(mediaSessionImpl.mNativeMediaSessionAndroid);
    }
}

