/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.b.a.g;
import a.b.a.p.a;
import a.b.a.p.c;
import a.b.a.p.d;
import a.b.c.a.a;
import a.b.c.a.e;
import a.b.c.b.d;
import a.b.c.b.l;
import a.b.c.b.m;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.text.TextUtils;
import com.vccorp.base.library_loader.Linker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.Callback;
import org.chromium.base.ContextUtils;
import org.chromium.base.CpuFeatures;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.process_launcher.FileDescriptorInfo;
import org.chromium.content.browser.ContentFeatureList;
import org.chromium.content.browser.GpuProcessCallback;
import org.chromium.content.browser.LauncherThread;

@JNINamespace(value="content::internal")
public final class ChildProcessLauncherHelperImpl {
    public static final String TAG = "ChildProcLH";
    public static final String NUM_SANDBOXED_SERVICES_KEY = "com.vccorp.content.browser.NUM_SANDBOXED_SERVICES";
    public static final String SANDBOXED_SERVICES_NAME = "com.vccorp.content.app.SandboxedProcessService";
    public static final String NUM_PRIVILEGED_SERVICES_KEY = "com.vccorp.content.browser.NUM_PRIVILEGED_SERVICES";
    public static final String PRIVILEGED_SERVICES_NAME = "com.vccorp.content.app.PrivilegedProcessService";
    public static l sSpareSandboxedConnection;
    public static l sSparePrivilegedConntection;
    public static a.b.a.p.a sSandboxedChildConnectionAllocator;
    public static a.b.c.b.d sSandboxedChildConnectionRanking;
    public static final Map<Integer, ChildProcessLauncherHelperImpl> sLauncherByPid;
    public static a.b.a.p.a sPrivilegedChildConnectionAllocator;
    public static a.b sSandboxedServiceFactoryForTesting;
    public static int sSandboxedServicesCountForTesting;
    public static String sSandboxedServicesNameForTesting;
    public static a.b.c.b.a sBindingManager;
    public static boolean sApplicationInForegroundOnUiThread;
    public static boolean sLinkerInitialized;
    public static long sLinkerLoadAddress;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final a.b.c.b.d mRanking;
    public final a.b.c.b.a mBindingManager;
    public final boolean mSandboxed;
    public final String mProcessType;
    public final boolean mCanUseWarmUpConnection;
    public final d.c mLauncherDelegate = new d.c(){
        public static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = ChildProcessLauncherHelperImpl.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public c getBoundConnection(a.b.a.p.a object, c.j j2) {
            if (!l2.ChildProcessLauncherHelperImpl.this.mCanUseWarmUpConnection) {
                return null;
            }
            l l2 = l2.ChildProcessLauncherHelperImpl.this.mSandboxed ? sSpareSandboxedConnection : sSparePrivilegedConntection;
            if (l2 == null) {
                return null;
            }
            if (!l.e && !LauncherThread.runningOnLauncherThread()) {
                throw new AssertionError();
            }
            if (!l2.b() && l2.a == object && l2.d == null) {
                l l3 = l2;
                l3.d = j2;
                object = l3.b;
                if (l3.c) {
                    if (j2 != null) {
                        LauncherThread.post(new m(l2, j2));
                    }
                    l2.a();
                }
            } else {
                object = null;
            }
            return object;
        }

        @Override
        public void onBeforeConnectionAllocated(Bundle bundle) {
            ChildProcessLauncherHelperImpl.populateServiceBundle(bundle);
        }

        @Override
        public void onBeforeConnectionSetup(Bundle bundle) {
            Bundle bundle2 = bundle;
            bundle2.putInt("com.google.android.apps.chrome.extra.cpu_count", CpuFeatures.getCount());
            long l2 = CpuFeatures.getMask();
            bundle2.putLong("com.google.android.apps.chrome.extra.cpu_features", l2);
            if (LibraryLoader.useCrazyLinker()) {
                bundle.putBundle("com.vccorp.base.android.linker.shared_relros", Linker.l.e());
            }
        }

        @Override
        public void onConnectionEstablished(c c2) {
            if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
                throw new AssertionError();
            }
            int n2 = c2.e();
            if (n2 > 0) {
                sLauncherByPid.put(n2, ChildProcessLauncherHelperImpl.this);
                if (ChildProcessLauncherHelperImpl.this.mRanking != null) {
                    1 v0 = this;
                    v0.ChildProcessLauncherHelperImpl.this.mRanking.a(c2, false, 1L, false, 1);
                    if (v0.ChildProcessLauncherHelperImpl.this.mBindingManager != null) {
                        ChildProcessLauncherHelperImpl.this.mBindingManager.a();
                    }
                }
            }
            if (ChildProcessLauncherHelperImpl.this.mNativeChildProcessLauncherHelper != 0L) {
                ChildProcessLauncherHelperImpl.nativeOnChildProcessStarted(ChildProcessLauncherHelperImpl.this.mNativeChildProcessLauncherHelper, c2.e());
            }
            ChildProcessLauncherHelperImpl.access$802(ChildProcessLauncherHelperImpl.this, 0L);
        }

        @Override
        public void onConnectionLost(c c2) {
            if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
                throw new AssertionError();
            }
            if (c2.e() == 0) {
                return;
            }
            sLauncherByPid.remove(c2.e());
            if (ChildProcessLauncherHelperImpl.this.mBindingManager != null) {
                ChildProcessLauncherHelperImpl.this.mBindingManager.b(c2);
            }
            if (ChildProcessLauncherHelperImpl.this.mRanking != null) {
                1 v0 = this;
                v0.ChildProcessLauncherHelperImpl.this.mRanking.b(c2);
                if (v0.ChildProcessLauncherHelperImpl.this.mBindingManager != null) {
                    ChildProcessLauncherHelperImpl.this.mBindingManager.a();
                }
            }
        }
    };
    public final d mLauncher;
    public long mNativeChildProcessLauncherHelper;
    public int mEffectiveImportance = 1;
    public boolean mVisible;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileDescriptorInfo makeFdInfo(int n2, int n3, boolean bl, long l2, long l3) {
        ParcelFileDescriptor parcelFileDescriptor;
        if (!$assertionsDisabled) {
            if (!LauncherThread.runningOnLauncherThread()) throw new AssertionError();
        }
        if (bl) {
            parcelFileDescriptor = ParcelFileDescriptor.adoptFd((int)n3);
            return new FileDescriptorInfo(n2, parcelFileDescriptor, l2, l3);
        }
        try {
            parcelFileDescriptor = ParcelFileDescriptor.fromFd((int)n3);
            return new FileDescriptorInfo(n2, parcelFileDescriptor, l2, l3);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = iOException;
            g.b(TAG, "Invalid FD provided for process connection, aborting connection.", objectArray2);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ChildProcessLauncherHelperImpl createAndStart(long l2, String[] stringArray, FileDescriptorInfo[] fileDescriptorInfoArray, boolean bl) {
        boolean bl2;
        Object object;
        block7: {
            block8: {
                if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
                    throw new AssertionError();
                }
                object = a.b.a.e.a(stringArray, "type");
                bl2 = true;
                if ("renderer".equals(object)) break block7;
                if ("gpu-process".equals(object)) break block8;
                if (!$assertionsDisabled && !"utility".equals(object)) {
                    throw new AssertionError();
                }
                if (!"network".equals(a.b.a.e.a(stringArray, "service-sandbox-type"))) break block7;
            }
            bl2 = false;
        }
        if ("gpu-process".equals(object)) {
            GpuProcessCallback gpuProcessCallback;
            object = gpuProcessCallback;
            gpuProcessCallback = new GpuProcessCallback();
        } else {
            object = null;
        }
        ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl = new ChildProcessLauncherHelperImpl(l2, stringArray, fileDescriptorInfoArray, bl2, bl, (IBinder)object);
        childProcessLauncherHelperImpl.start();
        return childProcessLauncherHelperImpl;
    }

    public static void warmUp(final Context context, final boolean bl) {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        LauncherThread.post(new Runnable(){

            @Override
            public void run() {
                ChildProcessLauncherHelperImpl.warmUpOnLauncherThread(context, bl);
            }
        });
    }

    public static void warmUpOnLauncherThread(Context context, boolean bl) {
        l l2 = bl ? sSpareSandboxedConnection : sSparePrivilegedConntection;
        if (l2 != null) {
            boolean bl2 = l2.b == null || l2.d != null;
            if (!bl2) {
                return;
            }
        }
        Bundle bundle = ChildProcessLauncherHelperImpl.populateServiceBundle(new Bundle());
        a.b.a.p.a a2 = ChildProcessLauncherHelperImpl.getConnectionAllocator(context, bl);
        if (bl) {
            sSpareSandboxedConnection = new l(context, a2, bundle);
        } else {
            sSparePrivilegedConntection = new l(context, a2, bundle);
        }
    }

    public static void startModerateBindingManagement(final Context context) {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        LauncherThread.post(new Runnable(){

            @Override
            public void run() {
                a.b.a.p.a a2 = ChildProcessLauncherHelperImpl.getConnectionAllocator(context, true);
                sBindingManager = new a.b.c.b.a(context, a2.b.length, sSandboxedChildConnectionRanking);
            }
        });
        sApplicationInForegroundOnUiThread = ApplicationStatus.getStateForApplication() == 1 || ApplicationStatus.getStateForApplication() == 2;
        ApplicationStatus.registerApplicationStateListener(n2 -> {
            if (n2 != 0) {
                if (n2 != 1 && n2 != 2) {
                    if (sApplicationInForegroundOnUiThread) {
                        ChildProcessLauncherHelperImpl.onSentToBackground();
                    }
                } else if (!sApplicationInForegroundOnUiThread) {
                    ChildProcessLauncherHelperImpl.onBroughtToForeground();
                }
            }
        });
    }

    public static void onSentToBackground() {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        sApplicationInForegroundOnUiThread = false;
        LauncherThread.post(() -> {
            a.b.c.b.a a2 = sBindingManager;
            if (a2 != null) {
                a2.c();
            }
        });
    }

    public static void onBroughtToForeground() {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        sApplicationInForegroundOnUiThread = true;
        LauncherThread.post(() -> {
            a.b.c.b.a a2 = sBindingManager;
            if (a2 != null) {
                a2.b();
            }
        });
    }

    public static void setSandboxServicesSettingsForTesting(a.b b2, int n2, String string2) {
        sSandboxedServiceFactoryForTesting = b2;
        sSandboxedServicesCountForTesting = n2;
        sSandboxedServicesNameForTesting = string2;
    }

    public static a.b.a.p.a getConnectionAllocator(Context object, boolean bl) {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        String string2 = a.b.c.b.c.f ? a.b.c.b.c.a : ContextUtils.getApplicationContext().getPackageName();
        boolean bl2 = a.b.c.b.c.f && a.b.c.b.c.d;
        boolean bl3 = bl && a.b.c.b.c.f && a.b.c.b.c.b;
        if (!bl) {
            if (sPrivilegedChildConnectionAllocator == null) {
                sPrivilegedChildConnectionAllocator = a.b.a.p.a.a(object, LauncherThread.getHandler(), null, string2, PRIVILEGED_SERVICES_NAME, NUM_PRIVILEGED_SERVICES_KEY, bl2, bl3, true);
            }
            return sPrivilegedChildConnectionAllocator;
        }
        if (sSandboxedChildConnectionAllocator == null) {
            a.b.a.p.a a2;
            Object[] objectArray = new Object[1];
            Object object2 = objectArray;
            objectArray[0] = string2;
            g.d(TAG, "Create a new ChildConnectionAllocator with package name = %s, sandboxed = true", object2);
            object2 = () -> {
                Object object = sSandboxedChildConnectionRanking;
                if (((a.b.c.b.d)object).k.isEmpty()) {
                    object = null;
                } else {
                    List<d.b> list = ((a.b.c.b.d)object).k;
                    object = list.get((int)(list.size() - 1)).a;
                }
                if (object != null) {
                    ((c)object).j();
                }
            };
            if (sSandboxedServicesCountForTesting != -1) {
                Handler handler;
                a.b.a.p.a a3;
                object = !TextUtils.isEmpty((CharSequence)sSandboxedServicesNameForTesting) ? sSandboxedServicesNameForTesting : e.class.getName();
                int n2 = sSandboxedServicesCountForTesting;
                a2 = a3;
                Handler handler2 = handler;
                handler2();
                a3 = new a.b.a.p.a(handler, (Runnable)object2, string2, (String)object, bl2, bl3, false, n2);
            } else {
                a2 = a.b.a.p.a.a(object, LauncherThread.getHandler(), (Runnable)object2, string2, SANDBOXED_SERVICES_NAME, NUM_SANDBOXED_SERVICES_KEY, bl2, bl3, false);
            }
            object = sSandboxedServiceFactoryForTesting;
            if (object != null) {
                a2.k = object;
            }
            sSandboxedChildConnectionAllocator = a2;
            sSandboxedChildConnectionRanking = new a.b.c.b.d(ChildProcessLauncherHelperImpl.sSandboxedChildConnectionAllocator.b.length);
        }
        return sSandboxedChildConnectionAllocator;
    }

    public ChildProcessLauncherHelperImpl(long l2, String[] stringArray, FileDescriptorInfo[] fileDescriptorInfoArray, boolean bl, boolean bl2, IBinder object) {
        d d2;
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        this.mNativeChildProcessLauncherHelper = l2;
        this.mSandboxed = bl;
        this.mCanUseWarmUpConnection = bl2;
        a.b.a.p.a a2 = ChildProcessLauncherHelperImpl.getConnectionAllocator(ContextUtils.getApplicationContext(), bl);
        Handler handler = LauncherThread.getHandler();
        d.c c2 = this.mLauncherDelegate;
        object = object == null ? null : Arrays.asList(object);
        d d3 = d2;
        d3(handler, c2, stringArray, fileDescriptorInfoArray, a2, (List<IBinder>)object);
        this.mLauncher = d3;
        this.mProcessType = a.b.a.e.a(stringArray, "type");
        if (bl) {
            ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl = this;
            childProcessLauncherHelperImpl.mRanking = sSandboxedChildConnectionRanking;
            childProcessLauncherHelperImpl.mBindingManager = sBindingManager;
        } else {
            ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl = this;
            childProcessLauncherHelperImpl.mRanking = null;
            childProcessLauncherHelperImpl.mBindingManager = null;
        }
    }

    private void start() {
        this.mLauncher.a(true, true);
    }

    private String getProcessType() {
        return TextUtils.isEmpty((CharSequence)this.mProcessType) ? "" : this.mProcessType;
    }

    private void getTerminationInfoAndStop(long l2) {
        c c2 = ((ChildProcessLauncherHelperImpl)object).mLauncher.g;
        if (c2 == null) {
            return;
        }
        ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl = object;
        c c3 = c2;
        Object object = c3.m();
        ChildProcessLauncherHelperImpl.nativeSetTerminationInfo(l2, c3.b(), c2.h(), c2.f(), (int)object[3], (int)object[2], (int)object[1]);
        LauncherThread.post(() -> this.mLauncher.d());
    }

    private void setPriority(int n2, boolean bl, boolean n3, boolean bl2, long l2, boolean bl3, boolean bl4, int n4) {
        int n5;
        a.b.c.b.d d2;
        a.b.c.b.a a2;
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mLauncher.a() != n2) {
            throw new AssertionError();
        }
        if (ChildProcessLauncherHelperImpl.getByPid(n2) == null) {
            return;
        }
        c c2 = this.mLauncher.g;
        boolean bl5 = a.b.c.b.c.f && a.b.c.b.c.e;
        if (bl5) {
            bl = false;
            bl4 = false;
        }
        bl5 = ContentFeatureList.isEnabled("BackgroundMediaRendererHasModerateBinding");
        boolean bl6 = ContentFeatureList.isEnabled("ServiceWorkerForegroundPriority");
        n3 = !(bl && l2 == 0L || n4 == 2 || n3 != 0 && !bl5) ? (!(bl && l2 > 0L && bl3 || bl4 || n4 == 1 || n3 != 0 && bl5 || bl2 && bl6) ? 0 : 1) : 2;
        if (bl && !this.mVisible && (a2 = this.mBindingManager) != null) {
            a2.a(c2);
        }
        this.mVisible = bl;
        if (this.mEffectiveImportance != n3 && n3 != 0) {
            if (n3 != 1) {
                if (n3 != 2) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                } else {
                    if (!c.B && !c2.i()) {
                        throw new AssertionError();
                    }
                    if (!c2.g()) {
                        Object[] objectArray = new Object[1];
                        Object[] objectArray2 = objectArray;
                        objectArray[0] = c2.e();
                        g.d("ChildProcessConn", "The connection is not bound for %d", objectArray2);
                    } else {
                        if (c2.q == 0) {
                            c c3 = c2;
                            ((c.g)c3.n).a();
                            c3.q();
                        }
                        ++c2.q;
                    }
                }
            } else {
                c2.a();
            }
        }
        if ((d2 = this.mRanking) != null) {
            d2.b(c2, bl, l2, bl3, n4);
            a.b.c.b.a a3 = this.mBindingManager;
            if (a3 != null) {
                a3.a();
            }
        }
        if ((n5 = this.mEffectiveImportance) != n3 && n5 != 0) {
            if (n5 != 1) {
                if (n5 != 2) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                } else {
                    if (!c.B && !c2.i()) {
                        throw new AssertionError();
                    }
                    if (!c2.g()) {
                        Object[] objectArray = new Object[1];
                        Object[] objectArray3 = objectArray;
                        objectArray[0] = c2.e();
                        g.d("ChildProcessConn", "The connection is not bound for %d", objectArray3);
                    } else {
                        if (!c.B && c2.q <= 0) {
                            throw new AssertionError();
                        }
                        c c4 = c2;
                        --c4.q;
                        if (c4.q == 0) {
                            c c5 = c2;
                            ((c.g)c5.n).b();
                            c5.q();
                        }
                    }
                }
            } else {
                c2.n();
            }
        }
        this.mEffectiveImportance = n3;
    }

    public static void stop(int n2) {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        int n3 = n2;
        Object object = n3;
        g.a(TAG, "stopping child connection: pid=%d", object);
        object = ChildProcessLauncherHelperImpl.getByPid(n3);
        if (object != null) {
            ((ChildProcessLauncherHelperImpl)object).mLauncher.d();
        }
    }

    private void dumpProcessStack(int n2) {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        Object object = ChildProcessLauncherHelperImpl.getByPid(n2);
        if (object != null) {
            object = ((ChildProcessLauncherHelperImpl)object).mLauncher.g;
            if (!c.B && !((c)object).i()) {
                throw new AssertionError();
            }
            object = ((c)object).i;
            if (object != null) {
                try {
                    object.dumpProcessStack();
                }
                catch (RemoteException remoteException) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = remoteException;
                    g.b("ChildProcessConn", "Failed to dump process stack.", objectArray2);
                }
            }
        }
    }

    public static native void nativeOnChildProcessStarted(long var0, int var2);

    public static void initLinker() {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        if (sLinkerInitialized) {
            return;
        }
        if (LibraryLoader.useCrazyLinker() && (sLinkerLoadAddress = Linker.l.d()) == 0L) {
            Object[] objectArray = new Object[]{};
            g.c(TAG, "Shared RELRO support disabled!", objectArray);
        }
        sLinkerInitialized = true;
    }

    public static a getLinkerParamsForNewConnection() {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        ChildProcessLauncherHelperImpl.initLinker();
        if (!$assertionsDisabled && !sLinkerInitialized) {
            throw new AssertionError();
        }
        if (sLinkerLoadAddress == 0L) {
            return null;
        }
        Linker.h();
        return new a(sLinkerLoadAddress, true);
    }

    public static Bundle populateServiceBundle(Bundle bundle) {
        if (a.b.c.b.c.f) {
            bundle.putInt("com.vccorp.content.common.child_service_params.library_process_type", a.b.c.b.c.c);
        }
        boolean bl = a.b.c.b.c.f && a.b.c.b.c.d;
        bundle.putBoolean("com.vccorp.base.process_launcher.extra.bind_to_caller", bl);
        a a2 = ChildProcessLauncherHelperImpl.getLinkerParamsForNewConnection();
        if (a2 != null) {
            long l2 = a2.a;
            bundle.putLong("com.vccorp.content.common.linker_params.base_load_address", l2);
            bundle.putBoolean("com.vccorp.content.common.linker_params.wait_for_shared_relro", a2.b);
            bundle.putString("com.vccorp.content.common.linker_params.test_runner_class_name", a2.c);
        }
        return bundle;
    }

    public static ChildProcessLauncherHelperImpl getByPid(int n2) {
        return sLauncherByPid.get(n2);
    }

    public static void getProcessIdsByType(Callback<Map<String, List<Integer>>> callback) {
        LauncherThread.post(() -> ChildProcessLauncherHelperImpl.a(new Handler(), callback));
    }

    public static Map<Integer, ChildProcessLauncherHelperImpl> getAllProcessesForTesting() {
        return sLauncherByPid;
    }

    public static ChildProcessLauncherHelperImpl createAndStartForTesting(String[] stringArray, FileDescriptorInfo[] fileDescriptorInfoArray, boolean bl, boolean bl2, IBinder iBinder, boolean bl3) {
        ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl = new ChildProcessLauncherHelperImpl(0L, stringArray, fileDescriptorInfoArray, bl, bl2, iBinder);
        childProcessLauncherHelperImpl.mLauncher.a(bl3, true);
        return childProcessLauncherHelperImpl;
    }

    public static int getConnectedServicesCountForTesting() {
        a.b.a.p.a a2 = sPrivilegedChildConnectionAllocator;
        int n2 = a2 == null ? 0 : a2.a();
        return ChildProcessLauncherHelperImpl.getConnectedSandboxedServicesCountForTesting() + n2;
    }

    public static int getConnectedSandboxedServicesCountForTesting() {
        a.b.a.p.a a2 = sSandboxedChildConnectionAllocator;
        return a2 == null ? 0 : a2.a();
    }

    public static c getWarmUpConnectionForTesting(boolean bl) {
        Object object = bl ? sSpareSandboxedConnection : sSparePrivilegedConntection;
        object = object == null ? null : ((l)object).b;
        return object;
    }

    public static native void nativeSetTerminationInfo(long var0, int var2, boolean var3, boolean var4, int var5, int var6, int var7);

    public static /* synthetic */ void a(Handler handler, Callback callback) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        Object object = sLauncherByPid;
        Callback<Map.Entry> callback2 = arg_0 -> ChildProcessLauncherHelperImpl.a(new HashMap(), arg_0);
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            callback2.onResult((Map.Entry)object.next());
        }
        handler.post(() -> callback.onResult(hashMap2));
    }

    public static /* synthetic */ void a(Map map, Map.Entry entry) {
        String string2 = ((ChildProcessLauncherHelperImpl)entry.getValue()).getProcessType();
        List list = (List)map.get(string2);
        if (list == null) {
            ArrayList arrayList;
            list = arrayList;
            map.put(string2, new ArrayList());
        }
        list.add((Integer)entry.getKey());
    }

    public static /* synthetic */ long access$802(ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl, long l2) {
        childProcessLauncherHelperImpl.mNativeChildProcessLauncherHelper = l2;
        return l2;
    }

    static {
        $assertionsDisabled = ChildProcessLauncherHelperImpl.class.desiredAssertionStatus() ^ true;
        sLauncherByPid = new HashMap<Integer, ChildProcessLauncherHelperImpl>();
        sSandboxedServicesCountForTesting = -1;
    }

    public int getPidForTesting() {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        return this.mLauncher.a();
    }

    public c getChildProcessConnection() {
        return this.mLauncher.g;
    }

    public a.b.a.p.a getChildConnectionAllocatorForTesting() {
        return this.mLauncher.e;
    }
}

