/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.app;

import a.b.a.g;
import a.b.a.p.e;
import a.b.c.a.a;
import a.b.c.b.c;
import a.b.c.c.a;
import a.b.d.a.y;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.SparseArray;
import android.view.Surface;
import com.vccorp.base.library_loader.Linker;
import java.util.List;
import org.chromium.base.JNIUtils;
import org.chromium.base.UnguessableToken;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.task.PostTask;
import org.chromium.content.app.ContentMain;

@JNINamespace(value="content")
@MainDex
public class ContentChildProcessServiceDelegate
implements e {
    public static final String TAG = "ContentCPSDelegate";
    public static final /* synthetic */ boolean $assertionsDisabled;
    public a mLinkerParams;
    public int mLibraryProcessType;
    public a.b.c.c.a mGpuCallback;
    public int mCpuCount;
    public long mCpuFeatures;
    public SparseArray<String> mFdsIdsToKeys;

    public ContentChildProcessServiceDelegate() {
        a.b.c.a.c.a();
    }

    private boolean initializeLibrary() {
        try {
            LibraryLoader.getInstance().initialize(this.mLibraryProcessType);
            this.nativeRetrieveFileDescriptorsIdsToKeys();
            return true;
        }
        catch (a.b.a.m.c c2) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = c2;
            g.d(TAG, "startup failed: %s", objectArray2);
            return false;
        }
    }

    private Linker getLinker() {
        Linker.h();
        return Linker.l;
    }

    private void setFileDescriptorsIdsToKeys(int[] nArray, String[] stringArray) {
        if (!$assertionsDisabled && nArray.length != stringArray.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mFdsIdsToKeys != null) {
            throw new AssertionError();
        }
        this.mFdsIdsToKeys = new SparseArray();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.mFdsIdsToKeys.put(nArray[i2], (Object)stringArray[i2]);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void forwardSurfaceForSurfaceRequest(UnguessableToken unguessableToken, Surface surface) {
        Throwable throwable2;
        Object object = object.mGpuCallback;
        if (object == null) {
            object = new Object[]{};
            g.b(TAG, "No callback interface has been provided.", object);
            return;
        }
        object.forwardSurfaceForSurfaceRequest(unguessableToken, surface);
        surface.release();
        return;
        {
            catch (Throwable throwable2) {
            }
            catch (RemoteException remoteException) {}
            {
                g.b(TAG, "Unable to call forwardSurfaceForSurfaceRequest: %s", new Object[]{remoteException});
            }
            surface.release();
            return;
        }
        surface.release();
        throw throwable2;
    }

    private Surface getViewSurface(int n2) {
        block5: {
            Object object;
            block4: {
                object = object.mGpuCallback;
                if (object == null) {
                    object = new Object[]{};
                    g.b(TAG, "No callback interface has been provided.", object);
                    return null;
                }
                try {
                    object = object.getViewSurface(n2);
                    if (object == null) break block4;
                }
                catch (RemoteException remoteException) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = remoteException;
                    g.b(TAG, "Unable to call getViewSurface: %s", objectArray2);
                    return null;
                }
                object = object.j;
                break block5;
            }
            object = null;
        }
        return object;
    }

    private native void nativeInitChildProcess(int var1, long var2);

    private native void nativeRetrieveFileDescriptorsIdsToKeys();

    static {
        $assertionsDisabled = ContentChildProcessServiceDelegate.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public void onServiceCreated() {
    }

    @Override
    public void onServiceBound(Intent intent) {
        a a2;
        Bundle bundle = intent.getExtras();
        if (bundle.containsKey("com.vccorp.content.common.linker_params.base_load_address") && bundle.containsKey("com.vccorp.content.common.linker_params.wait_for_shared_relro") && bundle.containsKey("com.vccorp.content.common.linker_params.test_runner_class_name")) {
            a a3;
            a2 = a3;
            a3 = new a(bundle);
        } else {
            a2 = null;
        }
        this.mLinkerParams = a2;
        this.mLibraryProcessType = c.a(intent.getExtras());
    }

    @Override
    public void onConnectionSetup(Bundle bundle, List<IBinder> object) {
        object = object != null && !object.isEmpty() ? a.a.asInterface(object.get(0)) : null;
        this.mGpuCallback = object;
        this.mCpuCount = bundle.getInt("com.google.android.apps.chrome.extra.cpu_count");
        this.mCpuFeatures = bundle.getLong("com.google.android.apps.chrome.extra.cpu_features");
        if (!$assertionsDisabled && this.mCpuCount <= 0) {
            throw new AssertionError();
        }
        if (LibraryLoader.useCrazyLinker() && !LibraryLoader.getInstance().isLoadedByZygote() && (bundle = bundle.getBundle("com.vccorp.base.android.linker.shared_relros")) != null) {
            this.getLinker().a(bundle);
        }
    }

    @Override
    public void preloadNativeLibrary(Context context) {
        LibraryLoader.getInstance().preloadNowOverrideApplicationContext(context);
    }

    @Override
    public boolean loadNativeLibrary(Context context) {
        if (LibraryLoader.getInstance().isLoadedByZygote()) {
            return this.initializeLibrary();
        }
        JNIUtils.enableSelectiveJniRegistration();
        Object[] objectArray = null;
        boolean bl = false;
        if (LibraryLoader.useCrazyLinker()) {
            if (!$assertionsDisabled && this.mLinkerParams == null) {
                throw new AssertionError();
            }
            ContentChildProcessServiceDelegate contentChildProcessServiceDelegate = this;
            objectArray = contentChildProcessServiceDelegate.getLinker();
            a a2 = contentChildProcessServiceDelegate.mLinkerParams;
            if (a2.b) {
                bl = true;
                objectArray.a(a2.a);
            } else {
                objectArray.a();
            }
        }
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            LibraryLoader.getInstance().loadNowOverrideApplicationContext(context);
            bl2 = true;
        }
        catch (a.b.a.m.c c2) {
            if (bl) {
                Object[] objectArray2 = new Object[]{};
                g.d(TAG, "Failed to load native library with shared RELRO, retrying without", objectArray2);
                bl3 = true;
            }
            Object[] objectArray3 = new Object[1];
            Object[] objectArray4 = objectArray3;
            objectArray3[0] = c2;
            g.b(TAG, "Failed to load native library", objectArray4);
        }
        if (!bl2 && bl) {
            objectArray.a();
            try {
                LibraryLoader.getInstance().loadNowOverrideApplicationContext(context);
                bl2 = true;
            }
            catch (a.b.a.m.c c3) {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = c3;
                g.b(TAG, "Failed to load native library on retry", objectArray);
            }
        }
        if (!bl2) {
            return false;
        }
        LibraryLoader.getInstance().registerRendererProcessHistogram(bl, bl3);
        return this.initializeLibrary();
    }

    @Override
    public SparseArray<String> getFileDescriptorsIdsToKeys() {
        if (!$assertionsDisabled && this.mFdsIdsToKeys == null) {
            throw new AssertionError();
        }
        return this.mFdsIdsToKeys;
    }

    @Override
    public void onBeforeMain() {
        ContentChildProcessServiceDelegate contentChildProcessServiceDelegate = this;
        contentChildProcessServiceDelegate.nativeInitChildProcess(contentChildProcessServiceDelegate.mCpuCount, this.mCpuFeatures);
        PostTask.postTask(y.a, () -> a.b.a.n.c.a());
    }

    @Override
    public void runMain() {
        ContentMain.start(false);
    }
}

